/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.rules;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.delivery.DeliveryItem;
import com.gridnine.xtrip.common.model.delivery.DeliveryItemType;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.DeliveryHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rules.Parameter;
import com.gridnine.xtrip.common.model.rules.standard.DeliveryPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.elements.DebugInfo;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.handlers.DeliveryActionSet;
import com.gridnine.xtrip.server.model.handlers.DeliveryPropertySet;
import com.gridnine.xtrip.server.model.handlers.RulesHandler;
import com.gridnine.xtrip.server.model.handlers.rules.GeneralProductRulesHelper;
import com.gridnine.xtrip.server.model.handlers.rules.RulesProductHandler;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DeliveryRulesHandler
implements RulesHandler {
    @Override
    public void applyRules(EntityContainer<BookingFile> bookingContainer, boolean forced, boolean simulate, List<Message> messages, Map<Parameter, Object> params, DebugInfo debugInfo, boolean calcAppliedRulesToBooking) throws Exception {
        HashMap<Delivery, Boolean> payedMap = new HashMap<Delivery, Boolean>();
        HashMap<Delivery, PaymentType> fopMap = new HashMap<Delivery, PaymentType>();
        final HashMap propertyMap = new HashMap();
        EntityStorageContext storageContext = new EntityStorageContext();
        for (Reservation res : ((BookingFile)bookingContainer.getEntity()).getReservations()) {
            for (BaseProduct bp : res.getProducts()) {
                if (!(bp instanceof Delivery)) continue;
                Delivery delivery = (Delivery)bp;
                if (!forced && delivery.isContractRulesApplied() || payedMap.containsKey(delivery)) continue;
                boolean payed = false;
                PaymentType paymentType = null;
                for (GeneralProductFop fop : delivery.getClientFops()) {
                    paymentType = fop.getType();
                }
                for (DeliveryItem item : delivery.getDeliveryItems()) {
                    Fop fop;
                    BaseProduct product;
                    if (item.getType() != DeliveryItemType.PRODUCT || (product = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)((NestedEntityReference)item.getObject()), (EntityStorageContext)storageContext)) == null) continue;
                    if (GeneralProductHelper.findFOPAgent((BaseProduct)product) != null) {
                        payed = true;
                    }
                    if ((fop = GeneralProductHelper.findFop((BaseProduct)product)) == null || fop.getType() == null) continue;
                    if (paymentType == null) {
                        PaymentType type = fop.getType();
                        if (type != PaymentType.CREDIT_CARD && type != PaymentType.CREDIT_CARD_AGENCY && type != PaymentType.CASH && type != PaymentType.INVOICE) continue;
                        paymentType = type;
                    }
                    if (!payed) continue;
                    break;
                }
                payedMap.put(delivery, payed);
                if (paymentType == null) {
                    paymentType = PaymentType.CASH;
                }
                fopMap.put(delivery, paymentType);
            }
        }
        final ProductHandler deliveryHandler = HandlersRegistry.get().findProductHandler(Delivery.class);
        final HashMap deliveryMap = new HashMap();
        GeneralProductRulesHelper.applyContracts(bookingContainer, forced, simulate, new RulesProductHandler<Delivery, DeliveryPropertySet, DeliveryActionSet>(){

            @Override
            public void clearActionSet(RuleProxy<DeliveryPropertySet, DeliveryActionSet> proxy, Delivery item) {
                proxy.getAppliedRuleCategories().clear();
                proxy.getAppliedRules().clear();
                proxy.getTracer().clear();
                proxy.setActionSet((Object)new DeliveryActionSet(proxy, (DeliveryPropertiesProvider)proxy.getPropertySet(), item));
            }

            @Override
            public RuleProxy<DeliveryPropertySet, DeliveryActionSet> createProxy(Delivery item, boolean enabledTracer) {
                RuleProxy proxy = new RuleProxy();
                DeliveryPropertySet props = new DeliveryPropertySet(proxy);
                proxy.setPropertySet((Object)props);
                proxy.getTracer().setDisabled(!enabledTracer);
                proxy.setProxyDate(item.getIssueDate());
                proxy.setProxyType(Targets.DELIVERY.getId());
                ((DeliveryPropertySet)proxy.getPropertySet()).init(item);
                propertyMap.put(item, proxy.getPropertySet());
                return proxy;
            }

            @Override
            public Date getIssueDate(Delivery item) {
                return item.getIssueDate();
            }

            @Override
            public boolean hasRefundCommissions(RuleProxy<DeliveryPropertySet, DeliveryActionSet> proxy) {
                return ((DeliveryActionSet)proxy.getActionSet()).hasRefundCommissions();
            }

            @Override
            public Class<Delivery> getProductClass() {
                return Delivery.class;
            }

            @Override
            public ProductStatus getStatus(Delivery item) {
                return DeliveryHelper.getProductStatus((Delivery)item);
            }

            @Override
            public TicketType getTicketType(Delivery item) {
                return TicketType.OWN;
            }

            @Override
            public List<ValidationMessage> getValidationMessages(Delivery item) {
                return item.getValidationMessages();
            }

            @Override
            public boolean isChecked(Delivery item) {
                return item.isChecked();
            }

            @Override
            public boolean isContractRulesApplied(Delivery item) {
                return item.isContractRulesApplied();
            }

            @Override
            public void setContractRulesApplied(Delivery item, boolean value) {
                item.setContractRulesApplied(value);
            }

            @Override
            public EntityReference<Organization> getBlankOwner(Delivery item) {
                return null;
            }

            @Override
            public void updateContractRelationsBySalesChain(Delivery item) {
            }

            @Override
            public List<GeneralProductContractRelationData> getContractRelations(Delivery item) {
                List result = deliveryHandler.getUnmodifiableContractRelations((BaseProduct)item);
                deliveryMap.put(item, result);
                return result;
            }

            @Override
            public List<GeneralProductContractRelationData> getPreviousProductContractRelations(Delivery item) {
                return item.getPreviousProduct() == null ? null : deliveryHandler.getUnmodifiableContractRelations((BaseProduct)item.getPreviousProduct());
            }

            @Override
            public List<GeneralProductCommission> createCommissions(RuleProxy<DeliveryPropertySet, DeliveryActionSet> proxy, Delivery item, GeneralProductContractRelationData relation, List<GeneralProductContractRelationData> allRelations, List<GeneralProductContractRelationData> previousProductContractRelations, boolean separateSupplierFees, ExchangeRateData rateData) throws Exception {
                return ((DeliveryActionSet)proxy.getActionSet()).createCommissions(relation, allRelations, previousProductContractRelations, separateSupplierFees, rateData, new ArrayList<ValidationMessage>());
            }

            @Override
            public List<GeneralProductCommission> createCommissions(RuleProxy<DeliveryPropertySet, DeliveryActionSet> proxy, Delivery item, GeneralProductContractRelationData relation, List<GeneralProductContractRelationData> allRelations, List<GeneralProductContractRelationData> previousProductContractRelations, boolean translateSupplierFees, boolean separateSupplierFees, ExchangeRateData rateData) throws Exception {
                return ((DeliveryActionSet)proxy.getActionSet()).createCommissions(relation, allRelations, previousProductContractRelations, translateSupplierFees, separateSupplierFees, rateData, new ArrayList<ValidationMessage>());
            }

            @Override
            public void afterCommissionCalculated(Delivery item) {
                List lst = (List)deliveryMap.get(item);
                List commissions = ((GeneralProductContractRelationData)lst.get(0)).getCommissions();
                ArrayList<GeneralProductFop> fops = new ArrayList<GeneralProductFop>();
                for (GeneralProductFop fp : ((GeneralProductContractRelationData)lst.get(0)).getFops()) {
                    if (GeneralProductHelper.isServiceFop((GeneralProductFop)fp)) continue;
                    fops.add(fp);
                }
                item.getCommissions().clear();
                item.getClientFops().clear();
                item.getCommissions().addAll(commissions);
                item.getClientFops().addAll(fops);
                DeliveryPropertySet ps = (DeliveryPropertySet)propertyMap.get(item);
                if (!ps.isFopSet()) {
                    if (ps.getPaymentType() == PaymentType.CASH) {
                        for (GeneralProductFop fop : item.getClientFops()) {
                            fop.setOperationDate(null);
                            fop.setAgent(null);
                        }
                    }
                    if (ps.getPaymentType() != null) {
                        for (GeneralProductFop fop : item.getClientFops()) {
                            fop.setType(ps.getPaymentType());
                        }
                    }
                    if (ps.getFopAgent() != null) {
                        for (GeneralProductFop fop : item.getClientFops()) {
                            fop.setAgent(ps.getFopAgent());
                        }
                    }
                    if (ps.getFopOperationDate() != null) {
                        for (GeneralProductFop fop : item.getClientFops()) {
                            fop.setOperationDate(ps.getFopOperationDate());
                        }
                    }
                    for (GeneralProductFop fop : item.getClientFops()) {
                        if (fop.getOperationDate() == null) {
                            fop.setOperationDate(item.getIssueDate());
                        }
                        if (fop.getAgent() != null) continue;
                        try {
                            fop.setAgent(ProfileDao.findCurrentAgent(new ArrayList<L10nMessage>()));
                        }
                        catch (Exception exception) {}
                    }
                }
            }

            @Override
            public Set<PaymentType> getAllowedPaymentTypes(DeliveryActionSet actionSet) {
                return actionSet.getAllowedPaymentTypes();
            }
        }, messages, params);
        if (!payedMap.isEmpty()) {
            EntityReference<Person> agent = ProfileDao.findCurrentAgent(new ArrayList<L10nMessage>());
            Date date = new Date();
            for (Map.Entry entry : payedMap.entrySet()) {
                Delivery key = (Delivery)entry.getKey();
                Boolean value = (Boolean)entry.getValue();
                for (GeneralProductFop fop : key.getClientFops()) {
                    if (Boolean.TRUE.equals(value)) {
                        if (fop.getOperationDate() == null) {
                            fop.setOperationDate(date);
                        }
                        if (fop.getAgent() == null) {
                            fop.setAgent(key.getAgent());
                        }
                        if (fop.getAgent() == null) {
                            fop.setAgent(agent);
                        }
                    }
                    fop.setType((PaymentType)fopMap.get(key));
                }
            }
        }
    }

    @Override
    public String getId() {
        return MiscUtil.getSimpleClassName(this.getClass());
    }
}

