/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.rules;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

final class ExternalTicketVirtualizationHelper {
    private static final String EXTERNAL_VIRTUAL_TICKET_PREFIX = "EXTERNAL_TICKET_VIRTUAL:";

    static List<Product> virturalize(Product originalProduct, ContractType contractType) throws Exception {
        ArrayList<Product> result = new ArrayList<Product>(1);
        result.add(originalProduct);
        if (contractType == ContractType.VENDOR && originalProduct.getStatus() == ProductStatus.REFUND && originalProduct.getTicketType() == TicketType.NOT_OWN) {
            Product virtualProduct = AirProductHelper.clone((Product)originalProduct, (boolean)false);
            virtualProduct.setUid(EXTERNAL_VIRTUAL_TICKET_PREFIX + virtualProduct.getUid() + '|' + originalProduct.getUid());
            virtualProduct.setNextProduct(null);
            virtualProduct.setStatus(ProductStatus.SELL);
            originalProduct.getReservation().getProducts().add(virtualProduct);
            result.add(virtualProduct);
        }
        return result;
    }

    static void devirtualize(Product originalProduct, Set<Product> vProducts) {
        Product vProduct = null;
        for (Product prod : vProducts) {
            if (!prod.getUid().startsWith(EXTERNAL_VIRTUAL_TICKET_PREFIX)) continue;
            vProduct = prod;
            break;
        }
        if (vProduct == null) {
            return;
        }
        ArrayList refundedCommissions = new ArrayList(AirProductHelper.getVendorContractRelation(vProduct).getCommissions());
        Iterator it = refundedCommissions.iterator();
        while (it.hasNext()) {
            Commission comm = (Commission)it.next();
            EntityContainer propCtr = EntityStorage.get().resolve(comm.getCommissionProperties());
            if (propCtr == null || !propCtr.getEntityType().equals(CommissionProperties.class)) {
                it.remove();
                continue;
            }
            CommissionProperties prop = (CommissionProperties)propCtr.getEntity();
            if (prop.getOperation() == null || prop.getOperation() == Operation.SELL) continue;
            it.remove();
        }
        AirProductHelper.getVendorContractRelation((Product)originalProduct).getCommissions().addAll(refundedCommissions);
        vProduct.getReservation().getProducts().remove(vProduct);
    }

    private ExternalTicketVirtualizationHelper() {
    }
}

