/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.rules;

import com.gridnine.xtrip.common.model.forOfPayment.OrganizationFOPCheckRules;
import com.gridnine.xtrip.common.model.rules.standard.formOfPayment.FOPActionProvider;
import com.gridnine.xtrip.common.model.rules.standard.formOfPayment.FOPActionResult;
import com.gridnine.xtrip.common.model.rules.standard.formOfPayment.FOPPropertiesProvider;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleFilteringCategory;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleResultHandler;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FOPRulesHelper {
    private static final Logger log = LoggerFactory.getLogger(FOPRulesHelper.class);

    public static void applyRules(RuleProxy<? extends FOPPropertiesProvider, FOPActionResult> proxy, OrganizationFOPCheckRules rules, Set<? extends RuleFilteringCategory> categories) throws Exception {
        FOPRulesHelper.applyRules(Collections.singletonList(proxy), rules.getRuleSet(), categories);
    }

    public static void applyRules(List<RuleProxy<? extends FOPPropertiesProvider, FOPActionResult>> proxies, OrganizationFOPCheckRules rules, Set<? extends RuleFilteringCategory> categories) throws Exception {
        FOPRulesHelper.applyRules(proxies, rules.getRuleSet(), categories);
    }

    public static void applyRules(RuleProxy<? extends FOPPropertiesProvider, FOPActionResult> proxy, RuleSet ruleSet, Set<? extends RuleFilteringCategory> categories) throws Exception {
        FOPRulesHelper.applyRules(Collections.singletonList(proxy), ruleSet, categories);
    }

    public static void applyRules(List<RuleProxy<? extends FOPPropertiesProvider, FOPActionResult>> proxies, RuleSet ruleSet, Set<? extends RuleFilteringCategory> categories) throws Exception {
        if (ruleSet == null) {
            log.info("No rule set to apply");
            return;
        }
        List rs = ruleSet.getRules().stream().filter(r -> categories.contains(r.getFilteringCategory())).collect(Collectors.toList());
        if (rs.isEmpty()) {
            log.info("No rules for category " + categories.stream().map(RuleFilteringCategory::getDisplayName).collect(Collectors.joining(",")));
        }
        RuleEngine.applyRules(proxies, rs, (RuleResultHandler)new RuleResultHandler(){

            public void processRuleResult(RuleProxy<?, ?> proxy, RuleSettings ruleSettings, RuleResult ruleResult) throws Exception {
                ((FOPActionProvider)proxy.getActionSet()).setRuleUid(ruleSettings.getUid());
                proxy.getAppliedRuleCategories().clear();
            }

            public boolean isProcessAllRuleResults() {
                return true;
            }
        });
    }
}

