/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.rules;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseCommission;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ContractRelationContractData;
import com.gridnine.xtrip.common.model.booking.ContractRelationGeneralData;
import com.gridnine.xtrip.common.model.booking.ContractRelationServiceData;
import com.gridnine.xtrip.common.model.booking.ContractRelationServiceDataDetalization;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountType;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeType;
import com.gridnine.xtrip.common.model.booking.transfers.TransferProvider;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.misc.IrrelevanceTolerantEntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.ContractRelationHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MulticurrencyHelper;
import com.gridnine.xtrip.common.model.helpers.OnCreateFopListener;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.BaseRulesContainer;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.ExchangeRateCondition;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.rules.Parameter;
import com.gridnine.xtrip.common.model.rules.standard.ContractActionsProvider;
import com.gridnine.xtrip.common.model.rules.standard.PayerActionsProvider;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.TranslateSupplierFeesPropertyProvider;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.rules.elements.DebugInfo;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.StorageHelper;
import com.gridnine.xtrip.server.model.handlers.CommissionProxyHandler;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistry;
import com.gridnine.xtrip.server.model.handlers.rules.AirRulesHelper;
import com.gridnine.xtrip.server.model.handlers.rules.ProductRelatedOrganizations;
import com.gridnine.xtrip.server.model.handlers.rules.RulesProductHandler;
import com.gridnine.xtrip.server.model.helpers.ObjectCreationSettingsHelper;
import com.gridnine.xtrip.server.model.helpers.ShipmentHelper;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GeneralProductRulesHelper {
    private static final Logger log = LoggerFactory.getLogger(GeneralProductRulesHelper.class);
    public static List<TicketType> VALID_TICKET_TYPES = Arrays.asList(TicketType.OWN, TicketType.NOT_OWN, TicketType.EXTERNAL, TicketType.CORRECTION, TicketType.REFERRAL);

    public static <T extends BaseProduct, P, A> Set<PaymentType> getAllowedPaymentTypes(EntityContainer<BookingFile> bookingContainer, RulesProductHandler<T, P, A> handler) {
        return GeneralProductRulesHelper.getAllowedPaymentTypes(bookingContainer, handler, null, null);
    }

    public static <T extends BaseProduct, P, A> Set<PaymentType> getAllowedPaymentTypes(Reservation reservation, RulesProductHandler<T, P, A> handler) {
        return reservation.getProducts().stream().flatMap(p -> GeneralProductRulesHelper.getAllowedPaymentTypes(p, handler, null, null).stream()).collect(Collectors.toSet());
    }

    public static <T extends BaseProduct, P, A> Set<PaymentType> getAllowedPaymentTypes(EntityContainer<BookingFile> bookingContainer, RulesProductHandler<T, P, A> handler, List<Message> messages) {
        return GeneralProductRulesHelper.getAllowedPaymentTypes(bookingContainer, handler, messages, null);
    }

    public static <T extends BaseProduct, P, A> Set<PaymentType> getAllowedPaymentTypes(EntityContainer<BookingFile> bookingContainer, RulesProductHandler<T, P, A> handler, List<Message> messages, ContractType filterContractType) {
        HashSet<PaymentType> result = new HashSet<PaymentType>();
        for (Reservation res : ((BookingFile)bookingContainer.getEntity()).getReservations()) {
            for (BaseProduct bp : res.getProducts()) {
                result.addAll(GeneralProductRulesHelper.getAllowedPaymentTypes(bp, handler, messages, filterContractType));
            }
        }
        return result;
    }

    public static <T extends BaseProduct, P, A> Set<PaymentType> getAllowedPaymentTypes(BaseProduct bp, RulesProductHandler<T, P, A> handler, List<Message> messages, ContractType filterContractType) {
        if (handler.getProductClass().equals(bp.getClass())) {
            BaseProduct product = bp;
            ArrayList<RuleProxy<P, A>> proxyList = new ArrayList<RuleProxy<P, A>>();
            try {
                RuleProxy<P, A> proxy = handler.createProxy(product, false);
                handler.clearActionSet(proxy, product);
                proxyList.add(proxy);
                ProductRelatedOrganizations organizations = GeneralProductRulesHelper.collectOrganizations(product, handler);
                for (GeneralProductContractRelationData item : handler.getContractRelations(product)) {
                    ContractType contractType = GeneralProductHelper.getContractType((EntityReference)item.getDescription());
                    if (contractType == ContractType.VENDOR || filterContractType != null && filterContractType != contractType) continue;
                    EntityReference<Organization> blankOwner = organizations.blankOwner;
                    ContractRelationDescription description = (ContractRelationDescription)EntityStorage.get().resolve(item.getDescription()).getEntity();
                    EntityReference supplier = GeneralProductHelper.getContractor((SalesChain)organizations.salesChain, (EntityReference)description.getSupplier());
                    EntityReference customer = contractType == ContractType.CLIENT ? organizations.client : GeneralProductHelper.getContractor((SalesChain)organizations.salesChain, (EntityReference)description.getCustomer());
                    EntityContainer<Contract> contract = EntityStorage.get().resolve(item.getGeneralData().getContractData().getManualContract());
                    if (null == contract) {
                        contract = EntityStorage.get().resolve(handler.getDefaultContract(product, contractType));
                    }
                    if (null == contract) {
                        contract = GeneralProductRulesHelper.getContract(contractType, product, blankOwner, (EntityReference<Organization>)supplier, (EntityReference<Organization>)customer, handler.getValidationMessages(product), handler.getIssueDate(product), null, null);
                    }
                    if (contract != null) {
                        RulesHelper.applyRules((EntityContainer)contract, proxyList, (BaseProduct)product);
                        continue;
                    }
                    Collection contracts = (Collection)GeneralProductRulesHelper.collectOldContracts(contractType, product, handler, blankOwner, (EntityReference<Organization>)supplier, (EntityReference<Organization>)customer, null).getFirst();
                    for (EntityContainer ctr : contracts) {
                        RulesHelper.applyRules((EntityContainer)ctr, proxyList, (BaseProduct)product);
                    }
                }
                return handler.getAllowedPaymentTypes(((RuleProxy)proxyList.get(0)).getActionSet());
            }
            catch (Exception e) {
                if (messages != null) {
                    messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.AirRulesHelper_applyRulesError, (Throwable)e, (Object[])new Object[0]));
                }
                log.error("unable to create proxy", (Throwable)e);
            }
        }
        return Collections.emptySet();
    }

    public static <T extends BaseProduct, P, A> void applyContracts(EntityContainer<BookingFile> bookingContainer, boolean forced, boolean simulate, RulesProductHandler<T, P, A> handler, List<Message> messages, Map<Parameter, Object> params) throws Exception {
        GeneralProductRulesHelper.applyContracts(bookingContainer, forced, simulate, handler, messages, params, null, true);
    }

    public static <T extends BaseProduct, P, A> void applyContracts(EntityContainer<BookingFile> bookingContainer, boolean forced, boolean simulate, RulesProductHandler<T, P, A> handler, List<Message> messages, Map<Parameter, Object> params, boolean calcAppliedRulesToBooking) throws Exception {
        GeneralProductRulesHelper.applyContracts(bookingContainer, forced, simulate, handler, messages, params, null, calcAppliedRulesToBooking);
    }

    public static <T extends BaseProduct, P, A> void applyContracts(EntityContainer<BookingFile> bookingContainer, boolean forced, boolean simulate, RulesProductHandler<T, P, A> handler, List<Message> messages, Map<Parameter, Object> params, DebugInfo info, boolean calcAppliedRulesToBooking) throws Exception {
        BookingFile bookingFile = (BookingFile)bookingContainer.getEntity();
        boolean traceEnabled = ObjectCreationSettingsHelper.isCreateRulesDebugInfo(((BookingFile)bookingContainer.getEntity()).getNumber()) || info != null || Boolean.TRUE.equals(GeneralProductRulesHelper.getFromParams(params, Parameter.CREATE_LOG_DOCUMENT));
        List<BaseProduct> products = GeneralProductRulesHelper.prepareProducts(bookingContainer, handler, forced, simulate, messages, params, traceEnabled);
        if (products.isEmpty()) {
            log.debug("products collection is empty in booking " + TextUtil.buildFullNumber((CompositeNumber)bookingFile));
            return;
        }
        for (BaseProduct product : products) {
            GeneralProductRulesHelper.applyRules(product, bookingContainer, handler, messages, params, info, simulate, traceEnabled, calcAppliedRulesToBooking);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends BaseProduct, P, A> RuleProxy<P, A> applyRules(T product, EntityContainer<BookingFile> bookingContainer, RulesProductHandler<T, P, A> handler, List<Message> messages, Map<Parameter, Object> params, DebugInfo info, boolean simulate, boolean traceEnabled, boolean calcAppliedRulesToBooking) throws Exception {
        RuleProxy<P, A> proxy;
        BookingFile bookingFile = (BookingFile)bookingContainer.getEntity();
        String productTitle = GeneralProductRulesHelper.getProductTitle(product);
        log.debug("analyzing product \"{}\"", (Object)productTitle);
        if (!Boolean.FALSE.equals(GeneralProductRulesHelper.getFromParams(params, Parameter.CLEAR_APPLIED_RULES))) {
            bookingFile.getAppliedRules().removeIf(appliedRule -> !appliedRule.isHotelPreprocessingRule() && product.getUid().equals(appliedRule.getProductUid()));
        }
        handler.updateContractRelationsBySalesChain(product);
        List<GeneralProductContractRelationData> contractRelations = handler.getContractRelations(product);
        List<GeneralProductContractRelationData> previousProductContractRelations = handler.getPreviousProductContractRelations(product);
        try {
            proxy = handler.createProxy(product, traceEnabled);
        }
        catch (Throwable e) {
            log.error("unable to create proxy", e);
            GeneralProductRulesHelper.addValidationMessage(handler, product, (ValidationMessageType)StandartValidationMessageType.RH_CANT_APPLY_RULES, e, new Object[0]);
            return null;
        }
        String initTrace = proxy.getTracer().getTrace();
        GeneralProductRulesHelper.deleteRulesValidationMessages(handler.getValidationMessages(product));
        GeneralProductRulesHelper.clearCommissions(contractRelations);
        try {
            ProductRelatedOrganizations organizations = GeneralProductRulesHelper.collectOrganizations(product, handler);
            GeneralProductHelper.RelationData last = new GeneralProductHelper.RelationData(product);
            for (GeneralProductContractRelationData contractRelation : contractRelations) {
                ContractActionsProvider cap;
                List customerInfos;
                List contracts;
                ContractType contractType = GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription());
                EntityContainer relationDescription = EntityStorage.get().resolve(contractRelation.getDescription());
                if (contractType == null || relationDescription == null) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u0442\u0438\u043f\u0443 \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u044b\u0445 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0439 {0}", (Object[])new Object[]{contractRelation.getDescription()}));
                    continue;
                }
                proxy.setContractType(contractType.name());
                handler.clearActionSet(proxy, product);
                log.debug("analizing contract of type " + contractType.name());
                EntityReference supplier = GeneralProductHelper.getContractor((SalesChain)organizations.salesChain, (EntityReference)((ContractRelationDescription)relationDescription.getEntity()).getSupplier());
                EntityReference customer = contractType == ContractType.CLIENT ? organizations.client : GeneralProductHelper.getContractor((SalesChain)organizations.salesChain, (EntityReference)((ContractRelationDescription)relationDescription.getEntity()).getCustomer());
                EntityContainer customerCtr = EntityStorage.get().resolve(customer);
                boolean separateSupplierFees = customerCtr != null && ((Organization)customerCtr.getEntity()).isSeparateSupplierFees();
                try {
                    Enum<?> provider = ContractType.VENDOR == contractType ? handler.getProvider(product) : null;
                    MiscUtil.Pair<List<EntityContainer<Contract>>, List<ContractCustomerInfo>> pair = GeneralProductRulesHelper.getContracts(handler, product, contractRelation, contractType, organizations, (EntityReference<Organization>)supplier, (EntityReference<Organization>)customer, provider);
                    contracts = (List)pair.getFirst();
                    customerInfos = (List)pair.getSecond();
                }
                catch (Exception e) {
                    log.error("failed collecting contracts of type {} for product {}", new Object[]{contractType.name(), product, e});
                    GeneralProductRulesHelper.addValidationMessage(handler, product, (ValidationMessageType)StandartValidationMessageType.RH_ERROR_FINDING_CONTRACT, e, contractType);
                    ExchangeRateData rateData = GeneralProductRulesHelper.updateServiceData(product, contractRelation, last, Collections.emptyList(), (EntityReference<Organization>)customer);
                    last = new GeneralProductHelper.RelationData((BaseContractRelationData)contractRelation, last);
                    GeneralProductRulesHelper.cleanupFops(contractRelation);
                    GeneralProductRulesHelper.updatePreviouslyCalculatedCommissions(handler, product, proxy, contractRelation, contractRelations, previousProductContractRelations, separateSupplierFees, rateData);
                    if (handler.getStatus(product) != ProductStatus.EXCHANGE && handler.getStatus(product) != ProductStatus.REFUND) continue;
                    GeneralProductRulesHelper.setPreviousContract(product, contractRelation);
                    continue;
                }
                ExchangeRateData rateData = GeneralProductRulesHelper.updateServiceData(product, contractRelation, last, contracts, (EntityReference<Organization>)customer);
                last = new GeneralProductHelper.RelationData((BaseContractRelationData)contractRelation, last);
                if (contracts.isEmpty()) {
                    log.debug("no contracts of type \"{}\" was collected", (Object)contractType.name());
                    GeneralProductRulesHelper.addValidationMessage(handler, product, (ValidationMessageType)StandartValidationMessageType.RH_MISSING_CONTRACT_OF_TYPE, null, contractType);
                    GeneralProductRulesHelper.cleanupFops(contractRelation);
                    GeneralProductRulesHelper.updatePreviouslyCalculatedCommissions(handler, product, proxy, contractRelation, contractRelations, previousProductContractRelations, separateSupplierFees, rateData);
                    if (handler.getStatus(product) != ProductStatus.EXCHANGE && handler.getStatus(product) != ProductStatus.REFUND) continue;
                    GeneralProductRulesHelper.setPreviousContract(product, contractRelation);
                    continue;
                }
                EntityContainer contract = null;
                boolean translateSupplierFees = true;
                boolean contractSet = false;
                try {
                    block13: for (EntityContainer ctr : contracts) {
                        EntityReference ctrRef = ctr.toReference();
                        log.debug("applying contract {}", (Object)ctrRef);
                        proxy.getTracer().traceLogic(() -> "contract applied: ".concat(Objects.toString(ctrRef)));
                        if (((Contract)ctr.getEntity()).isNewModel()) {
                            Date date = (Date)MiscUtil.guarded((Object)GeneralProductHelper.getHandler(product).findIssueDate(product), Date::new);
                            List rules = ProfileHelper.getRuleContainersData((EntityContainer)ctr, (Date)date);
                            for (ProfileHelper.RuleContainerData data : rules) {
                                if (!GeneralProductRulesHelper.applyRules(product, proxy, (EntityContainer<Contract>)ctr, (EntityContainer<? extends BaseRulesContainer>)data.getContainer(), translateSupplierFees, calcAppliedRulesToBooking)) continue;
                                if (contract == null) {
                                    contract = ctr;
                                }
                                if (contractSet || data.isTranslateSupplierFees() == null) continue;
                                contract = ctr;
                                translateSupplierFees = data.isTranslateSupplierFees();
                                contractSet = true;
                            }
                            continue;
                        }
                        if (!GeneralProductRulesHelper.applyRules(product, proxy, (EntityContainer<Contract>)ctr, (EntityContainer<? extends BaseRulesContainer>)ctr, translateSupplierFees, calcAppliedRulesToBooking)) continue;
                        if (contract == null) {
                            contract = ctr;
                        }
                        if (contractSet) continue;
                        for (ContractCustomerInfo customerInfo : customerInfos) {
                            if (CollectionUtil.find((Iterable)((Contract)ctr.getEntity()).getCustomers(), (String)customerInfo.getUid()) == null) continue;
                            contract = ctr;
                            translateSupplierFees = customerInfo.isTranslateSupplierFees();
                            contractRelation.getGeneralData().setContract(new NestedEntityReference(ctr, (BaseEntity)customerInfo));
                            contractRelation.getGeneralData().getContractData().setContract(ctrRef);
                            contractSet = true;
                            continue block13;
                        }
                    }
                }
                catch (Exception e) {
                    log.error("failed applying rules from contracts of type {} for product {}", new Object[]{contractType.name(), product, e});
                    GeneralProductRulesHelper.addValidationMessage(handler, product, (ValidationMessageType)StandartValidationMessageType.RH_ERROR_APPLYING_RULES, e, contractType);
                    proxy.getTracer().traceError("failed applying rules: contract type ".concat(contractType.name()), (Throwable)e);
                    GeneralProductRulesHelper.cleanupFops(contractRelation);
                    GeneralProductRulesHelper.updatePreviouslyCalculatedCommissions(handler, product, proxy, contractRelation, contractRelations, previousProductContractRelations, separateSupplierFees, rateData);
                    continue;
                }
                finally {
                    if (handler.getStatus(product) != ProductStatus.EXCHANGE && (handler.getStatus(product) != ProductStatus.REFUND || handler.hasRefundCommissions(proxy))) continue;
                    GeneralProductRulesHelper.setPreviousContract(product, contractRelation);
                    continue;
                }
                if (proxy.getActionSet() instanceof ContractActionsProvider && (cap = (ContractActionsProvider)proxy.getActionSet()).isTranslateSupplierFee() != null) {
                    translateSupplierFees = cap.isTranslateSupplierFee();
                }
                if (contract != null) {
                    EntityReference payerRef;
                    contractRelation.getGeneralData().setTranslateSupplierFees(Boolean.valueOf(translateSupplierFees));
                    if (proxy.getActionSet() instanceof PayerActionsProvider && (payerRef = ((PayerActionsProvider)proxy.getActionSet()).getPayer()) != null) {
                        contractRelation.getFops().forEach(fop -> fop.setPayer(payerRef));
                    }
                    List<GeneralProductCommission> commissions = handler.createCommissions(proxy, product, contractRelation, contractRelations, previousProductContractRelations, translateSupplierFees, separateSupplierFees, rateData);
                    GeneralProductRulesHelper.setManualCommissionsAppliedFlags(product, commissions, contractType);
                    GeneralProductRulesHelper.addValidationMessage(handler, product, (ValidationMessageType)StandartValidationMessageType.RH_RULE_WAS_APPLIED, null, contractType);
                    proxy.getTracer().traceLogic(() -> "rules applied: contract type = ".concat(contractType.name()));
                    log.debug("rules applied: contract type = {}", (Object)contractType.name());
                } else {
                    GeneralProductRulesHelper.addValidationMessage(handler, product, (ValidationMessageType)StandartValidationMessageType.RH_NO_ONE_RULE_WAS_APPLIED, null, contractType);
                    proxy.getTracer().traceLogic(() -> "rules were not applied: contract type = ".concat(contractType.name()));
                    if (handler.getStatus(product) == ProductStatus.REFUND || handler.getStatus(product) == ProductStatus.EXCHANGE) {
                        proxy.getTracer().traceLogic("trying to copy commissions from related sell");
                    }
                    GeneralProductRulesHelper.cleanupFops(contractRelation);
                    GeneralProductRulesHelper.updatePreviouslyCalculatedCommissions(handler, product, proxy, contractRelation, contractRelations, previousProductContractRelations, separateSupplierFees, rateData);
                    log.warn("rules were not applied: contract type = {}", (Object)contractType.name());
                }
                handler.setContractRulesApplied(product, true);
                if (!simulate && ObjectCreationSettingsHelper.isCreateRulesDebugInfo(bookingFile.getNumber()) || Boolean.TRUE.equals(GeneralProductRulesHelper.getFromParams(params, Parameter.CREATE_LOG_DOCUMENT))) {
                    GeneralProductRulesHelper.saveLogDocument(initTrace, proxy, bookingContainer, product, contractType, params);
                }
                if (info == null) continue;
                info.startBlock("trace");
                info.message(String.format("trace of %s (%s)", productTitle, contractRelation.getDescription()));
                info.message(initTrace + "\r\n" + proxy.getTracer().getTrace());
                info.endBlock();
            }
            ProductHandler prodHandler = HandlersRegistry.get().findProductHandler(product.getClass());
            GeneralProductRulesHelper.updateManuallyCalculatedFees(contractRelations, (EntityReference<Person>)prodHandler.findIssuingAgent(product), product);
            messages.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.AirRulesHelper_productApplyRules, (Object[])new Object[]{productTitle}));
        }
        finally {
            handler.afterCommissionCalculated(product);
        }
        for (GeneralProductContractRelationData contractRelation : contractRelations) {
            ContractType contractType = GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription());
            EntityContainer relationDescription = EntityStorage.get().resolve(contractRelation.getDescription());
            if (contractType == null || relationDescription == null) continue;
            GeneralProductRulesHelper.applyTravelPolicy(handler, product, contractRelation, traceEnabled);
        }
        return proxy;
    }

    private static <T extends BaseProduct> MiscUtil.Pair<List<EntityContainer<Contract>>, List<ContractCustomerInfo>> getContracts(RulesProductHandler handler, T product, GeneralProductContractRelationData contractRelation, ContractType contractType, ProductRelatedOrganizations organizations, EntityReference<Organization> supplier, EntityReference<Organization> customer, Enum<?> provider) throws Exception {
        List customerInfos;
        List contracts = handler.getContracts(product, contractType);
        if (CollectionUtil.isNotEmpty(contracts)) {
            customerInfos = ((Contract)contracts.get(0).getEntity()).getCustomers();
        } else {
            EntityContainer<Contract> contract = EntityStorage.get().resolve(contractRelation.getGeneralData().getContractData().getManualContract());
            if (null == contract) {
                contract = EntityStorage.get().resolve(handler.getDefaultContract(product, contractType));
            }
            if (null == contract) {
                contract = GeneralProductRulesHelper.getContract(contractType, product, organizations.blankOwner, supplier, customer, handler.getValidationMessages(product), handler.getIssueDate(product), provider, null);
            }
            if (contract != null) {
                contracts = Collections.singletonList(contract);
                customerInfos = ((Contract)contract.getEntity()).getCustomers();
            } else {
                MiscUtil.Pair<List<EntityContainer<Contract>>, List<ContractCustomerInfo>> collectRes = GeneralProductRulesHelper.collectOldContracts(contractType, product, handler, organizations.blankOwner, supplier, customer, provider instanceof HotelProvider ? provider : null);
                contracts = (List)collectRes.getFirst();
                customerInfos = (List)collectRes.getSecond();
            }
        }
        return new MiscUtil.Pair(contracts, (Object)customerInfos);
    }

    private static <T extends BaseProduct, P, A> boolean applyRules(T product, RuleProxy<P, A> proxy, EntityContainer<Contract> contract, EntityContainer<? extends BaseRulesContainer> container, boolean translateSupplierFees, boolean calcAppliedRulesToBooking) throws Exception {
        proxy.getTracer().traceLogic(() -> "container applied: ".concat(Objects.toString(container.toReference())));
        Object ps = proxy.getPropertySet();
        if (ps instanceof TranslateSupplierFeesPropertyProvider) {
            ((TranslateSupplierFeesPropertyProvider)ps).setTranslateSupplierFees(translateSupplierFees);
            proxy.getTracer().traceLogic(() -> "translate supplier fees is set to" + translateSupplierFees);
        }
        HashSet appliedRulesBefore = new HashSet(proxy.getAppliedRules());
        RulesHelper.applyContainerRules(container, Collections.singletonList(proxy), product);
        LinkedHashSet appliedRulesLocal = new LinkedHashSet(proxy.getAppliedRules());
        appliedRulesLocal.removeAll(appliedRulesBefore);
        if (!appliedRulesLocal.isEmpty()) {
            if (calcAppliedRulesToBooking) {
                List appliedRules = RulesHelper.calcAppliedRulesToBooking(proxy, appliedRulesLocal, Collections.singletonList(container), product, contract);
                product.getReservation().getBookingFile().getAppliedRules().addAll(appliedRules);
            }
            return true;
        }
        return false;
    }

    private static <T extends BaseProduct> void setPreviousContract(T product, GeneralProductContractRelationData contractRelation) {
        ProductHandler handler = GeneralProductHelper.getHandler(product);
        BaseProduct prev = handler.getPreviousProduct(product);
        if (null == prev) {
            return;
        }
        GeneralProductContractRelationData prevRelation = (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation((List)handler.getUnmodifiableContractRelations(prev), (EntityReference)contractRelation.getDescription());
        if (null == prevRelation) {
            return;
        }
        ContractRelationGeneralData generalData = contractRelation.getGeneralData();
        ContractRelationGeneralData prevGeneralData = prevRelation.getGeneralData();
        generalData.setContract(prevGeneralData.getContract());
        ContractRelationContractData contractData = generalData.getContractData();
        if (contractData.getManualContract() == null) {
            contractData.setContract(prevGeneralData.getContractData().getContract());
        }
    }

    public static <A, T extends BaseProduct, P> void applyTravelPolicy(RulesProductHandler<T, P, A> handler, T product, GeneralProductContractRelationData contractRelation, boolean traceEnabled) {
        if (GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription()) != ContractType.CLIENT) {
            return;
        }
        try {
            handler.applyTravelPolicy(product, contractRelation, traceEnabled);
        }
        catch (Throwable e) {
            GeneralProductRulesHelper.addValidationMessage(handler, product, (ValidationMessageType)StandartValidationMessageType.RH_RULE_APPLY_TRAVEL_POLICY_ERROR, e, new Object[0]);
        }
    }

    private static <T extends BaseProduct> ExchangeRateData updateServiceData(T product, GeneralProductContractRelationData contractRelation, GeneralProductHelper.RelationData last, List<EntityContainer<Contract>> contracts, EntityReference<Organization> customerRef) {
        ContractRelationGeneralData prevGeneralData;
        String prevCurrency;
        GeneralProductContractRelationData prevRelation;
        BaseProduct previousProduct;
        BigDecimal correct;
        Money fare;
        Double gdsCurrencyRate;
        EntityContainer<Contract> contractCtr;
        ContractRelationGeneralData generalData = contractRelation.getGeneralData();
        if (contracts.size() == 1 && ((Contract)contracts.get(0).getEntity()).isNewModel()) {
            contractCtr = contracts.get(0);
            generalData.setContract(((Contract)contractCtr.getEntity()).getCustomers().isEmpty() ? null : new NestedEntityReference(contractCtr, (BaseEntity)((Contract)contractCtr.getEntity()).getCustomers().get(0)));
        } else {
            NestedEntityReference<Contract, ContractCustomerInfo> ref;
            Date date = GeneralProductHelper.getHandler(product).findIssueDate(product);
            if (null == date) {
                date = new Date();
            }
            contractCtr = (ref = AirRulesHelper.buildContractNestedRef(contracts, customerRef, date)) != null ? (EntityContainer)contracts.stream().filter(c -> ref.getUid().equals(c.getUid())).findFirst().orElse(null) : null;
            generalData.setContract(ref);
        }
        generalData.getContractData().setContract(contractCtr != null ? contractCtr.toReference() : null);
        generalData.setTranslateSupplierFees(null);
        ProductHandler ph = GeneralProductHelper.getHandler(product);
        ProductStatus productStatus = ph.getStatus(product);
        Date productDate = GeneralProductHelper.getProductDate(product);
        EntityReference supplier = GeneralProductHelper.getSupplier(product);
        ExchangeRateData rateData = RulesHelper.getExchangeRateData(contracts, customerRef, (Date)productDate, (EntityReference)supplier, (String)last.getCurrency(), (boolean)false);
        boolean isVendor = GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription()) == ContractType.VENDOR;
        boolean isFareFopsRelevant = last.isFareFopsRelevant();
        Double d = gdsCurrencyRate = isVendor && isFareFopsRelevant && rateData != null ? ph.getGdsCurrencyRate(product) : null;
        if (gdsCurrencyRate != null) {
            MulticurrencyHelper.modifyExchangeRateData((ExchangeRateData)rateData, (double)gdsCurrencyRate);
        }
        generalData.setCurrency((DictionaryReference)(rateData != null ? rateData.getCurrency() : new CurrencyInfoReference(last.getCurrency())));
        generalData.setRate(rateData);
        String currency = ContractRelationHelper.currencyCode((ContractRelationGeneralData)generalData);
        ContractRelationServiceData serviceData = contractRelation.getServiceData();
        ContractRelationServiceDataDetalization detalization = serviceData.getDetalization();
        if (isVendor && isFareFopsRelevant && rateData != null && rateData.getCoefficient() != 1.0 && !last.getFareCurrency().equals(currency)) {
            ExchangeRateCondition exchangeRateCondition = MulticurrencyHelper.buildExchangeRateCondition((ExchangeRateData)rateData);
            ExchangeRateData rateData2 = gdsCurrencyRate != null ? rateData : MulticurrencyHelper.buildExchangeRateData((String)last.getFareCurrency(), (String)currency, (ExchangeRateCondition)exchangeRateCondition, (Date)GeneralProductHelper.getOperationDate(product), (EntityReference)supplier, (boolean)false);
            String prevCurrency2 = last.getCurrency();
            ph.updateProductEquivalentFare(product, rateData2);
            last.updateFromEquivalentSums(product);
            last.setUpdateFops(true);
            if (!last.getCurrency().equals(prevCurrency2)) {
                rateData = MulticurrencyHelper.buildExchangeRateData((String)last.getCurrency(), (String)currency, (ExchangeRateCondition)exchangeRateCondition, (Date)productDate, (EntityReference)supplier, (boolean)false);
                generalData.setRate(rateData);
            }
        }
        BigDecimal oldCorrect = serviceData.getDetalization().getCorrectVat();
        GeneralProductHelper.updateServiceData(product, (BaseContractRelationData)contractRelation, (GeneralProductHelper.RelationData)last);
        if (isVendor && !isFareFopsRelevant && (null == (fare = ph.getProductEquivalentFare(product)) || fare.getValue() != null && detalization.getFare().compareTo(fare.getValue()) != 0 || !currency.equals(fare.getCurrency()))) {
            ExchangeRateData rateData2;
            if (last.getFareCurrency().equals(last.getCurrency())) {
                rateData2 = rateData;
            } else {
                Date operationDate = GeneralProductHelper.getOperationDate(product);
                rateData2 = MulticurrencyHelper.buildExchangeRateData((String)last.getFareCurrency(), (String)currency, (ExchangeRateCondition)MulticurrencyHelper.buildExchangeRateCondition((ExchangeRateData)generalData.getRate()), (Date)operationDate, (EntityReference)supplier, (boolean)false);
            }
            ph.updateProductEquivalentFare(product, rateData2);
        }
        if (rateData != null) {
            last.setUpdateFops(true);
        }
        if (last.shouldUpdateFops()) {
            BigDecimal paymentPricePrice;
            BigDecimal paymentPrice;
            BigDecimal addToServiceFop;
            BaseProduct previousProduct2 = ph.getPreviousProduct(product);
            if (previousProduct2 != null && ph.getStatus(previousProduct2) == ProductStatus.EXCHANGE && ph.getPreviousProduct(previousProduct2) != null) {
                BigDecimal currentExchangePrice;
                BigDecimal addToExchangeFop;
                BigDecimal prevExchangePrice = BigDecimal.ZERO;
                BaseProduct prevSellProduct = ph.getPreviousProduct(previousProduct2);
                GeneralProductContractRelationData prevRelation2 = (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation((List)ph.getUnmodifiableContractRelations(prevSellProduct), (EntityReference)contractRelation.getDescription());
                if (prevRelation2 != null) {
                    prevExchangePrice = prevRelation2.getFops().stream().filter(GeneralProductHelper::isServiceFop).map(GeneralProductFop::getEquivalentAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                if (BigDecimal.ZERO.compareTo(addToExchangeFop = prevExchangePrice.subtract(currentExchangePrice = contractRelation.getFops().stream().filter(f -> f.getType() == PaymentType.TICKET).map(GeneralProductFop::getEquivalentAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add))) != 0) {
                    BigDecimal surcharge;
                    GeneralProductFop exchangeFop = contractRelation.getFops().stream().filter(GeneralProductHelper::isServiceFop).filter(f -> f.getType() == PaymentType.TICKET).findFirst().orElse(null);
                    if (null == exchangeFop) {
                        exchangeFop = new GeneralProductFop();
                        exchangeFop.setType(PaymentType.TICKET);
                        exchangeFop.setEquivalentAmount(BigDecimal.ZERO);
                    }
                    if (BigDecimal.ZERO.compareTo(surcharge = MiscUtil.guarded((BigDecimal)exchangeFop.getEquivalentAmount()).add(addToExchangeFop)) > 0) {
                        surcharge = BigDecimal.ZERO;
                    }
                    exchangeFop.setEquivalentAmount(surcharge);
                }
            }
            if (BigDecimal.ZERO.compareTo(addToServiceFop = (paymentPrice = serviceData.getPaymentPrice()).subtract(paymentPricePrice = contractRelation.getFops().stream().filter(GeneralProductHelper::isServiceFop).map(GeneralProductFop::getEquivalentAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add).subtract(contractRelation.getFops().stream().filter(GeneralProductHelper::isServiceFop).flatMap(f -> f.getCommissions().stream()).filter(c -> GeneralProductHelper.isHiddenFee((EntityReference)c.getCommissionProperties())).map(BaseCommission::getEquivalentAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add)))) != 0) {
                GeneralProductFop serviceFop = contractRelation.getFops().stream().filter(GeneralProductHelper::isServiceFop).filter(f -> f.getType() == PaymentType.CASH).findFirst().orElse(null);
                if (null == serviceFop) {
                    serviceFop = contractRelation.getFops().stream().filter(GeneralProductHelper::isServiceFop).filter(f -> f.getType() == PaymentType.INVOICE).findFirst().orElse(null);
                }
                if (null == serviceFop) {
                    serviceFop = contractRelation.getFops().stream().filter(GeneralProductHelper::isServiceFop).findFirst().orElse(null);
                }
                if (null == serviceFop) {
                    serviceFop = new GeneralProductFop();
                    serviceFop.setType(PaymentType.CASH);
                    serviceFop.setEquivalentAmount(BigDecimal.ZERO);
                    OnCreateFopListener.fire(product, (Fop)serviceFop, (ContractType)GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription()));
                }
                serviceFop.setEquivalentAmount(MiscUtil.guarded((BigDecimal)serviceFop.getEquivalentAmount()).add(addToServiceFop));
            }
        }
        if (BigDecimal.ZERO.compareTo(correct = MiscUtil.guarded((BigDecimal)serviceData.getDetalization().getCorrectVat()).subtract(MiscUtil.guarded((BigDecimal)oldCorrect))) != 0) {
            GeneralProductFop serviceFop = contractRelation.getFops().stream().filter(GeneralProductHelper::isServiceFop).filter(f -> f.getType() == PaymentType.CASH).findFirst().orElse(null);
            if (null == serviceFop) {
                serviceFop = contractRelation.getFops().stream().filter(GeneralProductHelper::isServiceFop).filter(f -> f.getType() == PaymentType.INVOICE).findFirst().orElse(null);
            }
            if (null == serviceFop) {
                serviceFop = contractRelation.getFops().stream().filter(GeneralProductHelper::isServiceFop).findFirst().orElse(null);
            }
            if (null == serviceFop) {
                serviceFop = new GeneralProductFop();
                serviceFop.setType(PaymentType.CASH);
                serviceFop.setEquivalentAmount(BigDecimal.ZERO);
                OnCreateFopListener.fire(product, (Fop)serviceFop, (ContractType)GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription()));
            }
            serviceFop.setEquivalentAmount(MiscUtil.guarded((BigDecimal)serviceFop.getEquivalentAmount()).add(correct));
        }
        if ((ProductStatus.REFUND == productStatus || ProductStatus.EXCHANGE == productStatus) && (previousProduct = ph.getPreviousProduct(product)) != null && (prevRelation = (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation((List)ph.getUnmodifiableContractRelations(previousProduct), (EntityReference)contractRelation.getDescription())) != null && Objects.equals(currency, prevCurrency = ContractRelationHelper.currencyCode((ContractRelationGeneralData)(prevGeneralData = prevRelation.getGeneralData())))) {
            return prevRelation.getGeneralData().getRate();
        }
        return rateData;
    }

    private static void clearCommissions(List<GeneralProductContractRelationData> relations) {
        for (GeneralProductContractRelationData relation : relations) {
            GeneralProductRulesHelper.clearCommissionList(relation, relations);
        }
    }

    static void clearCommissionList(GeneralProductContractRelationData relation, List<GeneralProductContractRelationData> allRelations) {
        List commissions = relation.getCommissions();
        Iterator it = commissions.iterator();
        while (it.hasNext()) {
            GeneralProductCommission commission = (GeneralProductCommission)it.next();
            boolean commissionTranslated = GeneralProductRulesHelper.isCommissionTranslated(commission, relation, allRelations);
            EntityContainer ctr = EntityStorage.get().resolve(commission.getCommissionProperties());
            if (ctr != null && ctr.getEntity() instanceof FeeProperties && ((FeeProperties)ctr.getEntity()).getType() == FeeType.MANUALLY_CALCULATED && !commissionTranslated || ctr != null && ctr.getEntity() instanceof CommissionProperties && ((CommissionProperties)ctr.getEntity()).isManuallyCalculated() && !commissionTranslated || ctr != null && ctr.getEntity() instanceof DiscountProperties && ((DiscountProperties)ctr.getEntity()).getType() == DiscountType.MANUALLY_CALCULATED && !commissionTranslated) continue;
            it.remove();
        }
    }

    private static boolean isCommissionTranslated(GeneralProductCommission commission, GeneralProductContractRelationData relation, List<GeneralProductContractRelationData> allRelations) {
        int idx = allRelations.indexOf(relation);
        if (idx == 0) {
            return false;
        }
        GeneralProductContractRelationData previousRelation = allRelations.get(idx - 1);
        return previousRelation.getCommissions().stream().anyMatch(c -> MiscUtil.equals((Object)c.getCommissionProperties(), (Object)commission.getCommissionProperties()));
    }

    private static void deleteRulesValidationMessages(List<ValidationMessage> messages) {
        messages.removeIf(validationMessage -> validationMessage.getCategory() == ValidationMessageCategory.RULES);
    }

    private static <P extends BaseProduct> List<P> prepareProducts(EntityContainer<BookingFile> bookingCtr, final RulesProductHandler handler, boolean forced, boolean simulate, List<Message> messages, Map<Parameter, Object> params, boolean traceEnabled) throws Exception {
        ArrayList<BaseProduct> result = new ArrayList<BaseProduct>();
        BookingFile bookingFile = (BookingFile)bookingCtr.getEntity();
        final ProductHandler productHandler = HandlersRegistry.get().findProductHandler(handler.getProductClass());
        for (Reservation reservation : bookingFile.getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                if (!handler.getProductClass().equals(baseProduct.getClass())) continue;
                BaseProduct product = baseProduct;
                String productTitle = productHandler.generateProductName(product);
                log.debug("analyzing product {}", (Object)productTitle);
                if (handler.isChecked(product)) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.GeneralProductRulesHelper_ruleNotApplyAnchecked, (Object[])new Object[]{productTitle}));
                    log.debug("product is checked, skipping");
                    continue;
                }
                if (!handler.isRulesApplicable(product)) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.GeneralProductRulesHelper_rulesNotAppliesOnThisProduct, (Object[])new Object[]{productTitle}));
                    log.debug("rules not applicable to product, skipping");
                    continue;
                }
                if (!Boolean.FALSE.equals(GeneralProductRulesHelper.getFromParams(params, Parameter.SKIP_APPLIED_RULES)) && handler.isContractRulesApplied(product) && !forced) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.GeneralProductRulesHelper_ruleNotApplyEarlier, (Object[])new Object[]{productTitle}));
                    log.debug("contract rules for product were already applied, skipping");
                    continue;
                }
                if (ShipmentHelper.hasRelatedShipment(product)) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.AirRulesHelper_productHasShimpent, (Object[])new Object[]{productTitle}));
                    log.debug("product {} has related shipment,  skipping", (Object)productTitle);
                    product.getReservation().getBookingFile().getAppliedRules().removeIf(appliedRule -> appliedRule.isTravelPolicyRule() && product.getUid().equals(appliedRule.getProductUid()));
                    List<GeneralProductContractRelationData> contractRelations = handler.getContractRelations(product);
                    for (GeneralProductContractRelationData contractRelation : contractRelations) {
                        GeneralProductRulesHelper.applyTravelPolicy(handler, product, contractRelation, traceEnabled);
                    }
                    continue;
                }
                if (!simulate && ObjectCreationSettingsHelper.isCreateRulesDebugInfo(((BookingFile)bookingCtr.getEntity()).getNumber())) {
                    GeneralProductRulesHelper.deleteLogDocument((EntityReference<BookingFile>)bookingCtr.toReference(), product.getUid());
                }
                if (handler.getStatus(product) == ProductStatus.VOID) {
                    GeneralProductRulesHelper.deleteRulesValidationMessages(handler.getValidationMessages(product));
                    log.debug("status is VOID, skipping");
                    continue;
                }
                TicketType ticketType = handler.getTicketType(product);
                if (ticketType != null && !VALID_TICKET_TYPES.contains(ticketType)) {
                    GeneralProductRulesHelper.deleteRulesValidationMessages(handler.getValidationMessages(product));
                    GeneralProductRulesHelper.clearCommissions(handler.getContractRelations(product));
                    log.debug("product is not in {}, skipping", VALID_TICKET_TYPES);
                    continue;
                }
                result.add(product);
                log.debug("product was added to product list");
            }
        }
        result.sort(new Comparator<P>(){

            @Override
            public int compare(P o1, P o2) {
                int res = TextUtil.compare((String)TextUtil.collection2String((Collection)productHandler.getProductNumbers(o1)), (String)TextUtil.collection2String((Collection)productHandler.getProductNumbers(o2)), (boolean)false, (boolean)false);
                if (res != 0) {
                    return res;
                }
                return this.getStatusOrder(handler.getStatus(o1)) - this.getStatusOrder(handler.getStatus(o2));
            }

            private int getStatusOrder(ProductStatus status) {
                if (status == ProductStatus.SELL) {
                    return 1;
                }
                if (status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE) {
                    return 2;
                }
                return 0;
            }
        });
        return result;
    }

    private static Object getFromParams(Map<Parameter, Object> params, Parameter parameter) {
        return params != null ? params.get(parameter) : null;
    }

    private static void deleteLogDocument(EntityReference<BookingFile> reference, String uid) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.type.name(), (Object)DocumentType.DEBUG_RULES));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), reference));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)"navigationKey", (Object)uid), SearchCriterion.eq((String)"navigationKey", null)}));
        for (EntityContainer doc : StorageHelper.getEntityContainers((SearchQuery)query, BasicDocumentIndex.class)) {
            EntityStorage.get().delete(doc);
        }
    }

    private static <T extends BaseProduct, P, A> void addValidationMessage(RulesProductHandler<T, P, A> handler, T product, ValidationMessageType type, Throwable e, Object ... parameters) {
        ValidationMessage result = ValidationMessageHelper.createValidationMessage((ValidationMessageType)type, (Throwable)e, (Object[])parameters);
        handler.getValidationMessages(product).add(result);
    }

    public static <T extends BaseProduct, P> EntityContainer<Contract> getContract(ContractType contractType, T product, EntityReference<Organization> blankOwner, EntityReference<Organization> supplier, EntityReference<Organization> customer, List<ValidationMessage> messages, Date date, Enum<?> provider, P propertySet) throws Exception {
        String productTitle = GeneralProductRulesHelper.getProductTitle(product);
        if (customer == null) {
            switch (contractType) {
                case VENDOR: {
                    messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_VENDOR_CONTRACT_DIDNT_APPIED_AGENCY_NOT_DEFINED, (Object[])new Object[]{productTitle}));
                    break;
                }
                case SUBAGENCY: {
                    messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_SUBAGENCY_CONTRACT_DIDNT_APPIED_SUBAGENCY_NOT_DEFINED, (Object[])new Object[]{productTitle}));
                    break;
                }
                case CLIENT: {
                    messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_CLIENT_CONTRACT_DIDNT_APPIED_CUSTOMER_NOT_DEFINED, (Object[])new Object[]{productTitle}));
                    break;
                }
            }
            return null;
        }
        EntityReference<Organization> correctedSupplier = supplier;
        if (supplier == null && contractType == ContractType.VENDOR && null == provider) {
            if (blankOwner == null) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_NO_VENDOR_AND_BLANKOWNER, (Object[])new Object[]{productTitle}));
                return null;
            }
            correctedSupplier = blankOwner;
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_NO_VENDOR_TRY_BLANKOWNER, (Object[])new Object[]{productTitle, correctedSupplier}));
        }
        List<ContractIndex> contractIndices = GeneralProductRulesHelper.getContractIndices(contractType, blankOwner, customer, date, provider, correctedSupplier);
        EntityReference allAgenciesProfile = ProfileDao.findAllAgenciesProfile();
        EntityReference allClientsProfile = ProfileDao.findAllClientsProfile();
        if (contractIndices.isEmpty() && allAgenciesProfile != null) {
            contractIndices = GeneralProductRulesHelper.getContractIndices(contractType, blankOwner, customer, date, provider, (EntityReference<Organization>)allAgenciesProfile);
        }
        if (contractIndices.isEmpty()) {
            if (contractType.equals((Object)ContractType.CLIENT) && allClientsProfile != null) {
                contractIndices = GeneralProductRulesHelper.getContractIndices(contractType, blankOwner, (EntityReference<Organization>)allClientsProfile, date, provider, correctedSupplier);
            } else if (contractType.equals((Object)ContractType.SUBAGENCY) && allAgenciesProfile != null) {
                contractIndices = GeneralProductRulesHelper.getContractIndices(contractType, blankOwner, (EntityReference<Organization>)allAgenciesProfile, date, provider, correctedSupplier);
            }
        }
        if (contractIndices.isEmpty()) {
            if (contractType.equals((Object)ContractType.CLIENT) && allAgenciesProfile != null && allClientsProfile != null) {
                contractIndices = GeneralProductRulesHelper.getContractIndices(contractType, blankOwner, (EntityReference<Organization>)allClientsProfile, date, provider, (EntityReference<Organization>)allAgenciesProfile);
            } else if (contractType.equals((Object)ContractType.SUBAGENCY) && allAgenciesProfile != null) {
                contractIndices = GeneralProductRulesHelper.getContractIndices(contractType, blankOwner, (EntityReference<Organization>)allAgenciesProfile, date, provider, (EntityReference<Organization>)allAgenciesProfile);
            }
        }
        return GeneralProductRulesHelper.getContract(product, contractType, contractIndices, propertySet);
    }

    public static <T extends BaseProduct> List<EntityContainer<Contract>> getContracts(ContractType contractType, T product, EntityReference<Organization> blankOwner, EntityReference<Organization> supplier, EntityReference<Organization> customer, List<ValidationMessage> messages, Date date, Enum<?> provider) {
        List<ContractIndex> contractIndices = GeneralProductRulesHelper.getContractIndices(contractType, product, blankOwner, supplier, customer, messages, date, provider);
        if (CollectionUtil.isEmpty(contractIndices)) {
            return Collections.emptyList();
        }
        return GeneralProductRulesHelper.getContracts(product, contractType, contractIndices);
    }

    private static <T extends BaseProduct> List<ContractIndex> getContractIndices(ContractType contractType, T product, EntityReference<Organization> blankOwner, EntityReference<Organization> supplier, EntityReference<Organization> customer, List<ValidationMessage> messages, Date date, Enum<?> provider) {
        String productTitle = GeneralProductRulesHelper.getProductTitle(product);
        if (customer == null) {
            switch (contractType) {
                case VENDOR: {
                    messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_VENDOR_CONTRACT_DIDNT_APPIED_AGENCY_NOT_DEFINED, (Object[])new Object[]{productTitle}));
                    break;
                }
                case SUBAGENCY: {
                    messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_SUBAGENCY_CONTRACT_DIDNT_APPIED_SUBAGENCY_NOT_DEFINED, (Object[])new Object[]{productTitle}));
                    break;
                }
                case CLIENT: {
                    messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_CLIENT_CONTRACT_DIDNT_APPIED_CUSTOMER_NOT_DEFINED, (Object[])new Object[]{productTitle}));
                    break;
                }
            }
            return null;
        }
        EntityReference<Organization> correctedSupplier = supplier;
        if (supplier == null && contractType == ContractType.VENDOR && null == provider) {
            if (blankOwner == null) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_NO_VENDOR_AND_BLANKOWNER, (Object[])new Object[]{productTitle}));
                return null;
            }
            correctedSupplier = blankOwner;
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_NO_VENDOR_TRY_BLANKOWNER, (Object[])new Object[]{productTitle, correctedSupplier}));
        }
        List<ContractIndex> contractIndices = GeneralProductRulesHelper.getContractIndices(contractType, blankOwner, customer, date, provider, correctedSupplier);
        EntityReference allAgenciesProfile = ProfileDao.findAllAgenciesProfile();
        EntityReference allClientsProfile = ProfileDao.findAllClientsProfile();
        if (contractIndices.isEmpty() && allAgenciesProfile != null) {
            contractIndices = GeneralProductRulesHelper.getContractIndices(contractType, blankOwner, customer, date, provider, (EntityReference<Organization>)allAgenciesProfile);
        }
        if (contractIndices.isEmpty()) {
            if (contractType.equals((Object)ContractType.CLIENT) && allClientsProfile != null) {
                contractIndices = GeneralProductRulesHelper.getContractIndices(contractType, blankOwner, (EntityReference<Organization>)allClientsProfile, date, provider, correctedSupplier);
            } else if (contractType.equals((Object)ContractType.SUBAGENCY) && allAgenciesProfile != null) {
                contractIndices = GeneralProductRulesHelper.getContractIndices(contractType, blankOwner, (EntityReference<Organization>)allAgenciesProfile, date, provider, correctedSupplier);
            }
        }
        if (contractIndices.isEmpty()) {
            if (contractType.equals((Object)ContractType.CLIENT) && allAgenciesProfile != null && allClientsProfile != null) {
                contractIndices = GeneralProductRulesHelper.getContractIndices(contractType, blankOwner, (EntityReference<Organization>)allClientsProfile, date, provider, (EntityReference<Organization>)allAgenciesProfile);
            } else if (contractType.equals((Object)ContractType.SUBAGENCY) && allAgenciesProfile != null) {
                contractIndices = GeneralProductRulesHelper.getContractIndices(contractType, blankOwner, (EntityReference<Organization>)allAgenciesProfile, date, provider, (EntityReference<Organization>)allAgenciesProfile);
            }
        }
        return contractIndices;
    }

    private static List<ContractIndex> getContractIndices(ContractType contractType, EntityReference<Organization> blankOwner, EntityReference<Organization> customer, Date date, Enum<?> provider, EntityReference<Organization> correctedSupplier) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.newModel.name(), (Object)true));
        if (null == provider) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), correctedSupplier));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), correctedSupplier), SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), null)}));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.customer.name(), customer));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.contractType.name(), (Object)contractType));
        if (blankOwner != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.vendor.name(), blankOwner), SearchCriterion.eq((String)ContractIndex.Property.vendor.name(), null)}));
        }
        if (provider instanceof HotelProvider) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.provider.name(), provider), SearchCriterion.eq((String)ContractIndex.Property.provider.name(), null)}));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.transferProvider.name(), null));
        } else if (provider instanceof TransferProvider) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.transferProvider.name(), provider), SearchCriterion.eq((String)ContractIndex.Property.transferProvider.name(), null)}));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.provider.name(), null));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.provider.name(), null));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.transferProvider.name(), null));
        }
        if (date != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractIndex.Property.startDate.name(), (Object)MiscUtil.setDayEndTime((Date)date))}));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractIndex.Property.endDate.name(), (Object)MiscUtil.clearTime((Date)date))}));
        }
        return new ArrayList<ContractIndex>(EntityStorage.get().search(ContractIndex.class, query, IrrelevanceTolerantEntityStorage.IRRELEVANCE_TOLERANT_PARAMS).getData());
    }

    public static <T extends BaseProduct, P, A> MiscUtil.Pair<List<EntityContainer<Contract>>, List<ContractCustomerInfo>> collectOldContracts(final ContractType contractType, T product, RulesProductHandler<T, P, A> handler, EntityReference<Organization> blankOwner, EntityReference<Organization> supplier, EntityReference<Organization> customer, Enum<?> provider) {
        String productTitle = GeneralProductRulesHelper.getProductTitle(product);
        List<ValidationMessage> messages = handler.getValidationMessages(product);
        List emptyList = Collections.emptyList();
        if (customer == null) {
            switch (contractType) {
                case VENDOR: {
                    messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_VENDOR_CONTRACT_DIDNT_APPIED_AGENCY_NOT_DEFINED, (Object[])new Object[]{productTitle}));
                    break;
                }
                case SUBAGENCY: {
                    messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_SUBAGENCY_CONTRACT_DIDNT_APPIED_SUBAGENCY_NOT_DEFINED, (Object[])new Object[]{productTitle}));
                    break;
                }
                case CLIENT: {
                    messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_CLIENT_CONTRACT_DIDNT_APPIED_CUSTOMER_NOT_DEFINED, (Object[])new Object[]{productTitle}));
                    break;
                }
            }
            return new MiscUtil.Pair(emptyList, null);
        }
        EntityReference<Organization> correctedSupplier = supplier;
        final EntityReference allAgenciesProfile = ProfileDao.findAllAgenciesProfile();
        if (supplier == null && contractType == ContractType.VENDOR && null == provider) {
            if (blankOwner == null) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_NO_VENDOR_AND_BLANKOWNER, (Object[])new Object[]{productTitle}));
                return new MiscUtil.Pair(emptyList, null);
            }
            correctedSupplier = blankOwner;
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_NO_VENDOR_TRY_BLANKOWNER, (Object[])new Object[]{productTitle, correctedSupplier}));
        }
        final EntityReference allClientsProfile = ProfileDao.findAllClientsProfile();
        HashSet<EntityReference<Organization>> suppliers = new HashSet<EntityReference<Organization>>();
        HashSet<EntityReference<Organization>> customers = new HashSet<EntityReference<Organization>>();
        suppliers.add(correctedSupplier);
        customers.add(customer);
        if (allAgenciesProfile != null) {
            switch (contractType) {
                case VENDOR: {
                    customers.add(allAgenciesProfile);
                    break;
                }
                case SUBAGENCY: {
                    customers.add(allAgenciesProfile);
                    suppliers.add(allAgenciesProfile);
                    break;
                }
                case CLIENT: {
                    suppliers.add(allAgenciesProfile);
                }
            }
        }
        if (allClientsProfile != null && contractType == ContractType.CLIENT) {
            customers.add(allClientsProfile);
        }
        if (contractType == ContractType.VENDOR) {
            suppliers.add(null);
        } else if (provider != null) {
            suppliers.add(null);
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.newModel.name(), null), SearchCriterion.eq((String)ContractIndex.Property.newModel.name(), (Object)false)}));
        query.getCriteria().getCriterions().add(GeneralProductRulesHelper.toCriterion(ContractCustomerIndex.Property.supplier.name(), suppliers));
        query.getCriteria().getCriterions().add(GeneralProductRulesHelper.toCriterion(ContractCustomerIndex.Property.customer.name(), customers));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.contractType.name(), (Object)contractType));
        if (blankOwner != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.vendor.name(), blankOwner), SearchCriterion.eq((String)ContractCustomerIndex.Property.vendor.name(), null)}));
        }
        if (provider != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.provider.name(), provider), SearchCriterion.eq((String)ContractCustomerIndex.Property.provider.name(), null)}));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.provider.name(), null));
        }
        Date date = handler.getIssueDate(product);
        if (date != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractCustomerIndex.Property.startDate.name(), (Object)MiscUtil.setDayEndTime((Date)date))}));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractCustomerIndex.Property.endDate.name(), (Object)MiscUtil.clearTime((Date)date))}));
        }
        final HashMap<EntityReference, EntityContainer> contractsMap = new HashMap<EntityReference, EntityContainer>();
        ArrayList<ContractCustomerIndex> contractIndexes = new ArrayList<ContractCustomerIndex>(EntityStorage.get().search(ContractCustomerIndex.class, query, IrrelevanceTolerantEntityStorage.IRRELEVANCE_TOLERANT_PARAMS).getData());
        for (ContractCustomerIndex item : contractIndexes) {
            contractsMap.put(item.getSource(), EntityStorage.get().resolve(item.getSource()));
        }
        final String preferredClientContractNumber = handler.getPrefferedClientContractNumber(product);
        contractIndexes.sort(new Comparator<ContractCustomerIndex>(){

            @Override
            public int compare(ContractCustomerIndex o1, ContractCustomerIndex o2) {
                int index2;
                boolean idx2;
                boolean idx1;
                if (contractType == ContractType.CLIENT && !TextUtil.isBlank((String)preferredClientContractNumber) && (idx1 = preferredClientContractNumber.equals(o1.getNumber())) != (idx2 = preferredClientContractNumber.equals(o2.getNumber()))) {
                    return idx1 ? -1 : 1;
                }
                EntityContainer ctr1 = (EntityContainer)contractsMap.get(o1.getSource());
                EntityContainer ctr2 = (EntityContainer)contractsMap.get(o2.getSource());
                if (((Contract)ctr1.getEntity()).getPriority() != ((Contract)ctr2.getEntity()).getPriority()) {
                    return ((Contract)ctr1.getEntity()).getPriority() > ((Contract)ctr2.getEntity()).getPriority() ? -1 : 1;
                }
                int index1 = this.getGeneralityIndex(o1);
                if (index1 != (index2 = this.getGeneralityIndex(o2))) {
                    return index1 > index2 ? 1 : -1;
                }
                if (((Contract)ctr1.getEntity()).isTypicalContract() != ((Contract)ctr2.getEntity()).isTypicalContract()) {
                    return ((Contract)ctr1.getEntity()).isTypicalContract() ? 1 : -1;
                }
                return -MiscUtil.compare((Date)o1.getIssueDate(), (Date)o2.getIssueDate(), (boolean)true);
            }

            private int getGeneralityIndex(ContractCustomerIndex o1) {
                return (allAgenciesProfile != null && allAgenciesProfile.equals((Object)o1.getSupplier()) ? 4 : 0) + (allAgenciesProfile != null && allAgenciesProfile.equals((Object)o1.getCustomer()) ? 2 : 0) + (allClientsProfile != null && allClientsProfile.equals((Object)o1.getCustomer()) ? 1 : 0);
            }
        });
        ArrayList<EntityContainer> result = new ArrayList<EntityContainer>();
        ArrayList<ContractCustomerInfo> customerInfos = new ArrayList<ContractCustomerInfo>();
        for (ContractCustomerIndex index : contractIndexes) {
            EntityContainer ctr = (EntityContainer)contractsMap.get(index.getSource());
            if (!result.contains(ctr)) {
                result.add(ctr);
            }
            if (TextUtil.isBlank((String)index.getNumber())) continue;
            for (ContractCustomerInfo info : ((Contract)ctr.getEntity()).getCustomers()) {
                if (!info.getUid().equals(index.getNavigationKey())) continue;
                customerInfos.add(info);
            }
        }
        return new MiscUtil.Pair(result, customerInfos);
    }

    private static SearchCriterion toCriterion(String propertyName, Set<EntityReference<Organization>> suppliers) {
        if (suppliers.size() == 1) {
            return SearchCriterion.eq((String)propertyName, suppliers.iterator().next());
        }
        ArrayList<SearchCriterion> crits = new ArrayList<SearchCriterion>();
        for (EntityReference<Organization> item : suppliers) {
            crits.add(SearchCriterion.eq((String)propertyName, item));
        }
        return SearchCriterion.or((SearchCriterion[])crits.toArray(new SearchCriterion[0]));
    }

    private static <T extends BaseProduct, P, A> void updatePreviouslyCalculatedCommissions(RulesProductHandler<T, P, A> handler, T item, RuleProxy<P, A> proxy, GeneralProductContractRelationData contractRelation, List<GeneralProductContractRelationData> contractRelations, List<GeneralProductContractRelationData> previousProductContractRelations, boolean separateSupplierFees, ExchangeRateData rateData) {
        ContractType contractType = GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription());
        try {
            List<GeneralProductCommission> commissions = handler.createCommissions(proxy, item, contractRelation, contractRelations, previousProductContractRelations, separateSupplierFees, rateData);
            if (commissions.isEmpty()) {
                log.debug("no commission was added");
                return;
            }
            if (handler.getStatus(item) == ProductStatus.REFUND || handler.getStatus(item) == ProductStatus.EXCHANGE) {
                GeneralProductRulesHelper.addValidationMessage(handler, item, (ValidationMessageType)StandartValidationMessageType.RH_COMMISION_WAS_PARTIALLY_REFUNDED, null, contractType);
            }
        }
        catch (Throwable e) {
            log.error("unable to update refunded commissions", e);
            GeneralProductRulesHelper.addValidationMessage(handler, item, (ValidationMessageType)StandartValidationMessageType.RH_COMMISSION_UPDATE_FAILED, e, contractType);
        }
    }

    private static void cleanupFops(GeneralProductContractRelationData contractRelation) {
        Iterator it = contractRelation.getFops().iterator();
        while (it.hasNext()) {
            EntityContainer ctr;
            GeneralProductFop fop = (GeneralProductFop)it.next();
            if (GeneralProductHelper.isServiceFop((GeneralProductFop)fop) || (ctr = EntityStorage.get().resolve(((GeneralProductCommission)fop.getCommissions().get(0)).getCommissionProperties())) != null && ctr.getEntity() instanceof FeeProperties && ((FeeProperties)ctr.getEntity()).getType() == FeeType.MANUALLY_CALCULATED || ctr != null && ctr.getEntity() instanceof CommissionProperties && ((CommissionProperties)ctr.getEntity()).isManuallyCalculated() || ctr != null && ctr.getEntity() instanceof DiscountProperties && ((DiscountProperties)ctr.getEntity()).getType() == DiscountType.MANUALLY_CALCULATED) continue;
            it.remove();
        }
    }

    private static <T extends BaseProduct> void saveLogDocument(String initTrace, RuleProxy<?, ?> proxy, EntityContainer<BookingFile> container, T product, ContractType contractType, Map<Parameter, Object> params) throws Exception {
        EntityContainer ctr = new EntityContainer(Document.class);
        ctr.setCreated(new Date());
        ctr.setModified(ctr.getCreated());
        ctr.setCreatedBy(LogicalStorage.get().getUser());
        ctr.setModifiedBy(ctr.getCreatedBy());
        String trace = initTrace + "\r\n" + proxy.getTracer().getTrace();
        Document document = (Document)ctr.getEntity();
        document.setContentType(ContentType.TEXT);
        byte[] content = trace.getBytes(StandardCharsets.UTF_8);
        document.setContent(content);
        document.setCheckSum(MiscUtil.getCheckSum((byte[])content));
        DocumentType documentType = (DocumentType)GeneralProductRulesHelper.getFromParams(params, Parameter.LOG_DOCUMENT_TYPE);
        if (null == documentType) {
            documentType = DocumentType.DEBUG_RULES;
        }
        document.setType(documentType);
        String name = (String)GeneralProductRulesHelper.getFromParams(params, Parameter.LOG_DOCUMENT_NAME);
        if (TextUtil.isBlank((String)name)) {
            name = "Log for product ${product} for contract of type ${contractType}";
        }
        ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
        name = name.replace("${product}", handler.generateShortProductName(product)).replace("${contractType}", contractType != null ? contractType.name() : "(empty)");
        document.setName(name);
        document.setDescription(document.getName());
        document.setTitle(document.getName());
        EntityReference owner = (EntityReference)GeneralProductRulesHelper.getFromParams(params, Parameter.LOG_DOCUMENT_OWNER);
        if (null == owner) {
            owner = container.toReference();
        }
        document.setOwner(owner);
        document.setCreated(ctr.getCreated());
        document.setNavigationKey(product.getUid());
        EntityStorage.get().save(ctr, false);
    }

    /*
     * Could not resolve type clashes
     */
    private static <T extends BaseProduct, P, A> void updateManuallyCalculatedFees(List<GeneralProductContractRelationData> relations, EntityReference<Person> agent, T product) throws Exception {
        for (GeneralProductContractRelationData relation : relations) {
            Object comm2;
            String equivalentCurrency = relation.getGeneralData().getCurrency() != null ? relation.getGeneralData().getCurrency().getCode() : DictHelper.getLocalCurrency();
            Date operationDate = GeneralProductHelper.getOperationDate(product);
            ExchangeRateData rate = relation.getGeneralData().getRate();
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object comm2 : relation.getCommissions()) {
                FeeProperties prop;
                EntityContainer ctr;
                if (comm2.getEquivalentAmount() == null || (ctr = EntityStorage.get().resolve(comm2.getCommissionProperties())) == null || !(ctr.getEntity() instanceof FeeProperties) || (prop = (FeeProperties)ctr.getEntity()).getType() != FeeType.MANUALLY_CALCULATED) continue;
                GeneralProductRulesHelper.updateManuallyCalculatedFeeAmount((GeneralProductCommission)comm2, equivalentCurrency, operationDate, rate);
                boolean found = false;
                for (GeneralProductFop fop : relation.getFops()) {
                    if (!fop.getCommissions().contains(comm2)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                list.add(comm2);
            }
            if (list.isEmpty()) continue;
            GeneralProductFop productFop = null;
            comm2 = relation.getFops().iterator();
            while (comm2.hasNext()) {
                GeneralProductFop fop = (GeneralProductFop)comm2.next();
                if (fop.getType() == PaymentType.TICKET) continue;
                productFop = fop;
                break;
            }
            GeneralProductFop fop = new GeneralProductFop();
            if (productFop != null) {
                fop.setAgent(productFop.getAgent());
                fop.setCard(productFop.getCard());
                fop.setType(productFop.getType());
            } else {
                fop.setAgent(agent == null ? com.gridnine.xtrip.server.model.helpers.ProfileDao.findCurrentAgent(null) : agent);
                fop.setType(PaymentType.CASH);
            }
            BigDecimal value = BigDecimal.ZERO;
            for (GeneralProductCommission comm3 : list) {
                value = value.add(comm3.getEquivalentAmount());
            }
            fop.setOperationDate(new Date());
            fop.setEquivalentAmount(value);
            fop.getCommissions().addAll(list);
            relation.getFops().add(fop);
        }
    }

    private static void updateManuallyCalculatedFeeAmount(GeneralProductCommission commission, String equivalentCurrency, Date operationDate, ExchangeRateData rate) {
        Money money = commission.getAmount();
        if (null == money || money.getCurrency() == null || money.getValue() == null || equivalentCurrency.equals(money.getCurrency())) {
            return;
        }
        ExchangeRateData rateData = rate != null ? rate : MulticurrencyHelper.buildExchangeRateData((String)money.getCurrency(), (String)equivalentCurrency, null, (Date)operationDate, null, (boolean)false);
        try {
            EntityContainer ctr = EntityStorage.get().resolve(commission.getCommissionProperties());
            if (ctr != null) {
                rateData.setRoundingMode(((BaseCommissionProperties)ctr.getEntity()).getRoundingMode());
                rateData.setRoundingValue(((BaseCommissionProperties)ctr.getEntity()).getRoundingValue());
            }
        }
        catch (Exception e) {
            log.error("unable to resolve reference " + commission.getCommissionProperties(), (Throwable)e);
        }
        commission.setEquivalentAmount(RulesHelper.convert((BigDecimal)money.getValue(), (ExchangeRateData)rateData));
    }

    private static <T extends BaseProduct> void setManualCommissionsAppliedFlags(T product, List<GeneralProductCommission> commissions, ContractType contractType) {
        Boolean productManualDiscountApplied;
        Boolean productManualCommissionApplied;
        boolean manualFeeApplied = false;
        boolean manualCommissionApplied = false;
        boolean manualDiscountApplied = false;
        for (GeneralProductCommission commission : commissions) {
            EntityContainer properties = EntityStorage.get().resolve(commission.getCommissionProperties());
            if (properties == null) continue;
            if (properties.getEntity() instanceof FeeProperties && ((FeeProperties)properties.getEntity()).getType() == FeeType.MANUALLY_CALCULATED) {
                manualFeeApplied = true;
            }
            if (properties.getEntity() instanceof CommissionProperties && ((CommissionProperties)properties.getEntity()).isManuallyCalculated()) {
                manualCommissionApplied = true;
            }
            if (!(properties.getEntity() instanceof DiscountProperties) || ((DiscountProperties)properties.getEntity()).getType() != DiscountType.MANUALLY_CALCULATED) continue;
            manualDiscountApplied = true;
        }
        Boolean productManualFeeApplied = (Boolean)product.getManualFeeAppliedFlags().get(contractType);
        if (productManualFeeApplied == null || !productManualFeeApplied.booleanValue()) {
            product.getManualFeeAppliedFlags().put(contractType, manualFeeApplied);
        }
        if ((productManualCommissionApplied = (Boolean)product.getManualCommissionAppliedFlags().get(contractType)) == null || !productManualCommissionApplied.booleanValue()) {
            product.getManualCommissionAppliedFlags().put(contractType, manualCommissionApplied);
        }
        if ((productManualDiscountApplied = (Boolean)product.getManualDiscountAppliedFlags().get(contractType)) == null || !productManualDiscountApplied.booleanValue()) {
            product.getManualDiscountAppliedFlags().put(contractType, manualDiscountApplied);
        }
    }

    private GeneralProductRulesHelper() {
    }

    public static <T extends BaseProduct, P, A> ProductRelatedOrganizations collectOrganizations(T product, RulesProductHandler<T, P, A> handler) throws Exception {
        ProductHandler productHandler = HandlersRegistry.get().findProductHandler(handler.getProductClass());
        SalesChain salesChain = productHandler.getSalesChain(product);
        SalesChain result = new SalesChain();
        result.setDescription(salesChain.getDescription());
        result.getContractors().addAll(salesChain.getContractors());
        EntityReference agencyRef = GeneralProductHelper.getContractor((SalesChain)result, (PredefinedContractorType)PredefinedContractorType.AGENCY);
        if (agencyRef == null) {
            if (product.getReservation().getBookingFile().getAgency() != null) {
                String productTitle = productHandler.generateShortProductName(product);
                agencyRef = product.getReservation().getBookingFile().getAgency();
                GeneralProductRulesHelper.addValidationMessage(handler, product, (ValidationMessageType)StandartValidationMessageType.RH_TRY_GET_AGENCY_FROM_MAINTAB, null, productTitle);
            }
            GeneralProductHelper.setContractor((SalesChain)result, (PredefinedContractorType)PredefinedContractorType.AGENCY, (EntityReference)agencyRef);
        }
        EntityReference vendor = productHandler.getBlankOwner(product);
        return new ProductRelatedOrganizations((EntityReference<Organization>)vendor, (EntityReference<Organization>)product.getReservation().getBookingFile().getCustomerProfile(), salesChain);
    }

    private static String getProductTitle(BaseProduct product) {
        ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
        return handler.generateShortProductName(product);
    }

    public static <T extends BaseProduct, P, A> EntityContainer<Contract> getContract(T product, ContractType contractType, Collection<ContractIndex> contractIndexes, P propertySet) throws Exception {
        CommissionProxyHandler proxyHandler;
        EntityContainer contract;
        ProductHandler handler = GeneralProductHelper.getHandler(product);
        String preferredClientContractNumber = handler.getPreferredClientContractNumber(product);
        if (ContractType.CLIENT == contractType && TextUtil.nonBlank((String)preferredClientContractNumber) && (contract = (EntityContainer)contractIndexes.stream().filter(i -> preferredClientContractNumber.equals(i.getNumber())).map(i -> EntityStorage.get().resolve(i.getSource())).filter(Objects::nonNull).findFirst().orElse(null)) != null) {
            return contract;
        }
        if (contractIndexes.size() > 1 && (proxyHandler = ServerHandlersRegistry.get().getCommissionProxyHandler(product.getClass())) != null) {
            RuleProxy proxy = proxyHandler.createProxy(product, propertySet);
            proxy.getTracer().setDisabled(true);
            for (ContractIndex index : contractIndexes) {
                EntityContainer contract2 = EntityStorage.get().resolve(index.getSource());
                if (null == contract2) continue;
                proxy.setContractType(contractType.name());
                proxyHandler.clearActionSet(proxy, product);
                if (!(proxy.getActionSet() instanceof ContractActionsProvider)) break;
                RulesHelper.applyRules((EntityContainer)contract2, Collections.singletonList(proxy), product);
                if (!Boolean.TRUE.equals(((ContractActionsProvider)proxy.getActionSet()).isContractSelected())) continue;
                return contract2;
            }
        }
        return ProfileHelper.getDefaultContract(contractIndexes);
    }

    public static <T extends BaseProduct> List<EntityContainer<Contract>> getContracts(T product, ContractType contractType, Collection<ContractIndex> contractIndexes) {
        EntityContainer contract;
        ProductHandler handler = GeneralProductHelper.getHandler(product);
        String preferredClientContractNumber = handler.getPreferredClientContractNumber(product);
        if (ContractType.CLIENT == contractType && TextUtil.nonBlank((String)preferredClientContractNumber) && (contract = (EntityContainer)contractIndexes.stream().filter(i -> preferredClientContractNumber.equals(i.getNumber())).map(i -> EntityStorage.get().resolve(i.getSource())).filter(Objects::nonNull).findFirst().orElse(null)) != null) {
            return Collections.singletonList(contract);
        }
        ArrayList<EntityContainer<Contract>> result = new ArrayList<EntityContainer<Contract>>();
        for (ContractIndex index : contractIndexes) {
            EntityContainer contract2 = EntityStorage.get().resolve(index.getSource());
            if (contract2 == null) continue;
            result.add((EntityContainer<Contract>)contract2);
        }
        return result;
    }

    public static void updateFromGeneralFops(GeneralProductContractRelationData relation, List<GeneralProductFop> fops) {
        List generalFops = relation.getFops();
        ArrayList<GeneralProductFop> newFops = new ArrayList<GeneralProductFop>();
        for (GeneralProductFop fop : generalFops) {
            GeneralProductFop item = (GeneralProductFop)CollectionUtil.find(fops, (String)fop.getUid());
            if (item == null) {
                item = new GeneralProductFop();
                item.setUid(fop.getUid());
            }
            item.setAgent(fop.getAgent());
            item.setCard(fop.getCard());
            item.setEquivalentAmount(fop.getEquivalentAmount());
            item.setOperationDate(fop.getOperationDate());
            item.setRelatedTicketNumber(fop.getRelatedTicketNumber());
            item.setType(fop.getType());
            item.getCommissions().clear();
            item.setPayer(fop.getPayer());
            item.getCommissions().addAll(fop.getCommissions());
            newFops.add(item);
        }
        fops.clear();
        fops.addAll(newFops);
    }
}

