/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.rules;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentHelper;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.Parameter;
import com.gridnine.xtrip.common.model.rules.standard.InsuranceAccidentPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.elements.DebugInfo;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.handlers.InsuranceAccidentActionSet;
import com.gridnine.xtrip.server.model.handlers.InsuranceAccidentPropertySet;
import com.gridnine.xtrip.server.model.handlers.RulesHandler;
import com.gridnine.xtrip.server.model.handlers.rules.GeneralProductRulesHelper;
import com.gridnine.xtrip.server.model.handlers.rules.RulesProductHandler;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InsuranceAccidentRulesHandler
implements RulesHandler {
    @Override
    public void applyRules(EntityContainer<BookingFile> bookingContainer, boolean forced, boolean simulate, List<Message> messages, Map<Parameter, Object> params, DebugInfo debugInfo, boolean calcAppliedRulesToBooking) throws Exception {
        GeneralProductRulesHelper.applyContracts(bookingContainer, forced, simulate, new RulesProductHandler<InsuranceAccident, InsuranceAccidentPropertySet, InsuranceAccidentActionSet>(){

            @Override
            public void clearActionSet(RuleProxy<InsuranceAccidentPropertySet, InsuranceAccidentActionSet> proxy, InsuranceAccident item) {
                proxy.getAppliedRuleCategories().clear();
                proxy.getAppliedRules().clear();
                proxy.getTracer().clear();
                proxy.setActionSet((Object)new InsuranceAccidentActionSet(proxy, (InsuranceAccidentPropertiesProvider)proxy.getPropertySet(), item));
            }

            @Override
            public RuleProxy<InsuranceAccidentPropertySet, InsuranceAccidentActionSet> createProxy(InsuranceAccident item, boolean enabledTracer) {
                RuleProxy proxy = new RuleProxy();
                InsuranceAccidentPropertySet props = new InsuranceAccidentPropertySet(proxy);
                proxy.setPropertySet((Object)props);
                proxy.setProxyDate(item.getIssueDate());
                proxy.getTracer().setDisabled(!enabledTracer);
                proxy.setProxyType(Targets.INSURANCE_ACCIDENT_COMMISSION.getId());
                ((InsuranceAccidentPropertySet)proxy.getPropertySet()).init(item);
                return proxy;
            }

            @Override
            public EntityReference<Organization> getBlankOwner(InsuranceAccident item) {
                return item.getBlankOwner();
            }

            @Override
            public Date getIssueDate(InsuranceAccident item) {
                return item.getIssueDate();
            }

            @Override
            public boolean hasRefundCommissions(RuleProxy<InsuranceAccidentPropertySet, InsuranceAccidentActionSet> proxy) {
                return ((InsuranceAccidentActionSet)proxy.getActionSet()).hasRefundCommissions();
            }

            @Override
            public Class<InsuranceAccident> getProductClass() {
                return InsuranceAccident.class;
            }

            @Override
            public ProductStatus getStatus(InsuranceAccident item) {
                return item.getStatus();
            }

            @Override
            public TicketType getTicketType(InsuranceAccident item) {
                return item.getTicketType();
            }

            @Override
            public List<ValidationMessage> getValidationMessages(InsuranceAccident item) {
                return item.getValidationMessages();
            }

            @Override
            public boolean isChecked(InsuranceAccident item) {
                return item.isChecked();
            }

            @Override
            public boolean isContractRulesApplied(InsuranceAccident item) {
                return item.isContractRulesApplied();
            }

            @Override
            public void setContractRulesApplied(InsuranceAccident item, boolean value) {
                item.setContractRulesApplied(value);
            }

            @Override
            public void updateContractRelationsBySalesChain(InsuranceAccident item) {
            }

            @Override
            public List<GeneralProductContractRelationData> getContractRelations(InsuranceAccident item) {
                return InsuranceAccidentHelper.getContractRelations((InsuranceAccident)item);
            }

            @Override
            public List<GeneralProductContractRelationData> getPreviousProductContractRelations(InsuranceAccident item) {
                return item.getPreviousProduct() == null ? null : InsuranceAccidentHelper.getContractRelations((InsuranceAccident)item.getPreviousProduct());
            }

            @Override
            public List<GeneralProductCommission> createCommissions(RuleProxy<InsuranceAccidentPropertySet, InsuranceAccidentActionSet> proxy, InsuranceAccident item, GeneralProductContractRelationData relation, List<GeneralProductContractRelationData> allRelations, List<GeneralProductContractRelationData> previousProductContractRelations, boolean separateSupplierFees, ExchangeRateData rateData) throws Exception {
                return ((InsuranceAccidentActionSet)proxy.getActionSet()).createCommissions(relation, allRelations, previousProductContractRelations, separateSupplierFees, rateData, new ArrayList<ValidationMessage>());
            }

            @Override
            public List<GeneralProductCommission> createCommissions(RuleProxy<InsuranceAccidentPropertySet, InsuranceAccidentActionSet> proxy, InsuranceAccident item, GeneralProductContractRelationData relation, List<GeneralProductContractRelationData> allRelations, List<GeneralProductContractRelationData> previousProductContractRelations, boolean translateSupplierFees, boolean separateSupplierFees, ExchangeRateData rateData) throws Exception {
                return ((InsuranceAccidentActionSet)proxy.getActionSet()).createCommissions(relation, allRelations, previousProductContractRelations, translateSupplierFees, separateSupplierFees, rateData, new ArrayList<ValidationMessage>());
            }

            @Override
            public void afterCommissionCalculated(InsuranceAccident item) {
            }

            @Override
            public Set<PaymentType> getAllowedPaymentTypes(InsuranceAccidentActionSet actionSet) {
                return actionSet.getAllowedPaymentTypes();
            }
        }, messages, params, calcAppliedRulesToBooking);
    }

    @Override
    public String getId() {
        return MiscUtil.getSimpleClassName(this.getClass());
    }
}

