/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.rules;

import com.gridnine.xtrip.common.model.qualityCheck.OrganizationQualityCheckRules;
import com.gridnine.xtrip.common.model.rules.standard.qualityCheck.QualityCheckActionProvider;
import com.gridnine.xtrip.common.model.rules.standard.qualityCheck.QualityCheckActionResult;
import com.gridnine.xtrip.common.model.rules.standard.qualityCheck.QualityCheckPropertiesProvider;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleFilteringCategory;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleResultHandler;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QualityCheckRulesHelper {
    private static final Logger log = LoggerFactory.getLogger(QualityCheckRulesHelper.class);

    public static void applyRules(RuleProxy<? extends QualityCheckPropertiesProvider, QualityCheckActionResult> proxy, OrganizationQualityCheckRules rules, Set<? extends RuleFilteringCategory> categories) throws Exception {
        QualityCheckRulesHelper.applyRules(Collections.singletonList(proxy), rules.getRuleSet(), categories);
    }

    public static void applyRules(List<RuleProxy<? extends QualityCheckPropertiesProvider, QualityCheckActionResult>> proxies, OrganizationQualityCheckRules rules, Set<? extends RuleFilteringCategory> categories) throws Exception {
        QualityCheckRulesHelper.applyRules(proxies, rules.getRuleSet(), categories);
    }

    public static void applyRules(RuleProxy<? extends QualityCheckPropertiesProvider, QualityCheckActionResult> proxy, RuleSet ruleSet, Set<? extends RuleFilteringCategory> categories) throws Exception {
        QualityCheckRulesHelper.applyRules(Collections.singletonList(proxy), ruleSet, categories);
    }

    public static void applyRules(List<RuleProxy<? extends QualityCheckPropertiesProvider, QualityCheckActionResult>> proxies, RuleSet ruleSet, Set<? extends RuleFilteringCategory> categories) throws Exception {
        if (ruleSet == null) {
            log.info("No rule set to apply");
            return;
        }
        List rs = ruleSet.getRules().stream().filter(r -> categories.contains(r.getFilteringCategory())).collect(Collectors.toList());
        if (rs.isEmpty()) {
            log.info("No rules for categories " + categories.stream().map(RuleFilteringCategory::getDisplayName).collect(Collectors.joining(",")));
        }
        RuleEngine.applyRules(proxies, rs, (RuleResultHandler)new RuleResultHandler(){

            public void processRuleResult(RuleProxy<?, ?> proxy, RuleSettings ruleSettings, RuleResult ruleResult) throws Exception {
                ((QualityCheckActionProvider)proxy.getActionSet()).setRuleUid(ruleSettings.getUid());
                proxy.getAppliedRuleCategories().clear();
            }

            public boolean isProcessAllRuleResults() {
                return true;
            }
        });
    }
}

