/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.rules;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AppliedRule;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.commission.BaseCategorizedCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.dict.CommissionCategory;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.model.handlers.ProductCommissionActionSet;
import com.gridnine.xtrip.server.model.handlers.ProductPropertySet;
import com.gridnine.xtrip.server.model.handlers.rules.AirRulesHelper;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class S720130401VirtualizationHelper {
    static final String S7_2013_04_01_VIRTUAL_TICKET_PREFFIX = "S7_VIRTUAL_2013_04_01:";
    public static final Date startDate;

    static boolean isApplicable(Product ticket) {
        if (!"421".equals(ticket.getCarrierNumber())) {
            return false;
        }
        return ticket.getIssueDate() != null && !ticket.getIssueDate().before(startDate);
    }

    static void virtualize(Product ticket, List<Product> result) throws Exception {
        result.add(ticket);
        if (!S720130401VirtualizationHelper.isApplicable(ticket)) {
            return;
        }
        if (ticket.getProductCategory() != ProductCategory.AIR && (ticket.getProductCategory() != ProductCategory.MCO || ticket.getMcoCategory() != MCOCategory.PTA)) {
            return;
        }
        if (ticket.getSegmentTariffs().size() <= 1) {
            return;
        }
        if (ticket.getStatus() == ProductStatus.REFUND || ticket.getStatus() == ProductStatus.EXCHANGE) {
            return;
        }
        BigDecimal equivalentFare = AirProductHelper.getEquivalentFare((Product)ticket);
        if (equivalentFare == null || BigDecimal.ZERO.compareTo(equivalentFare) == 0) {
            return;
        }
        for (SegmentTariff st : ticket.getSegmentTariffs()) {
            Product vProduct = new Product();
            AirProductHelper.copy((Product)ticket, (Product)vProduct, (boolean)false);
            vProduct.setUid(String.format("%s%s|%s", S7_2013_04_01_VIRTUAL_TICKET_PREFFIX, vProduct.getUid(), ticket.getUid()));
            vProduct.getSegmentTariffs().clear();
            vProduct.getSegmentTariffs().add(st);
            vProduct.getFares().clear();
            vProduct.getTaxes().clear();
            AirProductHelper.setEquivalentFare((Product)vProduct, (BigDecimal)BigDecimal.valueOf(100L));
            ProductFop fop = new ProductFop();
            fop.setType(PaymentType.CASH);
            fop.setAmount(SystemHelper.getMoney((double)100.0, (String)"RUB"));
            AirProductHelper.addFopToAllContractRelations((Product)vProduct, (ProductFop)fop);
            result.add(vProduct);
        }
    }

    static void updateProxy(RuleProxy<ProductPropertySet, ProductCommissionActionSet> proxy) throws Exception {
        ProductPropertySet propertySet = (ProductPropertySet)proxy.getPropertySet();
        Product product = propertySet.getProduct();
        String uid = product.getUid();
        if (!uid.startsWith(S7_2013_04_01_VIRTUAL_TICKET_PREFFIX)) {
            return;
        }
        Product originalProduct = (Product)BookingHelper.findProductByUid((String)uid.substring(uid.lastIndexOf("|") + 1), (BookingFile)product.getReservation().getBookingFile());
        if (originalProduct == null) {
            AirRulesHelper.log.warn("can't find original product for virtual one " + AirRulesHelper.getProductTitle(product));
            return;
        }
        RuleProxy hProxy = new RuleProxy();
        hProxy.getTracer().setDisabled(true);
        ProductPropertySet hPropertySet = new ProductPropertySet(hProxy);
        hPropertySet.init(originalProduct);
        propertySet.setInterline(hPropertySet.isInterline());
        propertySet.getAirlines().clear();
        propertySet.getAirlines().addAll(hPropertySet.getAirlines());
        propertySet.setNumOfSegments(hPropertySet.getNumOfSegments());
        propertySet.setNumOfInterlineSegments(hPropertySet.getNumOfInterlineSegments());
    }

    static void deVirtualize(List<Product> products) throws Exception {
        Product ticket;
        LinkedHashMap<Product, ArrayList<Product>> productMap = new LinkedHashMap<Product, ArrayList<Product>>();
        for (Product product : products) {
            if (!product.getUid().startsWith(S7_2013_04_01_VIRTUAL_TICKET_PREFFIX)) continue;
            ticket = (Product)CollectionUtil.find(products, (String)product.getUid().substring(product.getUid().indexOf(124) + 1));
            if (ticket == null) {
                AirRulesHelper.log.warn("can't find original product for virtual one");
                continue;
            }
            ArrayList<Product> lst = (ArrayList<Product>)productMap.get(ticket);
            if (lst == null) {
                lst = new ArrayList<Product>();
                productMap.put(ticket, lst);
            }
            lst.add(product);
        }
        for (Map.Entry entry : productMap.entrySet()) {
            BigDecimal fare;
            ticket = (Product)entry.getKey();
            if (ticket.getStatus() == ProductStatus.REFUND) {
                S720130401VirtualizationHelper.processRefund(ticket);
                continue;
            }
            S720130401VirtualizationHelper.removeVendorCommission(ticket, false);
            S720130401VirtualizationHelper.removeAppliedRules(ticket);
            if (ticket.getStatus() == ProductStatus.EXCHANGE) continue;
            if (ticket.getStatus() == ProductStatus.SELL && ticket.getPreviousProduct() != null && ticket.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE && ticket.getPreviousProduct().getPreviousProduct() != null && ticket.getPreviousProduct().getPreviousProduct().getStatus() == ProductStatus.SELL) {
                fare = MiscUtil.guarded((BigDecimal)AirProductHelper.getEquivalentFare((Product)ticket)).subtract(MiscUtil.guarded((BigDecimal)AirProductHelper.getEquivalentFare((Product)ticket.getPreviousProduct().getPreviousProduct())));
                if (fare.compareTo(BigDecimal.ZERO) == -1) {
                    fare = BigDecimal.ZERO;
                }
            } else {
                fare = MiscUtil.guarded((BigDecimal)AirProductHelper.getEquivalentFare((Product)ticket));
            }
            Commission comm = null;
            for (Product product : (List)entry.getValue()) {
                for (ValidationMessage message : product.getValidationMessages()) {
                    if (message.getCategory() != ValidationMessageCategory.RULES) continue;
                    ticket.getValidationMessages().add(message);
                }
                products.remove(product);
                ticket.getReservation().getProducts().remove(product);
                ticket.setContractRulesApplied(true);
                Commission commission = S720130401VirtualizationHelper.findVendorCommission(product, false);
                if (commission == null) continue;
                Commission hComm = S720130401VirtualizationHelper.calculateCommission(fare, commission);
                if (comm != null && (hComm == null || hComm.getEquivalentAmount().compareTo(comm.getEquivalentAmount()) >= 0)) continue;
                comm = hComm;
            }
            if (comm == null) {
                S720130401VirtualizationHelper.removeAppliedRules((List)entry.getValue());
                continue;
            }
            List existingCommissions = S720130401VirtualizationHelper.findVendorContractRelation(ticket).getCommissions();
            if (!S720130401VirtualizationHelper.isCommissionCategoryExists(comm, existingCommissions)) {
                existingCommissions.add(comm);
                continue;
            }
            S720130401VirtualizationHelper.removeAppliedRules((List)entry.getValue());
        }
    }

    private static void removeAppliedRules(List<Product> value) {
        for (Product prod : value) {
            S720130401VirtualizationHelper.removeAppliedRules(prod);
        }
    }

    private static boolean hasFixedVendorCommission(Product ticket) {
        for (Commission comm : AirProductHelper.getVendorContractRelation((Product)ticket).getCommissions()) {
            if (comm.getCommissionProperties() != null && !CommissionProperties.class.isAssignableFrom(comm.getCommissionProperties().getType()) || comm.getRate() != null) continue;
            return true;
        }
        return false;
    }

    private static boolean isCommissionCategoryExists(Commission commission, List<Commission> existingCommissions) {
        for (Commission comm : existingCommissions) {
            if (commission.getContractType() != comm.getContractType() || !MiscUtil.equals(S720130401VirtualizationHelper.getCategory((EntityReference<? extends BaseCommissionProperties>)comm.getCommissionProperties()), S720130401VirtualizationHelper.getCategory((EntityReference<? extends BaseCommissionProperties>)comm.getCommissionProperties())) || comm.getRate() == null || commission.getRate() == null || !(Math.abs(commission.getRate() - comm.getRate()) < 0.001)) continue;
            return true;
        }
        return false;
    }

    private static DictionaryReference<CommissionCategory> getCategory(EntityReference<? extends BaseCommissionProperties> commissionProperties) {
        EntityContainer ctr = EntityStorage.get().resolve(commissionProperties);
        if (ctr == null) {
            return null;
        }
        if (ctr.getEntity() instanceof BaseCategorizedCommissionProperties) {
            return ((BaseCategorizedCommissionProperties)ctr.getEntity()).getCategory();
        }
        return null;
    }

    private static void removeAppliedRules(Product ticket) {
        Iterator it = ticket.getReservation().getBookingFile().getAppliedRules().iterator();
        while (it.hasNext()) {
            if (!ticket.getUid().equals(((AppliedRule)it.next()).getProductUid())) continue;
            it.remove();
        }
    }

    private static void processRefund(Product product) throws Exception {
        Commission vendorCommission;
        Product sell = product.getPreviousProduct();
        if (sell == null) {
            product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.S7VH_PREVIOUS_PRODUCT_NOT_DEFINED));
            return;
        }
        S720130401VirtualizationHelper.removeVendorCommission(product, true);
        if (!S720130401VirtualizationHelper.hasFixedVendorCommission(product)) {
            S720130401VirtualizationHelper.removeAppliedRules(product);
        }
        if ((vendorCommission = S720130401VirtualizationHelper.findVendorCommission(sell, true)) == null) {
            return;
        }
        BigDecimal fare = AirProductHelper.getEquivalentFare((Product)product);
        if (fare == null || BigDecimal.ZERO.compareTo(fare) == 0) {
            return;
        }
        Commission commission = S720130401VirtualizationHelper.calculateCommission(fare, vendorCommission);
        List existingCommissions = S720130401VirtualizationHelper.findVendorContractRelation(product).getCommissions();
        if (commission != null && !S720130401VirtualizationHelper.isCommissionCategoryExists(commission, existingCommissions)) {
            existingCommissions.add(commission);
        }
    }

    private static Commission calculateCommission(BigDecimal fare, Commission segmentCommission) throws Exception {
        BigDecimal commissionValue;
        RoundingValue rv = RoundingValue.V_0_1;
        RoundingMode rm = RoundingMode.MATH;
        EntityContainer ctr = EntityStorage.get().resolve(segmentCommission.getCommissionProperties());
        if (ctr != null) {
            CommissionProperties commissionProperties = (CommissionProperties)ctr.getEntity();
            if (commissionProperties.getRoundingMode() != null) {
                rm = commissionProperties.getRoundingMode();
            }
            if (commissionProperties.getRoundingValue() != null) {
                rv = commissionProperties.getRoundingValue();
            }
        }
        BigDecimal bigDecimal = commissionValue = segmentCommission.getRate() != null ? RulesHelper.roundDouble((BigDecimal)fare.multiply(BigDecimal.valueOf(segmentCommission.getRate())).divide(BigDecimal.valueOf(100L), 4, java.math.RoundingMode.HALF_UP), (RoundingMode)rm, (RoundingValue)rv) : segmentCommission.getEquivalentAmount();
        if (commissionValue.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        Commission commission = new Commission();
        commission.setCommissionProperties(segmentCommission.getCommissionProperties());
        commission.setContractType(ContractType.VENDOR);
        commission.setEquivalentAmount(commissionValue);
        if (segmentCommission.getRate() != null) {
            commission.setRate(segmentCommission.getRate());
        } else {
            commission.setAmount((Money)XCloneHelper.clone((XCloneable)segmentCommission.getAmount(), (boolean)true));
        }
        commission.setRoundingMode(rm);
        commission.setRoundingValue(rv);
        return commission;
    }

    private static void removeFixedVendorComission(Product ticket) {
        AirProductContractRelationData relation = S720130401VirtualizationHelper.findVendorContractRelation(ticket);
        if (relation == null) {
            return;
        }
        Iterator it = relation.getCommissions().iterator();
        while (it.hasNext()) {
            Commission comm = (Commission)it.next();
            if (comm.getRate() != null) continue;
            it.remove();
        }
    }

    private static void removeVendorCommission(Product ticket, boolean onlyRate) {
        AirProductContractRelationData relation = S720130401VirtualizationHelper.findVendorContractRelation(ticket);
        if (relation == null) {
            return;
        }
        Iterator it = relation.getCommissions().iterator();
        while (it.hasNext()) {
            Commission comm = (Commission)it.next();
            if (onlyRate && comm.getRate() == null || comm.getCommissionProperties() != null && !CommissionProperties.class.isAssignableFrom(comm.getCommissionProperties().getType())) continue;
            it.remove();
        }
    }

    private static Commission findVendorCommission(Product sell, boolean onlyRate) {
        AirProductContractRelationData relation = S720130401VirtualizationHelper.findVendorContractRelation(sell);
        if (relation == null) {
            return null;
        }
        for (Commission comm : relation.getCommissions()) {
            if (comm.getCommissionProperties() != null && !CommissionProperties.class.isAssignableFrom(comm.getCommissionProperties().getType()) || onlyRate && (comm.getRate() == null || !(Math.abs(comm.getRate()) > 0.001))) continue;
            return comm;
        }
        return null;
    }

    private static AirProductContractRelationData findVendorContractRelation(Product prod) {
        for (AirProductContractRelationData relation : AirProductHelper.getContractRelations((Product)prod)) {
            if (GeneralProductHelper.getContractType((EntityReference)relation.getDescription()) != ContractType.VENDOR) continue;
            return relation;
        }
        return null;
    }

    private S720130401VirtualizationHelper() {
    }

    static {
        try {
            startDate = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").parse("2013-04-01-00-00-00");
        }
        catch (ParseException e) {
            throw new RuntimeException("parsing problem ", e);
        }
    }
}

