/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.rules;

import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.model.handlers.ProductCommissionActionSet;
import com.gridnine.xtrip.server.model.handlers.ProductPropertySet;
import com.gridnine.xtrip.server.model.handlers.rules.S720130401VirtualizationHelper;
import java.util.List;

final class S7VirtualizationHelper {
    static void virtualize(Product ticket, List<Product> result) throws Exception {
        if (S720130401VirtualizationHelper.isApplicable(ticket)) {
            S720130401VirtualizationHelper.virtualize(ticket, result);
        } else {
            result.add(ticket);
        }
    }

    static void updateProxy(RuleProxy<ProductPropertySet, ProductCommissionActionSet> proxy) throws Exception {
        S720130401VirtualizationHelper.updateProxy(proxy);
    }

    static void deVirtualize(List<Product> products) throws Exception {
        boolean virtualized = false;
        for (Product item : products) {
            if (!S720130401VirtualizationHelper.isApplicable(item)) continue;
            virtualized = true;
        }
        if (virtualized) {
            S720130401VirtualizationHelper.deVirtualize(products);
        }
    }

    private S7VirtualizationHelper() {
    }
}

