/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.rules;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.BaseRulesContainer;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.rules.finance.ShipmentsDateActionSet;
import com.gridnine.xtrip.common.model.rules.finance.ShipmentsDatePropertySet;
import com.gridnine.xtrip.common.model.rules.finance.Targets;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleResultHandler;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.server.model.ibus.finance.documents.FinanceDocumentsIbusHelper;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShipmentsDateRulesHelper {
    static final Logger log = LoggerFactory.getLogger(ShipmentsDateRulesHelper.class);

    public static void applyRules(EntityContainer<BookingFile> bookingFileContainer, Map<BaseProduct, Boolean> contractRulesAppliedInfo, boolean forced, boolean simulate, List<Message> messages) throws Exception {
        log.debug(String.format("shipments date rules -> checking booking file %s -> ", bookingFileContainer.toReference(), String.valueOf(forced)));
        Date date = new Date();
        List products = ((BookingFile)bookingFileContainer.getEntity()).getReservations().stream().flatMap(item -> item.getProducts().stream()).collect(Collectors.toList());
        for (BaseProduct product : products) {
            log.debug(String.format("shipments date rules -> product -> %s", product));
            if (ProductHandler.of((BaseProduct)product).isChecked(product)) {
                log.debug(String.format("shipments date rules -> product %s is checked, skipping", ProductHandler.of((BaseProduct)product).generateShortProductName(product)));
                continue;
            }
            if (contractRulesAppliedInfo.get(product) != null && contractRulesAppliedInfo.get(product).booleanValue() && !forced) {
                log.debug(String.format("shipments date rules -> product %s have contract rules applied, skipping", ProductHandler.of((BaseProduct)product).generateShortProductName(product)));
                continue;
            }
            product.setShipmentsDate(null);
            product.setShipmentsDateSubagent(null);
            log.debug("shipments date rules -> shipments date cleared");
            if (!FinanceDocumentsHelper.allowedProductStatusesShipment.contains(ProductHandler.of((BaseProduct)product).getBaseStatus(product))) {
                log.debug("shipments date rules -> product not allowed, skipping");
                continue;
            }
            List contractRelations = ProductHandler.of((BaseProduct)product).getUnmodifiableContractRelations(product);
            Collections.reverse(contractRelations);
            for (GeneralProductContractRelationData contractRelation : contractRelations) {
                log.debug(String.format("shipments date rules -> contract relation -> %s", contractRelation));
                BigDecimal fopsEquivalentValue = MiscUtil.guarded((BigDecimal)GeneralProductHelper.calculateFopsEquivalentValue((Collection)contractRelation.getFops()));
                if (fopsEquivalentValue.compareTo(BigDecimal.ZERO) == 0) {
                    log.debug("shipments date rules -> fops equivalent value is zero, skipping");
                    continue;
                }
                EntityContainer contractContainer = EntityStorage.get().resolve(contractRelation.getGeneralData().getContractData().getContract());
                ArrayList rules = new ArrayList();
                ContractType contractType = null;
                if (contractContainer != null) {
                    rules.clear();
                    rules.addAll(ProfileHelper.getRuleContainers((EntityContainer)contractContainer, (Date)new Date()));
                    contractType = ((Contract)contractContainer.getEntity()).getContractType();
                }
                Date shipmentsDate = product.getShipmentsDate();
                Date shipmentsDateSubagent = product.getShipmentsDateSubagent();
                if (rules.size() > 0) {
                    log.debug(contractType.name() + " shipments date rules -> rules found");
                    RuleProxy proxy = new RuleProxy();
                    ShipmentsDatePropertySet propertySet = new ShipmentsDatePropertySet(proxy);
                    propertySet.init(product, contractRelation.getFops());
                    ShipmentsDateActionSet actionSet = new ShipmentsDateActionSet();
                    proxy.setProxyType(Targets.SHIPMENTS_DATE.getId());
                    proxy.setProxyDate(date);
                    proxy.setPropertySet((Object)propertySet);
                    proxy.setActionSet((Object)actionSet);
                    for (EntityContainer rule : rules) {
                        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)((BaseRulesContainer)rule.getEntity()).getRuleSet());
                    }
                    if (proxy.getAppliedRuleCategories().contains("rule_category_shipments_date")) {
                        log.debug(contractType.name() + " shipments date rules -> shipments date rules applied");
                        if (contractType == ContractType.CLIENT) {
                            shipmentsDate = actionSet.getShipmentsDate();
                        } else if (contractType == ContractType.SUBAGENCY) {
                            shipmentsDateSubagent = actionSet.getShipmentsDate();
                        }
                    } else {
                        log.debug(contractType.name() + " shipments date rules -> shipments date rules not applied");
                    }
                } else {
                    log.debug("shipments date rules -> rules not found");
                }
                if (contractType != null) {
                    if (contractType == ContractType.CLIENT) {
                        if (!MiscUtil.equals((Object)product.getShipmentsDate(), (Object)shipmentsDate)) {
                            if (shipmentsDate != null) {
                                log.debug(String.format("%s shipments date rules -> shipments date update -> %s -> %s", contractType.name(), product.getShipmentsDate(), shipmentsDate));
                                product.setShipmentsDate(shipmentsDate);
                                continue;
                            }
                            log.debug(contractType.name() + " shipments date rules -> shipments date is null");
                            continue;
                        }
                        log.debug(String.format("%s shipments date rules -> shipments date matches -> %s", contractType.name(), product.getShipmentsDate()));
                        continue;
                    }
                    if (contractType != ContractType.SUBAGENCY) continue;
                    if (!MiscUtil.equals((Object)product.getShipmentsDateSubagent(), (Object)shipmentsDateSubagent)) {
                        if (shipmentsDateSubagent != null) {
                            log.debug(String.format(contractType.name() + "%s shipments date rules -> shipments date update -> %s -> %s", contractType.name(), product.getShipmentsDateSubagent(), shipmentsDateSubagent));
                            product.setShipmentsDateSubagent(shipmentsDateSubagent);
                            continue;
                        }
                        log.debug(contractType.name() + " shipments date rules -> shipments date is null");
                        continue;
                    }
                    log.debug(String.format("%s shipments date rules -> shipments date matches -> %s", contractType.name(), product.getShipmentsDateSubagent()));
                    continue;
                }
                log.debug("shipments date rules -> contract type is null");
            }
        }
    }

    public static Pair<Date> getShipmentPeriod(List<FinanceDocumentsIbusHelper.ProductHolder> productHolders) {
        long maxDays = 0L;
        Date periodBegin = null;
        Date periodEnd = null;
        for (FinanceDocumentsIbusHelper.ProductHolder productHolder : productHolders) {
            long days;
            Date shipmentPeriodBegin = productHolder.getShipmentPeriodBegin();
            Date shipmentPeriodEnd = productHolder.getShipmentPeriodEnd();
            if (shipmentPeriodBegin == null && shipmentPeriodEnd == null || DateUtils.toLocalDate((Date)shipmentPeriodBegin) == null || DateUtils.toLocalDate((Date)shipmentPeriodEnd) == null || (days = Duration.between(DateUtils.toLocalDate((Date)shipmentPeriodBegin).atStartOfDay(), DateUtils.toLocalDate((Date)shipmentPeriodEnd).atStartOfDay()).toDays()) < maxDays) continue;
            maxDays = days;
            periodBegin = shipmentPeriodBegin;
            periodEnd = shipmentPeriodEnd;
        }
        return new Pair(periodBegin, periodEnd);
    }

    public static Pair<Date> getShipmentPeriod(Set<BaseProduct> products, EntityContainer<Contract> contract) throws Exception {
        Date date = new Date();
        long maxDays = 0L;
        Date periodBegin = null;
        Date periodEnd = null;
        List rules = ProfileHelper.getRuleContainers(contract, (Date)date);
        for (BaseProduct product : products) {
            long days;
            RuleProxy proxy = new RuleProxy();
            ShipmentsDatePropertySet propertySet = new ShipmentsDatePropertySet(proxy);
            propertySet.init(product, Collections.emptyList());
            ShipmentsDateActionSet actionSet = new ShipmentsDateActionSet();
            proxy.setProxyType(Targets.SHIPMENTS_DATE.getId());
            proxy.setProxyDate(date);
            proxy.setPropertySet((Object)propertySet);
            proxy.setActionSet((Object)actionSet);
            for (EntityContainer rule : rules) {
                RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)((BaseRulesContainer)rule.getEntity()).getRuleSet(), (RuleResultHandler)new RuleResultHandler(){

                    public boolean isProcessAllRuleResults() {
                        return true;
                    }

                    public void processRuleResult(RuleProxy<?, ?> proxy, RuleSettings ruleSettings, RuleResult ruleResult) throws Exception {
                    }
                });
            }
            Date shipmentPeriodBegin = actionSet.getShipmentPeriodBegin();
            Date shipmentPeriodEnd = actionSet.getShipmentPeriodEnd();
            if (shipmentPeriodBegin == null || shipmentPeriodEnd == null || DateUtils.toLocalDate((Date)shipmentPeriodBegin) == null || DateUtils.toLocalDate((Date)shipmentPeriodEnd) == null || (days = Duration.between(DateUtils.toLocalDate((Date)shipmentPeriodBegin).atStartOfDay(), DateUtils.toLocalDate((Date)shipmentPeriodEnd).atStartOfDay()).toDays()) < maxDays) continue;
            maxDays = days;
            periodBegin = shipmentPeriodBegin;
            periodEnd = shipmentPeriodEnd;
        }
        return new Pair(periodBegin, periodEnd);
    }
}

