/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.rules;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiHelper;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiProduct;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.Parameter;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.elements.DebugInfo;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.handlers.RulesHandler;
import com.gridnine.xtrip.server.model.handlers.TaxiProductActionSet;
import com.gridnine.xtrip.server.model.handlers.TaxiProductPropertySet;
import com.gridnine.xtrip.server.model.handlers.rules.GeneralProductRulesHelper;
import com.gridnine.xtrip.server.model.handlers.rules.RulesProductHandler;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TaxiProductRulesHandler
implements RulesHandler {
    public static final String ID = MiscUtil.getSimpleClassName(TaxiProductRulesHandler.class);

    @Override
    public void applyRules(EntityContainer<BookingFile> bookingContainer, boolean forced, boolean simulate, List<Message> messages, Map<Parameter, Object> params, DebugInfo debugInfo, boolean calcAppliedRulesToBooking) throws Exception {
        GeneralProductRulesHelper.applyContracts(bookingContainer, forced, simulate, this.createRulesHandler(), messages, params, debugInfo, calcAppliedRulesToBooking);
    }

    public RulesProductHandler<TaxiProduct, TaxiProductPropertySet, TaxiProductActionSet> createRulesHandler() {
        return new RulesProductHandler<TaxiProduct, TaxiProductPropertySet, TaxiProductActionSet>(){

            @Override
            public Class<TaxiProduct> getProductClass() {
                return TaxiProduct.class;
            }

            @Override
            public EntityReference<Organization> getBlankOwner(TaxiProduct item) {
                return item.getBlankOwner();
            }

            @Override
            public TicketType getTicketType(TaxiProduct item) {
                return item.getTicketType();
            }

            @Override
            public ProductStatus getStatus(TaxiProduct item) {
                return item.getStatus();
            }

            @Override
            public boolean isContractRulesApplied(TaxiProduct item) {
                return item.isContractRulesApplied();
            }

            @Override
            public void setContractRulesApplied(TaxiProduct item, boolean value) {
                item.setContractRulesApplied(value);
            }

            @Override
            public boolean isChecked(TaxiProduct item) {
                return item.isChecked();
            }

            @Override
            public RuleProxy<TaxiProductPropertySet, TaxiProductActionSet> createProxy(TaxiProduct item, boolean enabledTracer) throws Exception {
                RuleProxy proxy = new RuleProxy();
                TaxiProductPropertySet props = TaxiProductRulesHandler.this.createPropertySet((RuleProxy<TaxiProductPropertySet, TaxiProductActionSet>)proxy);
                proxy.setPropertySet((Object)props);
                proxy.setProxyDate(item.getIssueDate());
                proxy.setProxyType(Targets.TAXI.getId());
                proxy.getTracer().setDisabled(!enabledTracer);
                ((TaxiProductPropertySet)proxy.getPropertySet()).init(item);
                return proxy;
            }

            @Override
            public List<ValidationMessage> getValidationMessages(TaxiProduct item) {
                return item.getValidationMessages();
            }

            @Override
            public List<GeneralProductContractRelationData> getContractRelations(TaxiProduct item) {
                return TaxiHelper.getContractRelations((TaxiProduct)item);
            }

            @Override
            public List<GeneralProductContractRelationData> getPreviousProductContractRelations(TaxiProduct item) {
                return item.getPreviousProduct() == null ? null : TaxiHelper.getContractRelations((TaxiProduct)item.getPreviousProduct());
            }

            @Override
            public List<GeneralProductCommission> createCommissions(RuleProxy<TaxiProductPropertySet, TaxiProductActionSet> proxy, TaxiProduct item, GeneralProductContractRelationData relation, List<GeneralProductContractRelationData> allRelations, List<GeneralProductContractRelationData> previousProductContractRelations, boolean separateSupplierFees, ExchangeRateData rateData) throws Exception {
                return ((TaxiProductActionSet)proxy.getActionSet()).createCommissions(relation, allRelations, previousProductContractRelations, separateSupplierFees, rateData, new ArrayList<ValidationMessage>());
            }

            @Override
            public List<GeneralProductCommission> createCommissions(RuleProxy<TaxiProductPropertySet, TaxiProductActionSet> proxy, TaxiProduct item, GeneralProductContractRelationData relation, List<GeneralProductContractRelationData> allRelations, List<GeneralProductContractRelationData> previousProductContractRelations, boolean translateSupplierFees, boolean separateSupplierFees, ExchangeRateData rateData) throws Exception {
                return ((TaxiProductActionSet)proxy.getActionSet()).createCommissions(relation, allRelations, previousProductContractRelations, translateSupplierFees, separateSupplierFees, rateData, new ArrayList<ValidationMessage>());
            }

            @Override
            public void clearActionSet(RuleProxy<TaxiProductPropertySet, TaxiProductActionSet> proxy, TaxiProduct item) {
                proxy.getAppliedRuleCategories().clear();
                proxy.getAppliedRules().clear();
                proxy.getTracer().clear();
                proxy.setActionSet((Object)new TaxiProductActionSet(proxy, item));
            }

            @Override
            public Date getIssueDate(TaxiProduct item) {
                return item.getIssueDate();
            }

            @Override
            public boolean hasRefundCommissions(RuleProxy<TaxiProductPropertySet, TaxiProductActionSet> proxy) {
                return ((TaxiProductActionSet)proxy.getActionSet()).hasRefundCommissions();
            }

            @Override
            public Set<PaymentType> getAllowedPaymentTypes(TaxiProductActionSet actionSet) {
                return actionSet.getAllowedPaymentTypes();
            }
        };
    }

    @Override
    public String getId() {
        return ID;
    }

    protected TaxiProductPropertySet createPropertySet(RuleProxy<TaxiProductPropertySet, TaxiProductActionSet> proxy) {
        return new TaxiProductPropertySet(proxy);
    }
}

