/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.rules;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.TchDirectContract;
import com.gridnine.xtrip.common.util.CollectionUtil;
import java.util.List;

final class TchDirectContractsHelper {
    private TchDirectContractsHelper() {
    }

    static void clearDirectContract(Product product) {
        product.setTchDirectContract(null);
    }

    static void applyContracts(Product product, List<EntityContainer<Contract>> contracts, ContractCustomerInfo customeInfo) {
        DictionaryReference carrier = product.getCarrier();
        if (carrier == null || product.getIssueDate() == null) {
            return;
        }
        if (contracts.size() == 1 && ((Contract)contracts.get(0).getEntity()).isNewModel()) {
            EntityContainer<Contract> contractCtr = contracts.get(0);
            for (TchDirectContract directContract : ((Contract)contractCtr.getEntity()).getTchDirectContracts()) {
                if (!carrier.equals((Object)directContract.getAirline()) || directContract.getStartDate() != null && directContract.getStartDate().after(product.getIssueDate()) || directContract.getEndDate() != null && directContract.getEndDate().before(product.getIssueDate())) continue;
                NestedEntityReference ref = new NestedEntityReference(contractCtr.getUid(), Contract.class, directContract.getUid(), TchDirectContract.class, String.format("%s (%s)", directContract.getContractNumber(), ((Contract)contractCtr.getEntity()).getName()));
                product.setTchDirectContract(ref);
                return;
            }
            return;
        }
        if (customeInfo == null) {
            return;
        }
        for (TchDirectContract directContract : customeInfo.getTchDirectContracts()) {
            if (!carrier.equals((Object)directContract.getAirline()) || directContract.getStartDate() != null && directContract.getStartDate().after(product.getIssueDate()) || directContract.getEndDate() != null && directContract.getEndDate().before(product.getIssueDate())) continue;
            for (EntityContainer<Contract> contractCtr : contracts) {
                if (CollectionUtil.find((Iterable)((Contract)contractCtr.getEntity()).getCustomers(), (String)customeInfo.getUid()) == null) continue;
                NestedEntityReference ref = new NestedEntityReference(contractCtr.getUid(), Contract.class, directContract.getUid(), TchDirectContract.class, String.format("%s (%s)", directContract.getContractNumber(), ((Contract)contractCtr.getEntity()).getName()));
                product.setTchDirectContract(ref);
                return;
            }
        }
    }
}

