/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.rules;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.handlers.rules.AirRulesHelper;
import com.gridnine.xtrip.server.model.handlers.rules.TchSpecialSchemeVirtualizationHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class TchRulesHelper {
    public static void virtualize(Product ticket, List<Product> result) throws Exception {
        result.add(ticket);
        if (ticket.getProductCategory() != ProductCategory.AIR && (ticket.getProductCategory() != ProductCategory.MCO || ticket.getMcoCategory() != MCOCategory.PTA)) {
            return;
        }
        if (!"99A".equals(ticket.getCarrierNumber()) && !"99\u0410".equals(ticket.getCarrierNumber())) {
            return;
        }
        LinkedHashSet<DictionaryReference> airlines = new LinkedHashSet<DictionaryReference>();
        for (SegmentTariff st : ticket.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                if (seg.getAirline() == null) {
                    ticket.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.TRH_AIRLINE_NOT_DEFINED, (Object[])new Object[]{ticket.getSystemNumber(), seg.getRecordNumber()}));
                    return;
                }
                airlines.add(seg.getAirline());
            }
        }
        if (airlines.size() < 2) {
            return;
        }
        block2: for (DictionaryReference aref : airlines) {
            Product vTicket = new Product();
            AirProductHelper.copy((Product)ticket, (Product)vTicket, (boolean)false);
            vTicket.setUid("TCH_VIRTUAL:" + vTicket.getUid() + '|' + ticket.getUid());
            result.add(vTicket);
            vTicket.getValidationMessages().clear();
            ArrayList<SegmentTariff> tariffs = new ArrayList<SegmentTariff>();
            for (SegmentTariff st : vTicket.getSegmentTariffs()) {
                Segment seg;
                if (st.getSegments().isEmpty() || !aref.equals((Object)(seg = (Segment)st.getSegments().iterator().next()).getAirline())) continue;
                tariffs.add(st);
            }
            Airline airline = (Airline)DictionaryCache.get().resolveReference(aref);
            if (airline == null) {
                ticket.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.TRH_CANT_LOAD_AIRLINE, (Object[])new Object[]{ticket.getSystemNumber(), aref}));
            }
            vTicket.setCarrierNumber(airline != null ? airline.getAirlineNumber() : null);
            vTicket.setCarrier(aref);
            vTicket.getSegmentTariffs().clear();
            vTicket.getSegmentTariffs().addAll(tariffs);
            Iterator it = vTicket.getFares().iterator();
            while (it.hasNext()) {
                ProductFare fare = (ProductFare)it.next();
                if (fare.getSegmentTariff() == null) {
                    ticket.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.TRH_FARE_NOT_ASSIGNED_TO_SEGMENT, (Object[])new Object[]{ticket.getSystemNumber()}));
                    it.remove();
                    continue;
                }
                if (tariffs.contains(fare.getSegmentTariff())) continue;
                it.remove();
            }
            it = vTicket.getTaxes().iterator();
            while (it.hasNext()) {
                Tax tax = (Tax)it.next();
                if (tax.getSegmentTariff() == null) {
                    ticket.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.TRH_TAX_NOT_ASSIGNED_TO_SEGMENT, (Object[])new Object[]{ticket.getSystemNumber(), tax.getCode()}));
                    it.remove();
                    continue;
                }
                if (tariffs.contains(tax.getSegmentTariff())) continue;
                it.remove();
            }
            List vendorFops = AirProductHelper.getVendorContractRelation((Product)vTicket).getFops();
            Iterator it1 = vendorFops.iterator();
            while (it1.hasNext()) {
                ProductFop fop = (ProductFop)it1.next();
                BigDecimal total = BigDecimal.ZERO;
                if (fop.getTaxes().isEmpty() && fop.getFares().isEmpty()) {
                    if (vendorFops.size() > 1) {
                        ticket.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.TRH_FOP_NOT_ASSIGNED_TO_FARE_AND_TAX, (Object[])new Object[]{ticket.getSystemNumber(), vendorFops.size()}));
                        continue block2;
                    }
                    BigDecimal ef = AirProductHelper.getEquivalentFare((Product)vTicket);
                    if (ef == null) {
                        ef = BigDecimal.ZERO;
                    }
                    fop.getAmount().setValue(ef.add(AirProductTaxHelper.getEquivalentTaxesAmount((Product)vTicket)));
                    continue;
                }
                Iterator it2 = fop.getFares().iterator();
                while (it2.hasNext()) {
                    ProductFare fare = (ProductFare)it2.next();
                    if (fare.getSegmentTariff() == null) {
                        ticket.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.TRH_FARE_NOT_ASSIGNED_TO_SEGMENT_TARIFF, (Object[])new Object[]{ticket.getSystemNumber(), fare.getEquivalentFare()}));
                        continue block2;
                    }
                    if (!tariffs.contains(fare.getSegmentTariff())) {
                        it2.remove();
                        continue;
                    }
                    BigDecimal equivalentFare = fare.getEquivalentFare();
                    if (equivalentFare == null) continue;
                    total = total.add(equivalentFare);
                }
                it2 = fop.getTaxes().iterator();
                while (it2.hasNext()) {
                    BigDecimal amount;
                    Tax tax = (Tax)it2.next();
                    if (tax.getSegmentTariff() == null) {
                        ticket.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.TRH_TAX_NOT_ASSIGNED_TO_SEGMENT_TARIFF, (Object[])new Object[]{ticket.getSystemNumber(), tax.getCode()}));
                        continue block2;
                    }
                    if (!tariffs.contains(tax.getSegmentTariff())) {
                        it2.remove();
                    }
                    if ((amount = tax.getEquivalentAmount()) == null) continue;
                    total = total.add(amount);
                }
                if (fop.getTaxes().isEmpty() && fop.getFares().isEmpty()) {
                    it1.remove();
                    continue;
                }
                fop.getAmount().setValue(total);
            }
        }
    }

    static void deVirtualize(List<Product> products) {
        TchSpecialSchemeVirtualizationHelper.deVirtualize(products);
        HashSet<String> clearedProductUids = new HashSet<String>();
        for (Product product : products) {
            AirProductContractRelationData item2;
            if (!product.getUid().startsWith("TCH_VIRTUAL:")) continue;
            Product ticket = (Product)BookingHelper.findProduct((BookingFile)product.getReservation().getBookingFile(), (String)product.getUid().substring(product.getUid().indexOf(124) + 1));
            if (ticket == null) {
                AirRulesHelper.log.warn("can't find original product for virtual one");
                continue;
            }
            if (!clearedProductUids.contains(ticket.getUid())) {
                for (AirProductContractRelationData item2 : AirProductHelper.getContractRelations((Product)ticket)) {
                    Iterator it = item2.getCommissions().iterator();
                    while (it.hasNext()) {
                        Commission comm = (Commission)it.next();
                        if (comm.getCommissionProperties() != null && !CommissionProperties.class.isAssignableFrom(comm.getCommissionProperties().getType())) continue;
                        it.remove();
                    }
                }
                clearedProductUids.add(ticket.getUid());
            }
            DictionaryReference airlineRef = null;
            item2 = product.getSegmentTariffs().iterator();
            block3: while (item2.hasNext()) {
                SegmentTariff st = (SegmentTariff)item2.next();
                for (Segment seg : st.getSegments()) {
                    DictionaryReference airline = seg.getAirline();
                    if (airline == null) continue;
                    airlineRef = airline;
                    break block3;
                }
            }
            SegmentTariff tariff = null;
            if (airlineRef != null) {
                block5: for (SegmentTariff st : ticket.getSegmentTariffs()) {
                    for (Segment seg : st.getSegments()) {
                        if (!airlineRef.equals((Object)seg.getAirline())) continue;
                        tariff = st;
                        break block5;
                    }
                }
            }
            if (tariff == null) {
                ticket.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.TRH_CANT_ASSIGN_COMMISSION_TO_SEGMENT));
            }
            for (AirProductContractRelationData item3 : AirProductHelper.getContractRelations((Product)product)) {
                for (Commission comm : item3.getCommissions()) {
                    if (comm.getCommissionProperties() != null && !CommissionProperties.class.isAssignableFrom(comm.getCommissionProperties().getType())) continue;
                    comm.setSegmentTariff(tariff);
                    AirProductHelper.findContractRelation((List)AirProductHelper.getContractRelations((Product)ticket), (EntityReference)item3.getDescription()).getCommissions().add(comm);
                }
            }
            for (ValidationMessage message : product.getValidationMessages()) {
                if (message.getCategory() != ValidationMessageCategory.RULES) continue;
                ticket.getValidationMessages().add(message);
            }
            ticket.getReservation().getProducts().remove(product);
            ticket.setContractRulesApplied(true);
        }
    }

    private TchRulesHelper() {
    }

    public static void correctFops(Product product) {
        ProductFop ticketFop;
        BigDecimal difference;
        Collection fops = AirProductHelper.filterFops((Collection)AirProductHelper.getVendorFops((Product)product), (Set)GeneralProductHelper.productFopTypes, null, null, null).stream().filter(item -> item.getAmount() != null && item.getAmount().getValue() != null && item.getAmount().getValue().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
        AirRulesHelper.log.debug(String.format("%s -> checking taxes, penalties and fares to fops distribution", AirProductHelper.getProductTitle((Product)product)));
        boolean correct = true;
        ArrayList taxes = new ArrayList(product.getTaxes());
        BigDecimal penaltyAmount = product.getPenalty();
        boolean penaltyFopFound = false;
        for (ProductFop fop : fops) {
            if (!taxes.containsAll(fop.getTaxes())) {
                correct = false;
                break;
            }
            if (fop.isHasPenaltyComponent() && (penaltyFopFound || fop.getType() == PaymentType.TICKET)) {
                correct = false;
                break;
            }
            if (fop.isHasPenaltyComponent()) {
                penaltyFopFound = true;
            }
            BigDecimal fopAmount = Optional.ofNullable(fop.getAmount()).map(item -> item.getValue()).orElse(null);
            BigDecimal taxAmount = fop.getTaxes().stream().map(item -> item.getEquivalentAmount()).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(null);
            difference = MiscUtil.sum((BigDecimal[])new BigDecimal[]{fopAmount, MiscUtil.negate((BigDecimal)taxAmount), fop.isHasPenaltyComponent() ? MiscUtil.negate((BigDecimal)penaltyAmount) : null});
            if (difference != null && (difference.compareTo(BigDecimal.ZERO) < 0 || difference.compareTo(BigDecimal.ZERO) > 0 && fop.getFares().size() == 0 || difference.compareTo(BigDecimal.ZERO) == 0 && fop.getFares().size() > 0)) {
                correct = false;
                break;
            }
            taxes.removeAll(fop.getTaxes());
        }
        if (taxes.size() > 0) {
            correct = false;
        }
        if (!penaltyFopFound && penaltyAmount != null && penaltyAmount.compareTo(BigDecimal.ZERO) != 0 || penaltyFopFound && (penaltyAmount == null || penaltyAmount.compareTo(BigDecimal.ZERO) == 0)) {
            correct = false;
        }
        AirRulesHelper.log.debug(String.format("%s -> taxes, penalties and fares to fops distribution correct = %s", AirProductHelper.getProductTitle((Product)product), String.valueOf(correct)));
        if (correct) {
            return;
        }
        taxes = new ArrayList(product.getTaxes());
        if (product.getStatus() == ProductStatus.SELL && product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE && (ticketFop = (ProductFop)fops.stream().filter(item -> item.getType() == PaymentType.TICKET).findFirst().orElse(null)) != null) {
            Product previousProduct = product.getPreviousProduct();
            PaymentType paymentType = TchRulesHelper.getTicketFopPaymentType(previousProduct);
            if (paymentType == null) {
                AirRulesHelper.log.error(String.format("%s -> unable to determine ticket fop payment type", AirProductHelper.getProductTitle((Product)product)));
                product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.TRH_FOP_LINKING_FAILED));
                return;
            }
            ArrayList ticketFopTaxes = new ArrayList();
            ArrayList previousProductTaxes = new ArrayList(previousProduct.getTaxes());
            try {
                block3: while (previousProductTaxes.size() > 0) {
                    String code = ((Tax)previousProductTaxes.iterator().next()).getCode();
                    Collection taxesCombinations = CollectionUtil.combinations(taxes.stream().filter(item -> TextUtil.isSame((String)item.getCode(), (String)code)).collect(Collectors.toSet())).stream().filter(item -> item.size() > 0).collect(Collectors.toList());
                    Collection previousProductTaxesCombinations = CollectionUtil.combinations(previousProductTaxes.stream().filter(item -> TextUtil.isSame((String)item.getCode(), (String)code)).collect(Collectors.toSet())).stream().filter(item -> item.size() > 0).collect(Collectors.toList());
                    for (Set taxesCombination : taxesCombinations) {
                        for (Set previousProductTaxesCombination : previousProductTaxesCombinations) {
                            if (!MiscUtil.equals(taxesCombination.stream().map(item -> item.getEquivalentAmount()).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(null), previousProductTaxesCombination.stream().map(item -> item.getEquivalentAmount()).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(null))) continue;
                            ticketFopTaxes.addAll(taxesCombination);
                            taxes.removeAll(taxesCombination);
                            previousProductTaxes.removeAll(previousProductTaxesCombination);
                            continue block3;
                        }
                    }
                    AirRulesHelper.log.error(String.format("%s -> unable to determine ticket fop taxes", AirProductHelper.getProductTitle((Product)product)));
                    product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.TRH_FOP_LINKING_FAILED));
                    return;
                }
            }
            catch (OutOfMemoryError e) {
                AirRulesHelper.log.error(String.format("%s -> too many taxes", AirProductHelper.getProductTitle((Product)product)));
                product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.TRH_FOP_LINKING_FAILED));
                return;
            }
            BigDecimal fopAmount = Optional.ofNullable(ticketFop.getAmount()).map(item -> item.getValue()).orElse(null);
            BigDecimal taxAmount = ticketFopTaxes.stream().map(item -> item.getEquivalentAmount()).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(null);
            BigDecimal difference2 = MiscUtil.sum((BigDecimal[])new BigDecimal[]{fopAmount, MiscUtil.negate((BigDecimal)taxAmount)});
            if (difference2 != null && difference2.compareTo(BigDecimal.ZERO) < 0) {
                AirRulesHelper.log.error(String.format("%s -> unable to distribute taxes, penalties and fares to ticket fop", AirProductHelper.getProductTitle((Product)product)));
                product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.TRH_FOP_LINKING_FAILED));
                return;
            }
            ticketFop.getFares().clear();
            if (difference2 != null && difference2.compareTo(BigDecimal.ZERO) > 0) {
                ticketFop.getFares().addAll(product.getFares());
            }
            ticketFop.getTaxes().clear();
            if (ticketFopTaxes.size() > 0) {
                ticketFop.getTaxes().addAll(ticketFopTaxes);
            }
            ticketFop.setExchangePaymentType(paymentType);
            ticketFop.setHasPenaltyComponent(false);
            fops.remove(ticketFop);
        }
        if (fops.size() == 1) {
            ProductFop fop = (ProductFop)fops.iterator().next();
            BigDecimal fopAmount = Optional.ofNullable(fop.getAmount()).map(item -> item.getValue()).orElse(null);
            BigDecimal taxAmount = taxes.stream().map(item -> item.getEquivalentAmount()).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(null);
            BigDecimal difference3 = MiscUtil.sum((BigDecimal[])new BigDecimal[]{fopAmount, MiscUtil.negate((BigDecimal)taxAmount), product.getStatus() == ProductStatus.REFUND ? penaltyAmount : MiscUtil.negate((BigDecimal)penaltyAmount)});
            if (difference3 != null && difference3.compareTo(BigDecimal.ZERO) < 0) {
                AirRulesHelper.log.error(String.format("%s -> unable to distribute taxes, penalties and fares to fop", AirProductHelper.getProductTitle((Product)product)));
                product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.TRH_FOP_LINKING_FAILED));
                return;
            }
            fop.getFares().clear();
            if (difference3 != null && difference3.compareTo(BigDecimal.ZERO) > 0) {
                fop.getFares().addAll(product.getFares());
            }
            fop.getTaxes().clear();
            if (taxes.size() > 0) {
                fop.getTaxes().addAll(taxes);
            }
            fop.setHasPenaltyComponent(penaltyAmount != null && penaltyAmount.compareTo(BigDecimal.ZERO) != 0);
        } else if (fops.size() > 1) {
            if (taxes.size() > 0) {
                BigDecimal taxAmount = taxes.stream().map(item -> item.getEquivalentAmount()).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(null);
                ProductFop taxesFop = fops.stream().filter(item -> MiscUtil.equals((Object)taxAmount, item.getAmount() != null ? item.getAmount().getValue() : null)).findFirst().orElse(null);
                if (taxesFop == null) {
                    AirRulesHelper.log.error(String.format("%s -> unable to distribute taxes, penalties and fares to fop", AirProductHelper.getProductTitle((Product)product)));
                    product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.TRH_FOP_LINKING_FAILED));
                    return;
                }
                taxesFop.getFares().clear();
                taxesFop.getTaxes().clear();
                taxesFop.getTaxes().addAll(taxes);
                taxesFop.setHasPenaltyComponent(false);
                fops.remove(taxesFop);
            }
            boolean penaltyDistributed = penaltyAmount == null || penaltyAmount.compareTo(BigDecimal.ZERO) == 0;
            for (ProductFop fop : fops) {
                BigDecimal fopAmount = Optional.ofNullable(fop.getAmount()).map(item -> item.getValue()).orElse(null);
                difference = MiscUtil.sum((BigDecimal[])new BigDecimal[]{fopAmount, !penaltyDistributed ? MiscUtil.negate((BigDecimal)penaltyAmount) : null});
                if (difference != null && difference.compareTo(BigDecimal.ZERO) != 0) {
                    fop.getFares().clear();
                    fop.getFares().addAll(product.getFares());
                }
                fop.getTaxes().clear();
                if (!penaltyDistributed && difference != null && difference.compareTo(BigDecimal.ZERO) >= 0) {
                    fop.setHasPenaltyComponent(true);
                    penaltyDistributed = true;
                    continue;
                }
                fop.setHasPenaltyComponent(false);
            }
            if (!penaltyDistributed) {
                AirRulesHelper.log.error(String.format("%s -> unable to distribute taxes, penalties and fares to fop", AirProductHelper.getProductTitle((Product)product)));
                product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.TRH_FOP_LINKING_FAILED));
                return;
            }
        }
        AirRulesHelper.log.debug(String.format("%s -> finish taxes and fares to fops distribution", AirProductHelper.getProductTitle((Product)product)));
    }

    private static PaymentType getTicketFopPaymentType(Product product) {
        if (product != null) {
            Collection fops = AirProductHelper.filterFops((Collection)AirProductHelper.getVendorFops((Product)product), (Set)GeneralProductHelper.productFopTypes, null, null, null).stream().filter(item -> item.getAmount() != null && item.getAmount().getValue().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
            if (fops.size() != 1) {
                return null;
            }
            if (fops.size() == 1) {
                ProductFop fop = (ProductFop)fops.iterator().next();
                return fop.getType() != PaymentType.TICKET ? fop.getType() : TchRulesHelper.getTicketFopPaymentType(product.getPreviousProduct());
            }
        }
        return null;
    }

    public static boolean isEmdWithZeroPrice(Product product) {
        if (!AirProductHelper.isTCHTicket((Product)product)) {
            return false;
        }
        if (product.getMcoCategory() == MCOCategory.PENALTY || product.getMcoCategory() == MCOCategory.REBOOKING || product.getMcoCategory() == MCOCategory.PTA) {
            return false;
        }
        AirProductContractRelationData vendorContractRelation = AirProductHelper.getVendorContractRelation((Product)product);
        if (vendorContractRelation == null) {
            return true;
        }
        return BigDecimal.ZERO.compareTo(MiscUtil.guarded((BigDecimal)vendorContractRelation.getServiceData().getTotalPrice())) == 0;
    }
}

