/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.rules;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.commission.BaseCategorizedCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.handlers.ProductCommissionActionSet;
import com.gridnine.xtrip.server.model.handlers.ProductPropertySet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TchSpecialSchemeVirtualizationHelper {
    static final String TCH_SPECIAL_SCHEME_VIRTUALIZATION_TICKET_PREFFIX = "TCH_SPECIAL_SCHEME_VIRTUALIZATION";

    static void virtualize(Product ticket, List<Product> result) throws Exception {
        if (TchSpecialSchemeTicketHelper.isAppropriateProduct(ticket)) {
            TchSpecialSchemeTicketHelper.virtualize(ticket, result);
        } else if (TchSpecialSchemeLuggageAndPenaltyHelper.isAppropriateProduct(ticket)) {
            TchSpecialSchemeLuggageAndPenaltyHelper.virtualize(ticket, result);
        } else {
            result.add(ticket);
        }
    }

    static void updateProxy(RuleProxy<ProductPropertySet, ProductCommissionActionSet> proxy, ContractType contractType) throws Exception {
        TchSpecialSchemeTicketHelper.updateProxy(proxy, contractType);
        TchSpecialSchemeLuggageAndPenaltyHelper.updateProxy(proxy, contractType);
    }

    static void deVirtualize(List<Product> products) {
        TchSpecialSchemeTicketHelper.deVirtualize(products);
        TchSpecialSchemeLuggageAndPenaltyHelper.deVirtualize(products);
    }

    public static void updateProduct(Product prod) {
        TchSpecialSchemeTicketHelper.updateProduct(prod);
        TchSpecialSchemeLuggageAndPenaltyHelper.updateProduct(prod);
    }

    private TchSpecialSchemeVirtualizationHelper() {
    }

    static class SpecialSchemeCommonHelper {
        SpecialSchemeCommonHelper() {
        }

        static Collection<String> getAllCodes(DictionaryReference<Airline> carrier) {
            HashSet<String> result = new HashSet<String>();
            result.add(carrier.getCode());
            Airline airline = (Airline)DictionaryCache.get().resolveReference(carrier);
            if (airline != null) {
                result.addAll(airline.getCodeVariants().values());
                if (airline.getAirlineNumber() != null) {
                    result.add(airline.getAirlineNumber());
                }
            }
            return result;
        }

        static void clearCommissions(Product prod) {
            for (AirProductContractRelationData item : AirProductHelper.getContractRelations((Product)prod)) {
                Iterator it = item.getCommissions().iterator();
                while (it.hasNext()) {
                    Commission comm = (Commission)it.next();
                    if (comm.getCommissionProperties() != null && !BaseCategorizedCommissionProperties.class.isAssignableFrom(comm.getCommissionProperties().getType())) continue;
                    it.remove();
                }
            }
        }

        static void clearFeesFops(Product prod) {
            for (AirProductContractRelationData contractRelation : AirProductHelper.getContractRelations((Product)prod)) {
                Iterator fopIt = contractRelation.getFops().iterator();
                while (fopIt.hasNext()) {
                    if (AirProductHelper.isServiceFop((ProductFop)((ProductFop)fopIt.next()))) continue;
                    fopIt.remove();
                }
            }
        }
    }

    static class TchSpecialSchemeLuggageAndPenaltyHelper {
        private static final Logger log = LoggerFactory.getLogger(TchSpecialSchemeVirtualizationHelper.class);

        TchSpecialSchemeLuggageAndPenaltyHelper() {
        }

        static void updateProduct(Product prod) {
        }

        static void deVirtualize(List<Product> products) {
            for (Product vTicket : new ArrayList<Product>(products)) {
                String uid = vTicket.getUid();
                if (!uid.startsWith(TchSpecialSchemeVirtualizationHelper.TCH_SPECIAL_SCHEME_VIRTUALIZATION_TICKET_PREFFIX)) continue;
                Product mcProduct = (Product)BookingHelper.findProductByUid((String)uid.substring(uid.lastIndexOf("|") + 1), (BookingFile)vTicket.getReservation().getBookingFile());
                if (mcProduct == null || mcProduct.getProductCategory() != ProductCategory.MCO || mcProduct.getMcoCategory() != MCOCategory.EXCESS_LUGGAGE && mcProduct.getMcoCategory() != MCOCategory.PENALTY) {
                    log.warn("can't find original product for virtual one");
                    return;
                }
                SpecialSchemeCommonHelper.clearCommissions(mcProduct);
                for (AirProductContractRelationData item : AirProductHelper.getContractRelations((Product)vTicket)) {
                    for (Commission comm : item.getCommissions()) {
                        if (comm.getCommissionProperties() != null && !CommissionProperties.class.isAssignableFrom(comm.getCommissionProperties().getType())) continue;
                        AirProductHelper.findContractRelation((List)AirProductHelper.getContractRelations((Product)mcProduct), (EntityReference)item.getDescription()).getCommissions().add(comm);
                    }
                }
                for (ValidationMessage message : vTicket.getValidationMessages()) {
                    if (message.getCategory() != ValidationMessageCategory.RULES) continue;
                    mcProduct.getValidationMessages().add(message);
                }
                products.remove(vTicket);
                mcProduct.getReservation().getProducts().remove(vTicket);
                mcProduct.setContractRulesApplied(true);
            }
        }

        static boolean isAppropriateProduct(Product prod) {
            if (prod.getProductCategory() != ProductCategory.MCO) {
                return false;
            }
            if (prod.getMcoCategory() != MCOCategory.PENALTY && prod.getMcoCategory() != MCOCategory.EXCESS_LUGGAGE) {
                return false;
            }
            Product product = AirProductHelper.findRelatedAirProduct((Product)prod, null, (boolean)false);
            if (product == null) {
                return false;
            }
            if (product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE) {
                product = product.getPreviousProduct();
            }
            return AirProductHelper.isSpecialSchemeTCHTicket((Product)product);
        }

        static void virtualize(Product ticket, List<Product> result) throws Exception {
            if (!result.contains(ticket)) {
                result.add(ticket);
            }
            if (ticket.getProductCategory() != ProductCategory.MCO) {
                return;
            }
            if (ticket.getMcoCategory() != MCOCategory.PENALTY && ticket.getMcoCategory() != MCOCategory.EXCESS_LUGGAGE) {
                return;
            }
            Product product = AirProductHelper.findRelatedAirProduct((Product)ticket, null, (boolean)false);
            if (product == null) {
                return;
            }
            if (product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE) {
                product = product.getPreviousProduct();
            }
            if (!AirProductHelper.isSpecialSchemeTCHTicket((Product)product)) {
                return;
            }
            Product additionalTicket = TchSpecialSchemeTicketHelper.findRelatedProduct(product);
            if (additionalTicket == null) {
                return;
            }
            Product vTicket = new Product();
            AirProductHelper.copy((Product)ticket, (Product)vTicket, (boolean)true);
            vTicket.setCarrier(product.getCarrier());
            vTicket.setCarrierNumber(product.getCarrierNumber());
            vTicket.setMcoCategory(null);
            vTicket.setProductCategory(ProductCategory.AIR);
            vTicket.getSegmentTariffs().clear();
            vTicket.getSegmentTariffs().addAll(product.getSegmentTariffs());
            vTicket.setTourCode(product.getTourCode());
            vTicket.getSegmentTariffs().addAll(additionalTicket.getSegmentTariffs());
            vTicket.setUid(String.format("%s|%s|%s", TchSpecialSchemeVirtualizationHelper.TCH_SPECIAL_SCHEME_VIRTUALIZATION_TICKET_PREFFIX, additionalTicket.getUid(), ticket.getUid()));
            result.add(vTicket);
        }

        static void updateProxy(RuleProxy<ProductPropertySet, ProductCommissionActionSet> proxy, ContractType contractType) throws Exception {
            ProductPropertySet propertySet = (ProductPropertySet)proxy.getPropertySet();
            Product product = propertySet.getProduct();
            String uid = product.getUid();
            if (!uid.startsWith(TchSpecialSchemeVirtualizationHelper.TCH_SPECIAL_SCHEME_VIRTUALIZATION_TICKET_PREFFIX)) {
                return;
            }
            Product mcProduct = (Product)BookingHelper.findProductByUid((String)uid.substring(uid.lastIndexOf("|") + 1), (BookingFile)product.getReservation().getBookingFile());
            if (mcProduct == null || mcProduct.getProductCategory() != ProductCategory.MCO || mcProduct.getMcoCategory() != MCOCategory.PENALTY && mcProduct.getMcoCategory() != MCOCategory.EXCESS_LUGGAGE) {
                return;
            }
            ((ProductPropertySet)proxy.getPropertySet()).setMcoCategory(mcProduct.getMcoCategory().name());
            ((ProductPropertySet)proxy.getPropertySet()).setProductCategory(ProductCategory.MCO.name());
            propertySet.setTargetType(mcProduct.getMcoCategory().name());
            Product additionalTicket = (Product)BookingHelper.findProduct((BookingFile)mcProduct.getReservation().getBookingFile(), (String)uid.substring(uid.indexOf(124) + 1, uid.lastIndexOf("|")));
            if (additionalTicket != null) {
                Collection<String> additionalCodes = SpecialSchemeCommonHelper.getAllCodes((DictionaryReference<Airline>)additionalTicket.getCarrier());
                propertySet.getCarriers().addAll(additionalCodes);
                if (!additionalCodes.isEmpty()) {
                    propertySet.getAllValidatingCarriersCodes().add(additionalCodes.toArray(new String[additionalCodes.size()]));
                }
                propertySet.getCarriers().addAll(additionalCodes);
            }
            propertySet.setInterline(false);
            int size = propertySet.getInterlineCarriers().size();
            propertySet.getInterlineCarriers().clear();
            for (int n = 0; n < size; ++n) {
                propertySet.getInterlineCarriers().add(null);
            }
        }
    }

    static class TchSpecialSchemeTicketHelper {
        private static final Logger log = LoggerFactory.getLogger(TchSpecialSchemeVirtualizationHelper.class);

        TchSpecialSchemeTicketHelper() {
        }

        static boolean isAppropriateProduct(Product prod) {
            return AirProductHelper.isSpecialSchemeTCHTicket((Product)prod) && (TchSpecialSchemeTicketHelper.isAppropriateProduct(prod, true) || TchSpecialSchemeTicketHelper.isAppropriateProduct(prod, false));
        }

        static void updateProduct(Product prod) {
            if (prod.isChecked() || !prod.isContractRulesApplied() || !TchSpecialSchemeTicketHelper.isAppropriateProduct(prod, true)) {
                return;
            }
            Product slaveProduct = TchSpecialSchemeTicketHelper.findRelatedProduct(prod);
            if (slaveProduct == null || slaveProduct.isContractRulesApplied()) {
                return;
            }
            prod.setContractRulesApplied(false);
        }

        static Product findRelatedProduct(Product ticket) {
            for (BaseProduct bp : ticket.getReservation().getProducts()) {
                Product product;
                if (!(bp instanceof Product) || !TchSpecialSchemeTicketHelper.isAppropriateProduct(product = (Product)bp, false) || TextUtil.compare((String)product.getSystemNumber(), (String)ticket.getSystemNumber(), (boolean)false, (boolean)false) < 0 || product.getTraveller() == null || !product.getTraveller().equals((Object)ticket.getTraveller())) continue;
                return product;
            }
            return null;
        }

        private static boolean isAppropriateProduct(Product ticket, boolean masterProduct) {
            if (!AirProductHelper.isSpecialSchemeTCHTicket((Product)ticket)) {
                return false;
            }
            if (ticket.getProductCategory() != ProductCategory.AIR && (ticket.getProductCategory() != ProductCategory.MCO || ticket.getMcoCategory() != MCOCategory.PTA)) {
                return false;
            }
            if (ticket.getStatus() == ProductStatus.EXCHANGE || ticket.getStatus() == ProductStatus.REFUND) {
                return false;
            }
            BigDecimal ef = AirProductHelper.getEquivalentFare((Product)ticket);
            return masterProduct == (ef != null && BigDecimal.ZERO.compareTo(ef) != 0);
        }

        static void virtualize(Product ticket, List<Product> result) throws Exception {
            if (TchSpecialSchemeTicketHelper.isAppropriateProduct(ticket, false)) {
                ticket.setContractRulesApplied(true);
                return;
            }
            if (!result.contains(ticket)) {
                result.add(ticket);
            }
            if (!TchSpecialSchemeTicketHelper.isAppropriateProduct(ticket, true)) {
                return;
            }
            Product additionalTicket = TchSpecialSchemeTicketHelper.findRelatedProduct(ticket);
            if (additionalTicket == null) {
                return;
            }
            Product vTicket = new Product();
            AirProductHelper.copy((Product)ticket, (Product)vTicket, (boolean)true);
            vTicket.getSegmentTariffs().addAll(additionalTicket.getSegmentTariffs());
            vTicket.setUid(String.format("%s|%s|%s", TchSpecialSchemeVirtualizationHelper.TCH_SPECIAL_SCHEME_VIRTUALIZATION_TICKET_PREFFIX, ticket.getUid(), additionalTicket.getUid()));
            result.add(vTicket);
        }

        static void updateProxy(RuleProxy<ProductPropertySet, ProductCommissionActionSet> proxy, ContractType contractType) throws Exception {
            ProductPropertySet propertySet = (ProductPropertySet)proxy.getPropertySet();
            Product product = propertySet.getProduct();
            String uid = product.getUid();
            if (!uid.startsWith(TchSpecialSchemeVirtualizationHelper.TCH_SPECIAL_SCHEME_VIRTUALIZATION_TICKET_PREFFIX)) {
                return;
            }
            Product slaveProduct = (Product)BookingHelper.findProductByUid((String)uid.substring(uid.lastIndexOf("|") + 1), (BookingFile)product.getReservation().getBookingFile());
            if (slaveProduct != null && slaveProduct.getProductCategory() != ProductCategory.AIR) {
                return;
            }
            if (slaveProduct != null && slaveProduct.getCarrier() != null) {
                Collection<String> additionalCodes = SpecialSchemeCommonHelper.getAllCodes((DictionaryReference<Airline>)slaveProduct.getCarrier());
                propertySet.getCarriers().addAll(additionalCodes);
                if (!additionalCodes.isEmpty()) {
                    propertySet.getAllValidatingCarriersCodes().add(additionalCodes.toArray(new String[additionalCodes.size()]));
                }
                propertySet.getCarriers().addAll(additionalCodes);
            }
            propertySet.setInterline(false);
            int size = propertySet.getInterlineCarriers().size();
            propertySet.getInterlineCarriers().clear();
            for (int n = 0; n < size; ++n) {
                propertySet.getInterlineCarriers().add(null);
            }
        }

        static void deVirtualize(List<Product> products) {
            for (Product vTicket : new ArrayList<Product>(products)) {
                Product masterTicket;
                String uid = vTicket.getUid();
                if (!uid.startsWith(TchSpecialSchemeVirtualizationHelper.TCH_SPECIAL_SCHEME_VIRTUALIZATION_TICKET_PREFFIX)) continue;
                Product slaveProduct = (Product)BookingHelper.findProductByUid((String)uid.substring(uid.lastIndexOf("|") + 1), (BookingFile)vTicket.getReservation().getBookingFile());
                if (slaveProduct != null && slaveProduct.getProductCategory() != ProductCategory.AIR) {
                    return;
                }
                if (slaveProduct != null) {
                    SpecialSchemeCommonHelper.clearCommissions(slaveProduct);
                }
                if ((masterTicket = (Product)BookingHelper.findProduct((BookingFile)vTicket.getReservation().getBookingFile(), (String)uid.substring(uid.indexOf(124) + 1, uid.lastIndexOf("|")))) == null) {
                    vTicket.getReservation().getProducts().remove(vTicket);
                    log.warn("can't find original product for virtual one");
                    continue;
                }
                SpecialSchemeCommonHelper.clearCommissions(masterTicket);
                SpecialSchemeCommonHelper.clearFeesFops(masterTicket);
                for (AirProductContractRelationData item : AirProductHelper.getContractRelations((Product)vTicket)) {
                    AirProductContractRelationData masterRelation = AirProductHelper.findContractRelation((List)AirProductHelper.getContractRelations((Product)masterTicket), (EntityReference)item.getDescription());
                    for (Commission comm : item.getCommissions()) {
                        if (comm.getCommissionProperties() != null && !BaseCategorizedCommissionProperties.class.isAssignableFrom(comm.getCommissionProperties().getType())) continue;
                        masterRelation.getCommissions().add(comm);
                    }
                    for (ProductFop fop : item.getFops()) {
                        if (fop.getCommissions().isEmpty()) continue;
                        masterRelation.getFops().add(fop);
                    }
                }
                for (ValidationMessage message : vTicket.getValidationMessages()) {
                    if (message.getCategory() != ValidationMessageCategory.RULES) continue;
                    masterTicket.getValidationMessages().add(message);
                }
                products.remove(vTicket);
                masterTicket.getReservation().getProducts().remove(vTicket);
                masterTicket.setContractRulesApplied(true);
            }
        }
    }
}

