/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.rules;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.transfer.TransferHelper;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.booking.transfers.TransferProvider;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.Parameter;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.elements.DebugInfo;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ReflectionUtil;
import com.gridnine.xtrip.server.model.handlers.RulesHandler;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistry;
import com.gridnine.xtrip.server.model.handlers.TransferActionSet;
import com.gridnine.xtrip.server.model.handlers.TransferPropertySet;
import com.gridnine.xtrip.server.model.handlers.rules.GeneralProductRulesHelper;
import com.gridnine.xtrip.server.model.handlers.rules.RulesProductHandler;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferRulesHandler
implements RulesHandler {
    public static final String ID = MiscUtil.getSimpleClassName(TransferRulesHandler.class);

    public static TransferRulesHandler get() {
        return ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).getAllRulesHandlers().stream().filter(rulesHandler -> ID.equals(rulesHandler.getId())).map(TransferRulesHandler.class::cast).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"TransferRulesHandler not found in registry", (Object[])new Object[0]));
    }

    @Override
    public void applyRules(EntityContainer<BookingFile> bookingContainer, boolean forced, boolean simulate, List<Message> messages, Map<Parameter, Object> params, DebugInfo debugInfo, boolean calcAppliedRulesToBooking) throws Exception {
        TransferRulesProductHandler rulesHandler = (TransferRulesProductHandler)ReflectionUtil.createBySystemPropertyName((String)"com.gridnine.xtrip.server.model.handlers.rules.TransferRulesHandler.TransferRulesProductHandler.className", (Logger)LoggerFactory.getLogger(this.getClass()), TransferRulesProductHandler::new);
        GeneralProductRulesHelper.applyContracts(bookingContainer, forced, simulate, rulesHandler, messages, params, debugInfo, calcAppliedRulesToBooking);
    }

    public RulesProductHandler<Transfer, TransferPropertySet, TransferActionSet> createRulesHandler() {
        return (RulesProductHandler)ReflectionUtil.createBySystemPropertyName((String)"com.gridnine.xtrip.server.model.handlers.rules.TransferRulesHandler.TransferRulesProductHandler.className", (Logger)LoggerFactory.getLogger(this.getClass()), TransferRulesProductHandler::new);
    }

    @Override
    public String getId() {
        return ID;
    }

    protected TransferPropertySet createPropertySet(RuleProxy<TransferPropertySet, TransferActionSet> proxy) {
        return new TransferPropertySet(proxy);
    }

    public static class TransferRulesProductHandler
    extends RulesProductHandler<Transfer, TransferPropertySet, TransferActionSet> {
        @Override
        public void clearActionSet(RuleProxy<TransferPropertySet, TransferActionSet> proxy, Transfer item) {
            proxy.getAppliedRuleCategories().clear();
            proxy.getAppliedRules().clear();
            proxy.getTracer().clear();
            proxy.setActionSet((Object)this.createActionSet(proxy, item));
        }

        protected TransferActionSet createActionSet(RuleProxy<TransferPropertySet, TransferActionSet> proxy, Transfer item) {
            return new TransferActionSet(proxy, item);
        }

        @Override
        public RuleProxy<TransferPropertySet, TransferActionSet> createProxy(Transfer item, boolean enabledTracer) throws Exception {
            RuleProxy proxy = new RuleProxy();
            TransferPropertySet props = new TransferPropertySet(proxy);
            proxy.setPropertySet((Object)props);
            proxy.setProxyDate(item.getIssueDate());
            proxy.setProxyType(Targets.TRANSFER.getId());
            proxy.getTracer().setDisabled(!enabledTracer);
            ((TransferPropertySet)proxy.getPropertySet()).init(item);
            return proxy;
        }

        @Override
        public EntityReference<Organization> getBlankOwner(Transfer item) {
            return item.getBlankOwner();
        }

        @Override
        public Date getIssueDate(Transfer item) {
            return item.getIssueDate();
        }

        @Override
        public boolean hasRefundCommissions(RuleProxy<TransferPropertySet, TransferActionSet> proxy) {
            return ((TransferActionSet)proxy.getActionSet()).hasRefundCommissions();
        }

        @Override
        public Class<Transfer> getProductClass() {
            return Transfer.class;
        }

        @Override
        public ProductStatus getStatus(Transfer item) {
            return item.getStatus();
        }

        @Override
        public TicketType getTicketType(Transfer item) {
            return item.getTicketType();
        }

        @Override
        public List<ValidationMessage> getValidationMessages(Transfer item) {
            return item.getValidationMessages();
        }

        @Override
        public boolean isChecked(Transfer item) {
            return item.isChecked();
        }

        @Override
        public boolean isContractRulesApplied(Transfer item) {
            return item.isContractRulesApplied();
        }

        @Override
        public void setContractRulesApplied(Transfer item, boolean value) {
            item.setContractRulesApplied(value);
        }

        @Override
        public List<GeneralProductContractRelationData> getContractRelations(Transfer item) {
            return TransferHelper.getContractRelations((Transfer)item);
        }

        @Override
        public List<GeneralProductContractRelationData> getPreviousProductContractRelations(Transfer item) {
            return item.getPreviousProduct() == null ? null : TransferHelper.getContractRelations((Transfer)item.getPreviousProduct());
        }

        @Override
        public List<GeneralProductCommission> createCommissions(RuleProxy<TransferPropertySet, TransferActionSet> proxy, Transfer item, GeneralProductContractRelationData relation, List<GeneralProductContractRelationData> allRelations, List<GeneralProductContractRelationData> previousProductContractRelations, boolean separateSupplierFees, ExchangeRateData rateData) throws Exception {
            return ((TransferActionSet)proxy.getActionSet()).createCommissions(relation, allRelations, previousProductContractRelations, separateSupplierFees, rateData, new ArrayList<ValidationMessage>());
        }

        @Override
        public List<GeneralProductCommission> createCommissions(RuleProxy<TransferPropertySet, TransferActionSet> proxy, Transfer item, GeneralProductContractRelationData relation, List<GeneralProductContractRelationData> allRelations, List<GeneralProductContractRelationData> previousProductContractRelations, boolean translateSupplierFees, boolean separateSupplierFees, ExchangeRateData rateData) throws Exception {
            return ((TransferActionSet)proxy.getActionSet()).createCommissions(relation, allRelations, previousProductContractRelations, translateSupplierFees, separateSupplierFees, rateData, new ArrayList<ValidationMessage>());
        }

        @Override
        public Enum<?> getProvider(Transfer product) {
            if (product.getProvider() != null) {
                return product.getProvider();
            }
            EntityReference blankOwner = product.getBlankOwner();
            if (null == blankOwner) {
                return null;
            }
            if (blankOwner.getUid().contains("-iway-")) {
                return TransferProvider.IWAY;
            }
            GdsName gdsName = CommonReservationGdsNameInfoHelper.getRulesGdsName((Reservation)product.getReservation());
            if (gdsName != null && "TICKETME_TRANSFERS".equals(gdsName.name())) {
                return TransferProvider.valueOf((String)"TICKETME");
            }
            return null;
        }

        @Override
        public Set<PaymentType> getAllowedPaymentTypes(TransferActionSet actionSet) {
            return actionSet.getAllowedPaymentTypes();
        }
    }
}

