/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.rules;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.helpers.UniversalProductHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.Parameter;
import com.gridnine.xtrip.common.model.rules.standard.UniversalProductPropertiesProvider;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.elements.DebugInfo;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.handlers.RulesHandler;
import com.gridnine.xtrip.server.model.handlers.UniversalProductActionSet;
import com.gridnine.xtrip.server.model.handlers.UniversalProductPropertySet;
import com.gridnine.xtrip.server.model.handlers.rules.GeneralProductRulesHelper;
import com.gridnine.xtrip.server.model.handlers.rules.RulesProductHandler;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniversalProductRulesHandler
implements RulesHandler {
    @Override
    public void applyRules(EntityContainer<BookingFile> bookingFileContainer, boolean forced, boolean simulate, final List<Message> messages, Map<Parameter, Object> params, DebugInfo debugInfo, boolean calcAppliedRulesToBooking) throws Exception {
        GeneralProductRulesHelper.applyContracts(bookingFileContainer, forced, simulate, new RulesProductHandler<UniversalProduct, UniversalProductPropertySet, UniversalProductActionSet>(){
            private final transient Logger log = LoggerFactory.getLogger(UniversalProductRulesHandler.class);

            @Override
            public void clearActionSet(RuleProxy<UniversalProductPropertySet, UniversalProductActionSet> proxy, UniversalProduct item) {
                proxy.getAppliedRuleCategories().clear();
                proxy.getAppliedRules().clear();
                proxy.getTracer().clear();
                proxy.setActionSet((Object)new UniversalProductActionSet(proxy, (UniversalProductPropertiesProvider)proxy.getPropertySet(), item));
            }

            @Override
            public RuleProxy<UniversalProductPropertySet, UniversalProductActionSet> createProxy(UniversalProduct item, boolean enabledTracer) {
                RuleProxy proxy = new RuleProxy();
                UniversalProductPropertySet props = new UniversalProductPropertySet(proxy);
                proxy.setPropertySet((Object)props);
                proxy.getTracer().setDisabled(!enabledTracer);
                proxy.setProxyDate(item.getIssueDate());
                proxy.setProxyType(UniversalProductHelper.getRuleTargetId((EntityReference)item.getDescription()));
                ((UniversalProductPropertySet)proxy.getPropertySet()).init(item);
                return proxy;
            }

            @Override
            public EntityReference<Organization> getBlankOwner(UniversalProduct item) {
                return item.getBlankOwner();
            }

            @Override
            public Date getIssueDate(UniversalProduct item) {
                return item.getIssueDate();
            }

            @Override
            public boolean hasRefundCommissions(RuleProxy<UniversalProductPropertySet, UniversalProductActionSet> proxy) {
                return ((UniversalProductActionSet)proxy.getActionSet()).hasRefundCommissions();
            }

            @Override
            public Class<UniversalProduct> getProductClass() {
                return UniversalProduct.class;
            }

            @Override
            public ProductStatus getStatus(UniversalProduct item) {
                return item.getStatus();
            }

            @Override
            public TicketType getTicketType(UniversalProduct item) {
                EntityReference descriptionRef = item.getDescription();
                if (descriptionRef == null) {
                    this.log.error(String.format("product %s: description is null", item.getSystemNumber()));
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.UniversalProductRulesHandler_productNotDefineDescription, (Object[])new Object[]{item.getSystemNumber()}));
                    return TicketType.FAKE;
                }
                try {
                    EntityContainer descriptionCtr = EntityStorage.get().resolve(descriptionRef);
                    if (descriptionCtr == null) {
                        this.log.error(String.format("product %s: unable to resolve description %s", item.getSystemNumber(), descriptionRef));
                        messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.UniversalProductRulesHandler_productCantLoadDescription, (Object[])new Object[]{item.getSystemNumber()}));
                        return TicketType.FAKE;
                    }
                }
                catch (Exception e) {
                    this.log.error(String.format("product %s: unable to resolve description %s", item.getSystemNumber(), descriptionRef), (Throwable)e);
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.UniversalProductRulesHandler_productCantLoadDescription, (Throwable)e, (Object[])new Object[]{item.getSystemNumber()}));
                    return TicketType.FAKE;
                }
                return item.getTicketType();
            }

            @Override
            public List<ValidationMessage> getValidationMessages(UniversalProduct item) {
                return item.getValidationMessages();
            }

            @Override
            public boolean isChecked(UniversalProduct item) {
                return item.isChecked();
            }

            @Override
            public boolean isContractRulesApplied(UniversalProduct item) {
                return item.isContractRulesApplied();
            }

            @Override
            public boolean isRulesApplicable(UniversalProduct item) {
                EntityContainer descriptionCtr = EntityStorage.get().resolve(item.getDescription());
                return descriptionCtr != null && ((UniversalProductDescription)descriptionCtr.getEntity()).isRulesSupported();
            }

            @Override
            public void setContractRulesApplied(UniversalProduct item, boolean value) {
                item.setContractRulesApplied(value);
            }

            @Override
            public void updateContractRelationsBySalesChain(UniversalProduct item) {
            }

            @Override
            public List<GeneralProductContractRelationData> getContractRelations(UniversalProduct item) {
                return UniversalProductHelper.getContractRelations((UniversalProduct)item);
            }

            @Override
            public List<GeneralProductContractRelationData> getPreviousProductContractRelations(UniversalProduct item) {
                return item.getPreviousProduct() == null ? null : UniversalProductHelper.getContractRelations((UniversalProduct)item.getPreviousProduct());
            }

            @Override
            public List<GeneralProductCommission> createCommissions(RuleProxy<UniversalProductPropertySet, UniversalProductActionSet> proxy, UniversalProduct item, GeneralProductContractRelationData relation, List<GeneralProductContractRelationData> allRelations, List<GeneralProductContractRelationData> previousProductContractRelations, boolean separateSupplierFees, ExchangeRateData rateData) throws Exception {
                return ((UniversalProductActionSet)proxy.getActionSet()).createCommissions(relation, allRelations, previousProductContractRelations, separateSupplierFees, rateData, new ArrayList<ValidationMessage>());
            }

            @Override
            public List<GeneralProductCommission> createCommissions(RuleProxy<UniversalProductPropertySet, UniversalProductActionSet> proxy, UniversalProduct item, GeneralProductContractRelationData relation, List<GeneralProductContractRelationData> allRelations, List<GeneralProductContractRelationData> previousProductContractRelations, boolean translateSupplierFees, boolean separateSupplierFees, ExchangeRateData rateData) throws Exception {
                return ((UniversalProductActionSet)proxy.getActionSet()).createCommissions(relation, allRelations, previousProductContractRelations, translateSupplierFees, separateSupplierFees, rateData, new ArrayList<ValidationMessage>());
            }

            @Override
            public void afterCommissionCalculated(UniversalProduct item) {
            }

            @Override
            public Set<PaymentType> getAllowedPaymentTypes(UniversalProductActionSet actionSet) {
                return actionSet.getAllowedPaymentTypes();
            }
        }, messages, params, calcAppliedRulesToBooking);
    }

    @Override
    public String getId() {
        return MiscUtil.getSimpleClassName(this.getClass());
    }
}

