/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.rules;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.visa.VisaProduct;
import com.gridnine.xtrip.common.model.booking.visa.VisaProductHelper;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.Parameter;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.rules.standard.VisaProductPropertiesProvider;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.elements.DebugInfo;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.handlers.RulesHandler;
import com.gridnine.xtrip.server.model.handlers.VisaProductActionSet;
import com.gridnine.xtrip.server.model.handlers.VisaProductPropertySet;
import com.gridnine.xtrip.server.model.handlers.rules.GeneralProductRulesHelper;
import com.gridnine.xtrip.server.model.handlers.rules.RulesProductHandler;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VisaProductRulesHandler
implements RulesHandler {
    public static final String ID = MiscUtil.getSimpleClassName(VisaProductRulesHandler.class);

    @Override
    public void applyRules(EntityContainer<BookingFile> bookingContainer, boolean forced, boolean simulate, List<Message> messages, Map<Parameter, Object> params, DebugInfo debugInfo, boolean calcAppliedRulesToBooking) throws Exception {
        GeneralProductRulesHelper.applyContracts(bookingContainer, forced, simulate, new RulesProductHandler<VisaProduct, VisaProductPropertySet, VisaProductActionSet>(){

            @Override
            public void clearActionSet(RuleProxy<VisaProductPropertySet, VisaProductActionSet> proxy, VisaProduct item) {
                proxy.getAppliedRuleCategories().clear();
                proxy.getAppliedRules().clear();
                proxy.getTracer().clear();
                proxy.setActionSet((Object)new VisaProductActionSet(proxy, (VisaProductPropertiesProvider)proxy.getPropertySet(), item));
            }

            @Override
            public RuleProxy<VisaProductPropertySet, VisaProductActionSet> createProxy(VisaProduct item, boolean enabledTracer) {
                RuleProxy proxy = new RuleProxy();
                VisaProductPropertySet props = VisaProductRulesHandler.this.createPropertySet((RuleProxy<VisaProductPropertySet, VisaProductActionSet>)proxy);
                proxy.setPropertySet((Object)props);
                proxy.setProxyDate(item.getIssueDate());
                proxy.setProxyType(Targets.VISA_PRODUCT_COMMISSION.getId());
                proxy.getTracer().setDisabled(!enabledTracer);
                ((VisaProductPropertySet)proxy.getPropertySet()).init(item);
                return proxy;
            }

            @Override
            public EntityReference<Organization> getBlankOwner(VisaProduct item) {
                return item.getBlankOwner();
            }

            @Override
            public Date getIssueDate(VisaProduct item) {
                return item.getIssueDate();
            }

            @Override
            public boolean hasRefundCommissions(RuleProxy<VisaProductPropertySet, VisaProductActionSet> proxy) {
                return ((VisaProductActionSet)proxy.getActionSet()).hasRefundCommissions();
            }

            @Override
            public Class<VisaProduct> getProductClass() {
                return VisaProduct.class;
            }

            @Override
            public ProductStatus getStatus(VisaProduct item) {
                return item.getStatus();
            }

            @Override
            public TicketType getTicketType(VisaProduct item) {
                return item.getTicketType();
            }

            @Override
            public List<ValidationMessage> getValidationMessages(VisaProduct item) {
                return item.getValidationMessages();
            }

            @Override
            public boolean isChecked(VisaProduct item) {
                return item.isChecked();
            }

            @Override
            public boolean isContractRulesApplied(VisaProduct item) {
                return item.isContractRulesApplied();
            }

            @Override
            public void setContractRulesApplied(VisaProduct item, boolean value) {
                item.setContractRulesApplied(value);
            }

            @Override
            public void updateContractRelationsBySalesChain(VisaProduct item) {
            }

            @Override
            public List<GeneralProductContractRelationData> getContractRelations(VisaProduct item) {
                return VisaProductHelper.getContractRelations((VisaProduct)item);
            }

            @Override
            public List<GeneralProductContractRelationData> getPreviousProductContractRelations(VisaProduct item) {
                return item.getPreviousProduct() == null ? null : VisaProductHelper.getContractRelations((VisaProduct)item.getPreviousProduct());
            }

            @Override
            public List<GeneralProductCommission> createCommissions(RuleProxy<VisaProductPropertySet, VisaProductActionSet> proxy, VisaProduct item, GeneralProductContractRelationData relation, List<GeneralProductContractRelationData> allRelations, List<GeneralProductContractRelationData> previousProductContractRelations, boolean separateSupplierFees, ExchangeRateData rateData) throws Exception {
                return ((VisaProductActionSet)proxy.getActionSet()).createCommissions(relation, allRelations, previousProductContractRelations, separateSupplierFees, rateData, new ArrayList<ValidationMessage>());
            }

            @Override
            public List<GeneralProductCommission> createCommissions(RuleProxy<VisaProductPropertySet, VisaProductActionSet> proxy, VisaProduct item, GeneralProductContractRelationData relation, List<GeneralProductContractRelationData> allRelations, List<GeneralProductContractRelationData> previousProductContractRelations, boolean translateSupplierFees, boolean separateSupplierFees, ExchangeRateData rateData) throws Exception {
                return ((VisaProductActionSet)proxy.getActionSet()).createCommissions(relation, allRelations, previousProductContractRelations, translateSupplierFees, separateSupplierFees, rateData, new ArrayList<ValidationMessage>());
            }

            @Override
            public void afterCommissionCalculated(VisaProduct item) {
            }

            @Override
            public Set<PaymentType> getAllowedPaymentTypes(VisaProductActionSet actionSet) {
                return actionSet.getAllowedPaymentTypes();
            }
        }, messages, params, calcAppliedRulesToBooking);
    }

    @Override
    public String getId() {
        return ID;
    }

    protected VisaProductPropertySet createPropertySet(RuleProxy<VisaProductPropertySet, VisaProductActionSet> proxy) {
        return new VisaProductPropertySet(proxy);
    }
}

