/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.rules;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseCommission;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SimpleTax;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.ReturnCase;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoidingType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProductVoidingHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rules.elements.DebugInfo;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class VoidProductVirtualizationHelper {
    private static final String VOID_VIRTUAL_TICKET_PREFIX = "VOID_TICKET_VIRTUAL:";

    public static void resetRulesAppliedFlag(EntityContainer<BookingFile> bookingCtr) {
        if (!LogicalStorage.get().getEntityStorage().isGlobalOperationContextAvailable()) {
            return;
        }
        EntityContainer oldBookingCtr = LogicalStorage.get().getEntityStorage().getLocalOperationContext(bookingCtr.toReference()).getOldCtr();
        if (oldBookingCtr == null) {
            return;
        }
        for (Reservation res : ((BookingFile)bookingCtr.getEntity()).getReservations()) {
            for (BaseProduct prod : res.getProducts()) {
                Product oldProduct;
                if (!(prod instanceof Product)) continue;
                Product product = (Product)prod;
                if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus()) || !product.isContractRulesApplied() || (oldProduct = (Product)BookingHelper.findProduct((BookingFile)((BookingFile)oldBookingCtr.getEntity()), (String)product.getUid())) == null || ProductStatusHandler.getAllVoidStatuses().contains(oldProduct.getStatus())) continue;
                product.setContractRulesApplied(false);
            }
        }
    }

    public static void virtualizeVoidProducts(List<Product> products, List<Message> messages, DebugInfo info) throws Exception {
        boolean modified = false;
        ArrayList<Product> result = new ArrayList<Product>();
        for (Product product : products) {
            if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
                result.add(product);
                continue;
            }
            Product fakeSell = AirProductHelper.clone((Product)product, (boolean)true);
            fakeSell.setStatus(ProductStatus.SELL);
            fakeSell.setUid(VOID_VIRTUAL_TICKET_PREFIX + fakeSell.getUid() + '|' + product.getUid());
            Product fakeRefund = AirProductHelper.clone((Product)product, (boolean)true);
            fakeRefund.setStatus(ProductStatus.REFUND);
            fakeRefund.setUid(VOID_VIRTUAL_TICKET_PREFIX + fakeRefund.getUid() + '|' + product.getUid());
            fakeRefund.setPreviousProduct(fakeSell);
            result.add(fakeSell);
            result.add(fakeRefund);
            product.getRelatedProducts().add(fakeSell);
            product.getRelatedProducts().add(fakeRefund);
            modified = true;
            if (info != null) {
                info.message(String.format("product %s of status VOID is virtualized", product.getSystemNumber()));
            }
            result.add(product);
        }
        if (modified) {
            products.clear();
            products.addAll(result);
        }
    }

    public static boolean isVirtualVoid(Product product) {
        return product.getUid().startsWith(VOID_VIRTUAL_TICKET_PREFIX);
    }

    public static boolean isFakeSell(Product product) {
        return VoidProductVirtualizationHelper.isVirtualVoid(product) && product.getStatus() == ProductStatus.SELL;
    }

    public static boolean isFakeRefund(Product product) {
        return VoidProductVirtualizationHelper.isVirtualVoid(product) && product.getStatus() == ProductStatus.REFUND;
    }

    public static Product findRelatedFakeProduct(Product product, ProductStatus status) {
        int defaultIdx = status == ProductStatus.SELL ? 0 : 1;
        return product.getRelatedProducts().stream().filter(VoidProductVirtualizationHelper::isVirtualVoid).filter(prod -> prod.getStatus() == status).findFirst().orElse((Product)product.getRelatedProducts().get(defaultIdx));
    }

    public static void devirtualizeVoidProducts(Product voidProduct, List<Message> messages, DebugInfo info) throws Exception {
        if (VoidProductVirtualizationHelper.isVirtualVoid(voidProduct)) {
            return;
        }
        if (!ProductStatusHandler.getAllVoidStatuses().contains(voidProduct.getStatus())) {
            return;
        }
        Product fakeSell = VoidProductVirtualizationHelper.findRelatedFakeProduct(voidProduct, ProductStatus.SELL);
        Product fakeRefund = VoidProductVirtualizationHelper.findRelatedFakeProduct(voidProduct, ProductStatus.REFUND);
        List fakeSellRelations = GeneralProductHelper.getUnmodifiableContractRelations((BaseProduct)fakeSell);
        List fakeRefundRelations = GeneralProductHelper.getUnmodifiableContractRelations((BaseProduct)fakeRefund);
        List voidingFeeRelations = GeneralProductHelper.getUnmodifiableContractRelations((BaseProduct)voidProduct);
        ArrayList<GeneralProductContractRelationData> retainedSellFeeRelations = voidProduct.getStatus() == ProductStatus.VOID ? VoidProductVirtualizationHelper.prepareRetainedSellFeeRelations(fakeSellRelations, fakeRefundRelations) : new ArrayList();
        VoidProductVirtualizationHelper.updateValidationMessages(voidProduct, fakeSell);
        VoidProductVirtualizationHelper.createProductVoidingIfNeeded(ProductVoidingType.VOIDING_FEE, voidProduct, voidingFeeRelations);
        VoidProductVirtualizationHelper.createProductVoidingIfNeeded(ProductVoidingType.RETAINED_SELL_FEE, voidProduct, retainedSellFeeRelations);
        VoidProductVirtualizationHelper.swapContractRelations(voidProduct, fakeSell, fakeSellRelations);
        voidProduct.getRelatedProducts().remove(fakeSell);
        voidProduct.getRelatedProducts().remove(fakeRefund);
        voidProduct.getReservation().getProducts().remove(fakeSell);
        voidProduct.getReservation().getProducts().remove(fakeRefund);
    }

    private static void updateValidationMessages(Product voidProduct, Product fakeSell) {
        ArrayList<ValidationMessage> validationMessagesToRemove = new ArrayList<ValidationMessage>();
        ArrayList<ValidationMessage> validationMessagesToAdd = new ArrayList<ValidationMessage>();
        for (ValidationMessage validationMessage2 : voidProduct.getValidationMessages()) {
            if (ValidationMessageCategory.RULES != validationMessage2.getCategory() || !fakeSell.getValidationMessages().stream().noneMatch(sellValidationMessage -> sellValidationMessage.getMessage().equals((Object)validationMessage2.getMessage()))) continue;
            validationMessagesToRemove.add(validationMessage2);
        }
        for (ValidationMessage sellValidationMessage2 : fakeSell.getValidationMessages()) {
            if (ValidationMessageCategory.RULES != sellValidationMessage2.getCategory() || !voidProduct.getValidationMessages().stream().noneMatch(validationMessage -> validationMessage.getMessage().equals((Object)sellValidationMessage2.getMessage()))) continue;
            validationMessagesToAdd.add(sellValidationMessage2);
        }
        voidProduct.getValidationMessages().removeAll(validationMessagesToRemove);
        voidProduct.getValidationMessages().addAll(validationMessagesToAdd);
    }

    private static List<GeneralProductContractRelationData> prepareRetainedSellFeeRelations(List<GeneralProductContractRelationData> fakeSellRelations, List<GeneralProductContractRelationData> fakeRefundRelations) throws Exception {
        ArrayList<GeneralProductContractRelationData> retainedSellFeeRelations = new ArrayList<GeneralProductContractRelationData>();
        for (GeneralProductContractRelationData relation : fakeSellRelations) {
            GeneralProductContractRelationData rel = new GeneralProductContractRelationData();
            rel.copyFrom((BaseEntity)relation, true, new HashMap());
            rel.getServiceData().setTotalPrice(BigDecimal.ZERO);
            rel.getServiceData().setPaymentPrice(BigDecimal.ZERO);
            rel.getServiceData().getDetalization().setFare(BigDecimal.ZERO);
            rel.getServiceData().getDetalization().setObFees(BigDecimal.ZERO);
            rel.getServiceData().getDetalization().setPenalty(BigDecimal.ZERO);
            rel.getServiceData().getDetalization().setPenaltyWithMcoValue(BigDecimal.ZERO);
            rel.getServiceData().getDetalization().setDeduction(BigDecimal.ZERO);
            rel.getServiceData().getDetalization().getTaxes().clear();
            rel.getCommissions().clear();
            GeneralProductFop oldFop = rel.getFops().isEmpty() ? null : (GeneralProductFop)rel.getFops().get(0);
            rel.getFops().clear();
            GeneralProductContractRelationData refundRelation = fakeRefundRelations.stream().filter(it -> it.getDescription().equals((Object)relation.getDescription())).findFirst().get();
            rel.getCommissions().addAll(relation.getCommissions().stream().filter(it -> !MiscUtil.isZero((BigDecimal)it.getEquivalentAmount(), (boolean)true)).filter(it -> GeneralProductHelper.isStandartFee((EntityReference)it.getCommissionProperties())).filter(it -> refundRelation.getCommissions().stream().noneMatch(it2 -> it.getCommissionProperties().equals((Object)it2.getCommissionProperties()))).collect(Collectors.toList()));
            if (!rel.getCommissions().isEmpty()) {
                GeneralProductFop fop = new GeneralProductFop();
                if (oldFop != null) {
                    fop.copyFrom((BaseEntity)oldFop, true, new HashMap());
                }
                fop.setEquivalentAmount(rel.getCommissions().stream().map(BaseCommission::getEquivalentAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
                fop.getCommissions().clear();
                fop.getCommissions().addAll(rel.getCommissions());
                rel.getFops().add(fop);
            }
            retainedSellFeeRelations.add(rel);
        }
        return retainedSellFeeRelations;
    }

    private static void createProductVoidingIfNeeded(ProductVoidingType type, Product voidProduct, List<GeneralProductContractRelationData> originalRelations) throws Exception {
        boolean needProductVoiding = false;
        for (GeneralProductContractRelationData voidRel : originalRelations) {
            boolean notManualNotRefundableCommissionsExist = voidRel.getCommissions().stream().anyMatch(GeneralProductHelper::isNotManualNotRefundableCommission);
            if (!notManualNotRefundableCommissionsExist) continue;
            needProductVoiding = true;
            break;
        }
        ProductVoiding productVoiding = ProductVoidingHelper.getRelatedVoidings((BaseProduct)voidProduct).stream().filter(pv -> pv.getType() == type).findFirst().orElse(null);
        if (needProductVoiding) {
            if (productVoiding == null) {
                productVoiding = new ProductVoiding();
                productVoiding.setType(type);
                productVoiding.setReservation(voidProduct.getReservation());
                voidProduct.getReservation().getProducts().add(productVoiding);
                productVoiding.setRelatedProduct((BaseProduct)voidProduct);
            }
            ArrayList<GeneralProductContractRelationData> relations = new ArrayList<GeneralProductContractRelationData>();
            for (GeneralProductContractRelationData relation : originalRelations) {
                GeneralProductContractRelationData rel = new GeneralProductContractRelationData();
                rel.copyFrom((BaseEntity)relation, true, new HashMap());
                rel.getServiceData().setTotalPrice(BigDecimal.ZERO);
                rel.getServiceData().setPaymentPrice(BigDecimal.ZERO);
                rel.getServiceData().getDetalization().setFare(BigDecimal.ZERO);
                rel.getServiceData().getDetalization().setObFees(BigDecimal.ZERO);
                rel.getServiceData().getDetalization().setPenalty(BigDecimal.ZERO);
                rel.getServiceData().getDetalization().setPenaltyWithMcoValue(BigDecimal.ZERO);
                rel.getServiceData().getDetalization().setDeduction(BigDecimal.ZERO);
                rel.getServiceData().getDetalization().getTaxes().clear();
                rel.getFops().removeIf(GeneralProductHelper::isServiceFop);
                rel.getCommissions().removeIf(c -> {
                    if (!c.getCommissionProperties().getType().equals(FeeProperties.class)) {
                        return false;
                    }
                    EntityContainer ctr = EntityStorage.get().resolve(c.getCommissionProperties());
                    if (ctr == null) {
                        return false;
                    }
                    return ((FeeProperties)ctr.getEntity()).getReturnCases().contains(ReturnCase.VOID);
                });
                relations.add(rel);
            }
            GeneralProductHelper.getHandler((BaseProduct)productVoiding).updateContractRelations((BaseProduct)productVoiding, relations);
        } else if (productVoiding != null) {
            productVoiding.setReservation(null);
            productVoiding.setRelatedProduct(null);
            voidProduct.getReservation().getProducts().remove(productVoiding);
        }
        if (productVoiding != null && productVoiding.getRelatedProduct() != null) {
            voidProduct.setStatus(ProductVoidingHelper.getRelatedProductStatus((ProductVoiding)productVoiding));
        }
    }

    private static void swapContractRelations(Product voidProduct, Product fakeSell, List<GeneralProductContractRelationData> fakeSellRelations) {
        ArrayList voidProdTaxes = new ArrayList(voidProduct.getTaxes());
        HashMap<String, String> virt2Orig = new HashMap<String, String>();
        for (Tax virtualVoidTax : fakeSell.getTaxes()) {
            Tax match = voidProdTaxes.stream().filter(t -> Objects.equals(t.getCode(), virtualVoidTax.getCode()) && Objects.equals(t.getEquivalentAmount(), virtualVoidTax.getEquivalentAmount())).findFirst().orElse(null);
            if (match == null) continue;
            voidProdTaxes.remove(match);
            virt2Orig.put(virtualVoidTax.getUid(), match.getUid());
        }
        for (GeneralProductContractRelationData cr : fakeSellRelations) {
            for (SimpleTax tax : cr.getServiceData().getDetalization().getTaxes()) {
                String uid;
                if (null == tax.getSource() || null == (uid = (String)virt2Orig.get(tax.getSource()))) continue;
                tax.setSource(uid);
            }
            if (cr.getServiceData().getDetalization().getVat() == null) continue;
            for (VatComponent vatComponent : cr.getServiceData().getDetalization().getVat().getComponents()) {
                if (vatComponent.getTaxesUids().isEmpty()) continue;
                ArrayList<String> taxesUids = new ArrayList<String>(vatComponent.getTaxesUids());
                List crTaxes = cr.getServiceData().getDetalization().getTaxes();
                for (int i = 0; i < taxesUids.size(); ++i) {
                    SimpleTax tax;
                    String uid = (String)taxesUids.get(i);
                    if (null == uid || (tax = (SimpleTax)crTaxes.stream().filter(t -> uid.equals(t.getSource())).findFirst().orElse(null)) == null) continue;
                    taxesUids.set(i, tax.getUid());
                }
                vatComponent.getTaxesUids().clear();
                vatComponent.getTaxesUids().addAll(taxesUids);
            }
        }
        GeneralProductHelper.getHandler((BaseProduct)voidProduct).updateContractRelations((BaseProduct)voidProduct, fakeSellRelations);
    }

    private VoidProductVirtualizationHelper() {
    }
}

