/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.rules.hotel;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.Parameter;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.elements.DebugInfo;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.model.handlers.HotelActionSet;
import com.gridnine.xtrip.server.model.handlers.HotelPropertySet;
import com.gridnine.xtrip.server.model.handlers.HotelPropertySetContext;
import com.gridnine.xtrip.server.model.handlers.RulesHandler;
import com.gridnine.xtrip.server.model.handlers.rules.GeneralProductRulesHelper;
import com.gridnine.xtrip.server.model.handlers.rules.RulesCache;
import com.gridnine.xtrip.server.model.handlers.rules.RulesProductHandler;
import com.gridnine.xtrip.server.model.handlers.rules.hotel.HotelRulesHelper;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HotelRulesHandler
implements RulesHandler {
    public static final String ID = "hotels-rules-handler";
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    protected Consumer<HotelProduct> afterCommissionCalculatedConsumer;

    @Override
    public void applyRules(EntityContainer<BookingFile> bookingFileContainer, boolean forced, boolean simulate, List<Message> messages, Map<Parameter, Object> params, DebugInfo debugInfo, boolean calcAppliedRulesToBooking) throws Exception {
        this.applyRules(bookingFileContainer, Collections.emptyMap(), forced, simulate, messages, params, debugInfo, calcAppliedRulesToBooking);
    }

    @Override
    public void applyRules(EntityContainer<BookingFile> bookingContainer, final Map<BaseProduct, RulesCache<?>> rulesCacheMap, boolean forced, boolean simulate, List<Message> messages, Map<Parameter, Object> params, DebugInfo debugInfo, boolean calcAppliedRulesToBooking) throws Exception {
        final HashMap relationsMap = new HashMap();
        final ProductHandler productHandler = HandlersRegistry.get().findProductHandler(HotelProduct.class);
        GeneralProductRulesHelper.applyContracts(bookingContainer, forced, simulate, new RulesProductHandler<HotelProduct, HotelPropertySet, HotelActionSet>(){

            public HotelProvider getProvider(HotelProduct product) {
                return product.getProvider();
            }

            @Override
            public boolean hasRefundCommissions(RuleProxy<HotelPropertySet, HotelActionSet> proxy) {
                return ((HotelActionSet)proxy.getActionSet()).hasRefundCommissions();
            }

            @Override
            public void clearActionSet(RuleProxy<HotelPropertySet, HotelActionSet> proxy, HotelProduct item) {
                proxy.getAppliedRuleCategories().clear();
                proxy.getAppliedRules().clear();
                proxy.getTracer().clear();
                proxy.setActionSet((Object)HotelRulesHandler.this.createActionSet(proxy, item));
            }

            @Override
            public RuleProxy<HotelPropertySet, HotelActionSet> createProxy(HotelProduct item, boolean enabledTracer) throws Exception {
                RuleProxy proxy = new RuleProxy();
                RulesCache rulesCache = (RulesCache)rulesCacheMap.get(item);
                if (rulesCache != null && rulesCache.getPropertySet() != null) {
                    proxy.setPropertySet((Object)((HotelPropertySet)rulesCache.getPropertySet()));
                } else {
                    proxy.setPropertySet((Object)HotelRulesHandler.this.createPropertySet(proxy));
                    ((HotelPropertySet)proxy.getPropertySet()).init(item, HotelRulesHandler.this.createPropertySetContext(item));
                }
                proxy.getTracer().setDisabled(!enabledTracer);
                proxy.setProxyDate(item.getIssueDate());
                proxy.setProxyType(Targets.HOTELS_COMMISSION.getId());
                return proxy;
            }

            @Override
            public EntityReference<Organization> getBlankOwner(HotelProduct item) {
                return null;
            }

            @Override
            public Date getIssueDate(HotelProduct item) {
                return item.getIssueDate();
            }

            @Override
            public Class<HotelProduct> getProductClass() {
                return HotelProduct.class;
            }

            @Override
            public ProductStatus getStatus(HotelProduct item) {
                return HotelRulesHandler.this.getProductStatus(item);
            }

            @Override
            public TicketType getTicketType(HotelProduct item) {
                return item.getTicketType();
            }

            @Override
            public List<ValidationMessage> getValidationMessages(HotelProduct item) {
                return item.getValidationMessages();
            }

            @Override
            public boolean isChecked(HotelProduct item) {
                return item.isChecked();
            }

            @Override
            public boolean isContractRulesApplied(HotelProduct item) {
                return item.isContractRulesApplied();
            }

            @Override
            public void setContractRulesApplied(HotelProduct item, boolean value) {
                item.setContractRulesApplied(value);
            }

            @Override
            public void updateContractRelationsBySalesChain(HotelProduct item) {
            }

            @Override
            public List<GeneralProductContractRelationData> getContractRelations(HotelProduct item) {
                List relations = productHandler.getUnmodifiableContractRelations((BaseProduct)item);
                relationsMap.put(item, relations);
                return relations;
            }

            @Override
            public List<GeneralProductContractRelationData> getPreviousProductContractRelations(HotelProduct item) {
                return item.getPreviousProduct() == null ? null : productHandler.getUnmodifiableContractRelations((BaseProduct)item.getPreviousProduct());
            }

            @Override
            public List<GeneralProductCommission> createCommissions(RuleProxy<HotelPropertySet, HotelActionSet> proxy, HotelProduct item, GeneralProductContractRelationData relation, List<GeneralProductContractRelationData> allRelations, List<GeneralProductContractRelationData> previousProductContractRelations, boolean separateSupplierFees, ExchangeRateData rateData) throws Exception {
                return ((HotelActionSet)proxy.getActionSet()).createCommissions(relation, allRelations, previousProductContractRelations, separateSupplierFees, rateData, new LinkedList<ValidationMessage>());
            }

            @Override
            public List<GeneralProductCommission> createCommissions(RuleProxy<HotelPropertySet, HotelActionSet> proxy, HotelProduct item, GeneralProductContractRelationData relation, List<GeneralProductContractRelationData> allRelations, List<GeneralProductContractRelationData> previousProductContractRelations, boolean translateSupplierFees, boolean separateSupplierFees, ExchangeRateData rateData) throws Exception {
                return ((HotelActionSet)proxy.getActionSet()).createCommissions(relation, allRelations, previousProductContractRelations, translateSupplierFees, separateSupplierFees, rateData, new LinkedList<ValidationMessage>());
            }

            @Override
            public String getPrefferedClientContractNumber(HotelProduct item) {
                return item.getClientContractNumber();
            }

            @Override
            public void afterCommissionCalculated(HotelProduct item) {
                for (GeneralProductContractRelationData relation : (List)relationsMap.get(item)) {
                    HotelProductContractRelationData rel = HotelProductHelper.findContractRelation((List)HotelProductHelper.getContractRelations((HotelProduct)item), (EntityReference)relation.getDescription());
                    rel.getCommissions().clear();
                    rel.getCommissions().addAll(relation.getCommissions());
                    try {
                        XCloneModelHelper.copy((BaseEntity)relation.getGeneralData(), (BaseEntity)rel.getGeneralData(), (boolean)true);
                        XCloneModelHelper.copy((BaseEntity)relation.getServiceData(), (BaseEntity)rel.getServiceData(), (boolean)true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    HotelRulesHelper.fromGeneralFops(relation, rel.getFops());
                }
                if (HotelRulesHandler.this.afterCommissionCalculatedConsumer != null) {
                    HotelRulesHandler.this.afterCommissionCalculatedConsumer.accept(item);
                }
                HotelRulesHandler.this.afterCommissionCalculated(item);
            }

            @Override
            public void applyTravelPolicy(HotelProduct product, GeneralProductContractRelationData contractRelation, boolean traceEnabled) throws Exception {
                HotelRulesHandler.this.applyTravelPolicy(product, contractRelation, (RulesCache)rulesCacheMap.get(product), traceEnabled);
            }

            @Override
            public Set<PaymentType> getAllowedPaymentTypes(HotelActionSet actionSet) {
                return actionSet.getAllowedPaymentTypes();
            }

            @Override
            public EntityReference<Contract> getDefaultContract(HotelProduct product, ContractType contractType) {
                return HotelRulesHandler.this.getDefaultContract(product, contractType);
            }

            @Override
            public List<EntityContainer<Contract>> getContracts(HotelProduct product, ContractType contractType) {
                return Optional.ofNullable(rulesCacheMap.get(product)).map(RulesCache::getContracts).map(contractsMap -> (List)contractsMap.get(contractType)).orElseGet(Collections::emptyList);
            }

            @Override
            public void clearCachedContracts(HotelProduct product, ContractType contractType) {
                Optional.ofNullable(rulesCacheMap.get(product)).map(RulesCache::getContracts).ifPresent(contractsMap -> contractsMap.put(contractType, Collections.emptyList()));
            }

            @Override
            public void clearCachedPropertySet(HotelProduct product) {
                RulesCache rulesCache = (RulesCache)rulesCacheMap.get(product);
                if (rulesCache != null) {
                    rulesCache.setPropertySet(null);
                }
            }
        }, messages, params, debugInfo, calcAppliedRulesToBooking);
    }

    protected ProductStatus getProductStatus(HotelProduct product) {
        return product.getStatus();
    }

    protected void afterCommissionCalculated(HotelProduct product) {
    }

    @Override
    public String getId() {
        return ID;
    }

    public HotelPropertySet createPropertySet(RuleProxy<HotelPropertySet, ?> proxy) {
        return new HotelPropertySet(proxy);
    }

    public HotelPropertySetContext createPropertySetContext(HotelProduct product) {
        return new HotelPropertySetContext(product);
    }

    public HotelActionSet createActionSet(RuleProxy<HotelPropertySet, HotelActionSet> proxy, HotelProduct item) {
        return new HotelActionSet(proxy, (HotelPropertySet)proxy.getPropertySet(), item);
    }

    protected void applyTravelPolicy(HotelProduct product, GeneralProductContractRelationData contractRelation, RulesCache<?> rulesCache, boolean traceEnabled) throws Exception {
    }

    protected EntityReference<Contract> getDefaultContract(HotelProduct product, ContractType contractType) {
        return null;
    }
}

