/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.rules.hotel;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Contractor;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductFop;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductSettings;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.ContractorDescription;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.rules.standard.hotelProductSettings.HotelProductSettingsActionSet;
import com.gridnine.xtrip.common.model.rules.standard.hotelProductSettings.HotelProductSettingsTargets;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.handlers.HotelActionSet;
import com.gridnine.xtrip.server.model.handlers.HotelPropertySet;
import com.gridnine.xtrip.server.model.handlers.HotelPropertySetContext;
import com.gridnine.xtrip.server.model.handlers.RulesHandler;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistry;
import com.gridnine.xtrip.server.model.handlers.rules.GeneralProductRulesHelper;
import com.gridnine.xtrip.server.model.handlers.rules.ProductRelatedOrganizations;
import com.gridnine.xtrip.server.model.handlers.rules.hotel.HotelRulesHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HotelRulesHelper {
    private static final Logger log = LoggerFactory.getLogger(HotelRulesHelper.class);

    private static List<GeneralProductFop> toGeneralFops(List<HotelProductFop> fops) {
        ArrayList<GeneralProductFop> result = new ArrayList<GeneralProductFop>();
        for (HotelProductFop fop : fops) {
            GeneralProductFop item = new GeneralProductFop();
            item.setUid(fop.getUid());
            item.setAgent(fop.getAgent());
            item.setCard(fop.getCard());
            item.setEquivalentAmount(fop.getAmount() != null ? fop.getAmount().getValue() : null);
            item.setOperationDate(fop.getOperationDate());
            item.setPassengerStatus(fop.getPassengerStatus());
            item.setRelatedTicketNumber(fop.getRelatedTicketNumber());
            item.setType(fop.getType());
            item.setPayer(fop.getPayer());
            item.getCommissions().addAll(fop.getCommissions());
            result.add(item);
        }
        return result;
    }

    public static void fromGeneralFops(GeneralProductContractRelationData relation, List<HotelProductFop> fops) {
        ArrayList<HotelProductFop> newFops = new ArrayList<HotelProductFop>();
        for (GeneralProductFop fop : relation.getFops()) {
            HotelProductFop item = (HotelProductFop)CollectionUtil.find(fops, (String)fop.getUid());
            if (item == null) {
                item = new HotelProductFop();
                item.setUid(fop.getUid());
            }
            item.setAgent(fop.getAgent());
            item.setCard(fop.getCard());
            item.setAmount(fop.getEquivalentAmount() != null ? SystemHelper.getMoney((double)fop.getEquivalentAmount().doubleValue(), (String)(relation.getGeneralData().getCurrency() != null ? relation.getGeneralData().getCurrency().getCode() : DictHelper.getLocalCurrency())) : null);
            item.setOperationDate(fop.getOperationDate());
            item.setRelatedTicketNumber(fop.getRelatedTicketNumber());
            item.setType(fop.getType());
            item.setPayer(fop.getPayer());
            item.getCommissions().clear();
            item.getCommissions().addAll(fop.getCommissions());
            newFops.add(item);
        }
        fops.clear();
        fops.addAll(newFops);
    }

    public static <T extends BaseProduct, P, A> Set<PaymentType> getAllowedPaymentTypes(EntityContainer<BookingFile> bookingContainer, List<Message> messages, ContractType filterContractType) {
        HashSet<PaymentType> result = new HashSet<PaymentType>();
        for (Reservation res : ((BookingFile)bookingContainer.getEntity()).getReservations()) {
            for (BaseProduct bp : res.getProducts()) {
                result.addAll(HotelRulesHelper.getAllowedPaymentTypes(bp, messages, filterContractType));
            }
        }
        return result;
    }

    public static Set<PaymentType> getAllowedPaymentTypes(Reservation reservation) {
        return reservation.getProducts().stream().flatMap(p -> HotelRulesHelper.getAllowedPaymentTypes(p, null, null).stream()).collect(Collectors.toSet());
    }

    public static Set<PaymentType> getAllowedPaymentTypes(BaseProduct bp, List<Message> messages, ContractType filterContractType) {
        HashSet<PaymentType> result = new HashSet<PaymentType>();
        if (bp instanceof HotelProduct) {
            HotelProduct product = (HotelProduct)bp;
            try {
                List<EntityContainer<Contract>> contracts = HotelRulesHelper.getContracts(product, filterContractType, messages);
                RuleProxy<HotelPropertySet, HotelActionSet> ruleProxy = HotelRulesHelper.applyContracts(product, contracts, messages);
                return ruleProxy != null ? ((HotelActionSet)ruleProxy.getActionSet()).getAllowedPaymentTypes() : Collections.emptySet();
            }
            catch (Exception e) {
                if (messages != null) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.AirRulesHelper_applyRulesError, (Throwable)e, (Object[])new Object[0]));
                }
                log.error("unable to create proxy", (Throwable)e);
            }
        }
        return result;
    }

    public static RuleProxy<HotelPropertySet, HotelActionSet> applyContracts(HotelProduct product, List<EntityContainer<Contract>> contracts, List<Message> messages) {
        HotelRulesHandler hotelRulesHandler = HotelRulesHelper.getHotelRulesHandler();
        return HotelRulesHelper.applyContracts(product, contracts, hotelRulesHandler.createPropertySetContext(product), hotelRulesHandler, messages);
    }

    public static RuleProxy<HotelPropertySet, HotelActionSet> applyContracts(HotelProduct product, List<EntityContainer<Contract>> contracts, HotelPropertySetContext propertySetContext, HotelRulesHandler hotelRulesHandler, List<Message> messages) {
        if (CollectionUtil.isEmpty(contracts)) {
            return null;
        }
        ArrayList<RuleProxy<HotelPropertySet, HotelActionSet>> proxyList = new ArrayList<RuleProxy<HotelPropertySet, HotelActionSet>>();
        try {
            proxyList.add(HotelRulesHelper.createRuleProxy(product, propertySetContext, hotelRulesHandler));
            for (EntityContainer<Contract> contract : contracts) {
                for (RuleProxy ruleProxy : proxyList) {
                    ruleProxy.setContractType(((Contract)contract.getEntity()).getContractType().name());
                }
                RulesHelper.applyRules(contract, proxyList, (BaseProduct)product);
            }
            return (RuleProxy)proxyList.get(0);
        }
        catch (Exception e) {
            if (messages != null) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.AirRulesHelper_applyRulesError, (Throwable)e, (Object[])new Object[0]));
            }
            log.error("unable to create proxy", (Throwable)e);
            return null;
        }
    }

    public static RuleProxy<HotelPropertySet, HotelActionSet> applyContracts(HotelProduct product, RuleProxy<HotelPropertySet, HotelActionSet> ruleProxy, List<EntityContainer<Contract>> contracts, List<Message> messages) {
        if (CollectionUtil.isEmpty(contracts)) {
            return null;
        }
        ArrayList<RuleProxy<HotelPropertySet, HotelActionSet>> proxyList = new ArrayList<RuleProxy<HotelPropertySet, HotelActionSet>>();
        try {
            proxyList.add(ruleProxy);
            for (EntityContainer<Contract> contract : contracts) {
                for (RuleProxy ruleProxy2 : proxyList) {
                    ruleProxy2.setContractType(((Contract)contract.getEntity()).getContractType().name());
                }
                RulesHelper.applyRules(contract, proxyList, (BaseProduct)product);
            }
            return (RuleProxy)proxyList.get(0);
        }
        catch (Exception e) {
            if (messages != null) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.AirRulesHelper_applyRulesError, (Throwable)e, (Object[])new Object[0]));
            }
            log.error("unable to create proxy", (Throwable)e);
            return null;
        }
    }

    public static List<EntityContainer<Contract>> getContracts(HotelProduct product, ContractType filterContractType, List<Message> messages) {
        List<EntityContainer<Contract>> contracts = HotelRulesHelper.getContracts(product, filterContractType, null, Collections.emptyMap(), null, messages);
        if (contracts.isEmpty()) {
            contracts = HotelRulesHelper.getOldContracts(product, filterContractType, messages);
        }
        return contracts;
    }

    public static <P> List<EntityContainer<Contract>> getContracts(HotelProduct product, ContractType filterContractType, ContractKey contractKey, Map<ContractKey, List<EntityContainer<Contract>>> contractMap, P propertySet, List<Message> messages) {
        ArrayList<EntityContainer<Contract>> result = new ArrayList<EntityContainer<Contract>>();
        ArrayList<ValidationMessage> vm = new ArrayList<ValidationMessage>();
        try {
            ProductRelatedOrganizations organizations = HotelRulesHelper.collectOrganizations(product, vm);
            HotelRulesHelper.addMessages(messages, vm);
            for (HotelProductContractRelationData item : HotelProductHelper.getContractRelations((HotelProduct)product)) {
                EntityContainer<Contract> contract;
                ContractType contractType = GeneralProductHelper.getContractType((EntityReference)item.getDescription());
                if (contractType == ContractType.VENDOR || filterContractType != null && filterContractType != contractType) continue;
                EntityReference<Organization> blankOwner = organizations.blankOwner;
                ContractRelationDescription description = (ContractRelationDescription)EntityStorage.get().resolve(item.getDescription()).getEntity();
                EntityReference supplier = GeneralProductHelper.getContractor((SalesChain)organizations.salesChain, (EntityReference)description.getSupplier());
                EntityReference customer = contractType == ContractType.CLIENT ? organizations.client : GeneralProductHelper.getContractor((SalesChain)organizations.salesChain, (EntityReference)description.getCustomer());
                if (contractKey != null) {
                    contractKey.blankOwner = organizations.blankOwner;
                    contractKey.supplier = supplier;
                    contractKey.customer = customer;
                    contractKey.provider = product.getProvider();
                    contractKey.date = MiscUtil.clearTime((Date)product.getIssueDate());
                    if (contractMap.get(contractKey) != null) {
                        return contractMap.get(contractKey);
                    }
                }
                if ((contract = EntityStorage.get().resolve(item.getGeneralData().getContractData().getManualContract())) == null) {
                    contract = GeneralProductRulesHelper.getContract(contractType, product, blankOwner, (EntityReference<Organization>)supplier, (EntityReference<Organization>)customer, product.getValidationMessages(), product.getIssueDate(), product.getProvider(), propertySet);
                }
                if (contract == null) continue;
                result.add(contract);
                if (contractKey == null) continue;
                contractMap.put(contractKey.clone(), result);
            }
        }
        catch (Exception e) {
            if (messages != null) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.AirRulesHelper_applyRulesError, (Throwable)e, (Object[])new Object[0]));
            }
            log.error("unable to get contracts", (Throwable)e);
            return Collections.emptyList();
        }
        return result;
    }

    public static List<EntityContainer<Contract>> getOldContracts(HotelProduct product, ContractType filterContractType, List<Message> messages) {
        ArrayList<EntityContainer<Contract>> result = new ArrayList<EntityContainer<Contract>>();
        ArrayList<ValidationMessage> vm = new ArrayList<ValidationMessage>();
        try {
            ProductRelatedOrganizations organizations = HotelRulesHelper.collectOrganizations(product, vm);
            HotelRulesHelper.addMessages(messages, vm);
            for (HotelProductContractRelationData item : HotelProductHelper.getContractRelations((HotelProduct)product)) {
                ContractType contractType = GeneralProductHelper.getContractType((EntityReference)item.getDescription());
                if (contractType == ContractType.VENDOR || filterContractType != null && filterContractType != contractType) continue;
                EntityReference<Organization> blankOwner = organizations.blankOwner;
                ContractRelationDescription description = (ContractRelationDescription)EntityStorage.get().resolve(item.getDescription()).getEntity();
                EntityReference supplier = GeneralProductHelper.getContractor((SalesChain)organizations.salesChain, (EntityReference)description.getSupplier());
                EntityReference customer = contractType == ContractType.CLIENT ? organizations.client : GeneralProductHelper.getContractor((SalesChain)organizations.salesChain, (EntityReference)description.getCustomer());
                return (List)HotelRulesHelper.collectOldContracts(contractType, product, blankOwner, (EntityReference<Organization>)supplier, (EntityReference<Organization>)customer, null).getFirst();
            }
        }
        catch (Exception e) {
            if (messages != null) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.AirRulesHelper_applyRulesError, (Throwable)e, (Object[])new Object[0]));
            }
            log.error("unable to get contracts", (Throwable)e);
            return Collections.emptyList();
        }
        return result;
    }

    public static void addMessages(List<Message> messages, List<ValidationMessage> vm) {
        if (messages != null) {
            for (ValidationMessage item : vm) {
                Message msg = new Message();
                msg.setMessage(item.getMessage());
                msg.setType(MessageType.ERROR);
                if (item.getSeverity() == null) {
                    msg.setType(MessageType.MESSAGE);
                } else {
                    switch (item.getSeverity()) {
                        case WARNING: {
                            msg.setType(MessageType.WARNING);
                            break;
                        }
                        case MESSAGE: {
                            msg.setType(MessageType.MESSAGE);
                            break;
                        }
                        default: {
                            msg.setType(MessageType.ERROR);
                        }
                    }
                }
                messages.add(msg);
            }
        }
    }

    public static RuleProxy<HotelPropertySet, HotelActionSet> createRuleProxy(HotelProduct product, HotelPropertySet propertySet, HotelRulesHandler hotelRulesHandler) {
        RuleProxy result = new RuleProxy();
        result.setProxyType(Targets.HOTELS_COMMISSION.getId());
        result.setProxyDate(product.getIssueDate());
        result.setPropertySet((Object)propertySet);
        result.setActionSet((Object)hotelRulesHandler.createActionSet((RuleProxy<HotelPropertySet, HotelActionSet>)result, product));
        return result;
    }

    public static RuleProxy<HotelPropertySet, HotelActionSet> createRuleProxy(HotelProduct product, HotelPropertySetContext propertySetContext, HotelRulesHandler hotelRulesHandler) {
        RuleProxy result = new RuleProxy();
        HotelPropertySet propSet = hotelRulesHandler.createPropertySet(result);
        propSet.init(product, propertySetContext);
        result.setProxyType(Targets.HOTELS_COMMISSION.getId());
        result.setProxyDate(product.getIssueDate());
        result.setPropertySet((Object)propSet);
        result.setActionSet((Object)hotelRulesHandler.createActionSet((RuleProxy<HotelPropertySet, HotelActionSet>)result, product));
        return result;
    }

    public static RuleProxy<HotelPropertySet, HotelProductSettingsActionSet> createHotelProductSettingsRuleProxy(HotelProduct product, HotelPropertySetContext hotelPropertySetContext) {
        RuleProxy result = new RuleProxy();
        HotelPropertySet propSet = HotelRulesHelper.getHotelRulesHandler().createPropertySet(result);
        propSet.init(product, hotelPropertySetContext);
        result.setProxyType(HotelProductSettingsTargets.HOTEL_PRODUCT_SETTINGS.getId());
        result.setProxyDate(product.getIssueDate());
        result.setPropertySet((Object)propSet);
        result.setActionSet((Object)new HotelProductSettingsActionSet());
        return result;
    }

    public static RuleProxy<HotelPropertySet, HotelProductSettingsActionSet> applyHotelProductSettingsRules(HotelProduct product) throws Exception {
        return HotelRulesHelper.applyHotelProductSettingsRules(product, HotelRulesHelper.getHotelRulesHandler().createPropertySetContext(product));
    }

    public static RuleProxy<HotelPropertySet, HotelProductSettingsActionSet> applyHotelProductSettingsRules(HotelProduct product, HotelPropertySetContext hotelPropertySetContext) throws Exception {
        RuleProxy<HotelPropertySet, HotelProductSettingsActionSet> ruleProxy = HotelRulesHelper.createHotelProductSettingsRuleProxy(product, hotelPropertySetContext);
        RuleEngine.applyRules(Collections.singletonList(ruleProxy), (RuleSet)((HotelProductSettings)HotelProductHelper.getSettings().getEntity()).getRuleSet());
        return ruleProxy;
    }

    private static String getProductTitle(HotelProduct product) {
        return HandlersRegistry.get().findProductHandler(HotelProduct.class).generateProductName((BaseProduct)product);
    }

    public static ProductRelatedOrganizations collectOrganizations(HotelProduct product, List<ValidationMessage> messages) {
        String productTitle = HotelRulesHelper.getProductTitle(product);
        EntityReference vendor = product.getBlankOwnerRef();
        if (vendor == null && messages != null) {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_TRY_GET_BLANKOWNER_FROM_VALIDATOR));
        }
        EntityReference supplier = HotelProductHelper.getSupplier((HotelProduct)product);
        EntityReference agencyRef = HotelProductHelper.getAgency((HotelProduct)product);
        if ((supplier == null || agencyRef == null) && messages != null) {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_TRY_GET_AGENCY_FROM_VALIDATOR));
        }
        if (agencyRef == null) {
            agencyRef = product.getReservation().getBookingFile().getAgency();
            if (messages != null) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_TRY_GET_AGENCY_FROM_MAINTAB, (Object[])new Object[]{productTitle}));
            }
        }
        SalesChain salesChain = HotelProductHelper.getSalesChain((HotelProduct)product);
        SalesChain correctedSalesChain = new SalesChain();
        correctedSalesChain.setDescription(salesChain.getDescription());
        correctedSalesChain.getContractors().addAll(salesChain.getContractors());
        for (Contractor item : correctedSalesChain.getContractors()) {
            EntityContainer ctr;
            if (item.getContractor() != null || (ctr = EntityStorage.get().resolve(item.getDescription())) == null) continue;
            if (((ContractorDescription)ctr.getEntity()).getPredefinedType() == PredefinedContractorType.AGENCY) {
                item.setContractor(agencyRef);
                continue;
            }
            if (((ContractorDescription)ctr.getEntity()).getPredefinedType() != PredefinedContractorType.AGENCY) continue;
            item.setContractor(supplier);
        }
        return new ProductRelatedOrganizations((EntityReference<Organization>)vendor, (EntityReference<Organization>)product.getReservation().getBookingFile().getCustomerProfile(), salesChain);
    }

    private static <T extends BaseProduct> MiscUtil.Pair<List<EntityContainer<Contract>>, List<ContractCustomerInfo>> collectOldContracts(final ContractType contractType, HotelProduct product, EntityReference<Organization> blankOwner, EntityReference<Organization> supplier, EntityReference<Organization> customer, HotelProvider provider) {
        Date date;
        String productTitle = HotelRulesHelper.getProductTitle(product);
        List messages = product.getValidationMessages();
        List emptyList = Collections.emptyList();
        if (customer == null) {
            switch (contractType) {
                case VENDOR: {
                    messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_VENDOR_CONTRACT_DIDNT_APPIED_AGENCY_NOT_DEFINED, (Object[])new Object[]{productTitle}));
                    break;
                }
                case SUBAGENCY: {
                    messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_SUBAGENCY_CONTRACT_DIDNT_APPIED_SUBAGENCY_NOT_DEFINED, (Object[])new Object[]{productTitle}));
                    break;
                }
                case CLIENT: {
                    messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_CLIENT_CONTRACT_DIDNT_APPIED_CUSTOMER_NOT_DEFINED, (Object[])new Object[]{productTitle}));
                    break;
                }
            }
            return new MiscUtil.Pair(emptyList, null);
        }
        EntityReference<Organization> correctedSupplier = supplier;
        final EntityReference allAgenciesProfile = ProfileDao.findAllAgenciesProfile();
        if (supplier == null && contractType == ContractType.VENDOR && null == provider) {
            if (blankOwner == null) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_NO_VENDOR_AND_BLANKOWNER, (Object[])new Object[]{productTitle}));
                return new MiscUtil.Pair(emptyList, null);
            }
            correctedSupplier = blankOwner;
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_NO_VENDOR_TRY_BLANKOWNER, (Object[])new Object[]{productTitle, correctedSupplier}));
        }
        final EntityReference allClientsProfile = ProfileDao.findAllClientsProfile();
        HashSet<EntityReference<Organization>> suppliers = new HashSet<EntityReference<Organization>>();
        HashSet<EntityReference<Organization>> customers = new HashSet<EntityReference<Organization>>();
        suppliers.add(correctedSupplier);
        customers.add(customer);
        if (allAgenciesProfile != null) {
            switch (contractType) {
                case VENDOR: {
                    customers.add(allAgenciesProfile);
                    break;
                }
                case SUBAGENCY: {
                    customers.add(allAgenciesProfile);
                    suppliers.add(allAgenciesProfile);
                    break;
                }
                case CLIENT: {
                    suppliers.add(allAgenciesProfile);
                }
            }
        }
        if (allClientsProfile != null && contractType == ContractType.CLIENT) {
            customers.add(allClientsProfile);
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.newModel.name(), null), SearchCriterion.eq((String)ContractIndex.Property.newModel.name(), (Object)false)}));
        if (null == provider) {
            query.getCriteria().getCriterions().add(HotelRulesHelper.toCriterion(ContractCustomerIndex.Property.supplier.name(), suppliers));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{HotelRulesHelper.toCriterion(ContractCustomerIndex.Property.supplier.name(), suppliers), SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), null)}));
        }
        query.getCriteria().getCriterions().add(HotelRulesHelper.toCriterion(ContractCustomerIndex.Property.customer.name(), customers));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.contractType.name(), (Object)contractType));
        if (blankOwner != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.vendor.name(), blankOwner), SearchCriterion.eq((String)ContractCustomerIndex.Property.vendor.name(), null)}));
        }
        if (provider != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.provider.name(), (Object)provider), SearchCriterion.eq((String)ContractCustomerIndex.Property.provider.name(), null)}));
        }
        if ((date = product.getIssueDate()) != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractCustomerIndex.Property.startDate.name(), (Object)MiscUtil.setDayEndTime((Date)date))}));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractCustomerIndex.Property.endDate.name(), (Object)MiscUtil.clearTime((Date)date))}));
        }
        final HashMap<EntityReference, EntityContainer> contractsMap = new HashMap<EntityReference, EntityContainer>();
        ArrayList<ContractCustomerIndex> contractIndexes = new ArrayList<ContractCustomerIndex>(EntityStorage.get().search(ContractCustomerIndex.class, query).getData());
        for (ContractCustomerIndex item : contractIndexes) {
            contractsMap.put(item.getSource(), EntityStorage.get().resolve(item.getSource()));
        }
        final String preferedClientContractNumber = product.getClientContractNumber();
        contractIndexes.sort(new Comparator<ContractCustomerIndex>(){

            @Override
            public int compare(ContractCustomerIndex o1, ContractCustomerIndex o2) {
                int index2;
                boolean idx2;
                boolean idx1;
                if (contractType == ContractType.CLIENT && !TextUtil.isBlank((String)preferedClientContractNumber) && (idx1 = preferedClientContractNumber.equals(o1.getNumber())) != (idx2 = preferedClientContractNumber.equals(o2.getNumber()))) {
                    return idx1 ? -1 : 1;
                }
                EntityContainer ctr1 = (EntityContainer)contractsMap.get(o1.getSource());
                EntityContainer ctr2 = (EntityContainer)contractsMap.get(o2.getSource());
                if (((Contract)ctr1.getEntity()).getPriority() != ((Contract)ctr2.getEntity()).getPriority()) {
                    return ((Contract)ctr1.getEntity()).getPriority() > ((Contract)ctr2.getEntity()).getPriority() ? -1 : 1;
                }
                int index1 = this.getGeneralityIndex(o1);
                if (index1 != (index2 = this.getGeneralityIndex(o2))) {
                    return index1 > index2 ? 1 : -1;
                }
                if (((Contract)ctr1.getEntity()).isTypicalContract() != ((Contract)ctr2.getEntity()).isTypicalContract()) {
                    return ((Contract)ctr1.getEntity()).isTypicalContract() ? 1 : -1;
                }
                return -MiscUtil.compare((Date)o1.getIssueDate(), (Date)o2.getIssueDate(), (boolean)true);
            }

            private int getGeneralityIndex(ContractCustomerIndex o1) {
                return (allAgenciesProfile != null && allAgenciesProfile.equals((Object)o1.getSupplier()) ? 4 : 0) + (allAgenciesProfile != null && allAgenciesProfile.equals((Object)o1.getCustomer()) ? 2 : 0) + (allClientsProfile != null && allClientsProfile.equals((Object)o1.getCustomer()) ? 1 : 0);
            }
        });
        ArrayList<EntityContainer> result = new ArrayList<EntityContainer>();
        ArrayList<ContractCustomerInfo> customerInfos = new ArrayList<ContractCustomerInfo>();
        for (ContractCustomerIndex index : contractIndexes) {
            EntityContainer ctr = (EntityContainer)contractsMap.get(index.getSource());
            if (!result.contains(ctr)) {
                result.add(ctr);
            }
            if (TextUtil.isBlank((String)index.getNumber())) continue;
            for (ContractCustomerInfo info : ((Contract)ctr.getEntity()).getCustomers()) {
                if (!info.getUid().equals(index.getNavigationKey())) continue;
                customerInfos.add(info);
            }
        }
        return new MiscUtil.Pair(result, customerInfos);
    }

    private static SearchCriterion toCriterion(String propertyName, Set<EntityReference<Organization>> suppliers) {
        if (suppliers.size() == 1) {
            return SearchCriterion.eq((String)propertyName, suppliers.iterator().next());
        }
        ArrayList<SearchCriterion> crits = new ArrayList<SearchCriterion>();
        for (EntityReference<Organization> item : suppliers) {
            crits.add(SearchCriterion.eq((String)propertyName, item));
        }
        return SearchCriterion.or((SearchCriterion[])crits.toArray(new SearchCriterion[crits.size()]));
    }

    public static HotelRulesHandler getHotelRulesHandler() {
        HotelRulesHandler hotelRulesHandler = null;
        for (RulesHandler rulesHandler : ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).getAllRulesHandlers()) {
            if (!"hotels-rules-handler".equals(rulesHandler.getId())) continue;
            hotelRulesHandler = (HotelRulesHandler)rulesHandler;
            break;
        }
        if (hotelRulesHandler == null) {
            throw Xeption.forDeveloper((String)"illegal state: no hotel rule handler registered, but hotel code called", (Object[])new Object[0]);
        }
        return hotelRulesHandler;
    }

    public static class ContractKey {
        private EntityReference<Organization> blankOwner;
        private EntityReference<Organization> supplier;
        private EntityReference<Organization> customer;
        private HotelProvider provider;
        private Date date;

        public ContractKey clone() {
            ContractKey result = new ContractKey();
            result.blankOwner = this.blankOwner;
            result.supplier = this.supplier;
            result.customer = this.customer;
            result.provider = this.provider;
            result.date = this.date;
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContractKey that = (ContractKey)o;
            return Objects.equals(this.blankOwner, that.blankOwner) && Objects.equals(this.supplier, that.supplier) && Objects.equals(this.customer, that.customer) && this.provider == that.provider && Objects.equals(this.date, that.date);
        }

        public int hashCode() {
            return Objects.hash(this.blankOwner, this.supplier, this.customer, this.provider, this.date);
        }
    }
}

