/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.standard;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.util.ObjectFactory;
import com.gridnine.xtrip.server.model.export.FileConnectionHandler;
import com.gridnine.xtrip.server.model.export.FtpConnectionHandler;
import com.gridnine.xtrip.server.model.export.HttpConnectionHandler;
import com.gridnine.xtrip.server.model.export.SftpConnectionHandler;
import com.gridnine.xtrip.server.model.export.standard.booking.BookingXmlExportHandler;
import com.gridnine.xtrip.server.model.export.standard.booking.RelatedDocumentsExportHandler;
import com.gridnine.xtrip.server.model.export.standard.finance.FinanceDocumentXmlExportHandler;
import com.gridnine.xtrip.server.model.export.standard.finance.ShipmentXmlExportHandler;
import com.gridnine.xtrip.server.model.export.standard.finance.TemplateBasedShipmentExportHandler;
import com.gridnine.xtrip.server.model.export.standard.organization.OrganizationXmlExportHandler;
import com.gridnine.xtrip.server.model.export.standard.person.PersonXmlExportHandler;
import com.gridnine.xtrip.server.model.export.standard.transaction.TransactionXmlExportHandler;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistry;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistryConfigurator;
import com.gridnine.xtrip.server.model.handlers.delete.DebitOrderDeleteHandler;
import com.gridnine.xtrip.server.model.handlers.delete.FinanceDocumentDeleteHandler;
import com.gridnine.xtrip.server.model.handlers.delete.ShipmentDeleteHandler;
import com.gridnine.xtrip.server.model.handlers.finance.AeroexpressTicketBillingTransactionHandler;
import com.gridnine.xtrip.server.model.handlers.finance.AgencyMemoProductBillingTransactionHandler;
import com.gridnine.xtrip.server.model.handlers.finance.AirProductBillingTransactionHandler;
import com.gridnine.xtrip.server.model.handlers.finance.CarRentalProductBillingTransactionHandler;
import com.gridnine.xtrip.server.model.handlers.finance.CreditBankTransferOrderBillingTransactionHandler;
import com.gridnine.xtrip.server.model.handlers.finance.CreditSlipBillingTransactionHandler;
import com.gridnine.xtrip.server.model.handlers.finance.DebitBankTransferOrderBillingTransactionHandler;
import com.gridnine.xtrip.server.model.handlers.finance.DebitSlipBillingTransactionHandler;
import com.gridnine.xtrip.server.model.handlers.finance.DeliveryBillingTransactionHandler;
import com.gridnine.xtrip.server.model.handlers.finance.HotelProductBillingTransactionHandler;
import com.gridnine.xtrip.server.model.handlers.finance.InsuranceAccidentBillingTransactionHandler;
import com.gridnine.xtrip.server.model.handlers.finance.InsuranceTouristicBillingTransactionHandler;
import com.gridnine.xtrip.server.model.handlers.finance.ProductBillingTransactionsHandler;
import com.gridnine.xtrip.server.model.handlers.finance.ProductVoidingBillingTransactionHandler;
import com.gridnine.xtrip.server.model.handlers.finance.TransferBillingTransactionHandler;
import com.gridnine.xtrip.server.model.handlers.finance.UniversalProductBillingTransactionHandler;
import com.gridnine.xtrip.server.model.handlers.finance.VisaProductBillingTransactionHandler;
import com.gridnine.xtrip.server.model.handlers.index.StandardCommonProductIndexHandler;
import com.gridnine.xtrip.server.model.handlers.productReferences.FinanceDocumentsProductReferencesHandler;
import com.gridnine.xtrip.server.model.handlers.productReferences.ReceiptsProductReferencesHandler;
import com.gridnine.xtrip.server.model.handlers.proxy.AeroexpressTicketCommissionProxyHandler;
import com.gridnine.xtrip.server.model.handlers.proxy.AirProductCommissionProxyHandler;
import com.gridnine.xtrip.server.model.handlers.proxy.CarRentalProductCommissionProxyHandler;
import com.gridnine.xtrip.server.model.handlers.proxy.DeliveryCommissionProxyHandler;
import com.gridnine.xtrip.server.model.handlers.proxy.HotelCommissionProxyHandler;
import com.gridnine.xtrip.server.model.handlers.proxy.InsuranceAccidentCommissionProxyHandler;
import com.gridnine.xtrip.server.model.handlers.proxy.InsuranceTouristicCommissionProxyHandler;
import com.gridnine.xtrip.server.model.handlers.proxy.TransferCommissionProxyHandler;
import com.gridnine.xtrip.server.model.handlers.proxy.UniversalProductCommissionProxyHandler;
import com.gridnine.xtrip.server.model.handlers.proxy.VisaProductCommissionProxyHandler;
import com.gridnine.xtrip.server.model.handlers.rules.AdditionalServiceProductRulesHandler;
import com.gridnine.xtrip.server.model.handlers.rules.AeroexpressTicketRulesHandler;
import com.gridnine.xtrip.server.model.handlers.rules.AgentTouchProductRulesHandler;
import com.gridnine.xtrip.server.model.handlers.rules.AirProductRulesHandler;
import com.gridnine.xtrip.server.model.handlers.rules.CarRentalProductRulesHandler;
import com.gridnine.xtrip.server.model.handlers.rules.DeliveryRulesHandler;
import com.gridnine.xtrip.server.model.handlers.rules.InsuranceAccidentRulesHandler;
import com.gridnine.xtrip.server.model.handlers.rules.InsuranceTouristicRulesHandler;
import com.gridnine.xtrip.server.model.handlers.rules.TaxiProductRulesHandler;
import com.gridnine.xtrip.server.model.handlers.rules.TransferRulesHandler;
import com.gridnine.xtrip.server.model.handlers.rules.UniversalProductRulesHandler;
import com.gridnine.xtrip.server.model.handlers.rules.VisaProductRulesHandler;
import com.gridnine.xtrip.server.model.handlers.rules.hotel.HotelRulesHandler;
import com.gridnine.xtrip.server.model.handlers.stockcontrol.AeroexpressTicketStockControlHandler;
import com.gridnine.xtrip.server.model.handlers.stockcontrol.AirTicketStockControlHandler;
import com.gridnine.xtrip.server.model.handlers.stockcontrol.InsuranceAccidentStockControlHandler;
import com.gridnine.xtrip.server.model.handlers.stockcontrol.InsuranceTouristicStockControlHandler;
import com.gridnine.xtrip.server.model.handlers.stockcontrol.MCOFeesStockControlHandler;
import com.gridnine.xtrip.server.model.handlers.stockcontrol.UniversalProductStockControlHandler;
import com.gridnine.xtrip.server.model.handlers.validation.AdditionalServiceProductValidationHandler;
import com.gridnine.xtrip.server.model.handlers.validation.AeroexpressTicketValidationHandler;
import com.gridnine.xtrip.server.model.handlers.validation.AgencyMemoProductValidationHandler;
import com.gridnine.xtrip.server.model.handlers.validation.AirProductValidationHandler;
import com.gridnine.xtrip.server.model.handlers.validation.CarRentalProductValidationHandler;
import com.gridnine.xtrip.server.model.handlers.validation.DeliveryValidationHandler;
import com.gridnine.xtrip.server.model.handlers.validation.InsuranceAccidentValidationHandler;
import com.gridnine.xtrip.server.model.handlers.validation.InsuranceTouristicValidationHandler;
import com.gridnine.xtrip.server.model.handlers.validation.MCOFeesValidationHandler;
import com.gridnine.xtrip.server.model.handlers.validation.TaxiProductValidationHandler;
import com.gridnine.xtrip.server.model.handlers.validation.TransferValidationHandler;
import com.gridnine.xtrip.server.model.handlers.validation.UniversalProductValidationHandler;
import com.gridnine.xtrip.server.model.handlers.validation.VisaProductValidationHandler;
import com.gridnine.xtrip.server.model.handlers.validation.XtripHotelProductValidationHandler;
import com.gridnine.xtrip.server.model.helpers.fopDetalization.StandardNomenclatureRulesHandlersRegistrator;
import com.gridnine.xtrip.server.model.tasks.standard.handlers.FinanceDocumentSettingsBillingItemsSettingsUpdateTaskProcessHandler;
import org.slf4j.LoggerFactory;

public class StandardServerHandlersRegistryConfigurator
implements ServerHandlersRegistryConfigurator {
    @Override
    public void configure(ServerHandlersRegistry registry) {
        registry.registerTaskProcessHandler(new FinanceDocumentSettingsBillingItemsSettingsUpdateTaskProcessHandler());
        registry.registerProductBillingTransactionHandler(StandardServerHandlersRegistryConfigurator.createProductBillingTransactionHandler("air-product-billing-transaction-handler.className", new ObjectFactory<ProductBillingTransactionsHandler<Product>>(){

            public ProductBillingTransactionsHandler<Product> createObject() {
                return new AirProductBillingTransactionHandler();
            }
        }));
        registry.registerProductBillingTransactionHandler(new AeroexpressTicketBillingTransactionHandler());
        registry.registerProductBillingTransactionHandler(new CarRentalProductBillingTransactionHandler());
        registry.registerProductBillingTransactionHandler(new TransferBillingTransactionHandler());
        registry.registerProductBillingTransactionHandler(new DeliveryBillingTransactionHandler());
        registry.registerProductBillingTransactionHandler(new InsuranceAccidentBillingTransactionHandler());
        registry.registerProductBillingTransactionHandler(new InsuranceTouristicBillingTransactionHandler());
        registry.registerProductBillingTransactionHandler(new UniversalProductBillingTransactionHandler());
        registry.registerProductBillingTransactionHandler(new ProductVoidingBillingTransactionHandler());
        registry.registerProductBillingTransactionHandler(StandardServerHandlersRegistryConfigurator.createProductBillingTransactionHandler("hotel-product-billing-transaction-handler.className", new ObjectFactory<ProductBillingTransactionsHandler<HotelProduct>>(){

            public ProductBillingTransactionsHandler<HotelProduct> createObject() {
                return new HotelProductBillingTransactionHandler();
            }
        }));
        registry.registerProductBillingTransactionHandler(new VisaProductBillingTransactionHandler());
        registry.registerProductBillingTransactionHandler(new AgencyMemoProductBillingTransactionHandler());
        StandardNomenclatureRulesHandlersRegistrator.registerStandardNomenclatureRulesHandlers(registry);
        registry.registerPaymentDocumentBillingTransactionHandler(new CreditBankTransferOrderBillingTransactionHandler());
        registry.registerPaymentDocumentBillingTransactionHandler(new DebitBankTransferOrderBillingTransactionHandler());
        registry.registerPaymentDocumentBillingTransactionHandler(new DebitSlipBillingTransactionHandler());
        registry.registerPaymentDocumentBillingTransactionHandler(new CreditSlipBillingTransactionHandler());
        registry.registerRulesHandler(new AirProductRulesHandler());
        registry.registerRulesHandler(new AeroexpressTicketRulesHandler());
        registry.registerRulesHandler(new DeliveryRulesHandler());
        registry.registerRulesHandler(new InsuranceAccidentRulesHandler());
        registry.registerRulesHandler(new InsuranceTouristicRulesHandler());
        registry.registerRulesHandler(new UniversalProductRulesHandler());
        registry.registerRulesHandler(new HotelRulesHandler());
        registry.registerRulesHandler(new CarRentalProductRulesHandler());
        registry.registerRulesHandler(new VisaProductRulesHandler());
        registry.registerRulesHandler(new AdditionalServiceProductRulesHandler());
        registry.registerRulesHandler(new AgentTouchProductRulesHandler());
        registry.registerRulesHandler(new TransferRulesHandler());
        registry.registerRulesHandler(new TaxiProductRulesHandler());
        registry.registerStockControlHandler(new AirTicketStockControlHandler());
        registry.registerStockControlHandler(new AeroexpressTicketStockControlHandler());
        registry.registerStockControlHandler(new MCOFeesStockControlHandler());
        registry.registerStockControlHandler(new InsuranceAccidentStockControlHandler());
        registry.registerStockControlHandler(new InsuranceTouristicStockControlHandler());
        registry.registerStockControlHandler(new UniversalProductStockControlHandler());
        registry.registerConnectiontHandler(new FtpConnectionHandler());
        registry.registerConnectiontHandler(new SftpConnectionHandler());
        registry.registerConnectiontHandler(new HttpConnectionHandler());
        registry.registerConnectiontHandler(new FileConnectionHandler());
        registry.register(new AeroexpressTicketValidationHandler());
        registry.register(new AgencyMemoProductValidationHandler());
        registry.register(new AirProductValidationHandler());
        registry.register(new DeliveryValidationHandler());
        registry.register(new InsuranceAccidentValidationHandler());
        registry.register(new InsuranceTouristicValidationHandler());
        registry.register(new MCOFeesValidationHandler());
        registry.register(new UniversalProductValidationHandler());
        registry.register(new XtripHotelProductValidationHandler());
        registry.register(new VisaProductValidationHandler());
        registry.register(new AdditionalServiceProductValidationHandler());
        registry.register(new CarRentalProductValidationHandler());
        registry.register(new TransferValidationHandler());
        registry.register(new TaxiProductValidationHandler());
        registry.register(new AeroexpressTicketCommissionProxyHandler());
        registry.register(new AirProductCommissionProxyHandler());
        registry.register(new CarRentalProductCommissionProxyHandler());
        registry.register(new TransferCommissionProxyHandler());
        registry.register(new DeliveryCommissionProxyHandler());
        registry.register(new HotelCommissionProxyHandler());
        registry.register(new InsuranceAccidentCommissionProxyHandler());
        registry.register(new InsuranceTouristicCommissionProxyHandler());
        registry.register(new VisaProductCommissionProxyHandler());
        registry.register(new UniversalProductCommissionProxyHandler());
        registry.registerExportHandler(new BookingXmlExportHandler());
        registry.registerExportHandler(new OrganizationXmlExportHandler());
        registry.registerExportHandler(new PersonXmlExportHandler());
        registry.registerExportHandler(new TransactionXmlExportHandler());
        registry.registerExportHandler(new FinanceDocumentXmlExportHandler());
        registry.registerExportHandler(new ShipmentXmlExportHandler());
        registry.registerExportHandler(new RelatedDocumentsExportHandler());
        registry.registerExportHandler(new TemplateBasedShipmentExportHandler());
        registry.register(new ShipmentDeleteHandler());
        registry.register(new FinanceDocumentDeleteHandler());
        registry.register(new DebitOrderDeleteHandler());
        registry.register(new FinanceDocumentsProductReferencesHandler());
        registry.register(new ReceiptsProductReferencesHandler());
        registry.registerCommonIndexHandler(new StandardCommonProductIndexHandler());
    }

    public static <P extends BaseProduct, H extends ProductBillingTransactionsHandler<P>> H createProductBillingTransactionHandler(String key, ObjectFactory<H> objectFactory) {
        String clsName = System.getProperty(key);
        if (clsName == null) {
            return (H)((ProductBillingTransactionsHandler)objectFactory.createObject());
        }
        try {
            return (H)((ProductBillingTransactionsHandler)StandardServerHandlersRegistryConfigurator.class.getClassLoader().loadClass(clsName).newInstance());
        }
        catch (Exception e) {
            LoggerFactory.getLogger(StandardServerHandlersRegistryConfigurator.class).error("unable to load class " + clsName, (Throwable)e);
            return (H)((ProductBillingTransactionsHandler)objectFactory.createObject());
        }
    }
}

