/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.stockcontrol;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicketIndex;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AeroexpressTicketHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.handlers.stockcontrol.StockControlProductHandler;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class AeroexpressTicketStockControlHandler
implements StockControlProductHandler<AeroexpressTicket, AeroexpressTicketIndex, GeneralProductFop> {
    @Override
    public Class<AeroexpressTicket> getProductClass() {
        return AeroexpressTicket.class;
    }

    @Override
    public List<ValidationMessage> getValidationMessages(AeroexpressTicket product) {
        return product.getValidationMessages();
    }

    @Override
    public List<String> getSCNs(AeroexpressTicket product) {
        return TextUtil.isBlank((String)product.getScn()) ? new ArrayList() : Collections.singletonList(product.getScn());
    }

    @Override
    public ProductStatus getStatus(AeroexpressTicket product) {
        return product.getStatus();
    }

    @Override
    public AeroexpressTicket getPreviousProduct(AeroexpressTicket product) {
        return product.getPreviousProduct();
    }

    @Override
    public AeroexpressTicket getNextProduct(AeroexpressTicket product) {
        return product.getNextProduct();
    }

    @Override
    public TicketType getTicketType(AeroexpressTicket product) {
        return product.getTicketType();
    }

    @Override
    public Class<AeroexpressTicketIndex> getProductIndexClass() {
        return AeroexpressTicketIndex.class;
    }

    @Override
    public String getStatusIndexPropertyName() {
        return AeroexpressTicketIndex.Property.status.name();
    }

    @Override
    public String getSCNIndexPropertyName() {
        return AeroexpressTicketIndex.Property.scn.name();
    }

    @Override
    public String getTicketTypeIndexPropertyName() {
        return AeroexpressTicketIndex.Property.ticketType.name();
    }

    @Override
    public EntityReference<Organization> getBlankOwner(AeroexpressTicket product) {
        return product.getBlankOwner();
    }

    @Override
    public EntityReference<Organization> getSubagency(AeroexpressTicket product) {
        return AeroexpressTicketHelper.getSubagency((AeroexpressTicket)product);
    }

    @Override
    public EntityReference<Person> getAgent(AeroexpressTicket product) {
        return product.getAgent();
    }

    @Override
    public String getPCC(AeroexpressTicket product) {
        return product.getPcc();
    }

    @Override
    public String getValidator(AeroexpressTicket product) {
        return null;
    }

    @Override
    public String getSystemNumber(AeroexpressTicket product) {
        return product.getSystemNumber();
    }

    @Override
    public TariffType getTariffType(AeroexpressTicket product) {
        return TariffType.REGULAR;
    }

    @Override
    public List<GeneralProductFop> getVendorFops(AeroexpressTicket product) {
        return AeroexpressTicketHelper.getVendorFops((AeroexpressTicket)product);
    }

    @Override
    public Date getOperationDate(GeneralProductFop fop) {
        return fop.getOperationDate();
    }

    @Override
    public Date getIssueDate(AeroexpressTicket product) {
        return product.getIssueDate();
    }

    @Override
    public int getConjCount(AeroexpressTicket product) {
        return 0;
    }

    @Override
    public Traveller getTraveller(AeroexpressTicket product) {
        return product.getTraveller();
    }

    @Override
    public ProductSearchResult findProductByScnAndDate(String scn, Date issueDate, long threshold, ProductStatus status) throws Exception {
        List data;
        SearchQuery query = new SearchQuery();
        if (status != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AeroexpressTicketIndex.Property.status.name(), (Object)status));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)AeroexpressTicketIndex.Property.ticketType.name(), (Object)TicketType.OWN), SearchCriterion.eq((String)AeroexpressTicketIndex.Property.ticketType.name(), null)}));
        if (!TextUtil.isBlank((String)scn)) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AeroexpressTicketIndex.Property.scn.name(), (Object)scn));
        }
        if (issueDate != null) {
            Date lowerLim = new Date(issueDate.getTime() - threshold);
            Date upperLim = new Date(issueDate.getTime() + threshold);
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)AeroexpressTicketIndex.Property.issueDate.name(), (Object)lowerLim));
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)AeroexpressTicketIndex.Property.issueDate.name(), (Object)upperLim));
        }
        if ((data = EntityStorage.get().search(AeroexpressTicketIndex.class, query).getData()).isEmpty()) {
            return null;
        }
        AeroexpressTicketIndex idx = (AeroexpressTicketIndex)data.get(0);
        EntityContainer bfCtr = EntityStorage.get().resolve(idx.getSource());
        BookingFile booking = (BookingFile)bfCtr.getEntity();
        BaseProduct bp = BookingHelper.findProduct((BookingFile)booking, (String)idx.getNavigationKey());
        return new ProductSearchResult(booking, bp, bp.getReservation(), (EntityContainer<BookingFile>)bfCtr, data.size() == 1);
    }

    @Override
    public int getEticketCount(EntityReference<Organization> blankOwner, EntityReference<Organization> agency, EntityReference<Organization> subagency, EntityReference<SalesPoint> salesPoint, Set<GdsName> gdsNames, DictionaryReference<BlankType> blankType, boolean countVoid) throws Exception {
        return 0;
    }

    @Override
    public EntityReference<SalesPoint> getSalesPoint(AeroexpressTicket product) {
        return product.getSalesPoint();
    }

    @Override
    public String getIssueDateIndexPropertyName() {
        return AeroexpressTicketIndex.Property.issueDate.name();
    }

    @Override
    public List<SearchCriterion> getProductIndexAdditionalCriterions(AeroexpressTicket product) {
        return Collections.emptyList();
    }
}

