/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.stockcontrol;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductSearchIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.model.handlers.stockcontrol.StockControlProductHandler;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class AirTicketStockControlHandler
implements StockControlProductHandler<Product, ProductSearchIndex, ProductFop> {
    @Override
    public Class<Product> getProductClass() {
        return Product.class;
    }

    @Override
    public List<ValidationMessage> getValidationMessages(Product product) {
        return product.getValidationMessages();
    }

    @Override
    public List<String> getSCNs(Product product) {
        return product.getScns();
    }

    @Override
    public ProductStatus getStatus(Product product) {
        return product.getStatus();
    }

    @Override
    public Product getPreviousProduct(Product product) {
        return product.getPreviousProduct();
    }

    @Override
    public Product getNextProduct(Product product) {
        return product.getNextProduct();
    }

    @Override
    public TicketType getTicketType(Product product) {
        return product.getTicketType();
    }

    @Override
    public Class<ProductSearchIndex> getProductIndexClass() {
        return ProductSearchIndex.class;
    }

    @Override
    public String getStatusIndexPropertyName() {
        return ProductSearchIndex.Property.status.name();
    }

    @Override
    public String getSCNIndexPropertyName() {
        return ProductSearchIndex.Property.scn.name();
    }

    @Override
    public String getTicketTypeIndexPropertyName() {
        return ProductSearchIndex.Property.ticketType.name();
    }

    @Override
    public EntityReference<Organization> getBlankOwner(Product product) {
        return product.getBlankOwnerRef();
    }

    @Override
    public EntityReference<Organization> getSubagency(Product product) {
        return AirProductHelper.getSubagency((Product)product);
    }

    @Override
    public EntityReference<Person> getAgent(Product product) {
        return product.getCashier();
    }

    @Override
    public String getPCC(Product product) {
        return product.getPcc();
    }

    @Override
    public String getValidator(Product product) {
        return product.getValidatorCode();
    }

    @Override
    public String getSystemNumber(Product product) {
        return product.getSystemNumber();
    }

    @Override
    public TariffType getTariffType(Product product) {
        return product.getTariffType();
    }

    @Override
    public List<ProductFop> getVendorFops(Product product) {
        return AirProductHelper.getVendorContractRelation((Product)product).getFops();
    }

    @Override
    public Date getOperationDate(ProductFop fop) {
        return fop.getOperationDate();
    }

    @Override
    public Date getIssueDate(Product product) {
        return product.getIssueDate();
    }

    @Override
    public int getConjCount(Product product) {
        return product.getConjCount();
    }

    @Override
    public Traveller getTraveller(Product product) {
        return product.getTraveller();
    }

    @Override
    public ProductSearchResult findProductByScnAndDate(String scn, Date date, long treshold, ProductStatus status) throws Exception {
        return BookingDao.findProductByScnAndDate(scn, date, treshold, status);
    }

    @Override
    public int getEticketCount(EntityReference<Organization> blankOwner, EntityReference<Organization> agency, EntityReference<Organization> subagency, EntityReference<SalesPoint> salesPoint, Set<GdsName> gdsNames, DictionaryReference<BlankType> blankType, boolean countVoid) throws Exception {
        SearchQuery query = new SearchQuery();
        query.setResultMode(ResultMode.COUNT_ONLY);
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), null), SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), (Object)TicketType.OWN)}));
        if (countVoid) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductIndex.Property.status.name(), (Object)ProductStatus.SELL), SearchCriterion.eq((String)ProductIndex.Property.status.name(), (Object)ProductStatus.VOID)}));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.status.name(), (Object)ProductStatus.SELL));
        }
        if (blankOwner != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.blankOwner.name(), blankOwner));
        }
        if (agency != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.agency.name(), agency));
        }
        if (subagency != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.subagency.name(), subagency));
        }
        if (salesPoint != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.salesPoint.name(), salesPoint));
        }
        if (gdsNames != null) {
            ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
            for (GdsName gdsName : gdsNames) {
                criterions.add(SearchQueryHelper.getGdsNameSearchCriterionForProductIndex((GdsName)gdsName));
            }
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
        }
        if (blankType != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.blankType.name(), blankType));
        }
        return EntityStorage.get().search(ProductIndex.class, query).getTotalCount();
    }

    @Override
    public EntityReference<SalesPoint> getSalesPoint(Product product) {
        return product.getSalesPoint();
    }

    @Override
    public String getIssueDateIndexPropertyName() {
        return ProductIndex.Property.issueDate.name();
    }

    @Override
    public List<SearchCriterion> getProductIndexAdditionalCriterions(Product product) {
        return Collections.emptyList();
    }
}

