/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.stockcontrol;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentHelper;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentIndex;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.handlers.stockcontrol.StockControlProductHandler;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class InsuranceAccidentStockControlHandler
implements StockControlProductHandler<InsuranceAccident, InsuranceAccidentIndex, GeneralProductFop> {
    @Override
    public Class<InsuranceAccident> getProductClass() {
        return InsuranceAccident.class;
    }

    @Override
    public List<ValidationMessage> getValidationMessages(InsuranceAccident product) {
        return product.getValidationMessages();
    }

    @Override
    public List<String> getSCNs(InsuranceAccident product) {
        return TextUtil.isBlank((String)product.getScn()) ? new ArrayList() : Collections.singletonList(product.getScn());
    }

    @Override
    public ProductStatus getStatus(InsuranceAccident product) {
        return product.getStatus();
    }

    @Override
    public InsuranceAccident getPreviousProduct(InsuranceAccident product) {
        return product.getPreviousProduct();
    }

    @Override
    public InsuranceAccident getNextProduct(InsuranceAccident product) {
        return product.getNextProduct();
    }

    @Override
    public TicketType getTicketType(InsuranceAccident product) {
        return product.getTicketType();
    }

    @Override
    public Class<InsuranceAccidentIndex> getProductIndexClass() {
        return InsuranceAccidentIndex.class;
    }

    @Override
    public String getStatusIndexPropertyName() {
        return InsuranceAccidentIndex.Property.status.name();
    }

    @Override
    public String getSCNIndexPropertyName() {
        return InsuranceAccidentIndex.Property.scn.name();
    }

    @Override
    public String getTicketTypeIndexPropertyName() {
        return InsuranceAccidentIndex.Property.ticketType.name();
    }

    @Override
    public EntityReference<Organization> getBlankOwner(InsuranceAccident product) {
        return product.getBlankOwner();
    }

    @Override
    public EntityReference<Organization> getSubagency(InsuranceAccident product) {
        return InsuranceAccidentHelper.getSubagency((InsuranceAccident)product);
    }

    @Override
    public EntityReference<Person> getAgent(InsuranceAccident product) {
        return product.getAgent();
    }

    @Override
    public String getPCC(InsuranceAccident product) {
        return product.getPcc();
    }

    @Override
    public String getValidator(InsuranceAccident product) {
        return null;
    }

    @Override
    public String getSystemNumber(InsuranceAccident product) {
        return product.getSystemNumber();
    }

    @Override
    public TariffType getTariffType(InsuranceAccident product) {
        return TariffType.REGULAR;
    }

    @Override
    public List<GeneralProductFop> getVendorFops(InsuranceAccident product) {
        return InsuranceAccidentHelper.getVendorFops((InsuranceAccident)product);
    }

    @Override
    public Date getOperationDate(GeneralProductFop fop) {
        return fop.getOperationDate();
    }

    @Override
    public Date getIssueDate(InsuranceAccident product) {
        return product.getIssueDate();
    }

    @Override
    public int getConjCount(InsuranceAccident product) {
        return 0;
    }

    @Override
    public Traveller getTraveller(InsuranceAccident product) {
        return BookingHelper.findTraveller((BookingFile)product.getReservation().getBookingFile(), (String)product.getTravellerUid());
    }

    @Override
    public ProductSearchResult findProductByScnAndDate(String scn, Date issueDate, long threshold, ProductStatus status) throws Exception {
        List data;
        SearchQuery query = new SearchQuery();
        if (status != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)InsuranceAccidentIndex.Property.status.name(), (Object)status));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)InsuranceAccidentIndex.Property.ticketType.name(), (Object)TicketType.OWN), SearchCriterion.eq((String)InsuranceAccidentIndex.Property.ticketType.name(), null)}));
        if (!TextUtil.isBlank((String)scn)) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)InsuranceAccidentIndex.Property.scn.name(), (Object)scn));
        }
        if (issueDate != null) {
            Date lowerLim = new Date(issueDate.getTime() - threshold);
            Date upperLim = new Date(issueDate.getTime() + threshold);
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)InsuranceAccidentIndex.Property.issueDate.name(), (Object)lowerLim));
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)InsuranceAccidentIndex.Property.issueDate.name(), (Object)upperLim));
        }
        if ((data = EntityStorage.get().search(InsuranceAccidentIndex.class, query).getData()).isEmpty()) {
            return null;
        }
        InsuranceAccidentIndex idx = (InsuranceAccidentIndex)data.get(0);
        EntityContainer bfCtr = EntityStorage.get().resolve(idx.getSource());
        BookingFile booking = (BookingFile)bfCtr.getEntity();
        BaseProduct bp = BookingHelper.findProduct((BookingFile)booking, (String)idx.getNavigationKey());
        return new ProductSearchResult(booking, bp, bp.getReservation(), (EntityContainer<BookingFile>)bfCtr, data.size() == 1);
    }

    @Override
    public int getEticketCount(EntityReference<Organization> blankOwner, EntityReference<Organization> agency, EntityReference<Organization> subagency, EntityReference<SalesPoint> salesPoint, Set<GdsName> gdsNames, DictionaryReference<BlankType> blankType, boolean countVoid) throws Exception {
        return 0;
    }

    @Override
    public EntityReference<SalesPoint> getSalesPoint(InsuranceAccident product) {
        return product.getSalesPoint();
    }

    @Override
    public String getIssueDateIndexPropertyName() {
        return InsuranceAccidentIndex.Property.issueDate.name();
    }

    @Override
    public List<SearchCriterion> getProductIndexAdditionalCriterions(InsuranceAccident product) {
        return Collections.emptyList();
    }
}

