/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.stockcontrol;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristic;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristicHelper;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristicIndex;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.handlers.stockcontrol.StockControlProductHandler;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class InsuranceTouristicStockControlHandler
implements StockControlProductHandler<InsuranceTouristic, InsuranceTouristicIndex, GeneralProductFop> {
    @Override
    public Class<InsuranceTouristic> getProductClass() {
        return InsuranceTouristic.class;
    }

    @Override
    public List<ValidationMessage> getValidationMessages(InsuranceTouristic product) {
        return product.getValidationMessages();
    }

    @Override
    public List<String> getSCNs(InsuranceTouristic product) {
        return TextUtil.isBlank((String)product.getScn()) ? new ArrayList() : Collections.singletonList(product.getScn());
    }

    @Override
    public ProductStatus getStatus(InsuranceTouristic product) {
        return product.getStatus();
    }

    @Override
    public InsuranceTouristic getPreviousProduct(InsuranceTouristic product) {
        return product.getPreviousProduct();
    }

    @Override
    public InsuranceTouristic getNextProduct(InsuranceTouristic product) {
        return product.getNextProduct();
    }

    @Override
    public TicketType getTicketType(InsuranceTouristic product) {
        return product.getTicketType();
    }

    @Override
    public Class<InsuranceTouristicIndex> getProductIndexClass() {
        return InsuranceTouristicIndex.class;
    }

    @Override
    public String getStatusIndexPropertyName() {
        return InsuranceTouristicIndex.Property.status.name();
    }

    @Override
    public String getSCNIndexPropertyName() {
        return InsuranceTouristicIndex.Property.scn.name();
    }

    @Override
    public String getTicketTypeIndexPropertyName() {
        return InsuranceTouristicIndex.Property.ticketType.name();
    }

    @Override
    public EntityReference<Organization> getBlankOwner(InsuranceTouristic product) {
        return product.getBlankOwner();
    }

    @Override
    public EntityReference<Organization> getSubagency(InsuranceTouristic product) {
        return InsuranceTouristicHelper.getSubagency((InsuranceTouristic)product);
    }

    @Override
    public EntityReference<Person> getAgent(InsuranceTouristic product) {
        return product.getAgent();
    }

    @Override
    public String getPCC(InsuranceTouristic product) {
        return null;
    }

    @Override
    public String getValidator(InsuranceTouristic product) {
        return null;
    }

    @Override
    public String getSystemNumber(InsuranceTouristic product) {
        return product.getSystemNumber();
    }

    @Override
    public TariffType getTariffType(InsuranceTouristic product) {
        return TariffType.REGULAR;
    }

    @Override
    public List<GeneralProductFop> getVendorFops(InsuranceTouristic product) {
        return InsuranceTouristicHelper.getVendorFops((InsuranceTouristic)product);
    }

    @Override
    public Date getOperationDate(GeneralProductFop fop) {
        return fop.getOperationDate();
    }

    @Override
    public Date getIssueDate(InsuranceTouristic product) {
        return product.getIssueDate();
    }

    @Override
    public int getConjCount(InsuranceTouristic product) {
        return 0;
    }

    @Override
    public Traveller getTraveller(InsuranceTouristic product) {
        return BookingHelper.findTraveller((BookingFile)product.getReservation().getBookingFile(), (String)product.getPolicyHolderUid());
    }

    @Override
    public ProductSearchResult findProductByScnAndDate(String scn, Date issueDate, long threshold, ProductStatus status) throws Exception {
        List data;
        SearchQuery query = new SearchQuery();
        if (status != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)InsuranceTouristicIndex.Property.status.name(), (Object)status));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)InsuranceTouristicIndex.Property.ticketType.name(), (Object)TicketType.OWN), SearchCriterion.eq((String)InsuranceTouristicIndex.Property.ticketType.name(), null)}));
        if (!TextUtil.isBlank((String)scn)) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)InsuranceTouristicIndex.Property.scn.name(), (Object)scn));
        }
        if (issueDate != null) {
            Date lowerLim = new Date(issueDate.getTime() - threshold);
            Date upperLim = new Date(issueDate.getTime() + threshold);
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)InsuranceTouristicIndex.Property.issueDate.name(), (Object)lowerLim));
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)InsuranceTouristicIndex.Property.issueDate.name(), (Object)upperLim));
        }
        if ((data = EntityStorage.get().search(InsuranceTouristicIndex.class, query).getData()).isEmpty()) {
            return null;
        }
        InsuranceTouristicIndex idx = (InsuranceTouristicIndex)data.get(0);
        EntityContainer bfCtr = EntityStorage.get().resolve(idx.getSource());
        BookingFile booking = (BookingFile)bfCtr.getEntity();
        BaseProduct bp = BookingHelper.findProduct((BookingFile)booking, (String)idx.getNavigationKey());
        return new ProductSearchResult(booking, bp, bp.getReservation(), (EntityContainer<BookingFile>)bfCtr, data.size() == 1);
    }

    @Override
    public int getEticketCount(EntityReference<Organization> blankOwner, EntityReference<Organization> agency, EntityReference<Organization> subagency, EntityReference<SalesPoint> salesPoint, Set<GdsName> gdsNames, DictionaryReference<BlankType> blankType, boolean countVoid) throws Exception {
        return 0;
    }

    @Override
    public EntityReference<SalesPoint> getSalesPoint(InsuranceTouristic product) {
        return product.getSalesPoint();
    }

    @Override
    public String getIssueDateIndexPropertyName() {
        return InsuranceTouristicIndex.Property.issueDate.name();
    }

    @Override
    public List<SearchCriterion> getProductIndexAdditionalCriterions(InsuranceTouristic product) {
        return Collections.emptyList();
    }
}

