/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.stockcontrol;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.MCOFees;
import com.gridnine.xtrip.common.model.booking.MCOFeesIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.handlers.stockcontrol.StockControlProductHandler;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class MCOFeesStockControlHandler
implements StockControlProductHandler<MCOFees, MCOFeesIndex, GeneralProductFop> {
    @Override
    public Class<MCOFees> getProductClass() {
        return MCOFees.class;
    }

    @Override
    public List<ValidationMessage> getValidationMessages(MCOFees product) {
        return product.getValidationMessages();
    }

    @Override
    public List<String> getSCNs(MCOFees product) {
        return TextUtil.isBlank((String)product.getScn()) ? new ArrayList() : Collections.singletonList(product.getScn());
    }

    @Override
    public ProductStatus getStatus(MCOFees product) {
        return product.getStatus();
    }

    @Override
    public MCOFees getPreviousProduct(MCOFees product) {
        return product.getPreviousMCO();
    }

    @Override
    public MCOFees getNextProduct(MCOFees product) {
        return product.getNextMCO();
    }

    @Override
    public TicketType getTicketType(MCOFees product) {
        return TicketType.OWN;
    }

    @Override
    public Class<MCOFeesIndex> getProductIndexClass() {
        return MCOFeesIndex.class;
    }

    @Override
    public String getStatusIndexPropertyName() {
        return MCOFeesIndex.Property.status.name();
    }

    @Override
    public String getSCNIndexPropertyName() {
        return MCOFeesIndex.Property.scn.name();
    }

    @Override
    public String getTicketTypeIndexPropertyName() {
        return null;
    }

    @Override
    public EntityReference<Organization> getBlankOwner(MCOFees product) {
        return product.getAgency();
    }

    @Override
    public EntityReference<Organization> getSubagency(MCOFees product) {
        return product.getAgency();
    }

    @Override
    public EntityReference<Person> getAgent(MCOFees product) {
        return product.getAgent();
    }

    @Override
    public String getPCC(MCOFees product) {
        return null;
    }

    @Override
    public String getValidator(MCOFees product) {
        return null;
    }

    @Override
    public String getSystemNumber(MCOFees product) {
        return product.getScn();
    }

    @Override
    public TariffType getTariffType(MCOFees product) {
        return TariffType.REGULAR;
    }

    @Override
    public List<GeneralProductFop> getVendorFops(MCOFees product) {
        GeneralProductFop fop = new GeneralProductFop();
        fop.setEquivalentAmount(BigDecimal.ZERO);
        fop.setType(product.getPaymentType() != null ? product.getPaymentType() : PaymentType.CASH);
        fop.setOperationDate(product.getIssueDate());
        return Collections.singletonList(fop);
    }

    @Override
    public Date getOperationDate(GeneralProductFop fop) {
        return fop.getOperationDate();
    }

    @Override
    public Date getIssueDate(MCOFees product) {
        return product.getIssueDate();
    }

    @Override
    public int getConjCount(MCOFees product) {
        return 0;
    }

    @Override
    public Traveller getTraveller(MCOFees product) {
        return BookingHelper.findTraveller((BookingFile)product.getReservation().getBookingFile(), (String)product.getTravellerUid());
    }

    @Override
    public ProductSearchResult findProductByScnAndDate(String scn, Date issueDate, long threshold, ProductStatus status) throws Exception {
        List data;
        SearchQuery query = new SearchQuery();
        if (status != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)MCOFeesIndex.Property.status.name(), (Object)status));
        }
        if (!TextUtil.isBlank((String)scn)) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)MCOFeesIndex.Property.scn.name(), (Object)scn));
        }
        if (issueDate != null) {
            Date lowerLim = new Date(issueDate.getTime() - threshold);
            Date upperLim = new Date(issueDate.getTime() + threshold);
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)MCOFeesIndex.Property.issueDate.name(), (Object)lowerLim));
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)MCOFeesIndex.Property.issueDate.name(), (Object)upperLim));
        }
        if ((data = EntityStorage.get().search(MCOFeesIndex.class, query).getData()).isEmpty()) {
            return null;
        }
        MCOFeesIndex idx = (MCOFeesIndex)data.get(0);
        EntityContainer bfCtr = EntityStorage.get().resolve(idx.getSource());
        BookingFile booking = (BookingFile)bfCtr.getEntity();
        BaseProduct bp = BookingHelper.findProduct((BookingFile)booking, (String)idx.getNavigationKey());
        return new ProductSearchResult(booking, bp, bp.getReservation(), (EntityContainer<BookingFile>)bfCtr, data.size() == 1);
    }

    @Override
    public int getEticketCount(EntityReference<Organization> blankOwner, EntityReference<Organization> agency, EntityReference<Organization> subagency, EntityReference<SalesPoint> salesPoint, Set<GdsName> gdsNames, DictionaryReference<BlankType> blankType, boolean countVoid) throws Exception {
        return 0;
    }

    @Override
    public EntityReference<SalesPoint> getSalesPoint(MCOFees product) {
        return product.getSalesPoint();
    }

    @Override
    public String getIssueDateIndexPropertyName() {
        return MCOFeesIndex.Property.issueDate.name();
    }

    @Override
    public List<SearchCriterion> getProductIndexAdditionalCriterions(MCOFees product) {
        return Collections.emptyList();
    }
}

