/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.stockcontrol;

import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import java.util.Date;
import java.util.List;
import java.util.Set;

public interface StockControlProductHandler<P extends BaseProduct, I extends EntityIndex<BookingFile>, F extends Fop> {
    public Class<P> getProductClass();

    public List<ValidationMessage> getValidationMessages(P var1);

    public List<String> getSCNs(P var1);

    public ProductStatus getStatus(P var1);

    public P getPreviousProduct(P var1);

    public P getNextProduct(P var1);

    public TicketType getTicketType(P var1);

    public Class<I> getProductIndexClass();

    public List<SearchCriterion> getProductIndexAdditionalCriterions(P var1);

    public String getStatusIndexPropertyName();

    public String getSCNIndexPropertyName();

    public String getTicketTypeIndexPropertyName();

    public String getIssueDateIndexPropertyName();

    public EntityReference<Organization> getBlankOwner(P var1);

    public EntityReference<Organization> getSubagency(P var1);

    public EntityReference<SalesPoint> getSalesPoint(P var1);

    public EntityReference<Person> getAgent(P var1);

    public String getPCC(P var1);

    public String getValidator(P var1);

    public String getSystemNumber(P var1);

    public TariffType getTariffType(P var1);

    public List<F> getVendorFops(P var1);

    public Date getOperationDate(F var1);

    public Date getIssueDate(P var1);

    public int getConjCount(P var1);

    public Traveller getTraveller(P var1);

    public ProductSearchResult findProductByScnAndDate(String var1, Date var2, long var3, ProductStatus var5) throws Exception;

    public int getEticketCount(EntityReference<Organization> var1, EntityReference<Organization> var2, EntityReference<Organization> var3, EntityReference<SalesPoint> var4, Set<GdsName> var5, DictionaryReference<BlankType> var6, boolean var7) throws Exception;
}

