/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.stockcontrol;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.misc.BlankTypePolicy;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductIndex;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.UniversalProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.handlers.stockcontrol.StockControlProductHandler;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniversalProductStockControlHandler
implements StockControlProductHandler<UniversalProduct, UniversalProductIndex, GeneralProductFop> {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public Class<UniversalProduct> getProductClass() {
        return UniversalProduct.class;
    }

    @Override
    public List<ValidationMessage> getValidationMessages(UniversalProduct product) {
        return product.getValidationMessages();
    }

    @Override
    public List<String> getSCNs(UniversalProduct product) {
        return TextUtil.isBlank((String)product.getScn()) ? new ArrayList() : Collections.singletonList(product.getScn());
    }

    @Override
    public ProductStatus getStatus(UniversalProduct product) {
        return product.getStatus();
    }

    @Override
    public UniversalProduct getPreviousProduct(UniversalProduct product) {
        return product.getPreviousProduct();
    }

    @Override
    public UniversalProduct getNextProduct(UniversalProduct product) {
        return product.getNextProduct();
    }

    @Override
    public TicketType getTicketType(UniversalProduct product) {
        if (product.getDescription() == null) {
            this.log.warn(String.format("product %s: description is null", product.getSystemNumber()));
            return TicketType.FAKE;
        }
        try {
            EntityContainer descriptionContainer = EntityStorage.get().resolve(product.getDescription());
            if (descriptionContainer == null) {
                this.log.warn(String.format("product %s: description %s is absent in DB", product.getSystemNumber(), product.getDescription()));
                return TicketType.FAKE;
            }
            return ((UniversalProductDescription)descriptionContainer.getEntity()).getBlankTypePolicy() == BlankTypePolicy.PRINTED_OR_ETICKET ? product.getTicketType() : TicketType.FAKE;
        }
        catch (Exception e) {
            this.log.error("unable to resolve reference " + product.getDescription(), (Throwable)e);
            return TicketType.FAKE;
        }
    }

    @Override
    public Class<UniversalProductIndex> getProductIndexClass() {
        return UniversalProductIndex.class;
    }

    @Override
    public String getStatusIndexPropertyName() {
        return UniversalProductIndex.Property.status.name();
    }

    @Override
    public String getSCNIndexPropertyName() {
        return UniversalProductIndex.Property.scn.name();
    }

    @Override
    public String getTicketTypeIndexPropertyName() {
        return UniversalProductIndex.Property.ticketType.name();
    }

    @Override
    public EntityReference<Organization> getBlankOwner(UniversalProduct product) {
        return product.getBlankOwner();
    }

    @Override
    public EntityReference<Organization> getSubagency(UniversalProduct product) {
        return UniversalProductHelper.getSubagency((UniversalProduct)product);
    }

    @Override
    public EntityReference<Person> getAgent(UniversalProduct product) {
        return product.getAgent();
    }

    @Override
    public String getPCC(UniversalProduct product) {
        return null;
    }

    @Override
    public String getValidator(UniversalProduct product) {
        return null;
    }

    @Override
    public String getSystemNumber(UniversalProduct product) {
        return product.getSystemNumber();
    }

    @Override
    public TariffType getTariffType(UniversalProduct product) {
        return TariffType.REGULAR;
    }

    @Override
    public List<GeneralProductFop> getVendorFops(UniversalProduct product) {
        return UniversalProductHelper.getVendorFops((UniversalProduct)product);
    }

    @Override
    public Date getOperationDate(GeneralProductFop fop) {
        return fop.getOperationDate();
    }

    @Override
    public Date getIssueDate(UniversalProduct product) {
        return product.getIssueDate();
    }

    @Override
    public int getConjCount(UniversalProduct product) {
        return 0;
    }

    @Override
    public Traveller getTraveller(UniversalProduct product) {
        return product.getTravellersUids().isEmpty() ? null : (Traveller)CollectionUtil.find((Iterable)product.getReservation().getBookingFile().getTravellers(), (String)((String)product.getTravellersUids().get(0)));
    }

    @Override
    public ProductSearchResult findProductByScnAndDate(String scn, Date issueDate, long threshold, ProductStatus status) throws Exception {
        List data;
        SearchQuery query = new SearchQuery();
        if (status != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)UniversalProductIndex.Property.status.name(), (Object)status));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)UniversalProductIndex.Property.ticketType.name(), (Object)TicketType.OWN), SearchCriterion.eq((String)UniversalProductIndex.Property.ticketType.name(), null)}));
        if (!TextUtil.isBlank((String)scn)) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)UniversalProductIndex.Property.scn.name(), (Object)scn));
        }
        if (issueDate != null) {
            Date lowerLim = new Date(issueDate.getTime() - threshold);
            Date upperLim = new Date(issueDate.getTime() + threshold);
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)UniversalProductIndex.Property.issueDate.name(), (Object)lowerLim));
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)UniversalProductIndex.Property.issueDate.name(), (Object)upperLim));
        }
        if ((data = EntityStorage.get().search(UniversalProductIndex.class, query).getData()).isEmpty()) {
            return null;
        }
        UniversalProductIndex idx = (UniversalProductIndex)data.get(0);
        EntityContainer bfCtr = EntityStorage.get().resolve(idx.getSource());
        BookingFile booking = (BookingFile)bfCtr.getEntity();
        BaseProduct bp = BookingHelper.findProduct((BookingFile)booking, (String)idx.getNavigationKey());
        return new ProductSearchResult(booking, bp, bp.getReservation(), (EntityContainer<BookingFile>)bfCtr, data.size() == 1);
    }

    @Override
    public int getEticketCount(EntityReference<Organization> blankOwner, EntityReference<Organization> agency, EntityReference<Organization> subagency, EntityReference<SalesPoint> salesPoint, Set<GdsName> gdsNames, DictionaryReference<BlankType> blankType, boolean countVoid) throws Exception {
        return 0;
    }

    @Override
    public EntityReference<SalesPoint> getSalesPoint(UniversalProduct product) {
        return product.getSalesPoint();
    }

    @Override
    public String getIssueDateIndexPropertyName() {
        return UniversalProductIndex.Property.issueDate.name();
    }

    @Override
    public List<SearchCriterion> getProductIndexAdditionalCriterions(UniversalProduct product) {
        return Collections.singletonList(SearchCriterion.eq((String)UniversalProductIndex.Property.description.name(), (Object)product.getDescription()));
    }
}

