/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.validation;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProductIndex;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.server.model.handlers.validation.GeneralProductValidationHelper;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationContext;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class AdditionalServiceProductValidationHandler
implements ProductValidationHandler<AdditionalServiceProduct> {
    @Override
    public Class<AdditionalServiceProduct> getProductClass() {
        return AdditionalServiceProduct.class;
    }

    @Override
    public void validate(final AdditionalServiceProduct product, ProductValidationContext ctx) throws Exception {
        List messages = product.getValidationMessages();
        MessageHelper.removeMessages((Collection)messages, (ValidationMessageCategory)ValidationMessageCategory.OTHER);
        MessageHelper.removeMessages((Collection)messages, (ValidationMessageCategory)ValidationMessageCategory.STATISTICS);
        if (ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            return;
        }
        GeneralProductValidationHelper.getAllValidationMessages((BaseProduct)product, new GeneralProductValidationHelper.ProductIndexProvider<BookingFile, AdditionalServiceProductIndex>(){

            @Override
            public Class<AdditionalServiceProductIndex> getIndexClass() {
                return AdditionalServiceProductIndex.class;
            }

            @Override
            public String getSystemNumberIndexPropertyName() {
                return AdditionalServiceProductIndex.Property.systemNumber.name();
            }

            @Override
            public String getStatusIndexPropertyName() {
                return AdditionalServiceProductIndex.Property.status.name();
            }

            @Override
            public String getProductTypeIndexPropertyName() {
                return null;
            }

            @Override
            public Collection<SearchCriterion> getAdditionalSystemNumberCriterions() {
                return Collections.singletonList(SearchCriterion.eq((String)AdditionalServiceProductIndex.Property.category.name(), (Object)product.getCategory()));
            }

            @Override
            public boolean hasEquivalentFare() {
                return false;
            }

            @Override
            public boolean hasTicketType() {
                return false;
            }

            @Override
            public boolean hasBlankOwner() {
                return false;
            }

            @Override
            public boolean hasSubagency() {
                return true;
            }
        }, messages, ctx);
    }
}

