/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.validation;

import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicketIndex;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AeroexpressTicketHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.server.model.handlers.validation.GeneralProductValidationHelper;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationContext;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AeroexpressTicketValidationHandler
implements ProductValidationHandler<AeroexpressTicket> {
    static final Logger log = LoggerFactory.getLogger(AeroexpressTicketValidationHandler.class);

    @Override
    public Class<AeroexpressTicket> getProductClass() {
        return AeroexpressTicket.class;
    }

    @Override
    public void validate(AeroexpressTicket product, ProductValidationContext ctx) throws Exception {
        List messages = product.getValidationMessages();
        MessageHelper.removeMessages((Collection)messages, (ValidationMessageCategory)ValidationMessageCategory.OTHER);
        MessageHelper.removeMessages((Collection)messages, (ValidationMessageCategory)ValidationMessageCategory.STATISTICS);
        if (product.getTicketType() == TicketType.FAKE) {
            return;
        }
        GeneralProductValidationHelper.getAllValidationMessages((BaseProduct)product, new GeneralProductValidationHelper.ProductIndexProvider<BookingFile, AeroexpressTicketIndex>(){

            @Override
            public Class<AeroexpressTicketIndex> getIndexClass() {
                return AeroexpressTicketIndex.class;
            }

            @Override
            public String getSystemNumberIndexPropertyName() {
                return AeroexpressTicketIndex.Property.ticketNumber.name();
            }

            @Override
            public String getStatusIndexPropertyName() {
                return AeroexpressTicketIndex.Property.status.name();
            }

            @Override
            public String getProductTypeIndexPropertyName() {
                return AeroexpressTicketIndex.Property.ticketType.name();
            }

            @Override
            public Collection<SearchCriterion> getAdditionalSystemNumberCriterions() {
                return Collections.emptyList();
            }

            @Override
            public boolean hasEquivalentFare() {
                return true;
            }

            @Override
            public boolean hasTicketType() {
                return true;
            }

            @Override
            public boolean hasBlankOwner() {
                return true;
            }

            @Override
            public boolean hasSubagency() {
                return true;
            }
        }, messages, ctx);
        if (ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            return;
        }
        messages.addAll(this.createValidationMessages(product));
    }

    List<ValidationMessage> createValidationMessages(AeroexpressTicket ticket) throws Exception {
        ArrayList<ValidationMessage> result = new ArrayList<ValidationMessage>();
        if (ticket.getAgent() == null) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATI_AGENT_NOT_DEFINED));
        }
        if (ticket.getArrivalLocation() == null) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATI_ARRIVE_POINT_NOT_DEFINED));
        }
        if (ticket.getClassOfService() == null) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATI_CLASS_OF_SERVICE_NOT_DEFINED));
        }
        if (ticket.getDepartureDate() == null) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATI_DEPART_POINT_NOT_DEFINED));
        }
        if (ticket.getPassengerType() == null) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATI_PASSENGER_TYPE_NOT_DEFINED));
        }
        if (ticket.getReservationId() == null) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATI_RESERVATION_ID_NOT_DEFINED));
        }
        if (AeroexpressTicketHelper.getSubagency((AeroexpressTicket)ticket) == null) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATI_SUBAGENCY_NOT_DEFINED));
        }
        if (ticket.getSystemNumber() == null) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATI_SYSTEM_NUMBER_NOT_DEFINED));
        }
        return result;
    }
}

