/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.validation;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductIndex;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.handlers.validation.GeneralProductValidationHelper;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationContext;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgencyMemoProductValidationHandler
implements ProductValidationHandler<AgencyMemoProduct> {
    static final Logger log = LoggerFactory.getLogger(AgencyMemoProductValidationHandler.class);

    @Override
    public Class<AgencyMemoProduct> getProductClass() {
        return AgencyMemoProduct.class;
    }

    @Override
    public void validate(AgencyMemoProduct product, ProductValidationContext ct) throws Exception {
        List messages = product.getValidationMessages();
        MessageHelper.removeMessages((Collection)messages, (ValidationMessageCategory)ValidationMessageCategory.OTHER);
        GeneralProductValidationHelper.addCommonValidationMessages((BaseProduct)product, new GeneralProductValidationHelper.ProductIndexProvider<BookingFile, AgencyMemoProductIndex>(){

            @Override
            public Class<AgencyMemoProductIndex> getIndexClass() {
                return AgencyMemoProductIndex.class;
            }

            @Override
            public String getSystemNumberIndexPropertyName() {
                return null;
            }

            @Override
            public String getStatusIndexPropertyName() {
                return null;
            }

            @Override
            public String getProductTypeIndexPropertyName() {
                return null;
            }

            @Override
            public Collection getAdditionalSystemNumberCriterions() {
                return null;
            }

            @Override
            public boolean hasEquivalentFare() {
                return false;
            }

            @Override
            public boolean hasTicketType() {
                return false;
            }

            @Override
            public boolean hasBlankOwner() {
                return false;
            }

            @Override
            public boolean hasSubagency() {
                return false;
            }

            @Override
            public boolean hasIssuingAgent() {
                return false;
            }
        }, messages);
        GeneralProductValidationHelper.addFOPValidationMessages((BaseProduct)product, messages);
        product.getValidationMessages().addAll(messages);
    }

    List<ValidationMessage> createValidationMessages(AgencyMemoProduct product) throws Exception {
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
        if (product.getBlankOwner() == null) {
            validationMessages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.AMP_BLANK_OWNER_NOT_DEFINED));
        }
        if (product.getSupplier() == null) {
            validationMessages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.AMP_SUPPLIER_NOT_DEFINED));
        }
        if (product.getAgency() == null) {
            validationMessages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.AMP_AGENCY_NOT_DEFINED));
        }
        if (product.getType() == null) {
            validationMessages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.AMP_TYPE_NOT_DEFINED));
        }
        if (TextUtil.isBlank((String)product.getAirlineCode())) {
            validationMessages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.AMP_AIRLINE_CODE_NOT_DEFINED));
        }
        if (TextUtil.isBlank((String)product.getSystemNumber())) {
            validationMessages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.AMP_SYSTEM_NUMBER_NOT_DEFINED));
        }
        return validationMessages;
    }
}

