/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.validation;

import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseCommission;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeValue;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductSearchIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationRemark;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictPredifinedValueProvider;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.helpers.MulticurrencyHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.ReasonCode;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.profile.ValidatorIndex;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.rate.RateHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.handlers.validation.GeneralProductValidationHelper;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationContext;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationHandler;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AirProductValidationHandler
implements ProductValidationHandler<Product> {
    protected static final Logger log = LoggerFactory.getLogger(AirProductValidationHandler.class);

    @Override
    public Class<Product> getProductClass() {
        return Product.class;
    }

    @Override
    public void validate(final Product product, ProductValidationContext context) throws Exception {
        List messages = product.getValidationMessages();
        MessageHelper.removeMessages((Collection)messages, (ValidationMessageCategory)ValidationMessageCategory.OTHER);
        MessageHelper.removeMessages((Collection)messages, (ValidationMessageCategory)ValidationMessageCategory.STATISTICS);
        if (product.getTicketType() == TicketType.FAKE) {
            return;
        }
        if (product.getProductCategory() != ProductCategory.MCO || product.getMcoCategory() != MCOCategory.INFORMATION) {
            GeneralProductValidationHelper.getAllValidationMessages((BaseProduct)product, new GeneralProductValidationHelper.ProductIndexProvider<BookingFile, ProductIndex>(){

                @Override
                public Class<ProductIndex> getIndexClass() {
                    return ProductIndex.class;
                }

                @Override
                public String getSystemNumberIndexPropertyName() {
                    return ProductIndex.Property.ticketNumbers.name();
                }

                @Override
                public String getStatusIndexPropertyName() {
                    return ProductIndex.Property.status.name();
                }

                @Override
                public String getProductTypeIndexPropertyName() {
                    return ProductIndex.Property.ticketType.name();
                }

                @Override
                public Collection<SearchCriterion> getAdditionalSystemNumberCriterions() {
                    if (product.getIssueDate() != null) {
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(product.getIssueDate());
                        cal.add(1, -1);
                        return Collections.singletonList(SearchCriterion.ge((String)ProductSearchIndex.Property.issueDate.name(), (Object)cal.getTime()));
                    }
                    return Collections.emptyList();
                }

                @Override
                public boolean hasEquivalentFare() {
                    return true;
                }

                @Override
                public boolean hasTicketType() {
                    return true;
                }

                @Override
                public boolean hasBlankOwner() {
                    return true;
                }

                @Override
                public boolean hasSubagency() {
                    return true;
                }
            }, messages, context);
        }
        if (ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            return;
        }
        messages.addAll(AirProductValidationHandler.getValidationMessages(product));
    }

    static List<ValidationMessage> getValidationMessages(Product prod) throws Exception {
        String code = ProfileHelper.findOrganizationCode((EntityReference)prod.getBlankOwnerRef());
        if ("SU".equals(code)) {
            return AirProductValidationHandler.getSuValidationMessages(prod, code);
        }
        return AirProductValidationHandler.getStandardValidationMessages(prod, code);
    }

    private static List<ValidationMessage> getStandardValidationMessages(Product prod, String blankOwnerCode) {
        BigDecimal checkSumProductFops;
        boolean hasDuplicatedNumber;
        LinkedHashSet<ValidationMessage> result = new LinkedHashSet<ValidationMessage>();
        EntityContainer blankOwner = EntityStorage.get().resolve(prod.getBlankOwnerRef());
        if (blankOwner == null) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_BLANK_OWNER_IS_EMPTY));
        }
        if (prod.getCarrier() == null || prod.getCarrierNumber() == null) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_CARRIER_IS_EMPTY));
        }
        if (TextUtil.isBlank((String)prod.getSystemNumber())) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATI_SYSTEM_NUMBER_NOT_DEFINED));
        }
        List relatedAirOrEmdProducts = prod.getRelatedProducts().stream().filter(AirProductHelper::isAirProductOrEMD).collect(Collectors.toList());
        if (AirProductHelper.needRelatedTicketForMCO((MCOCategory)prod.getMcoCategory()) && relatedAirOrEmdProducts.isEmpty()) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.EMD_TICKET_IS_EMPTY));
        }
        if (hasDuplicatedNumber = relatedAirOrEmdProducts.stream().anyMatch(rp -> MiscUtil.equals((Object)rp.getSystemNumber(), (Object)prod.getSystemNumber()))) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.EMD_NUMBER_IS_DUPLICATE_OF_TICKET_NUMBER));
        }
        if (prod.getStatus() != ProductStatus.BOOKING && !ProductStatusHandler.getAllNonIssuedVoidStatuses().contains(prod.getStatus()) && prod.getTicketType() != TicketType.EXTERNAL) {
            if (prod.getBlankType() == null) {
                result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_BLANK_IS_EMPTY));
            } else {
                BlankType type = (BlankType)DictionaryCache.get().resolveReference(prod.getBlankType());
                if (type == null) {
                    result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_BLANK_TYPE_HAS_WRONG_VALUE));
                }
            }
        }
        int segmentIdx = 0;
        for (SegmentTariff st : prod.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                GeoLocation arrivalCity;
                GeoLocation airportLocation;
                GeoLocation cityLocation;
                ++segmentIdx;
                if (seg.getDepartureLocation() == null && seg.getDepartCityCode() == null) {
                    result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_NO_DEPARTURE_IN_SEGMENT_FOR_TICKET, (Object[])new Object[]{prod.getSystemNumber() != null ? prod.getSystemNumber() : "", seg.getRecordNumber()}));
                } else if (seg.getDepartCityCode() != null) {
                    cityLocation = DictHelper.findLocation((DictionaryReference)seg.getDepartureLocation(), (LocationType)LocationType.CITY);
                    airportLocation = DictHelper.findLocation((DictionaryReference)seg.getDepartureLocation(), (LocationType)LocationType.AIRPORT);
                    if (cityLocation == null && airportLocation == null) {
                        result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_NO_DEPARTURE_IN_SEGMENT_FOR_TICKET_WRONG_CODE, (Object[])new Object[]{prod.getSystemNumber() != null ? prod.getSystemNumber() : "", seg.getRecordNumber(), seg.getDepartureLocation()}));
                    } else if (!(cityLocation != null && (cityLocation.getCodeVariants().containsValue(seg.getDepartCityCode()) || seg.getDepartCityCode().equals(cityLocation.getCode())) || airportLocation != null && airportLocation.getCodeVariants().containsValue(seg.getDepartCityCode()))) {
                        result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_WRONG_DEPARTURE_IN_SEGMENT_FOR_TICKET, (Object[])new Object[]{prod.getSystemNumber() != null ? prod.getSystemNumber() : "", seg.getRecordNumber(), seg.getDepartCityCode()}));
                    }
                }
                if (seg.getArriveLocation() == null && seg.getArriveCityCode() == null) {
                    result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_NO_ARRIVE_IN_SEGMENT_FOR_TICKET, (Object[])new Object[]{prod.getSystemNumber() != null ? prod.getSystemNumber() : "", seg.getRecordNumber()}));
                } else if (seg.getArriveCityCode() != null) {
                    cityLocation = DictHelper.findLocation((DictionaryReference)seg.getArriveLocation(), (LocationType)LocationType.CITY);
                    airportLocation = DictHelper.findLocation((DictionaryReference)seg.getArriveLocation(), (LocationType)LocationType.AIRPORT);
                    if (cityLocation == null && airportLocation == null) {
                        result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_NO_ARRIVE_IN_SEGMENT_FOR_TICKET_WRONG_CODE, (Object[])new Object[]{prod.getSystemNumber() != null ? prod.getSystemNumber() : "", seg.getRecordNumber(), seg.getArriveLocation()}));
                    } else if (!(cityLocation != null && (cityLocation.getCodeVariants().containsValue(seg.getArriveCityCode()) || seg.getArriveCityCode().equals(cityLocation.getCode())) || airportLocation != null && airportLocation.getCodeVariants().containsValue(seg.getArriveCityCode()))) {
                        result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_WRONG_ARRIVAL_IN_SEGMENT_FOR_TICKET, (Object[])new Object[]{prod.getSystemNumber() != null ? prod.getSystemNumber() : "", seg.getRecordNumber(), seg.getArriveCityCode()}));
                    }
                }
                if (seg.getFlightDuration() != null) continue;
                GeoLocation departureCity = DictHelper.findCity((DictionaryReference)seg.getDepartureLocation());
                if (departureCity != null && departureCity.getTimeZoneId() == null) {
                    ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_NO_TIMEZONE_IN_GEOLOCATION, (Object[])new Object[]{segmentIdx, departureCity.toReference()});
                }
                if ((arrivalCity = DictHelper.findCity((DictionaryReference)seg.getArriveLocation())) == null || arrivalCity.getTimeZoneId() != null) continue;
                ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_NO_TIMEZONE_IN_GEOLOCATION, (Object[])new Object[]{segmentIdx, arrivalCity.toReference()});
            }
        }
        ProductCategory productCategory = prod.getProductCategory();
        if (!(TextUtil.isBlank((String)prod.getSystemNumber()) || productCategory != ProductCategory.AIR || prod.getStatus() != ProductStatus.REFUND && prod.getStatus() != ProductStatus.EXCHANGE || prod.getPreviousProduct() != null && prod.getPreviousProduct().getStatus() == ProductStatus.SELL && prod.getPreviousProduct().getProductCategory() == ProductCategory.AIR)) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_PRODUCT_NOT_FOUND, (Object[])new Object[]{prod.getSystemNumber(), ProductStatus.SELL}));
        }
        if (productCategory == null) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_PRODUCT_CATEGORY_UNDEFINED));
        }
        AirProductValidationHandler.checkValidator(prod, (EntityContainer<Organization>)blankOwner, result);
        if (!(prod.getTariffType() != null || productCategory != ProductCategory.MCO && productCategory != ProductCategory.AIR && productCategory != ProductCategory.EXCESS_BAGAGE || prod.getTicketType() != TicketType.OWN && prod.getTicketType() != TicketType.CORRECTION && prod.getTicketType() != TicketType.EXTERNAL)) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_FATE_TYPE_NOT_DEFINED));
        }
        ArrayList faresMessages = new ArrayList();
        AirProductHelper.checkFares((Product)prod, (EntityContainer)blankOwner, faresMessages);
        result.addAll(faresMessages);
        for (Tax tax : prod.getTaxes()) {
            if (!TextUtil.isBlank((String)tax.getCode())) continue;
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_TAX_CODE_IS_EMPTY));
            break;
        }
        boolean isInfTariff = false;
        boolean hasEmptyFareBasis = false;
        for (Object st : prod.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                if (TextUtil.isBlank((String)seg.getFareBasis())) {
                    hasEmptyFareBasis = true;
                    continue;
                }
                if (!seg.getFareBasis().contains("100")) continue;
                isInfTariff = true;
            }
        }
        if (hasEmptyFareBasis) {
            boolean createdFromUtsItinerary = false;
            for (ReservationRemark rem : prod.getReservation().getReservationRemarks()) {
                if (!"uts-itinerary".equals(rem.getRemarkText())) continue;
                createdFromUtsItinerary = true;
            }
            if (!(createdFromUtsItinerary || blankOwner != null && ((Organization)blankOwner.getEntity()).getAirline() != null && "AO".equals(((Organization)blankOwner.getEntity()).getAirline().getCode()))) {
                result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_FARE_BASIS_IS_EMPTY));
            }
        }
        MCOCategory mcoCategory = prod.getMcoCategory();
        if (productCategory == ProductCategory.MCO && mcoCategory == null) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_MCO_CATEGORY_UNDEFINED));
        }
        if (mcoCategory == MCOCategory.PENALTY && AirProductHelper.findRelatedAirProduct((Product)prod, (ProductStatus)ProductStatus.REFUND, (boolean)false, (boolean)false) == null && AirProductHelper.findRelatedAirProduct((Product)prod, (ProductStatus)ProductStatus.EXCHANGE, (boolean)false, (boolean)false) == null) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_RELATED_REFUND_ABSENT));
        }
        boolean mco = productCategory == ProductCategory.MCO && prod.getMcoCategory() != MCOCategory.PTA;
        boolean hasPreviousExchnage = prod.getPreviousProduct() != null && prod.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE;
        boolean excessBagage = productCategory == ProductCategory.EXCESS_BAGAGE;
        Money baseFare = AirProductHelper.getBaseFare((Product)prod);
        if (!(baseFare != null || mco || isInfTariff || excessBagage)) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_BASE_FARE_NOT_DEFINED));
        }
        if (!(mco || isInfTariff || baseFare == null || baseFare.getCurrency() == null || baseFare.getCurrency().equals(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, null)))) {
            result.addAll(AirProductValidationHandler.validateIATARate(prod));
        }
        if ((checkSumProductFops = AirProductHelper.calculateTariffEquivalentFare((Product)prod)) == null) {
            checkSumProductFops = BigDecimal.ZERO;
        }
        if (!(mco || isInfTariff || hasPreviousExchnage || baseFare == null || baseFare.getCurrency() == null || !baseFare.getCurrency().equals(prod.getGdsCurrency() == null ? DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB") : prod.getGdsCurrency()) || baseFare.getValue() != null && baseFare.getValue().compareTo(checkSumProductFops) == 0)) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_BASE_FARE_NOT_EQUAL_TO_FARE, (Object[])new Object[]{baseFare.getValue(), checkSumProductFops}));
        }
        if (blankOwner != null && ((Organization)blankOwner.getEntity()).getAirline() != null && ((Organization)blankOwner.getEntity()).getAirline().getCode().equalsIgnoreCase("BSP") && prod.getStatus() == ProductStatus.SELL) {
            AirProductValidationHandler.validateBSPCommission(prod, result);
        }
        if (blankOwner != null && ((Organization)blankOwner.getEntity()).getAirline() != null && ((Organization)blankOwner.getEntity()).getAirline().getCode().equalsIgnoreCase("AO") && prod.getReservation().getProducts().size() > 1) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_FARE_INFO_IS_WRONG));
        }
        if (productCategory == ProductCategory.AIR && prod.getStatisticalData() != null) {
            EntityReference organizationRef = null;
            if (prod.getReservation() != null && prod.getReservation().getBookingFile() != null && prod.getReservation().getBookingFile().getCustomerProfile() != null) {
                organizationRef = prod.getReservation().getBookingFile().getCustomerProfile();
            }
            StatisticalData statisticalData = prod.getStatisticalData();
            StringBuilder unrelatedCostCodes = new StringBuilder();
            Iterator costCodeIterator = StatisticsHelper.getAllCostCodes((StatisticalData)statisticalData).iterator();
            while (costCodeIterator.hasNext()) {
                CostCode costCode = (CostCode)costCodeIterator.next();
                if (costCode.getCostCodeProperties() != null && ProfileHelper.isCostCodePropertiesExists((CostCodeProperties)costCode.getCostCodeProperties(), (EntityReference)organizationRef)) continue;
                unrelatedCostCodes.append(costCode.getValue());
                if (!costCodeIterator.hasNext()) continue;
                unrelatedCostCodes.append(",");
            }
            if (unrelatedCostCodes.length() > 0) {
                result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_UDID_TYPE_MISSING, (Object[])new Object[]{unrelatedCostCodes.toString(), organizationRef != null ? organizationRef.getCaption() : ""}));
            }
            StringBuilder unrelatedReasonCodes = new StringBuilder();
            Iterator reasonCodeIterator = statisticalData.getReasonCodes().iterator();
            while (reasonCodeIterator.hasNext()) {
                ReasonCode reasonCode = (ReasonCode)reasonCodeIterator.next();
                if (ProfileHelper.isReasonCodeExists((EntityReference)organizationRef, (ReasonCodeType)ReasonCodeType.REASON_CODE_AIR, (String)reasonCode.getName())) continue;
                unrelatedReasonCodes.append(reasonCode.getName());
                if (!reasonCodeIterator.hasNext()) continue;
                unrelatedReasonCodes.append(",");
            }
            if (unrelatedReasonCodes.length() > 0) {
                result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_REASON_CODE_TYPE_MISSING, (Object[])new Object[]{unrelatedReasonCodes.toString(), organizationRef != null ? organizationRef.getCaption() : ""}));
            }
        }
        AirProductContractRelationData clientRelation = AirProductHelper.getClientContractRelation((Product)prod);
        for (Commission commission : clientRelation.getCommissions()) {
            BigDecimal contractEquivalentAmount = commission.getContractEquivalentAmount();
            if (contractEquivalentAmount != null && commission.getAmount() != null && commission.getAmount().getCurrency() != null && clientRelation.getGeneralData() != null && clientRelation.getGeneralData().getCurrency() != null && !commission.getAmount().getCurrency().equals(clientRelation.getGeneralData().getCurrency().getCode()) && clientRelation.getGeneralData().getRate() != null && clientRelation.getGeneralData().getRate().getRateWithCoefficient() != 0.0) {
                contractEquivalentAmount = MulticurrencyHelper.roundDouble((BigDecimal)commission.getContractEquivalentAmount().multiply(BigDecimal.valueOf(clientRelation.getGeneralData().getRate().getRateWithCoefficient())), (RoundingMode)clientRelation.getGeneralData().getRate().getRoundingMode(), (RoundingValue)clientRelation.getGeneralData().getRate().getRoundingValue());
            }
            if (MiscUtil.equals((Object)commission.getEquivalentAmount(), (Object)contractEquivalentAmount)) continue;
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_COMMISSION_EQUIVALENT_AMOUNT_CHANGED, (Object[])new Object[]{commission.getEquivalentAmount(), contractEquivalentAmount}));
        }
        return new ArrayList<ValidationMessage>(result);
    }

    private static void checkValidator(Product prod, EntityContainer<Organization> blankOwner, Set<ValidationMessage> result) {
        if (prod.getTicketType() == TicketType.EXTERNAL) {
            return;
        }
        String validatorCode = prod.getValidatorCode();
        if (TextUtil.isBlank((String)validatorCode)) {
            if (!(prod.getProductCategory() != ProductCategory.MCO && prod.getProductCategory() != ProductCategory.AIR || prod.getTicketType() != TicketType.OWN && prod.getTicketType() != TicketType.CORRECTION || blankOwner != null && ((Organization)blankOwner.getEntity()).getAirline() != null && "AO".equals(((Organization)blankOwner.getEntity()).getAirline().getCode()))) {
                result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_VALIDATOR_NOT_DEFINED, (Object[])new Object[]{validatorCode}));
            }
            return;
        }
        SearchQuery query = AirProductHelper.createValidatorQuery((Product)prod, (boolean)false);
        if (query == null) {
            return;
        }
        List data = EntityStorage.get().search(ValidatorIndex.class, query).getData();
        if (data.isEmpty()) {
            return;
        }
        if (data.size() != 1) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_MORE_THAN_ONE_SALE_POINT, (Object[])new Object[]{validatorCode}));
            return;
        }
        ValidatorIndex index = (ValidatorIndex)data.get(0);
        EntityReference agency = prod.getReservation().getBookingFile().getAgency();
        if (agency != null && index.getAgency() != null && !MiscUtil.equals((Object)index.getAgency(), (Object)agency)) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_AGENCY_DOESNT_MATCH_VALIDATOR_CODE, (Object[])new Object[]{agency, validatorCode}));
        }
        if (index.getBlankOwner() != null && prod.getBlankOwnerRef() != null && !prod.getBlankOwnerRef().equals((Object)index.getBlankOwner())) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_BLANK_OWNER_DOESNT_MATCH_VALIDATOR_CODE, (Object[])new Object[]{prod.getBlankOwnerRef(), validatorCode}));
        }
        if (index.getSubagency() != null && !index.getSubagency().equals((Object)AirProductHelper.getSubagency((Product)prod))) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_SUBAGENCY_DOESNT_MATCH_VALIDATOR_CODE, (Object[])new Object[]{AirProductHelper.getSubagency((Product)prod), validatorCode}));
        }
        if (prod.getValidatorRef() != null) {
            if (!MiscUtil.equals((Object)prod.getValidatorRef().getNestedEntityUid(), (Object)index.getNavigationKey()) || !MiscUtil.equals((Object)prod.getValidatorRef().getUid(), (Object)index.getSource().getUid())) {
                result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_SALES_POINT_DOESNT_MATCH_VALIDATOR_CODE, (Object[])new Object[]{prod.getSalesPoint(), validatorCode}));
            }
        } else if (prod.getSalesPoint() != null && !prod.getSalesPoint().equals((Object)index.getSource())) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_SALES_POINT_DOESNT_MATCH_VALIDATOR_CODE, (Object[])new Object[]{prod.getSalesPoint(), validatorCode}));
        }
    }

    private static List<ValidationMessage> getSuValidationMessages(Product prod, String blankOwnerCode) {
        ProductStatus status;
        List<ValidationMessage> result = AirProductValidationHandler.getStandardValidationMessages(prod, blankOwnerCode);
        boolean isSticker = false;
        if (AirProductHelper.getSubagency((Product)prod) == null) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_SUBAGENCY_IS_ABSENT));
        }
        if (prod.getCarrier() == null || prod.getCarrierNumber() == null) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_CARRIER_IS_EMPTY));
        }
        if (MCOCategory.STICKER == prod.getMcoCategory()) {
            for (Product relProd : prod.getRelatedProducts()) {
                if (relProd.getStatus() != ProductStatus.SELL) continue;
                isSticker = true;
                break;
            }
        }
        if (ProductStatus.VOID != (status = prod.getStatus())) {
            for (Tax tax : prod.getTaxes()) {
                BigDecimal equivalentAmount = tax.getEquivalentAmount();
                if (equivalentAmount != null) continue;
                result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_TAX_HAS_NO_EQUIVALENT_VALUE, (Object[])new Object[]{tax.getCode()}));
            }
            BigDecimal fareRate = AirProductHelper.calculateFareRate((Product)prod);
            TransportationType transportationType = AirProductHelper.calculateTransportationType((Product)prod);
            if (BigDecimal.ZERO.compareTo(fareRate) == 0 && TransportationType.DOMESTIC != transportationType) {
                result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_FARE_RATE_INCORRECT, (Object[])new Object[]{fareRate}));
            }
            if (prod.getProductCategory() != ProductCategory.EXCESS_BAGAGE && (prod.getProductCategory() != ProductCategory.MCO || prod.getMcoCategory() != MCOCategory.GROUP_PREPAYMENT && prod.getMcoCategory() != MCOCategory.GROUP_PENALTY)) {
                if (prod.getTraveller() == null || TextUtil.isBlank((String)prod.getTraveller().getName())) {
                    result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_TRAVELLER_NOT_DEFINED));
                } else {
                    Traveller traveller = prod.getTraveller();
                    if (prod.getReservation() != null && CommonReservationGdsNameInfoHelper.containsGds((Reservation)prod.getReservation(), (GdsName)GdsName.SABRE)) {
                        String travellerNameByPassport = null;
                        if (traveller.getPassport() != null) {
                            travellerNameByPassport = String.format("%s %s %s", TextUtil.nonNullStr((String)traveller.getPassport().getLastName()), TextUtil.nonNullStr((String)traveller.getPassport().getFirstName()), TextUtil.nonNullStr((String)traveller.getPassport().getMiddleName())).trim();
                        }
                        if (!(TextUtil.isBlank(travellerNameByPassport) || TextUtil.isBlank((String)traveller.getName()) || traveller.getName().equalsIgnoreCase(travellerNameByPassport))) {
                            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_TRAVELLER_NAME_NOT_EQUAL_PASSPORT, (Object[])new Object[]{travellerNameByPassport, traveller.getName()}));
                        }
                    }
                    if (prod.getPassengerType() != null && DictHelper.isEqualsPredifinedValue((DictionaryReference)prod.getPassengerType(), (DictPredifinedValueProvider[])new DictPredifinedValueProvider[]{PassengerTypeValue.INFANT, PassengerTypeValue.INFANT_WITH_SITE, PassengerTypeValue.CHILD})) {
                        Date startDate = null;
                        if (!prod.getSegmentTariffs().isEmpty() && !((SegmentTariff)prod.getSegmentTariffs().get(0)).getSegments().isEmpty()) {
                            startDate = ((Segment)((SegmentTariff)prod.getSegmentTariffs().get(0)).getSegments().get(0)).getStartDate();
                        }
                        if (startDate != null && traveller.getBirthday() != null) {
                            if (DictHelper.isEqualsPredifinedValue((DictionaryReference)prod.getPassengerType(), (DictPredifinedValueProvider[])new DictPredifinedValueProvider[]{PassengerTypeValue.INFANT, PassengerTypeValue.INFANT_WITH_SITE})) {
                                if (ProfileHelper.getDiffYears((Date)startDate, (Date)traveller.getBirthday()) > 1) {
                                    result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_TRAVELLER_NOT_INFANT, (Object[])new Object[]{traveller.getName()}));
                                }
                            } else if (DictHelper.isEqualsPredifinedValue((DictionaryReference)prod.getPassengerType(), (DictPredifinedValueProvider[])new DictPredifinedValueProvider[]{PassengerTypeValue.CHILD}) && ProfileHelper.getDiffYears((Date)startDate, (Date)traveller.getBirthday()) > 11) {
                                result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_TRAVELLER_NOT_CHILD, (Object[])new Object[]{traveller.getName()}));
                            }
                        }
                    }
                }
            }
            if (prod.getTariffType() == TariffType.GROUP && prod.getProductCategory() == ProductCategory.MCO && prod.getMcoCategory() == MCOCategory.GROUP_PREPAYMENT && !prod.getRelatedProducts().isEmpty() && TextUtil.isBlank((String)prod.getTelexNumber())) {
                result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_TELEXNUMBER_NOT_DEFINED));
            }
            HashSet<DictionaryReference> locations = new HashSet<DictionaryReference>();
            ArrayList segments = new ArrayList();
            for (SegmentTariff segmentTariff : prod.getSegmentTariffs()) {
                segments.addAll(segmentTariff.getSegments());
            }
            if (segments.isEmpty() && (ProductCategory.MCO != prod.getProductCategory() || isSticker)) {
                result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_ROUTE_NOT_DEFINED));
            }
            HashSet<Integer> segNums = new HashSet<Integer>();
            for (Segment segment : segments) {
                if (segment.getRecordNumber() == 0) {
                    result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_RECORD_NUMBER_CANT_BE_ZERO));
                }
                if (segNums.contains(segment.getRecordNumber())) {
                    result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_RECORD_NUMBER_NOT_FOUND, (Object[])new Object[]{segment.getRecordNumber()}));
                }
                segNums.add(segment.getRecordNumber());
                if (segment.getAirline() == null) {
                    result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_NO_AIRLINE_IN_SEGMENT, (Object[])new Object[]{segment.getRecordNumber()}));
                }
                if (segment.getArriveLocation() == null) {
                    result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_NO_ARRIVETOWN, (Object[])new Object[]{segment.getRecordNumber()}));
                } else {
                    locations.add(segment.getArriveLocation());
                }
                if (segment.getDepartureLocation() == null) {
                    result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_NO_DEPARTTOWN, (Object[])new Object[]{segment.getRecordNumber()}));
                    continue;
                }
                locations.add(segment.getDepartureLocation());
            }
            for (DictionaryReference loc : locations) {
                Country country = DictHelper.findCountry((String)loc.getCode());
                if (country != null) continue;
                result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_CANT_FIND_COUNTRY_FOR_CODE, (Object[])new Object[]{loc.getCode()}));
            }
        }
        return result;
    }

    public static void validateBSPCommission(Product product, Set<ValidationMessage> msgs) {
        if (!AirProductHelper.isBSPTicket((Product)product) || product.getStatus() == ProductStatus.EXCHANGE) {
            return;
        }
        if (product.getBspCommissionValue() == null || product.getBspCommissionValue().getValue() == null || product.getBspCommissionValue().getCurrency() == null) {
            msgs.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_BSP_COMMISION_DIDNT_GET_FROM_GDS));
            return;
        }
        Collection bspCommissions = GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), null, (Set)GeneralProductHelper.bspCommissionTypes, null);
        if (bspCommissions.isEmpty()) {
            msgs.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_BSP_COMMISION_IS_MISSING));
        } else if (bspCommissions.size() > 1) {
            msgs.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_BSP_COMMISION_IS_AMBIGUOUS));
            return;
        }
        boolean productBspCommissionIsZero = BigDecimal.ZERO.compareTo(product.getBspCommissionValue().getValue()) == 0;
        BigDecimal calculateBspValue = AirProductHelper.calculateCommissionsEquivalentValue((Collection)bspCommissions);
        Money calculateBspMoney = MoneyHelper.sum((Collection)bspCommissions.stream().map(BaseCommission::getAmount).filter(Objects::nonNull).collect(Collectors.toList()));
        boolean calculateBspCommissionIsZero = calculateBspValue == null || calculateBspValue.compareTo(BigDecimal.ZERO) == 0;
        BigDecimal productBspRate = product.getBspCommissionRate() != null ? BigDecimal.valueOf(product.getBspCommissionRate()) : null;
        BigDecimal calculateBspRate = AirProductHelper.calculateCommissionsRate((Collection)bspCommissions, (boolean)false);
        if (!(calculateBspRate == null || productBspRate != null || productBspCommissionIsZero && calculateBspCommissionIsZero)) {
            msgs.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_PERCENT_ISNT_FIX));
            return;
        }
        if (!(bspCommissions.isEmpty() || calculateBspRate != null || productBspRate == null || productBspCommissionIsZero && calculateBspCommissionIsZero)) {
            msgs.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_FIX_ISNT_PERCENT));
            return;
        }
        DecimalFormat priceFormat = LocaleManager.get().getCurrentLocaleData().getPriceFormat();
        if (calculateBspRate == null) {
            calculateBspRate = BigDecimal.ZERO;
        }
        if (productBspRate != null && !MiscUtil.isSame((BigDecimal[])new BigDecimal[]{calculateBspRate, productBspRate})) {
            msgs.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_COMMISION_PERCENT_IS_WRONG, (Object[])new Object[]{priceFormat.format(MiscUtil.nonNull((BigDecimal)calculateBspRate)), priceFormat.format(MiscUtil.nonNull((BigDecimal)productBspRate))}));
            return;
        }
        Money productBspMoney = product.getBspCommissionValue();
        BigDecimal productBspValue = productBspMoney.getValue();
        if (calculateBspValue == null) {
            calculateBspValue = BigDecimal.ZERO;
        }
        if (!(MoneyHelper.isZero((Money)calculateBspMoney) || MoneyHelper.isZero((Money)productBspMoney) || MiscUtil.equals((Object)calculateBspMoney.getCurrency(), (Object)productBspMoney.getCurrency()))) {
            BigDecimal currencyRate = RateHelper.getCurrencyRate((String)calculateBspMoney.getCurrency(), (String)productBspMoney.getCurrency(), (Product)product, (boolean)false, new ArrayList());
            productBspValue = productBspValue.multiply(currencyRate);
            Commission bspCommission = bspCommissions.stream().findFirst().orElse(null);
            if (bspCommission != null) {
                productBspValue = RulesHelper.roundDouble((BigDecimal)productBspValue, (RoundingMode)bspCommission.getRoundingMode(), (RoundingValue)bspCommission.getRoundingValue());
            }
        }
        if (!MiscUtil.equals((Object)calculateBspValue, (Object)productBspValue)) {
            msgs.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_COMMISION_VALUE_IS_WRONG, (Object[])new Object[]{priceFormat.format(MiscUtil.nonNull((BigDecimal)calculateBspValue)), priceFormat.format(MiscUtil.nonNull((BigDecimal)productBspValue))}));
        }
    }

    public static List<ValidationMessage> validateIATARate(Product product) {
        String equivalentCurrencyCode;
        String string = equivalentCurrencyCode = product.getGdsCurrency() == null ? DictHelper.getEquivCurrency() : product.getGdsCurrency();
        if (TextUtil.isBlank((String)equivalentCurrencyCode)) {
            log.debug("equivalent currency code is not specified");
            return Collections.emptyList();
        }
        IATARateValidator rateValidator = null;
        if (!AirProductValidationHandler.isTch((EntityReference<Organization>)product.getBlankOwnerRef())) {
            if (TextUtil.isSame((String)"RUB", (String)equivalentCurrencyCode)) {
                rateValidator = product.getTariffType() == TariffType.BLOCKCHARTER || product.getTariffType() == TariffType.CHARTER ? null : RussiaIATARateChecker.getInstance();
            } else if (TextUtil.isSame((String)"UAH", (String)equivalentCurrencyCode)) {
                rateValidator = UkraineIATARateChecker.getInstance();
            } else if (TextUtil.isSame((String)"UZS", (String)equivalentCurrencyCode)) {
                rateValidator = UzsIATARateChecker.getInstance();
            }
        }
        if (rateValidator == null) {
            log.debug(String.format("no rate validator was found for currency %s", equivalentCurrencyCode));
            return Collections.emptyList();
        }
        return rateValidator.validateRate(product);
    }

    private static boolean isTch(EntityReference<Organization> blankOwnerRef) {
        EntityContainer ctr = EntityStorage.get().resolve(blankOwnerRef);
        if (ctr == null) {
            return false;
        }
        String airlineCode = ((Organization)ctr.getEntity()).getAirline() == null ? ((Organization)ctr.getEntity()).getCode() : ((Organization)ctr.getEntity()).getAirline().getCode();
        return "\u04281".equals(airlineCode);
    }

    public static abstract class IATARateValidator {
        abstract List<ValidationMessage> validateRate(Product var1);
    }

    private static abstract class BaseIATARateChecker
    extends IATARateValidator {
        private BaseIATARateChecker() {
        }

        @Override
        final List<ValidationMessage> validateRate(Product product) {
            ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
            Money baseFare = AirProductHelper.getBaseFare((Product)product);
            if (baseFare != null && baseFare.getValue() != null && baseFare.getCurrency() != null) {
                BigDecimal calculatedEquivalentFare;
                BigDecimal equivalentFare;
                boolean isUkraine;
                String gdsCurrency;
                BigDecimal rate = null;
                String string = gdsCurrency = product.getGdsCurrency() == null ? DictHelper.getEquivCurrency() : product.getGdsCurrency();
                if (baseFare.getCurrency().equals(gdsCurrency)) {
                    rate = BigDecimal.ONE;
                } else {
                    Date date = AirProductHelper.getCurrencyRateDate((Product)product);
                    if (date != null) {
                        CurrencyRate currencyRate = BookingHelper.findCurrencyRateWithIndirectChecking((String)baseFare.getCurrency(), (String)gdsCurrency, (Date)date, (CurrencyRateType)CurrencyRateType.IATA, (TariffType)product.getTariffType(), (EntityReference)product.getBlankOwnerRef(), (EntityReference)GeneralProductHelper.getSupplier((BaseProduct)product));
                        if (currencyRate != null) {
                            rate = BigDecimal.valueOf(currencyRate.getRate());
                        } else {
                            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_IATA_RATE_NOT_FOUND, (Object[])new Object[]{baseFare.getCurrency()}));
                        }
                    } else {
                        messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_IATA_RATE_DEFINE_FAILED, (Object[])new Object[]{baseFare.getCurrency()}));
                    }
                }
                DictionaryReference ukrRef = DictHelper.findCountryByName((String)"Ukraine");
                Country ukr = (Country)DictionaryCache.get().resolveReference(ukrRef);
                boolean bl = isUkraine = ukr != null && ukr.isDomestic();
                if (rate != null && (equivalentFare = AirProductHelper.getEquivalentFare((Product)product)) != null && (calculatedEquivalentFare = this.calculateEquivalentFare(baseFare.getValue(), rate)).compareTo(equivalentFare) != 0 && !isUkraine) {
                    messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_EQUIVALENT_FARES_NOT_EQUALS, (Object[])new Object[]{equivalentFare, calculatedEquivalentFare}));
                }
            }
            return messages;
        }

        protected abstract BigDecimal calculateEquivalentFare(BigDecimal var1, BigDecimal var2);
    }

    private static class UzsIATARateChecker
    extends BaseIATARateChecker {
        private static final UzsIATARateChecker rateChecker = new UzsIATARateChecker();

        private UzsIATARateChecker() {
        }

        public static UzsIATARateChecker getInstance() {
            return rateChecker;
        }

        @Override
        protected BigDecimal calculateEquivalentFare(BigDecimal baseFareValue, BigDecimal rate) {
            return MiscUtil.round((BigDecimal)baseFareValue.multiply(rate), (BigDecimal)BigDecimal.valueOf(1L));
        }
    }

    private static class UkraineIATARateChecker
    extends BaseIATARateChecker {
        private static final UkraineIATARateChecker rateChecker = new UkraineIATARateChecker();

        private UkraineIATARateChecker() {
        }

        public static UkraineIATARateChecker getInstance() {
            return rateChecker;
        }

        @Override
        protected BigDecimal calculateEquivalentFare(BigDecimal baseFareValue, BigDecimal rate) {
            return MiscUtil.ceil((BigDecimal)MiscUtil.round((BigDecimal)baseFareValue.multiply(rate), (BigDecimal)BigDecimal.valueOf(0.01)), (BigDecimal)BigDecimal.valueOf(1L));
        }
    }

    private static class RussiaIATABlockCharterRateChecker
    extends BaseIATARateChecker {
        private static final RussiaIATABlockCharterRateChecker rateChecker = new RussiaIATABlockCharterRateChecker();

        private RussiaIATABlockCharterRateChecker() {
        }

        public static RussiaIATABlockCharterRateChecker getInstance() {
            return rateChecker;
        }

        @Override
        protected BigDecimal calculateEquivalentFare(BigDecimal value, BigDecimal rate) {
            return MiscUtil.ceil((BigDecimal)value.multiply(rate), (BigDecimal)BigDecimal.ONE);
        }
    }

    private static class RussiaIATARateChecker
    extends BaseIATARateChecker {
        private static final RussiaIATARateChecker rateChecker = new RussiaIATARateChecker();

        private RussiaIATARateChecker() {
        }

        public static RussiaIATARateChecker getInstance() {
            return rateChecker;
        }

        @Override
        protected BigDecimal calculateEquivalentFare(BigDecimal value, BigDecimal rate) {
            return MiscUtil.ceil((BigDecimal)MiscUtil.round((BigDecimal)value.multiply(rate), (BigDecimal)BigDecimal.valueOf(0.01)), (BigDecimal)BigDecimal.valueOf(5L));
        }
    }
}

