/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.validation;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.DeliveryHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.server.model.handlers.validation.GeneralProductValidationHelper;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationContext;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeliveryValidationHandler
implements ProductValidationHandler<Delivery> {
    static final Logger log = LoggerFactory.getLogger(DeliveryValidationHandler.class);

    @Override
    public Class<Delivery> getProductClass() {
        return Delivery.class;
    }

    @Override
    public void validate(Delivery product, ProductValidationContext ct) throws Exception {
        List messages = product.getValidationMessages();
        MessageHelper.removeMessages((Collection)messages, (ValidationMessageCategory)ValidationMessageCategory.OTHER);
        if (ProductStatusHandler.getAllVoidStatuses().contains(DeliveryHelper.getProductStatus((Delivery)product))) {
            return;
        }
        GeneralProductValidationHelper.addFOPValidationMessages((BaseProduct)product, messages);
        messages.addAll(this.createValidationMessages(product));
    }

    List<ValidationMessage> createValidationMessages(Delivery ticket) throws Exception {
        ArrayList<ValidationMessage> result = new ArrayList<ValidationMessage>();
        if (ticket.getAgency() == null) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.DI_AGENCY_NOT_DEFINED));
        }
        if (ticket.getAgent() == null) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.DI_AGENT_NOT_DEFINED));
        }
        if (ticket.getIssueDate() == null) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.DI_ISSUE_DATE_NOT_DEFINED));
        }
        if (ticket.getStartDate() == null || ticket.getEndDate() == null) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.DI_DELIVERY_PERIOD_NOT_DEFINE));
        }
        return result;
    }
}

