/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.validation;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FopType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.AFSType;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.ReasonCodeComparisonType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationContext;
import com.gridnine.xtrip.server.model.helpers.ShipmentHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class GeneralProductValidationHelper {
    public static final Set<ProductStatus> BKG_PRODUCT_STATUSES = new HashSet<ProductStatus>(Arrays.asList(ProductStatus.BOOKING, ProductStatus.VOID_BOOKING, ProductStatus.SELL, ProductStatus.VOID));
    public static final Set<ProductStatus> TKT_PRODUCT_STATUSES = new HashSet<ProductStatus>(Arrays.asList(ProductStatus.SELL, ProductStatus.VOID));
    public static final Set<AFSType> NON_PRICING_AFS_TYPES = new HashSet<AFSType>(Arrays.asList(AFSType.DEST, AFSType.OCCL, AFSType.VALC, AFSType.CO2_EMISSIONS));
    public static final Set<AFSType> IGNORED_AFS_TYPES = new HashSet<AFSType>(Arrays.asList(AFSType.CO2_EMISSIONS));

    public static <E extends BookingFile, I extends EntityIndex<E>> void getAllValidationMessages(BaseProduct product, ProductIndexProvider<E, I> provider, List<ValidationMessage> messages, ProductValidationContext context) throws Exception {
        GeneralProductValidationHelper.addDuplicateValidationMessages(product, provider, messages, context);
        GeneralProductValidationHelper.addCommonValidationMessages(product, provider, messages);
        GeneralProductValidationHelper.addFOPValidationMessages(product, messages);
        GeneralProductValidationHelper.addStatisticsValidationMessages(product, messages);
    }

    private static void addStatisticsValidationMessages(BaseProduct product, List<ValidationMessage> messages) {
        EntityReference clientRef = product.getReservation().getBookingFile().getCustomerProfile();
        if (clientRef == null) {
            return;
        }
        EntityContainer clientCtr = EntityStorage.get().resolve(clientRef);
        if (clientCtr == null) {
            return;
        }
        Organization client = (Organization)clientCtr.getEntity();
        ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
        StatisticalData sd = handler.getStatisticalData(product);
        if (sd == null) {
            handler.newStatisticalData(product);
            sd = handler.getStatisticalData(product);
            if (sd == null) {
                return;
            }
        }
        ArrayList filledCostCodes = new ArrayList();
        sd.getTravellerCostCodes().forEach(travellerCostCodes -> filledCostCodes.addAll(travellerCostCodes.getCostCodes()));
        ProfileHelper.getNonFilledCostCodeProperties((Collection)client.getCostCodeProperties(), (Collection)client.getCostCodes(), filledCostCodes, (BaseProduct)product).stream().map(CostCodeProperties::getCategory).forEach(cat -> messages.add(GeneralProductValidationHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.STAT_MISSING_COST_CODE, cat)));
        if (product instanceof Product) {
            List afsTypes;
            Product prod = (Product)product;
            ProductStatus status = prod.getStatus();
            if (BKG_PRODUCT_STATUSES.contains(status) && !(afsTypes = StatisticsHelper.getInputableAfsTypesFromString((String)client.getAfsSettings(), (boolean)false)).isEmpty()) {
                afsTypes.forEach(type -> {
                    if (!IGNORED_AFS_TYPES.contains(type)) {
                        if (NON_PRICING_AFS_TYPES.contains(type)) {
                            if (StatisticsHelper.getNonPricingAfsValue((Product)prod, (AFSType)type) == null) {
                                messages.add(GeneralProductValidationHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.STAT_MISSING_AFS_OVERALL, type));
                            }
                        } else if (StatisticsHelper.getPricingAfsValue((Product)prod, (AFSType)type, (boolean)false) == null) {
                            messages.add(GeneralProductValidationHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.STAT_MISSING_AFS_BKG, type));
                        }
                    }
                });
                for (ReasonCodeComparisonType rcct : ReasonCodeComparisonType.values()) {
                    if (!client.getReasonCodes().stream().filter(rc -> rc.getComparisonType() == rcct).findAny().isPresent() || sd.getReasonCodes().stream().filter(rc -> rc.getComparisonType() == rcct).findAny().isPresent()) continue;
                    messages.add(GeneralProductValidationHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.STAT_MISSING_REASON_CODE, rcct));
                }
            }
            if (TKT_PRODUCT_STATUSES.contains(status) && !(afsTypes = StatisticsHelper.getInputableAfsTypesFromString((String)client.getAfsSettings(), (boolean)true)).isEmpty()) {
                afsTypes.forEach(type -> {
                    if (!NON_PRICING_AFS_TYPES.contains(type) && StatisticsHelper.getPricingAfsValue((Product)prod, (AFSType)type, (boolean)true) == null) {
                        messages.add(GeneralProductValidationHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.STAT_MISSING_AFS_TKT, type));
                    }
                });
            }
        }
    }

    public static <E extends BookingFile, I extends EntityIndex<E>> void addDuplicateValidationMessages(BaseProduct product, ProductIndexProvider<E, I> provider, List<ValidationMessage> messages, ProductValidationContext context) {
        BaseProduct oldProduct;
        ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
        List systemNumbers = handler.getProductNumbers(product);
        if (context.getPreviousVersionOfBooking() != null && (oldProduct = BookingHelper.findProductByUid((String)product.getUid(), (BookingFile)context.getPreviousVersionOfBooking())) != null && CollectionUtil.equals((Collection)systemNumbers, (Collection)handler.getProductNumbers(oldProduct), (boolean)true)) {
            return;
        }
        if (handler.hasSameSystemNumbers(product)) {
            messages.add(GeneralProductValidationHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.PH_DUPLICATE_PRODUCT, systemNumbers.stream().collect(Collectors.joining(", "))));
        }
    }

    public static <E extends BookingFile, I extends EntityIndex<E>> void addCommonValidationMessages(BaseProduct product, ProductIndexProvider<E, I> provider, List<ValidationMessage> messages) {
        BaseProduct previousProduct;
        ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
        TicketType ticketType = handler.getTicketType(product);
        if (provider.hasTicketType() && ticketType == null) {
            messages.add(GeneralProductValidationHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATI_TICKET_TYPE_NOT_DEFINED, handler.getProductNumbers(product)));
        }
        if (handler.findIssueDate(product) == null) {
            messages.add(GeneralProductValidationHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATI_ISSUE_DATE_NOT_DEFINED, new Object[0]));
        }
        if (handler.getStatus(product) == null) {
            messages.add(GeneralProductValidationHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATVH_PRODUCT_STATUS_UNDEFINED, new Object[0]));
        }
        if (ticketType != TicketType.EXTERNAL && provider.hasBlankOwner() && handler.getBlankOwner(product) == null) {
            messages.add(GeneralProductValidationHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATI_BLANKOWNER_NOT_DEFINED, new Object[0]));
        }
        if (GeneralProductHelper.getAgency((BaseProduct)product) == null) {
            messages.add(GeneralProductValidationHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATI_AGENCY_NOT_DEFINED, new Object[0]));
        }
        if (provider.hasSubagency() && GeneralProductHelper.getSubagency((BaseProduct)product) == null) {
            messages.add(GeneralProductValidationHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATI_SUBAGENCY_NOT_DEFINED, new Object[0]));
        }
        if (ProductStatusHandler.getAllVoidStatuses().contains(handler.getStatus(product))) {
            if (ShipmentHelper.hasRelatedShipment(product)) {
                messages.add(GeneralProductValidationHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.GPVH_VOIDED_TICKET_IN_SHIPMENT, new Object[0]));
            }
            return;
        }
        if (provider.hasIssuingAgent() && handler.findIssuingAgent(product) == null) {
            EntityReference agency = GeneralProductHelper.getAgency((BaseProduct)product);
            EntityReference subagency = GeneralProductHelper.getSubagency((BaseProduct)product);
            if (subagency != null && !subagency.equals((Object)agency)) {
                messages.add(GeneralProductValidationHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.PRODUCT_MISSING_ISSUING_AGENT_SUBAGENCY, new Object[0]));
            } else {
                messages.add(GeneralProductValidationHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.PRODUCT_MISSING_ISSUING_AGENT, new Object[0]));
            }
        }
        if (provider.hasEquivalentFare() && handler.getEquivalentFare(product) == null) {
            messages.add(GeneralProductValidationHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATI_EQUIVALENT_FARE_NOT_DEFINED, new Object[0]));
        }
        if (handler.getStatus(product) == ProductStatus.REFUND && (previousProduct = handler.getPreviousProduct(product)) != null) {
            VatAmount productPrice = handler.calculateProductPrice(product, ContractType.CLIENT);
            VatAmount previousProductPrice = handler.calculateProductPrice(previousProduct, ContractType.CLIENT);
            if (productPrice != null && previousProductPrice != null && previousProductPrice.getTotal().negate().compareTo(productPrice.getTotal()) > 0) {
                messages.add(GeneralProductValidationHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.GPVH_REFUND_PRODUCT_TOTAL_GT_SELL_PRODUCT_TOTAL, new Object[0]));
            }
        }
        if (product.getReservation().getBookingFile().getAgency() == null) {
            messages.add(GeneralProductValidationHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.BOOKING_FILE_MISSING_AGENCY, new Object[0]));
        }
    }

    public static void addFOPValidationMessages(BaseProduct product, List<ValidationMessage> messages) throws Exception {
        GeneralProductValidationHelper.addFOPValidationMessages(product, true, messages);
    }

    public static void addFOPValidationMessages(BaseProduct product, boolean checkFopsAmount, List<ValidationMessage> messages) {
        Product prodCurrent;
        ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
        if (ProductStatusHandler.getAllVoidStatuses().contains(handler.getStatus(product))) {
            return;
        }
        List contractRelations = handler.getUnmodifiableContractRelations(product);
        List contractRelationsPrevious = Collections.emptyList();
        if (product instanceof Product && (prodCurrent = (Product)product).getStatus() == ProductStatus.SELL && prodCurrent.getPreviousProduct() != null && prodCurrent.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
            contractRelationsPrevious = handler.getUnmodifiableContractRelations((BaseProduct)prodCurrent.getPreviousProduct());
        }
        block0: for (GeneralProductContractRelationData contractRelation : contractRelations) {
            BigDecimal feePrice;
            ContractType contractType = GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription());
            for (GeneralProductFop fop : contractRelation.getFops()) {
                if (fop.getType() != null) continue;
                messages.add(GeneralProductValidationHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.GPVH_FOP_TYPE_MISSING, contractRelation.getDescription()));
            }
            if (contractType == ContractType.CLIENT) {
                GeneralProductValidationHelper.validateDateAndAgent(contractRelation.getFops(), product, messages);
            }
            if (!handler.isFareFopsRelevant(product)) continue;
            BigDecimal hiddenFeesTotal = GeneralProductHelper.calculateFopsHiddenFeesEquivalentValue((Collection)GeneralProductHelper.getFops((List)handler.getUnmodifiableContractRelations(product), (ContractType)contractType));
            if (checkFopsAmount) {
                BigDecimal productPrice = handler.calculateProductPrice(contractRelation, product).getTotal();
                ProductStatus status = handler.getStatus(product);
                if (status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE) {
                    productPrice = productPrice.add(hiddenFeesTotal.negate());
                    productPrice = productPrice.negate();
                } else {
                    productPrice = productPrice.add(hiddenFeesTotal);
                }
                if (contractType == ContractType.VENDOR) {
                    GeneralProductValidationHelper.checkFops(productPrice, contractRelation, GeneralProductHelper.productFopTypes, StandartValidationMessageType.GPVH_TOTAL_PRODUCT_PRICE_PAYMENT_NOT_EQUAL_TO_PRODUCT_PRICE_VENDOR, messages);
                } else {
                    GeneralProductValidationHelper.checkFops(productPrice, contractRelation, GeneralProductHelper.productFopTypes, StandartValidationMessageType.GPVH_TOTAL_PRODUCT_PRICE_PAYMENT_NOT_EQUAL_TO_PRODUCT_PRICE, messages);
                }
            }
            if ((feePrice = GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)contractRelation.getCommissions(), (Set)GeneralProductHelper.feePropertyTypes, null, null))) != null) {
                feePrice = feePrice.subtract(hiddenFeesTotal);
            }
            GeneralProductValidationHelper.checkFops(feePrice, contractRelation, GeneralProductHelper.feeFopTypes, StandartValidationMessageType.GPVH_TOTAL_CLIENT_FEES_PAYMENT_NOT_EQUAL_TO_FEES, messages);
            BigDecimal discountPrice = GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)contractRelation.getCommissions(), (Set)GeneralProductHelper.discountPropertyTypes, null, null));
            GeneralProductValidationHelper.checkFops(discountPrice, contractRelation, GeneralProductHelper.discountFopTypes, StandartValidationMessageType.GPVH_TOTAL_CLIENT_DISCOUNTS_PAYMENT_NOT_EQUAL_TO_DISCOUNTS, messages);
            for (GeneralProductContractRelationData relationPrevious : contractRelationsPrevious) {
                Collection productFopsExch;
                BigDecimal productFopValueExch;
                if (GeneralProductHelper.getContractType((EntityReference)relationPrevious.getDescription()) != GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription())) continue;
                Collection productFopsSell = GeneralProductHelper.filterFops((Collection)contractRelation.getFops(), (Set)GeneralProductHelper.productFopTypes, new HashSet<PaymentType>(Arrays.asList(PaymentType.TICKET)), null);
                BigDecimal productFopValueSell = MiscUtil.nonNull((BigDecimal)GeneralProductHelper.calculateFopsEquivalentValue((Collection)productFopsSell));
                if (MiscUtil.equals((Object)productFopValueSell, (Object)(productFopValueExch = MiscUtil.minimum((BigDecimal[])new BigDecimal[]{MiscUtil.nonNull((BigDecimal)GeneralProductHelper.calculateFopsEquivalentValue((Collection)(productFopsExch = GeneralProductHelper.filterFops((Collection)relationPrevious.getFops(), (Set)GeneralProductHelper.productFopTypes, null, null)))), contractRelation.getServiceData().getTotalPrice()})))) continue block0;
                messages.add(GeneralProductValidationHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.GPVH_FOP_TICKET_NOT_EQUAL, MiscUtil.nonNull((BigDecimal)productFopValueSell), MiscUtil.nonNull((BigDecimal)productFopValueExch), contractRelation.getDescription()));
                continue block0;
            }
        }
    }

    private static void checkFops(BigDecimal expectedAmount, GeneralProductContractRelationData contractRelation, Set<FopType> fopTypes, StandartValidationMessageType messageType, List<ValidationMessage> messages) {
        Collection productFops = GeneralProductHelper.filterFops((Collection)contractRelation.getFops(), fopTypes, null, null);
        BigDecimal productFopValue = MiscUtil.nonNull((BigDecimal)GeneralProductHelper.calculateFopsEquivalentValue((Collection)productFops));
        if (fopTypes.contains(FopType.DISCOUNT)) {
            productFopValue = productFopValue.negate();
        }
        if (!MiscUtil.equals((Object)productFopValue, (Object)expectedAmount)) {
            messages.add(GeneralProductValidationHelper.createValidationMessage((ValidationMessageType)messageType, MiscUtil.nonNull((BigDecimal)productFopValue), MiscUtil.nonNull((BigDecimal)expectedAmount), contractRelation.getDescription()));
        }
    }

    private static void validateDateAndAgent(Collection<GeneralProductFop> productFops, BaseProduct product, List<ValidationMessage> result) {
        block0: for (GeneralProductFop fop : productFops) {
            for (GeneralProductCommission comm : fop.getCommissions()) {
                if (comm.getCommissionProperties() == null || !PaymentFeeProperties.class.equals((Object)comm.getCommissionProperties().getType())) continue;
                continue block0;
            }
            if (fop.getAgent() == null && fop.getOperationDate() == null || fop.getAgent() != null && fop.getOperationDate() != null) continue;
            if (fop.getAgent() != null && fop.getOperationDate() == null) {
                result.add(GeneralProductValidationHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.GPVH_FOP_HAS_ONLY_AGENT, fop.getAgent()));
            }
            if (fop.getOperationDate() == null || fop.getAgent() != null) continue;
            EntityReference agency = GeneralProductHelper.getAgency((BaseProduct)product);
            EntityReference subagency = GeneralProductHelper.getSubagency((BaseProduct)product);
            if (subagency != null && !subagency.equals((Object)agency)) {
                result.add(GeneralProductValidationHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.GPVH_FOP_HAS_ONLY_DATE_SUBAGENCY, fop.getOperationDate()));
                continue;
            }
            result.add(GeneralProductValidationHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.GPVH_FOP_HAS_ONLY_DATE, fop.getOperationDate()));
        }
    }

    private static ValidationMessage createValidationMessage(ValidationMessageType type, Object ... params) {
        return ValidationMessageHelper.createValidationMessage((ValidationMessageType)type, (Object[])params);
    }

    public static interface ProductIndexProvider<E extends BookingFile, I extends EntityIndex<E>> {
        public Class<I> getIndexClass();

        public String getSystemNumberIndexPropertyName();

        public String getStatusIndexPropertyName();

        public String getProductTypeIndexPropertyName();

        public Collection<SearchCriterion> getAdditionalSystemNumberCriterions();

        public boolean hasEquivalentFare();

        public boolean hasTicketType();

        public boolean hasBlankOwner();

        public boolean hasSubagency();

        default public boolean hasIssuingAgent() {
            return true;
        }
    }
}

