/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.validation;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentHelper;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentIndex;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.server.model.handlers.validation.GeneralProductValidationHelper;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationContext;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsuranceAccidentValidationHandler
implements ProductValidationHandler<InsuranceAccident> {
    static final Logger log = LoggerFactory.getLogger(InsuranceAccidentValidationHandler.class);

    @Override
    public Class<InsuranceAccident> getProductClass() {
        return InsuranceAccident.class;
    }

    @Override
    public void validate(InsuranceAccident product, ProductValidationContext ctx) throws Exception {
        List messages = product.getValidationMessages();
        MessageHelper.removeMessages((Collection)messages, (ValidationMessageCategory)ValidationMessageCategory.OTHER);
        MessageHelper.removeMessages((Collection)messages, (ValidationMessageCategory)ValidationMessageCategory.STATISTICS);
        if (product.getTicketType() == TicketType.FAKE) {
            return;
        }
        GeneralProductValidationHelper.getAllValidationMessages((BaseProduct)product, new GeneralProductValidationHelper.ProductIndexProvider<BookingFile, InsuranceAccidentIndex>(){

            @Override
            public Class<InsuranceAccidentIndex> getIndexClass() {
                return InsuranceAccidentIndex.class;
            }

            @Override
            public String getSystemNumberIndexPropertyName() {
                return InsuranceAccidentIndex.Property.ticketNumber.name();
            }

            @Override
            public String getStatusIndexPropertyName() {
                return InsuranceAccidentIndex.Property.status.name();
            }

            @Override
            public String getProductTypeIndexPropertyName() {
                return InsuranceAccidentIndex.Property.ticketType.name();
            }

            @Override
            public Collection<SearchCriterion> getAdditionalSystemNumberCriterions() {
                return Collections.emptyList();
            }

            @Override
            public boolean hasEquivalentFare() {
                return true;
            }

            @Override
            public boolean hasTicketType() {
                return false;
            }

            @Override
            public boolean hasBlankOwner() {
                return true;
            }

            @Override
            public boolean hasSubagency() {
                return true;
            }
        }, messages, ctx);
        if (ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            return;
        }
        messages.addAll(this.createValidationMessages(product));
    }

    List<ValidationMessage> createValidationMessages(InsuranceAccident ticket) throws Exception {
        ArrayList<ValidationMessage> result = new ArrayList<ValidationMessage>();
        if (ticket.getAgent() == null) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.IAI_AGENT_NOT_DEFINED));
        }
        if (ticket.getPassengerType() == null) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.IAI_PASSENGER_TYPE_NOT_DEFINED));
        }
        if (InsuranceAccidentHelper.getSubagency((InsuranceAccident)ticket) == null) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.IAI_SUBAGENCY_NOT_DEFINED));
        }
        if (ticket.getSystemNumber() == null) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.IAI_SYSTEM_NUMBER_NOT_DEFINED));
        }
        if (ticket.getStatus() == ProductStatus.VOID) {
            return result;
        }
        if (ticket.getInsuranceSum() == null) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.IAI_INSURANCE_SUM_NOT_DEFINED));
        }
        return result;
    }
}

