/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.validation;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristic;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristicHelper;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristicIndex;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.server.model.handlers.validation.GeneralProductValidationHelper;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationContext;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsuranceTouristicValidationHandler
implements ProductValidationHandler<InsuranceTouristic> {
    static final Logger log = LoggerFactory.getLogger(InsuranceTouristicValidationHandler.class);

    @Override
    public Class<InsuranceTouristic> getProductClass() {
        return InsuranceTouristic.class;
    }

    @Override
    public void validate(InsuranceTouristic product, ProductValidationContext ctx) throws Exception {
        List messages = product.getValidationMessages();
        MessageHelper.removeMessages((Collection)messages, (ValidationMessageCategory)ValidationMessageCategory.OTHER);
        MessageHelper.removeMessages((Collection)messages, (ValidationMessageCategory)ValidationMessageCategory.STATISTICS);
        if (product.getTicketType() == TicketType.FAKE) {
            return;
        }
        GeneralProductValidationHelper.getAllValidationMessages((BaseProduct)product, new GeneralProductValidationHelper.ProductIndexProvider<BookingFile, InsuranceTouristicIndex>(){

            @Override
            public Class<InsuranceTouristicIndex> getIndexClass() {
                return InsuranceTouristicIndex.class;
            }

            @Override
            public String getSystemNumberIndexPropertyName() {
                return InsuranceTouristicIndex.Property.systemNumber.name();
            }

            @Override
            public String getStatusIndexPropertyName() {
                return InsuranceTouristicIndex.Property.status.name();
            }

            @Override
            public String getProductTypeIndexPropertyName() {
                return InsuranceTouristicIndex.Property.ticketType.name();
            }

            @Override
            public Collection<SearchCriterion> getAdditionalSystemNumberCriterions() {
                return Collections.emptyList();
            }

            @Override
            public boolean hasEquivalentFare() {
                return true;
            }

            @Override
            public boolean hasTicketType() {
                return true;
            }

            @Override
            public boolean hasBlankOwner() {
                return true;
            }

            @Override
            public boolean hasSubagency() {
                return true;
            }
        }, messages, ctx);
        if (ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            return;
        }
        messages.addAll(this.createValidationMessages(product));
    }

    List<ValidationMessage> createValidationMessages(InsuranceTouristic ticket) throws Exception {
        ArrayList<ValidationMessage> result = new ArrayList<ValidationMessage>();
        if (InsuranceTouristicHelper.getSupplier((InsuranceTouristic)ticket) == null) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ITI_VENDOR_NOT_DEFINED));
        }
        if (ticket.getAgent() == null) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ITI_AGENT_NOT_DEFINED));
        }
        if (ticket.getStartDate() == null) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ITI_START_DATE_NOT_DEFINED));
        }
        if (ticket.getEndDate() == null) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ITI_END_DATE_NOT_DEFINED));
        }
        if (ticket.getSystemNumber() == null) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ITI_SYSTEM_NUMBER_NOT_DEFINED));
        }
        return result;
    }
}

