/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.validation;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.MCOFees;
import com.gridnine.xtrip.common.model.booking.MCOFeesIndex;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.handlers.validation.GeneralProductValidationHelper;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationContext;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MCOFeesValidationHandler
implements ProductValidationHandler<MCOFees> {
    static final Logger log = LoggerFactory.getLogger(MCOFeesValidationHandler.class);

    @Override
    public Class<MCOFees> getProductClass() {
        return MCOFees.class;
    }

    @Override
    public void validate(MCOFees product, ProductValidationContext ctx) throws Exception {
        List messages = product.getValidationMessages();
        MessageHelper.removeMessages((Collection)messages, (ValidationMessageCategory)ValidationMessageCategory.OTHER);
        MessageHelper.removeMessages((Collection)messages, (ValidationMessageCategory)ValidationMessageCategory.STATISTICS);
        if (TextUtil.isBlank((String)product.getScn())) {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.MCOFI_SCN_NOT_DEFINED));
            return;
        }
        GeneralProductValidationHelper.getAllValidationMessages((BaseProduct)product, new GeneralProductValidationHelper.ProductIndexProvider<BookingFile, MCOFeesIndex>(){

            @Override
            public Class<MCOFeesIndex> getIndexClass() {
                return MCOFeesIndex.class;
            }

            @Override
            public String getSystemNumberIndexPropertyName() {
                return MCOFeesIndex.Property.scn.name();
            }

            @Override
            public String getStatusIndexPropertyName() {
                return MCOFeesIndex.Property.status.name();
            }

            @Override
            public String getProductTypeIndexPropertyName() {
                return MCOFeesIndex.Property.type.name();
            }

            @Override
            public Collection<SearchCriterion> getAdditionalSystemNumberCriterions() {
                return Collections.emptyList();
            }

            @Override
            public boolean hasEquivalentFare() {
                return false;
            }

            @Override
            public boolean hasTicketType() {
                return false;
            }

            @Override
            public boolean hasBlankOwner() {
                return false;
            }

            @Override
            public boolean hasSubagency() {
                return false;
            }
        }, messages, ctx);
        if (ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            return;
        }
        messages.addAll(this.createValidationMessages(product));
    }

    List<ValidationMessage> createValidationMessages(MCOFees ticket) throws Exception {
        ArrayList<ValidationMessage> result = new ArrayList<ValidationMessage>();
        if (ticket.getPaymentType() == null) {
            result.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.MCOFI_PAYMENT_TYPE_NOT_DEFINED));
        }
        return result;
    }
}

