/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.validation;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiProduct;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiProductIndex;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.server.model.handlers.validation.GeneralProductValidationHelper;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationContext;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class TaxiProductValidationHandler
implements ProductValidationHandler<TaxiProduct> {
    @Override
    public Class<TaxiProduct> getProductClass() {
        return TaxiProduct.class;
    }

    @Override
    public void validate(TaxiProduct product, ProductValidationContext ctx) throws Exception {
        List messages = product.getValidationMessages();
        MessageHelper.removeMessages((Collection)messages, (ValidationMessageCategory)ValidationMessageCategory.OTHER);
        MessageHelper.removeMessages((Collection)messages, (ValidationMessageCategory)ValidationMessageCategory.STATISTICS);
        if (product.getTicketType() == TicketType.FAKE) {
            return;
        }
        if (ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            return;
        }
        GeneralProductValidationHelper.getAllValidationMessages((BaseProduct)product, new GeneralProductValidationHelper.ProductIndexProvider<BookingFile, TaxiProductIndex>(){

            @Override
            public Class<TaxiProductIndex> getIndexClass() {
                return TaxiProductIndex.class;
            }

            @Override
            public String getSystemNumberIndexPropertyName() {
                return TaxiProductIndex.Property.systemNumber.name();
            }

            @Override
            public String getStatusIndexPropertyName() {
                return TaxiProductIndex.Property.status.name();
            }

            @Override
            public String getProductTypeIndexPropertyName() {
                return TaxiProductIndex.Property.ticketType.name();
            }

            @Override
            public Collection<SearchCriterion> getAdditionalSystemNumberCriterions() {
                return Collections.emptyList();
            }

            @Override
            public boolean hasEquivalentFare() {
                return true;
            }

            @Override
            public boolean hasTicketType() {
                return true;
            }

            @Override
            public boolean hasBlankOwner() {
                return true;
            }

            @Override
            public boolean hasSubagency() {
                return true;
            }
        }, messages, ctx);
        TaxiProductValidationHandler.getValidationMessages(product, messages);
    }

    static void getValidationMessages(TaxiProduct product, List<ValidationMessage> messages) throws Exception {
    }
}

