/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.validation;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.booking.transfers.TransferIndex;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.handlers.validation.GeneralProductValidationHelper;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationContext;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class TransferValidationHandler
implements ProductValidationHandler<Transfer> {
    @Override
    public Class<Transfer> getProductClass() {
        return Transfer.class;
    }

    @Override
    public void validate(Transfer product, ProductValidationContext ctx) throws Exception {
        List messages = product.getValidationMessages();
        MessageHelper.removeMessages((Collection)messages, (ValidationMessageCategory)ValidationMessageCategory.OTHER);
        MessageHelper.removeMessages((Collection)messages, (ValidationMessageCategory)ValidationMessageCategory.STATISTICS);
        if (product.getTicketType() == TicketType.FAKE) {
            return;
        }
        if (ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            return;
        }
        GeneralProductValidationHelper.getAllValidationMessages((BaseProduct)product, new GeneralProductValidationHelper.ProductIndexProvider<BookingFile, TransferIndex>(){

            @Override
            public Class<TransferIndex> getIndexClass() {
                return TransferIndex.class;
            }

            @Override
            public String getSystemNumberIndexPropertyName() {
                return TransferIndex.Property.systemNumber.name();
            }

            @Override
            public String getStatusIndexPropertyName() {
                return TransferIndex.Property.status.name();
            }

            @Override
            public String getProductTypeIndexPropertyName() {
                return TransferIndex.Property.ticketType.name();
            }

            @Override
            public Collection<SearchCriterion> getAdditionalSystemNumberCriterions() {
                return Collections.emptyList();
            }

            @Override
            public boolean hasEquivalentFare() {
                return true;
            }

            @Override
            public boolean hasTicketType() {
                return true;
            }

            @Override
            public boolean hasBlankOwner() {
                return true;
            }

            @Override
            public boolean hasSubagency() {
                return true;
            }
        }, messages, ctx);
        TransferValidationHandler.getValidationMessages(product, messages);
    }

    static void getValidationMessages(Transfer product, List<ValidationMessage> messages) throws Exception {
        TransferValidationHandler.checkNoDepartureCountry(product, messages);
        TransferValidationHandler.checkSystemNumber(product, messages);
    }

    static void checkNoDepartureCountry(Transfer product, List<ValidationMessage> messages) throws Exception {
        DictionaryReference startCountry = product.getStartCountry();
        if (Objects.isNull(startCountry)) {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.TRANSFER_MISSING_DEPARTURE_COUNTRY));
        }
    }

    static void checkSystemNumber(Transfer product, List<ValidationMessage> messages) {
        if (TextUtil.isBlank((String)product.getSystemNumber())) {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.TRANSFER_SYSTEM_NUMBER_NOT_DEFINED));
        }
    }
}

