/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.validation;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductIndex;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.UniversalProductMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.server.model.handlers.validation.GeneralProductValidationHelper;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationContext;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniversalProductValidationHandler
implements ProductValidationHandler<UniversalProduct> {
    final Logger log = LoggerFactory.getLogger(UniversalProductValidationHandler.class);

    @Override
    public Class<UniversalProduct> getProductClass() {
        return UniversalProduct.class;
    }

    @Override
    public void validate(final UniversalProduct product, ProductValidationContext ctx) throws Exception {
        List messages = product.getValidationMessages();
        MessageHelper.removeMessages((Collection)messages, (ValidationMessageCategory)ValidationMessageCategory.OTHER);
        MessageHelper.removeMessages((Collection)messages, (ValidationMessageCategory)ValidationMessageCategory.STATISTICS);
        if (product.getTicketType() == TicketType.FAKE) {
            return;
        }
        final UniversalProductDescription description = this.getDescription(product, messages);
        GeneralProductValidationHelper.getAllValidationMessages((BaseProduct)product, new GeneralProductValidationHelper.ProductIndexProvider<BookingFile, UniversalProductIndex>(){

            @Override
            public Class<UniversalProductIndex> getIndexClass() {
                return UniversalProductIndex.class;
            }

            @Override
            public String getSystemNumberIndexPropertyName() {
                return UniversalProductIndex.Property.ticketNumber.name();
            }

            @Override
            public String getStatusIndexPropertyName() {
                return UniversalProductIndex.Property.status.name();
            }

            @Override
            public String getProductTypeIndexPropertyName() {
                return UniversalProductIndex.Property.ticketType.name();
            }

            @Override
            public Collection<SearchCriterion> getAdditionalSystemNumberCriterions() {
                return Collections.singletonList(SearchCriterion.eq((String)UniversalProductIndex.Property.description.name(), (Object)product.getDescription()));
            }

            @Override
            public boolean hasEquivalentFare() {
                return description == null || !description.isBlankOwnerAndSupplierAreAgency();
            }

            @Override
            public boolean hasTicketType() {
                return true;
            }

            @Override
            public boolean hasBlankOwner() {
                return true;
            }

            @Override
            public boolean hasSubagency() {
                return true;
            }
        }, messages, ctx);
        if (ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            return;
        }
        messages.addAll(this.createValidationMessages(product, description));
    }

    List<ValidationMessage> createValidationMessages(UniversalProduct ticket, UniversalProductDescription description) throws Exception {
        ArrayList<ValidationMessage> result = new ArrayList<ValidationMessage>();
        if (ticket.getAgent() == null) {
            result.add(UniversalProductValidationHandler.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATI_AGENT_NOT_DEFINED, new Object[0]));
        }
        if (ticket.getSystemNumber() == null) {
            result.add(UniversalProductValidationHandler.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATI_SYSTEM_NUMBER_NOT_DEFINED, new Object[0]));
        }
        if (ticket.getStatus() == ProductStatus.VOID) {
            return result;
        }
        if (description != null && !description.isBlankOwnerAndSupplierAreAgency() && ticket.getEquivalentFare() == null) {
            result.add(UniversalProductValidationHandler.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATI_EQUIVALENT_FARE_NOT_DEFINED, new Object[0]));
        }
        return result;
    }

    private static ValidationMessage createValidationMessage(ValidationMessageType type, Object ... params) {
        return ValidationMessageHelper.createValidationMessage((ValidationMessageType)type, (Object[])params);
    }

    private UniversalProductDescription getDescription(UniversalProduct ticket, List<ValidationMessage> additionalMessages) {
        if (ticket.getDescription() == null) {
            this.log.warn(String.format("product %s: description is null", ticket.getSystemNumber()));
            additionalMessages.add(MessageHelper.createValidationMessage((ValidationMessageType)UniversalProductMessageType.UNIVERSAL_PRODUCT_DESCRIPTION_IS_NULL, null, (Object[])new Object[0]));
            return null;
        }
        try {
            EntityContainer descriptionContainer = EntityStorage.get().resolve(ticket.getDescription());
            if (descriptionContainer == null) {
                additionalMessages.add(MessageHelper.createValidationMessage((ValidationMessageType)UniversalProductMessageType.UNIVERSAL_PRODUCT_UNABLE_TO_LOAD_DESCRIPTION, null, (Object[])new Object[0]));
                this.log.warn(String.format("product %s: description %s is absent in DB", ticket.getSystemNumber(), ticket.getDescription()));
                return null;
            }
            return (UniversalProductDescription)descriptionContainer.getEntity();
        }
        catch (Exception e) {
            this.log.error("unable to resolve reference " + ticket.getDescription(), (Throwable)e);
            additionalMessages.add(MessageHelper.createValidationMessage((ValidationMessageType)UniversalProductMessageType.UNIVERSAL_PRODUCT_UNABLE_TO_LOAD_DESCRIPTION, (Throwable)e, (Object[])new Object[0]));
            return null;
        }
    }
}

