/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.validation;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.visa.VisaProduct;
import com.gridnine.xtrip.common.model.booking.visa.VisaProductIndex;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.server.model.handlers.validation.GeneralProductValidationHelper;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationContext;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class VisaProductValidationHandler
implements ProductValidationHandler<VisaProduct> {
    @Override
    public Class<VisaProduct> getProductClass() {
        return VisaProduct.class;
    }

    @Override
    public void validate(VisaProduct product, ProductValidationContext ctx) throws Exception {
        List messages = product.getValidationMessages();
        MessageHelper.removeMessages((Collection)messages, (ValidationMessageCategory)ValidationMessageCategory.OTHER);
        MessageHelper.removeMessages((Collection)messages, (ValidationMessageCategory)ValidationMessageCategory.STATISTICS);
        if (product.getTicketType() == TicketType.FAKE) {
            return;
        }
        if (ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            return;
        }
        GeneralProductValidationHelper.getAllValidationMessages((BaseProduct)product, new GeneralProductValidationHelper.ProductIndexProvider<BookingFile, VisaProductIndex>(){

            @Override
            public Class<VisaProductIndex> getIndexClass() {
                return VisaProductIndex.class;
            }

            @Override
            public String getSystemNumberIndexPropertyName() {
                return VisaProductIndex.Property.systemNumber.name();
            }

            @Override
            public String getStatusIndexPropertyName() {
                return VisaProductIndex.Property.status.name();
            }

            @Override
            public String getProductTypeIndexPropertyName() {
                return VisaProductIndex.Property.ticketType.name();
            }

            @Override
            public Collection<SearchCriterion> getAdditionalSystemNumberCriterions() {
                return Collections.emptyList();
            }

            @Override
            public boolean hasEquivalentFare() {
                return true;
            }

            @Override
            public boolean hasTicketType() {
                return true;
            }

            @Override
            public boolean hasBlankOwner() {
                return false;
            }

            @Override
            public boolean hasSubagency() {
                return true;
            }
        }, messages, ctx);
    }
}

