/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.validation;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalServiceType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.CancellationCharge;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.booking.xtriphotels.MainHotelProductIndex;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.model.validation.XtripHotelsValidationMessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.handlers.validation.GeneralProductValidationHelper;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationContext;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationHandler;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XtripHotelProductValidationHandler
implements ProductValidationHandler<HotelProduct> {
    static final Logger log = LoggerFactory.getLogger(XtripHotelProductValidationHandler.class);

    @Override
    public Class<HotelProduct> getProductClass() {
        return HotelProduct.class;
    }

    @Override
    public void validate(HotelProduct product, ProductValidationContext ct) throws Exception {
        List messages = product.getValidationMessages();
        MessageHelper.removeMessages((Collection)messages, (ValidationMessageCategory)ValidationMessageCategory.OTHER);
        if (product.getTicketType() == TicketType.FAKE) {
            return;
        }
        GeneralProductValidationHelper.addCommonValidationMessages((BaseProduct)product, new GeneralProductValidationHelper.ProductIndexProvider<BookingFile, MainHotelProductIndex>(){

            @Override
            public Class<MainHotelProductIndex> getIndexClass() {
                return MainHotelProductIndex.class;
            }

            @Override
            public String getSystemNumberIndexPropertyName() {
                return null;
            }

            @Override
            public String getStatusIndexPropertyName() {
                return null;
            }

            @Override
            public String getProductTypeIndexPropertyName() {
                return null;
            }

            @Override
            public Collection getAdditionalSystemNumberCriterions() {
                return null;
            }

            @Override
            public boolean hasEquivalentFare() {
                return true;
            }

            @Override
            public boolean hasTicketType() {
                return false;
            }

            @Override
            public boolean hasBlankOwner() {
                return true;
            }

            @Override
            public boolean hasSubagency() {
                return true;
            }
        }, messages);
        if (ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            return;
        }
        boolean checkFopsAmount = !HotelProductHelper.isPaymentInHotel((HotelProduct)product) && product.getProvider() != HotelProvider.INTERNAL;
        GeneralProductValidationHelper.addFOPValidationMessages((BaseProduct)product, checkFopsAmount, messages);
        if (product.getStatus() == null) {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_PRODUCT_STATUS_UNDEFINED));
        }
        if (product.getTariffType() == null) {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_TARIFF_TYPE_UNDEFINED));
        }
        if (product.getBlankOwnerCode() == null) {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_BLANK_OWNER_CODE_UNDEFINED));
        }
        if (product.getProvider() == null) {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_PROVIDER_UNDEFINED));
        }
        if (product.getUnholdDate() == null) {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_UNHOLD_DATE_UNDEFINED));
        }
        if (product.getTravellers().isEmpty()) {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_TRAVELLERS_EMPTY));
        }
        if (product.getHotelCountry() == null) {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_HOTEL_COUNTRY_EMPTY));
        }
        if (product.getHotelLocation() == null) {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_HOTEL_LOCATION_EMPTY));
        } else if (DictHelper.resolve((DictionaryReference)product.getHotelLocation()) == null) {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_HOTEL_LOCATION_NO_DICT));
        }
        if (product.getHotelName() == null) {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_HOTEL_NAME_EMPTY));
        }
        if (product.getHotelAddress() == null) {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_HOTEL_ADDRESS_EMPTY));
        }
        if (product.getHotelFax() == null) {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_HOTEL_FAX_EMPTY));
        }
        if (product.getProvider() == HotelProvider.INTERNAL && product.getHotelPhone() == null) {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_HOTEL_PHONE_EMPTY));
        }
        if (product.isCancellable() && HotelProductHelper.getAvailableCancellationCharges((HotelProduct)product).isEmpty()) {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_CANCELLATION_CHARGES_EMPTY));
        }
        for (CancellationCharge charge : product.getCancellationCharges()) {
            if (charge.getPenalty() != null || product.getProvider() == HotelProvider.SABRE || CommonReservationGdsNameInfoHelper.containsGds((Reservation)product.getReservation(), (GdsName)GdsName.SABRE)) continue;
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_CANCELLATION_CHARGES_PENALTY_EMPTY));
        }
        if (product.getRooms().isEmpty()) {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_ROOMS_EMPTY));
        }
        for (Room room : product.getRooms()) {
            if (room.getRoomName() == null) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_ROOM_NAME_EMPTY));
            }
            if (room.getRoomSize() == null) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_ROOM_SIZE_EMPTY));
            }
            if (room.getHotelCardNumber() == null) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_ROOM_HOTEL_CARD_NUMBER_EMPTY));
            }
            if (room.getCheckInDate() == null) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_ROOM_CHECK_IN_DATE_EMPTY));
            }
            if (room.getCheckOutDate() == null) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_ROOM_CHECK_OUT_DATE_EMPTY));
            }
            if (room.getBaseRate() == null) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_ROOM_BASE_RATE_EMPTY));
            }
            if (room.getEquivalentPrice() == null) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_ROOM_EQ_PRICE_EMPTY));
            }
            if (room.getBasePrice() == null) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_ROOM_BASE_PRICE_EMPTY));
            }
            if (room.getBasePrice() != null && room.getBasePrice().getCurrency() == null) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_ROOM_BASE_PRICE_CURRENCY_EMPTY));
            }
            if (room.getNumberOfPeople() == null || room.getNumberOfPeople() == 0) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_ROOM_NUMBER_OF_PEOPLE_EMPTY));
            }
            if (room.getCheckInDate() != null && room.getCheckOutDate() != null && room.getCheckInDate().after(room.getCheckOutDate())) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_CHECK_IN_LATER_CHECK_OUT));
            }
            if (room.getCheckInTime() == null) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_ROOM_CHECK_IN_TIME_EMPTY));
            }
            if (room.getCheckOutTime() == null) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_ROOM_CHECK_OUT_TIME_EMPTY));
            }
            if (MiscUtil.equals((Object)room.getCheckInTime(), (Object)room.getStandardCheckInTime(), (boolean)false) && product.getAdditionalServices().stream().anyMatch(service -> service.getType() == AdditionalServiceType.EARLIER_CHECKIN)) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_ROOM_WRONG_CHECK_IN_TIME));
            }
            if (!MiscUtil.equals((Object)room.getCheckOutTime(), (Object)room.getStandardCheckOutTime(), (boolean)false) || !product.getAdditionalServices().stream().anyMatch(service -> service.getType() == AdditionalServiceType.LATER_CHECKOUT)) continue;
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_ROOM_WRONG_CHECK_OUT_TIME));
        }
    }
}

