/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBooking;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.ArchivedEntity;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Anonymizer {
    public static Anonymizer getInstance() {
        return (Anonymizer)Environment.getPublished(Anonymizer.class);
    }

    public void anonymizePerson(EntityReference<Person> ref) throws Exception {
        LockUtil.lock(ref, ctr -> {
            this.anonymize((Person)ctr.getEntity());
            this.saveWithoutNewVersion((EntityContainer<? extends BaseEntity>)ctr);
            List<VersionInfo> oldVersionInfos = this.oldVersionInfos(ref);
            EntityStorage storage = EntityStorage.get();
            String uid = ctr.getUid();
            for (VersionInfo versionInfo : oldVersionInfos) {
                Integer versionNumber = versionInfo.getVersionNumber();
                EntityContainer version = storage.load(Person.class, uid, versionNumber);
                this.anonymize((Person)version.getEntity());
                this.saveWithoutNewVersion((EntityContainer<? extends BaseEntity>)version);
            }
        });
    }

    protected void anonymize(Person person) {
        person.setValue("lastName", null);
        person.setValue("firstName", null);
        person.setValue("middleName", null);
        person.setValue("secondName", null);
        person.setOldLastName(null);
        person.setOldFirstName(null);
        person.setGender(null);
        person.setBirthday(null);
        person.setTitle(null);
        person.setSignatureImage(null);
        person.getCommunications().clear();
        person.getSabrePhoneContacts().clear();
        person.getSabreEmailContacts().clear();
        person.getPassports().clear();
        person.getEmployments().clear();
        person.getAddresses().clear();
        person.setCwtProfileData(null);
        person.getVisas().clear();
        person.getBankAccounts().clear();
        person.getAirlineBonusCards().clear();
        person.getHotelBonusCards().clear();
        person.getCarBonusCards().clear();
        person.getRailwayBonusCards().clear();
        person.getCostCodes().clear();
        person.getMetadata().clear();
        person.getSabreAdditionalProfileLines().clear();
        person.getSabreProfilesUniqueIDs().clear();
        person.getSabreProfilesPccSettings().clear();
        person.getSabreProfilesMessages().clear();
        person.getSabreProfilesLoadMessages().clear();
    }

    public void anonymizeOrderInArchive(EntityReference<ArchivedBooking> ref) throws Exception {
        LockUtil.lock(ref, ctr -> {
            ArchivedBooking archivedBooking = (ArchivedBooking)ctr.getEntity();
            ArchivedEntity archivedEntity = archivedBooking.getBooking();
            for (EntityContainer v : archivedEntity.getVersions()) {
                this.anonymize((BookingFile)v.getEntity());
            }
            this.saveWithoutNewVersion((EntityContainer<? extends BaseEntity>)ctr);
        });
    }

    public void anonymizeOrder(EntityReference<BookingFile> ref) throws Exception {
        LockUtil.lock(ref, ctr -> {
            this.anonymize((BookingFile)ctr.getEntity());
            this.saveWithoutNewVersion((EntityContainer<? extends BaseEntity>)ctr);
            List<VersionInfo> oldVersionInfos = this.oldVersionInfos(ref);
            EntityStorage storage = EntityStorage.get();
            String uid = ctr.getUid();
            for (VersionInfo versionInfo : oldVersionInfos) {
                Integer versionNumber = versionInfo.getVersionNumber();
                EntityContainer version = storage.load(BookingFile.class, uid, versionNumber);
                this.anonymize((BookingFile)version.getEntity());
                this.saveWithoutNewVersion((EntityContainer<? extends BaseEntity>)version);
            }
        });
    }

    protected void anonymize(BookingFile bookingFile) {
        for (Traveller traveller : bookingFile.getTravellers()) {
            this.anonymize(traveller);
        }
        this.anonymize(bookingFile.getCustomer());
    }

    public void anonymizeCustomer(EntityReference<BookingFile> ref) throws Exception {
        LockUtil.lock(ref, ctr -> {
            this.anonymize(((BookingFile)ctr.getEntity()).getCustomer());
            this.saveWithoutNewVersion((EntityContainer<? extends BaseEntity>)ctr);
            List<VersionInfo> oldVersionInfos = this.oldVersionInfos(ref);
            EntityStorage storage = EntityStorage.get();
            String uid = ctr.getUid();
            for (VersionInfo versionInfo : oldVersionInfos) {
                Integer versionNumber = versionInfo.getVersionNumber();
                EntityContainer version = storage.load(BookingFile.class, uid, versionNumber);
                this.anonymize(((BookingFile)version.getEntity()).getCustomer());
                this.saveWithoutNewVersion((EntityContainer<? extends BaseEntity>)version);
            }
        });
    }

    public void anonymizeCustomerInArchive(EntityReference<ArchivedBooking> ref) throws Exception {
        LockUtil.lock(ref, ctr -> {
            ArchivedBooking archivedBooking = (ArchivedBooking)ctr.getEntity();
            ArchivedEntity archivedEntity = archivedBooking.getBooking();
            for (EntityContainer v : archivedEntity.getVersions()) {
                this.anonymize(((BookingFile)v.getEntity()).getCustomer());
            }
            this.saveWithoutNewVersion((EntityContainer<? extends BaseEntity>)ctr);
        });
    }

    protected void anonymize(Customer customer) {
        customer.setName(null);
        customer.setCompanyName(null);
        this.anonymize(customer.getPassport());
        customer.getAddresses().clear();
        customer.getCommunications().clear();
        customer.getAirlineBonusCards().clear();
    }

    public void anonymizeTraveller(EntityReference<BookingFile> ref, int versionNumber, String travellerUid) throws Exception {
        LockUtil.lock(ref, ctr -> {
            EntityStorage storage = EntityStorage.get();
            EntityContainer version = storage.load(BookingFile.class, ctr.getUid(), Integer.valueOf(versionNumber));
            Traveller pattern = this.anonymizeTraveller((EntityContainer<BookingFile>)version, travellerUid);
            this.saveWithoutNewVersion((EntityContainer<? extends BaseEntity>)version);
            if (pattern != null) {
                List allVersionInfos = LogicalStorage.get().getEntityStorage().getVersionInfos(ref);
                for (VersionInfo versionInfo : allVersionInfos) {
                    if (versionNumber == versionInfo.getVersionNumber()) continue;
                    Integer vn = versionInfo.getVersionNumber();
                    EntityContainer version2 = storage.load(BookingFile.class, ctr.getUid(), vn);
                    this.anonymizeTraveller((EntityContainer<BookingFile>)version2, pattern);
                    this.saveWithoutNewVersion((EntityContainer<? extends BaseEntity>)version2);
                }
            }
        });
    }

    public void anonymizeTravellerInArchive(EntityReference<ArchivedBooking> ref, int versionNumber, String travellerUid) throws Exception {
        LockUtil.lock(ref, ctr -> {
            ArchivedBooking archivedBooking = (ArchivedBooking)ctr.getEntity();
            ArchivedEntity archivedEntity = archivedBooking.getBooking();
            Traveller pattern = null;
            for (EntityContainer v : archivedEntity.getVersions()) {
                if (versionNumber != v.getVersionInfo().getVersionNumber()) continue;
                pattern = this.anonymizeTraveller((EntityContainer<BookingFile>)v, travellerUid);
                break;
            }
            if (pattern != null) {
                for (EntityContainer v : archivedEntity.getVersions()) {
                    if (versionNumber == v.getVersionInfo().getVersionNumber()) continue;
                    this.anonymizeTraveller((EntityContainer<BookingFile>)v, pattern);
                }
            }
            this.saveWithoutNewVersion((EntityContainer<? extends BaseEntity>)ctr);
        });
    }

    protected Traveller anonymizeTraveller(EntityContainer<BookingFile> ctr, String travellerUid) {
        Traveller result = null;
        for (Traveller traveller : ((BookingFile)ctr.getEntity()).getTravellers()) {
            if (!travellerUid.equals(traveller.getUid())) continue;
            try {
                result = (Traveller)XCloneHelper.clone((XCloneable)traveller);
            }
            catch (Exception e) {
                IncidentsLog.reportException((String)"failed to clone Traveller object", (Throwable)e);
            }
            this.anonymize(traveller);
            break;
        }
        return result;
    }

    protected void anonymizeTraveller(EntityContainer<BookingFile> ctr, Traveller pattern) {
        Object result = null;
        for (Traveller traveller : ((BookingFile)ctr.getEntity()).getTravellers()) {
            if (!this.isSame(pattern, traveller)) continue;
            this.anonymize(traveller);
            break;
        }
    }

    protected boolean isSame(Traveller t1, Traveller t2) {
        return false;
    }

    protected void anonymize(Traveller traveller) {
        traveller.setBirthday(null);
        traveller.setGender(null);
        traveller.setTitle(null);
        traveller.setName(null);
        traveller.setCyrillicName(null);
        traveller.setNameInGds(null);
        this.anonymize(traveller.getPassport());
        traveller.setPassenger(null);
        traveller.setPrototype(null);
        traveller.getCommunications().clear();
        traveller.setCode(null);
        traveller.setRailwayBonusCard(null);
        traveller.setCard(null);
        traveller.getAirlineBonusCards().clear();
    }

    protected void anonymize(Passport passport) {
        passport.setExpired(null);
        passport.setFirstName(null);
        passport.setLastName(null);
        passport.setMiddleName(null);
        passport.setSecondName(null);
        passport.setIssueCity(null);
        passport.setIssued(null);
        passport.setIssueOrganization(null);
        passport.setNumber(null);
        passport.setOriginCountry(null);
        passport.setBirthPlace(null);
        passport.setType(null);
        passport.setRemarks(null);
        passport.setBirthday(null);
        passport.setGender(null);
    }

    protected <T extends BaseEntity> List<VersionInfo> oldVersionInfos(EntityReference<T> ref) {
        List<VersionInfo> result;
        List versionInfos = LogicalStorage.get().getEntityStorage().getVersionInfos(ref);
        int numOfVersions = versionInfos.size();
        if (numOfVersions > 1) {
            result = new ArrayList<VersionInfo>(numOfVersions - 1);
            for (int i = 1; i < numOfVersions; ++i) {
                result.add((VersionInfo)versionInfos.get(i));
            }
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    protected void saveWithoutNewVersion(EntityContainer<? extends BaseEntity> ctr) {
        EntityStorage.get().save(ctr, false);
    }
}

