/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers;

import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.FopComponentType;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import java.util.Objects;

public class BillingItemHelper {
    public static boolean isTax(BillingItem item) {
        return item.getFopComponents().stream().map(EntityStorageHelper::resolve).filter(Objects::nonNull).anyMatch(f -> f.getType().equals((Object)FopComponentType.TAXES));
    }

    public static boolean isFee(BillingItem item) {
        return item.getServiceType().equals((Object)ServiceType.FEE);
    }

    public static String getTravellerName(BillingItem item) {
        Traveller traveller = (Traveller)EntityStorageHelper.resolve((NestedEntityReference)item.getTraveller());
        if (traveller != null) {
            return traveller.getName();
        }
        return null;
    }
}

