/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.ProductSearchIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBooking;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBookingHelper;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedProductIndex;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageDeleteParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSaveParameters;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.ValidatorIndex;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlank;
import com.gridnine.xtrip.common.model.system.ArchivedEntity;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.db.storage.common.StorageHelper;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import com.gridnine.xtrip.server.model.helpers.StockControlDao;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BookingDao {
    public static List<BookingFileIndex> findBookingFileIdxs(String bookingNumber) {
        if (TextUtil.isBlank((String)bookingNumber)) {
            return Collections.emptyList();
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BookingFileIndex.Property.fullNumber.name(), (Object)bookingNumber));
        return EntityStorage.get().search(BookingFileIndex.class, query).getData();
    }

    public static EntityContainer<BookingFile> findBookingFileByPnrAndReservationCreateDate(String pnr, Date creationDate) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(com.gridnine.xtrip.common.model.helpers.SearchQueryHelper.getBookingRecordLocatorSearchCriterion((String)pnr));
        List bookingFiles = StorageHelper.getEntityContainers((SearchQuery)query, BookingFileIndex.class);
        for (EntityContainer bookingFile : bookingFiles) {
            for (Reservation reservation : ((BookingFile)bookingFile.getEntity()).getReservations()) {
                if (!reservation.getProducts().isEmpty() && reservation.getProducts().stream().allMatch(p -> ProductHandler.of((BaseProduct)p).getTicketType(p) == TicketType.CORRECTION) || !CommonReservationGdsNameInfoHelper.containsRecordLocator((Reservation)reservation, (String)pnr) || MiscUtil.getDaysBetween((Date)reservation.getResDate(), (Date)creationDate) > 1L) continue;
                return bookingFile;
            }
        }
        return null;
    }

    public static EntityContainer<BookingFile> findBookingFileByPnrAndTicketNumbers(String pnr, Collection<String> ticketNumbers) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(com.gridnine.xtrip.common.model.helpers.SearchQueryHelper.getBookingRecordLocatorSearchCriterion((String)pnr));
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrContainsStringCriterion((String)BookingFileIndex.Property.ticketNumbers.name(), ticketNumbers));
        List bookingFiles = StorageHelper.getEntityContainers((SearchQuery)query, BookingFileIndex.class).stream().filter(bf -> {
            Reservation reservation = BookingHelper.findReservation((BookingFile)((BookingFile)bf.getEntity()), (String)pnr);
            return reservation != null && (reservation.getProducts().isEmpty() || reservation.getProducts().stream().anyMatch(p -> ProductHandler.of((BaseProduct)p).getTicketType(p) != TicketType.CORRECTION && CollectionUtil.containAtLeastOneCommonElement((Collection)ProductHandler.of((BaseProduct)p).getProductNumbers(p), (Collection)ticketNumbers)));
        }).collect(Collectors.toList());
        return (EntityContainer)CollectionUtil.head(bookingFiles);
    }

    public static EntityContainer<BookingFile> findBookingFile(String bookingNumber) throws Exception {
        if (TextUtil.isBlank((String)bookingNumber)) {
            return null;
        }
        List<EntityContainer<BookingFile>> lst = BookingDao.load(BookingDao.findBookingFileIdxs(bookingNumber));
        if (lst.isEmpty() && bookingNumber.length() > 7) {
            bookingNumber = bookingNumber.substring(bookingNumber.length() - 7);
            lst = BookingDao.load(BookingDao.findBookingFileIdxs(bookingNumber));
        }
        return (EntityContainer)CollectionUtil.head(lst);
    }

    private static List<EntityContainer<BookingFile>> load(List<BookingFileIndex> idxs) {
        return idxs.stream().map(idx -> EntityStorage.get().resolve(idx.getSource())).filter(ctr -> ctr != null).collect(Collectors.toList());
    }

    public static ProductSearchResult findProductByTraveller(String pnr, Traveller traveller, ProductStatus status) throws Exception {
        if (traveller == null || TextUtil.isBlank((String)pnr)) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(com.gridnine.xtrip.common.model.helpers.SearchQueryHelper.getBookingRecordLocatorSearchCriterion((String)pnr));
        ArrayList<ProductSearchResult> result = new ArrayList<ProductSearchResult>();
        for (EntityContainer ctr : StorageHelper.getEntityContainers((SearchQuery)query, BookingFileIndex.class)) {
            for (Reservation res : ((BookingFile)ctr.getEntity()).getReservations()) {
                for (BaseProduct bp : res.getProducts()) {
                    Product product;
                    if (!(bp instanceof Product) || (product = (Product)bp).getTicketType() == TicketType.CORRECTION || status != null && product.getStatus() != status || product.getTraveller() == null) continue;
                    if (!TextUtil.isBlank((String)traveller.getName()) && !TextUtil.isBlank((String)product.getTraveller().getName()) && traveller.getName().trim().equalsIgnoreCase(product.getTraveller().getName().trim())) {
                        result.add(new ProductSearchResult((BookingFile)ctr.getEntity(), (BaseProduct)product, res, (EntityContainer<BookingFile>)ctr, false));
                        continue;
                    }
                    if (traveller.getPassport() == null || product.getTraveller().getPassport() == null || TextUtil.isBlank((String)product.getTraveller().getPassport().getNumber()) || TextUtil.isBlank((String)traveller.getPassport().getNumber()) || !product.getTraveller().getPassport().getNumber().trim().equalsIgnoreCase(traveller.getPassport().getNumber().trim())) continue;
                    result.add(new ProductSearchResult((BookingFile)ctr.getEntity(), (BaseProduct)product, res, (EntityContainer<BookingFile>)ctr, false));
                }
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        ProductSearchResult psr = (ProductSearchResult)result.get(0);
        psr.setUnique(result.size() == 1);
        return psr;
    }

    public static ProductSearchResult findProduct(String ticketNumber, String blankOwnerNumber, Date issueDate, ProductStatus status) throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (!TextUtil.isBlank((String)ticketNumber)) {
            properties.put(ProductSearchIndex.Property.systemNumber.name(), ticketNumber);
        }
        if (status != null) {
            properties.put(ProductSearchIndex.Property.status.name(), status);
        }
        SearchQuery query = BookingDao.createQueryInternal(properties);
        if (!TextUtil.isBlank((String)blankOwnerNumber)) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductSearchIndex.Property.blankOwnerNumber.name(), null), SearchCriterion.startsWith((String)ProductSearchIndex.Property.blankOwnerNumber.name(), (String)blankOwnerNumber)}));
        }
        if (issueDate != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(issueDate);
            cal.add(1, -1);
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)ProductSearchIndex.Property.issueDate.name(), (Object)cal.getTime()));
            cal.add(1, 2);
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)ProductSearchIndex.Property.issueDate.name(), (Object)cal.getTime()));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductSearchIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
        return BookingDao.findProductInternal(query);
    }

    public static ProductSearchResult findProduct(String ticketNumber, String blankOwnerNumber, EntityReference<Organization> subagency, Date issueDate, ProductStatus status) throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (!TextUtil.isBlank((String)ticketNumber)) {
            properties.put(ProductSearchIndex.Property.systemNumber.name(), ticketNumber);
        }
        if (!TextUtil.isBlank((String)blankOwnerNumber)) {
            properties.put(ProductSearchIndex.Property.blankOwnerNumber.name(), blankOwnerNumber);
        }
        if (subagency != null) {
            properties.put(ProductSearchIndex.Property.subagency.name(), subagency);
        }
        if (status != null) {
            properties.put(ProductSearchIndex.Property.status.name(), status);
        }
        SearchQuery query = BookingDao.createQueryInternal(properties);
        if (issueDate != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(issueDate);
            cal.add(1, -1);
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)ProductSearchIndex.Property.issueDate.name(), (Object)cal.getTime()));
            cal.add(1, 2);
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)ProductSearchIndex.Property.issueDate.name(), (Object)cal.getTime()));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductSearchIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
        return BookingDao.findProductInternal(query);
    }

    public static ProductSearchResult findProduct(String blankOwnerNumber, String ticketNumber, ProductStatus status, String travellerName, Date issueDate) throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (!TextUtil.isBlank((String)blankOwnerNumber)) {
            properties.put(ProductSearchIndex.Property.blankOwnerNumber.name(), blankOwnerNumber);
        }
        if (!TextUtil.isBlank((String)ticketNumber)) {
            properties.put(ProductSearchIndex.Property.systemNumber.name(), ticketNumber);
        }
        if (status != null) {
            properties.put(ProductSearchIndex.Property.status.name(), status);
        }
        if (travellerName != null) {
            properties.put(ProductSearchIndex.Property.travellerName.name(), travellerName);
        }
        SearchQuery query = BookingDao.createQueryInternal(properties);
        if (issueDate != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(issueDate);
            cal.add(1, -1);
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)ProductSearchIndex.Property.issueDate.name(), (Object)cal.getTime()));
            cal.add(1, 2);
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)ProductSearchIndex.Property.issueDate.name(), (Object)cal.getTime()));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductSearchIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
        return BookingDao.findProductInternal(query);
    }

    public static ProductSearchResult findProduct(DictionaryReference<BlankType> blankType, String ticketNumber, Date issueDate) throws Exception {
        return BookingDao.findProduct(blankType, null, ticketNumber, issueDate);
    }

    public static ProductSearchResult findProduct(DictionaryReference<BlankType> blankType, String carrierNumber, String ticketNumber, Date issueDate) throws Exception {
        return BookingDao.findProduct(blankType, carrierNumber, ticketNumber, issueDate, null);
    }

    public static ProductSearchResult findProduct(DictionaryReference<BlankType> blankType, String carrierNumber, String ticketNumber, Date issueDate, ProductStatus status) throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (TextUtil.isBlank((String)ticketNumber)) {
            return null;
        }
        properties.put(ProductSearchIndex.Property.systemNumber.name(), ticketNumber);
        if (status != null) {
            properties.put(ProductSearchIndex.Property.status.name(), status);
        }
        SearchQuery query = BookingDao.createQueryInternal(properties);
        if (blankType != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductSearchIndex.Property.blankType.name(), null), SearchCriterion.eq((String)ProductSearchIndex.Property.blankType.name(), blankType)}));
        }
        if (carrierNumber != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductSearchIndex.Property.carrierNumber.name(), null), SearchCriterion.eq((String)ProductSearchIndex.Property.carrierNumber.name(), (Object)carrierNumber)}));
        }
        if (issueDate != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(issueDate);
            cal.add(1, -1);
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)ProductSearchIndex.Property.issueDate.name(), (Object)cal.getTime()));
            cal.add(1, 2);
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)ProductSearchIndex.Property.issueDate.name(), (Object)cal.getTime()));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductSearchIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
        return BookingDao.findProductInternal(query);
    }

    public static ProductSearchResult findProductByPnr(String pnr, Date issueDate, long threshold) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(com.gridnine.xtrip.common.model.helpers.SearchQueryHelper.getRecordLocatorSearchCriterionForProductSearchIndex((String)pnr));
        if (issueDate != null) {
            Date lowerLim = new Date(issueDate.getTime() - threshold);
            Date upperLim = new Date(issueDate.getTime() + threshold);
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)ProductSearchIndex.Property.issueDate.name(), (Object)lowerLim));
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)ProductSearchIndex.Property.issueDate.name(), (Object)upperLim));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductSearchIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
        return BookingDao.findProductInternal(query);
    }

    public static Date findLowerLimitSearchDateForIssueDate(Date issueDate, int periodInMonths) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(issueDate != null ? issueDate : new Date());
        cal.add(2, -1 * periodInMonths);
        return cal.getTime();
    }

    public static ProductSearchResult findProductByPnrAfterDate(String pnr, Date issueDateLowerLimit) throws Exception {
        if (issueDateLowerLimit == null) {
            return BookingDao.findProductByPnr(pnr, null, 0L);
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(com.gridnine.xtrip.common.model.helpers.SearchQueryHelper.getRecordLocatorSearchCriterionForProductSearchIndex((String)pnr));
        query.getCriteria().getCriterions().add(SearchCriterion.ge((String)ProductSearchIndex.Property.issueDate.name(), (Object)issueDateLowerLimit));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductSearchIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
        return BookingDao.findProductInternal(query);
    }

    public static ProductSearchResult findProductByPnrAndAirlineLocator(String pnr, List<String> airlineLocators, Date lowerLimDate) throws Exception {
        if (airlineLocators.isEmpty()) {
            return BookingDao.findProductByPnrAfterDate(pnr, lowerLimDate);
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(com.gridnine.xtrip.common.model.helpers.SearchQueryHelper.getRecordLocatorSearchCriterionForProductSearchIndex((String)pnr));
        SearchCriterion[] criteria = new SearchCriterion[airlineLocators.size()];
        for (int i = 0; i < airlineLocators.size(); ++i) {
            criteria[i] = SearchCriterion.contains((String)ProductSearchIndex.Property.airlineLocators.name(), (Object)airlineLocators.get(i));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criteria));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductSearchIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
        return BookingDao.findProductInternal(query);
    }

    public static ProductSearchResult findProductByTravellerAndDate(String traveller, Date issueDate, long threshold, ProductStatus status) throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (traveller != null) {
            properties.put(ProductSearchIndex.Property.travellerName.name(), traveller);
        }
        if (status != null) {
            properties.put(ProductSearchIndex.Property.status.name(), status);
        }
        SearchQuery query = BookingDao.createQueryInternal(properties);
        if (issueDate != null) {
            Date lowerLim = new Date(issueDate.getTime() - threshold);
            Date upperLim = new Date(issueDate.getTime() + threshold);
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)ProductSearchIndex.Property.issueDate.name(), (Object)lowerLim));
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)ProductSearchIndex.Property.issueDate.name(), (Object)upperLim));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductSearchIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
        return BookingDao.findProductInternal(query);
    }

    public static ProductSearchResult findProductByScnAndDate(String scn, Date issueDate, long threshold, ProductStatus status) throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (status != null) {
            properties.put(ProductSearchIndex.Property.status.name(), status);
        }
        SearchQuery query = BookingDao.createQueryInternal(properties);
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductSearchIndex.Property.ticketType.name(), (Object)TicketType.OWN), SearchCriterion.eq((String)ProductSearchIndex.Property.ticketType.name(), null)}));
        if (!TextUtil.isBlank((String)scn)) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductSearchIndex.Property.scn.name(), (Object)scn));
        }
        if (issueDate != null) {
            Date lowerLim = new Date(issueDate.getTime() - threshold);
            Date upperLim = new Date(issueDate.getTime() + threshold);
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)ProductSearchIndex.Property.issueDate.name(), (Object)lowerLim));
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)ProductSearchIndex.Property.issueDate.name(), (Object)upperLim));
        }
        return BookingDao.findProductInternal(query);
    }

    public static Collection<Reservation> getReservationsByPnr(String pnr, GdsName gdsName) throws Exception {
        ArrayList<Reservation> result = new ArrayList<Reservation>();
        EntityContainer<BookingFile> bfc = BookingDao.findBfcByPnr(pnr);
        if (bfc != null) {
            BookingFile bf = (BookingFile)bfc.getEntity();
            for (Reservation reservation : bf.getReservations()) {
                if (!CommonReservationGdsNameInfoHelper.containsRecordLocator((Reservation)reservation, (String)pnr, (GdsName)gdsName)) continue;
                result.add(reservation);
            }
        }
        return result;
    }

    public static EntityContainer<BookingFile> findBfcByPnr(String pnr) throws Exception {
        return BookingDao.findBookingByPnr(pnr, null, 0L);
    }

    public static EntityContainer<BookingFile> findBookingByPnr(String pnr, Date approximateBookingDate) throws Exception {
        return BookingDao.findBookingByPnr(pnr, approximateBookingDate, 31536000000L);
    }

    public static EntityContainer<BookingFile> findBookingByPnr(String pnr, Date approximateBookingDate, long treshhold) throws Exception {
        if (null == pnr) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(com.gridnine.xtrip.common.model.helpers.SearchQueryHelper.getBookingRecordLocatorSearchCriterion((String)pnr));
        if (approximateBookingDate != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)BookingFileIndex.Property.createDate.name(), (Object)new Date(approximateBookingDate.getTime() + treshhold)));
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)BookingFileIndex.Property.createDate.name(), (Object)new Date(approximateBookingDate.getTime() - treshhold)));
        }
        return EntityStorage.get().search(BookingFileIndex.class, query).getData().stream().map(index -> EntityStorage.get().resolve(index.getSource())).filter(EntityStorageHelper::nonEmpty).filter(bf -> {
            Reservation reservation = BookingHelper.findReservation((BookingFile)((BookingFile)bf.getEntity()), (String)pnr);
            if (reservation == null) {
                return false;
            }
            return reservation.getProducts().isEmpty() || reservation.getProducts().stream().anyMatch(p -> ProductHandler.of((BaseProduct)p).getTicketType(p) != TicketType.CORRECTION);
        }).findFirst().orElse(null);
    }

    public static List<EntityContainer<BookingFile>> getBookingListByPnr(String pnr) throws Exception {
        if (pnr == null) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(com.gridnine.xtrip.common.model.helpers.SearchQueryHelper.getBookingRecordLocatorSearchCriterion((String)pnr));
        return EntityStorage.get().search(BookingFileIndex.class, query).getData().stream().map(index -> EntityStorage.get().resolve(index.getSource())).filter(EntityStorageHelper::nonEmpty).filter(bf -> {
            Reservation reservation = BookingHelper.findReservation((BookingFile)((BookingFile)bf.getEntity()), (String)pnr);
            if (reservation == null) {
                return false;
            }
            return reservation.getProducts().isEmpty() || reservation.getProducts().stream().anyMatch(p -> ProductHandler.of((BaseProduct)p).getTicketType(p) != TicketType.CORRECTION);
        }).collect(Collectors.toList());
    }

    public static ProductSearchResult findProductByUid(String uid) throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(ProductSearchIndex.Property.productUid.name(), uid);
        SearchQuery query = BookingDao.createQueryInternal(properties);
        return BookingDao.findProductInternal(query);
    }

    public static SearchQuery createQueryInternal(Map<String, Object> properties) {
        SearchQuery query = new SearchQuery();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)entry.getKey(), (Object)entry.getValue()));
        }
        return query;
    }

    private static ProductSearchResult findProductInternal(SearchQuery query) throws Exception {
        List data = EntityStorage.get().search(ProductSearchIndex.class, query).getData();
        if (data.size() == 0) {
            return null;
        }
        boolean unique = data.size() == 1;
        ProductSearchIndex index = (ProductSearchIndex)data.get(0);
        String productUid = index.getProductUid();
        EntityContainer container = EntityStorage.get().resolve(index.getSource());
        Reservation reservation = null;
        BaseProduct product = null;
        BookingFile bookingFile = (BookingFile)container.getEntity();
        block0: for (Reservation res : bookingFile.getReservations()) {
            for (BaseProduct pr : res.getProducts()) {
                if (!pr.getUid().equals(productUid)) continue;
                reservation = res;
                if (!unique) break block0;
                product = pr;
                break block0;
            }
        }
        return new ProductSearchResult(bookingFile, product, reservation, (EntityContainer<BookingFile>)container, unique);
    }

    public static EntityReference<Organization> findSupplier(Product product) throws Exception {
        for (ValidatorIndex index : BookingDao.getValidatorIndexes(product)) {
            if (index.getSupplier() == null) continue;
            return index.getSupplier();
        }
        if (product.getScns().isEmpty()) {
            return null;
        }
        for (StockBlank blank : StockControlDao.getBlanksByProductUid(product.getUid())) {
            if (blank.getSupplier() == null || !blank.getSupplier().getType().equals(Organization.class)) continue;
            return blank.getSupplier();
        }
        return null;
    }

    public static EntityReference<Organization> findAgency(Product product) throws Exception {
        for (ValidatorIndex index : BookingDao.getValidatorIndexes(product)) {
            if (index.getAgency() == null) continue;
            return index.getAgency();
        }
        if (product.getScns().isEmpty()) {
            return null;
        }
        for (StockBlank blank : StockControlDao.getBlanksByProductUid(product.getUid())) {
            if (blank.getStockHolder() == null || !blank.getStockHolder().getType().equals(Organization.class)) continue;
            return blank.getStockHolder();
        }
        return null;
    }

    private static List<ValidatorIndex> getValidatorIndexes(Product product) throws Exception {
        if (TextUtil.isBlank((String)product.getValidatorCode())) {
            return Collections.emptyList();
        }
        SearchQuery query = new SearchQuery();
        if (product.getBlankOwnerRef() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ValidatorIndex.Property.blankOwner.name(), (Object)product.getBlankOwnerRef()));
        }
        if (!TextUtil.isBlank((String)product.getPcc())) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ValidatorIndex.Property.pcc.name(), null), SearchCriterion.ieq((String)ValidatorIndex.Property.pcc.name(), (String)product.getPcc())}));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ValidatorIndex.Property.number.name(), (Object)product.getValidatorCode()));
        if (product.getIssueDate() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ValidatorIndex.Property.closed.name(), null), SearchCriterion.ge((String)ValidatorIndex.Property.closed.name(), (Object)product.getIssueDate())}));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ValidatorIndex.Property.opened.name(), null), SearchCriterion.le((String)ValidatorIndex.Property.opened.name(), (Object)product.getIssueDate())}));
        }
        if (product.getSalesPoint() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"containerUid", (Object)product.getSalesPoint().getUid()));
        }
        List indices = EntityStorage.get().search(ValidatorIndex.class, query).getData();
        if (TextUtil.nonBlank((String)product.getPcc()) && indices.stream().anyMatch(index -> product.getPcc().equalsIgnoreCase(index.getPcc()))) {
            indices.removeIf(index -> index.getPcc() == null);
        }
        return indices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProductSearchResult findAndUnarchive(String ticketNumber, EntityReference<Organization> blankOwner, Date issueDate) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ArchivedProductIndex.Property.productNumber.name(), (Object)ticketNumber));
        if (blankOwner != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ArchivedProductIndex.Property.blankOwner.name(), blankOwner));
        }
        if (issueDate != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(issueDate);
            cal.add(1, -1);
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)ArchivedProductIndex.Property.issueDate.name(), (Object)cal.getTime()));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ArchivedProductIndex.Property.status.name(), (Object)ProductStatus.SELL));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ArchivedProductIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
        List result = EntityStorage.get().search(ArchivedProductIndex.class, query).getData();
        HashMap<EntityReference, String> refs = new HashMap<EntityReference, String>();
        for (ArchivedProductIndex item : result) {
            EntityReference ref = item.getSource();
            if (!ArchivedBooking.class.equals((Object)ref.getType())) continue;
            refs.put(ref, item.getNavigationKey());
        }
        if (refs.isEmpty()) {
            return null;
        }
        ProductSearchResult psr = new ProductSearchResult();
        psr.setUnique(result.isEmpty());
        EntityContainer bookingCtr = null;
        BaseProduct bp = null;
        LogicalSession ls = LogicalStorage.get().beginUnitOfWork();
        try {
            for (Map.Entry entry : refs.entrySet()) {
                EntityReference ref = (EntityReference)entry.getKey();
                EntityContainer archiveCtr = EntityStorage.get().resolve(ref);
                ArrayList<ArchivedEntity> entities = new ArrayList<ArchivedEntity>();
                ArchivedEntity booking = ((ArchivedBooking)archiveCtr.getEntity()).getBooking();
                bookingCtr = ArchivedBookingHelper.getBookingContainer((ArchivedBooking)((ArchivedBooking)archiveCtr.getEntity()));
                bp = BookingHelper.findProduct((BookingFile)((BookingFile)bookingCtr.getEntity()), (String)((String)entry.getValue()));
                entities.add(booking);
                entities.addAll(((ArchivedBooking)archiveCtr.getEntity()).getAdditionalEntities());
                for (ArchivedEntity item : entities) {
                    EntityStorage.get().save(ArchivedBookingHelper.getLastVersion((ArchivedEntity)item), true, (EntityStorageSaveParameters)new EntityStorageSaveParameters().ignoreInterceptors(true));
                    AssetsStorage.get().save((Iterable)item.getAssets(), true);
                }
                EntityStorage.get().delete(archiveCtr, (EntityStorageDeleteParameters)new EntityStorageDeleteParameters().ignoreInterceptors(true));
                LogicalStorage.get().endUnitOfWork(ls, true);
            }
        }
        finally {
            LogicalStorage.get().cancelUnitOfWork(ls);
        }
        psr.setBookingFile((BookingFile)bookingCtr.getEntity());
        psr.setContainer(bookingCtr);
        psr.setProduct(bp);
        psr.setReservation(bp.getReservation());
        return psr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntityContainer<BookingFile> unarchiveBookingFile(EntityReference<ArchivedBooking> archivedBookingReference) {
        EntityContainer archiveCtr = EntityStorage.get().resolve(archivedBookingReference);
        if (archiveCtr == null) {
            return null;
        }
        LogicalSession ls = LogicalStorage.get().beginUnitOfWork();
        try {
            ArrayList<ArchivedEntity> entities = new ArrayList<ArchivedEntity>();
            entities.add(((ArchivedBooking)archiveCtr.getEntity()).getBooking());
            entities.addAll(((ArchivedBooking)archiveCtr.getEntity()).getAdditionalEntities());
            for (ArchivedEntity item : entities) {
                EntityStorage.get().save(ArchivedBookingHelper.getLastVersion((ArchivedEntity)item), true, (EntityStorageSaveParameters)new EntityStorageSaveParameters().ignoreInterceptors(true));
                AssetsStorage.get().save((Iterable)item.getAssets(), true);
            }
            EntityStorage.get().delete(archiveCtr, (EntityStorageDeleteParameters)new EntityStorageDeleteParameters().ignoreInterceptors(true));
            LogicalStorage.get().endUnitOfWork(ls, true);
            EntityContainer entityContainer = ArchivedBookingHelper.getBookingContainer((ArchivedBooking)((ArchivedBooking)archiveCtr.getEntity()));
            return entityContainer;
        }
        finally {
            LogicalStorage.get().cancelUnitOfWork(ls);
        }
    }
}

