/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ProfileGroup;
import com.gridnine.xtrip.common.model.dict.ProfileGroupReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonMetadata;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Set;

public class CommonProductHelper {
    public static String AEROEXPRESS_SYSTEM_NUMBER_PREFIX = "AE";
    public static String HOTEL_AGREGATOR_SYSTEM_NUMBER_PREFIX = "HA";
    public static String MCO_FEES_SYSTEM_NUMBER_PREFIX = "MF";
    public static String UNIVERSAL_SYSTEM_NUMBER_PREFIX = "MI";

    public static void addSubagencyCodes(Set<String> subagencyCodes, EntityReference<Organization> agencyRef) {
        if (agencyRef != null) {
            try {
                Organization agency = (Organization)EntityStorage.get().resolve(agencyRef).getEntity();
                subagencyCodes.add(agency.getCode());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static <P extends BaseProduct> String getAgencyCode(P product) {
        EntityContainer agencyCtr = EntityStorage.get().resolve(GeneralProductHelper.getAgency(product));
        return agencyCtr == null ? null : ((Organization)agencyCtr.getEntity()).getCode();
    }

    public static void addProfileGroups(Set<String> profileGroups, EntityReference<? extends BaseProfile> ref) {
        block6: {
            if (ref != null) {
                try {
                    BaseProfile profile = (BaseProfile)EntityStorage.get().resolve(ref).getEntity();
                    if (profile instanceof Person) {
                        Person person = (Person)profile;
                        for (PersonMetadata meta : person.getMetadata()) {
                            if (meta.getKey() == null || !TextUtil.isSame((String)"KEY_PERSON_PROFILE_GROUP", (String)meta.getKey().getCode()) || !(meta.getValue() instanceof ProfileGroupReference)) continue;
                            ProfileGroup group = (ProfileGroup)DictionaryCache.get().resolveReference((DictionaryReference)((ProfileGroupReference)meta.getValue()));
                            profileGroups.addAll(group.getTranslations().values());
                            break block6;
                        }
                        break block6;
                    }
                    if (!(profile instanceof Organization)) break block6;
                    Organization org = (Organization)profile;
                    for (Metadata meta : org.getMetadata()) {
                        if (meta.getKey() == null || !TextUtil.isSame((String)"KEY_ORGANIZATION_PROFILE_GROUP", (String)meta.getKey().getCode()) || !(meta.getValue() instanceof ProfileGroupReference)) continue;
                        ProfileGroup group = (ProfileGroup)DictionaryCache.get().resolveReference((DictionaryReference)((ProfileGroupReference)meta.getValue()));
                        profileGroups.addAll(group.getTranslations().values());
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

