/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers;

import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainersLockHelper<T extends BaseEntity> {
    private LockData<T> lockData = null;
    private final Iterator<EntityContainer<T>> containerIterator;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public ContainersLockHelper(Collection<EntityContainer<T>> containers) {
        Collection sortedContainers = containers.stream().filter(Objects::nonNull).sorted((o1, o2) -> TextUtil.compare((String)o1.getUid(), (String)o2.getUid(), (boolean)false, (boolean)true)).collect(Collectors.toList());
        this.containerIterator = sortedContainers.iterator();
    }

    public static <T extends BaseEntity> ContainersLockHelper<T> fromReferences(Collection<EntityReference<T>> references) {
        List<EntityContainer<T>> containers = references.stream().map(entityReference -> EntityStorage.get().resolve(entityReference)).collect(Collectors.toList());
        return new ContainersLockHelper<T>(containers);
    }

    public static <T extends BaseEntity> ContainersLockHelper<T> fromSingleContainer(EntityContainer<T> container) {
        return new ContainersLockHelper<T>(Collections.singletonList(container));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockNextContainer() {
        if (!this.containerIterator.hasNext()) {
            return;
        }
        EntityContainer<T> container = this.containerIterator.next();
        NamedLock lock = null;
        boolean locked = false;
        try {
            lock = LockUtil.getLockManager().getLock((Object)LockUtil.getLockKey(container), TimeUnit.MINUTES.toMillis(1L));
            if (lock.tryLock(10L, TimeUnit.SECONDS)) {
                this.log.debug(String.format("successfully obtained lock for %s", container.getEntity()));
                locked = true;
                EntityContainer existingContainer = EntityStorage.get().resolve(container.toReference());
                if (existingContainer == null || !SystemHelper.isModifiedByThirdPartyProcess((VersionInfo)existingContainer.getVersionInfo(), (VersionInfo)container.getVersionInfo())) {
                    return;
                }
                this.log.debug(String.format("container %s was modified by background process %s", container.getEntity(), existingContainer.getModifiedBy()));
            }
        }
        catch (InterruptedException e) {
            this.log.warn("unable to lock container " + container.toReference());
        }
        finally {
            if (lock != null) {
                this.lockData = new LockData(lock, locked, container.toReference());
            }
        }
    }

    public void unlockCurrentContainerIfLocked() {
        if (this.isLocked()) {
            this.unlockCurrentContainer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void unlockCurrentContainer() {
        block20: {
            if (this.lockData == null) {
                return;
            }
            if (!this.lockData.locked) break block20;
            this.lockData.lock.unlock();
            this.log.debug(String.format("lock released for container %s", this.lockData.reference));
        }
        try {
            this.lockData.lock.close();
            this.log.debug(String.format("lock closed for container %s", this.lockData.reference));
        }
        catch (Exception e) {
            this.log.error(String.format("unable to close lock for %s", this.lockData.reference), (Throwable)e);
        }
        finally {
            this.lockData = null;
        }
        catch (Exception e) {
            try {
                this.log.error(String.format("unable to unlock %s", this.lockData.reference), (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    this.lockData.lock.close();
                    this.log.debug(String.format("lock closed for container %s", this.lockData.reference));
                }
                catch (Exception e2) {
                    this.log.error(String.format("unable to close lock for %s", this.lockData.reference), (Throwable)e2);
                }
                finally {
                    this.lockData = null;
                }
                throw throwable;
            }
            try {
                this.lockData.lock.close();
                this.log.debug(String.format("lock closed for container %s", this.lockData.reference));
            }
            catch (Exception e3) {
                this.log.error(String.format("unable to close lock for %s", this.lockData.reference), (Throwable)e3);
            }
            finally {
                this.lockData = null;
            }
        }
    }

    public boolean isLocked() {
        if (this.lockData == null) {
            return false;
        }
        return this.lockData.locked;
    }

    public boolean hasNext() {
        return this.containerIterator.hasNext();
    }

    public EntityContainer<T> getCurrentContainer() {
        return this.lockData == null ? null : EntityStorage.get().resolve(this.lockData.reference);
    }

    private static class LockData<E extends BaseEntity> {
        final NamedLock lock;
        final boolean locked;
        final EntityReference<E> reference;

        public LockData(NamedLock lock, boolean locked, EntityReference<E> reference) {
            this.lock = lock;
            this.locked = locked;
            this.reference = reference;
        }
    }
}

