/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.PredefinedContractRelationType;
import com.gridnine.xtrip.common.model.profile.SalesChainDescription;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class ContractRelationDescriptionHelper {
    public static List<ContractRelationDescription> resolveContractRelations(SalesChainDescription salesChainDescription) {
        return salesChainDescription.getContractRelations().stream().map(relationReference -> EntityStorage.get().resolve(relationReference)).filter(Objects::nonNull).map(EntityContainer::getEntity).collect(Collectors.toList());
    }

    public static int getSubagencyCount(List<ContractRelationDescription> contractRelations) {
        return (int)contractRelations.stream().filter(relation -> relation.getPredefinedType() == PredefinedContractRelationType.AGENCY_TO_SUBAGENCY || relation.getPredefinedType() == PredefinedContractRelationType.SUBAGENCY_TO_SUBAGENCY).count();
    }

    public static boolean hasTechnicalProvider(List<ContractRelationDescription> contractRelations) {
        return contractRelations.stream().anyMatch(relation -> relation.getPredefinedType() == PredefinedContractRelationType.TECHNICAL_PROVIDER_TO_AGENCY);
    }
}

