/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.meta.BaseClassType;
import com.gridnine.xtrip.common.meta.DictionaryType;
import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.meta.Property;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.asset.cache.AssetsCacheManager;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECManager;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.cache.EntityCacheManager;
import com.gridnine.xtrip.common.model.entity.misc.EntityStorageThreadContext;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSaveParameters;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.exchange.ExportType;
import com.gridnine.xtrip.common.model.system.exchange.ExportedItem;
import com.gridnine.xtrip.common.model.system.exchange.ImportData;
import com.gridnine.xtrip.common.model.system.exchange.ImportType;
import com.gridnine.xtrip.common.model.system.exchange.ItemExportSettings;
import com.gridnine.xtrip.common.model.system.exchange.ItemImportSettings;
import com.gridnine.xtrip.common.model.system.exchange.ItemType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.RandomAccessMapWrapper;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.tasks.AsyncServerTask;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExportImportHelper {
    public static final int treshold = 10;
    private static final Logger log = LoggerFactory.getLogger(ExportImportHelper.class);

    private static void collectDictionaries(Collection<EntityContainer<?>> values, Set<DictionaryReference<?>> dictionaries) {
        HashSet<Object> addedEntities = new HashSet<Object>();
        for (EntityContainer<?> item : values) {
            dictionaries.addAll(ExportImportHelper.getAllRelatedDictionaries(item.getEntity(), addedEntities));
        }
    }

    private static Set<DictionaryReference<?>> getAllRelatedDictionaries(BaseEntity entity, Set<Object> addedEntities) {
        HashSet res = new HashSet();
        if (entity == null) {
            return res;
        }
        EntityType type = MetaRegistryHelper.getEntityType((String)entity.getClass().getName());
        RandomAccessMapWrapper properties = MetaRegistryHelper.getAllProperties((EntityType)type);
        Map allDictTypes = MetaRegistry.get().getDictionaries();
        Map allTypes = MetaRegistry.get().getEntities();
        for (Map.Entry entry : properties.entrySet()) {
            Object obj;
            if (allDictTypes.containsKey(((Property)entry.getValue()).getType())) {
                obj = entity.getValue((String)entry.getKey());
                if (obj == null || !(obj instanceof DictionaryReference)) continue;
                DictionaryReference dictRef = (DictionaryReference)obj;
                res.add(dictRef);
                continue;
            }
            if (!allTypes.containsKey(((Property)entry.getValue()).getType())) continue;
            obj = entity.getValue((String)entry.getKey());
            if (((Property)entry.getValue()).isReference() || obj == null || !(obj instanceof BaseEntity) || addedEntities.contains(obj)) continue;
            addedEntities.add(obj);
            HashSet<Object> newAddedEntities = new HashSet<Object>(addedEntities);
            newAddedEntities.addAll(res);
            res.addAll(ExportImportHelper.getAllRelatedDictionaries((BaseEntity)obj, newAddedEntities));
        }
        RandomAccessMapWrapper collections = MetaRegistryHelper.getAllCollections((BaseClassType)type);
        for (Map.Entry entry : collections.entrySet()) {
            Collection coll;
            Object obj;
            if (allDictTypes.containsKey(((EntityCollection)entry.getValue()).getElementType())) {
                obj = entity.getValue((String)entry.getKey());
                if (obj == null) continue;
                coll = (Collection)obj;
                for (DictionaryReference dictRef : coll) {
                    if (dictRef == null) continue;
                    res.add(dictRef);
                }
                continue;
            }
            if (!allTypes.containsKey(((EntityCollection)entry.getValue()).getElementType())) continue;
            obj = entity.getValue((String)entry.getKey());
            if (((EntityCollection)entry.getValue()).isReference() || obj == null || !(obj instanceof Collection)) continue;
            coll = (Collection)obj;
            for (BaseEntity subEntity : coll) {
                if (addedEntities.contains(subEntity)) continue;
                addedEntities.add(subEntity);
                HashSet<Object> newAddedEntities = new HashSet<Object>(addedEntities);
                newAddedEntities.addAll(res);
                res.addAll(ExportImportHelper.getAllRelatedDictionaries(subEntity, newAddedEntities));
            }
        }
        return res;
    }

    private static void collectEntities(Map<EntityReference<?>, EntityContainer<?>> entities, Collection<String> toIgnore) {
        HashSet<Object> processed = new HashSet<Object>();
        for (EntityContainer<?> item : new HashSet(entities.values())) {
            ExportImportHelper.collectEntitiesInternal(item, toIgnore, processed, entities, 0);
        }
    }

    private static void collectEntitiesInternal(Object object, Collection<String> toIgnore, Set<Object> processed, Map<EntityReference<?>, EntityContainer<?>> cache, int currentDepth) {
        if (object == null) {
            return;
        }
        BaseEntity entity = null;
        if (object instanceof EntityContainer) {
            EntityContainer ctr = (EntityContainer)object;
            entity = ctr.getEntity();
        } else {
            entity = (BaseEntity)object;
        }
        if (processed.contains(object) || toIgnore.contains(entity.getClass().getName())) {
            return;
        }
        EntityType type = MetaRegistryHelper.getEntityType((String)entity.getClass().getName());
        if (type == null) {
            return;
        }
        processed.add(object);
        if (object instanceof EntityContainer) {
            processed.add(entity);
            processed.add(((EntityContainer)object).toReference());
        }
        RandomAccessMapWrapper properties = MetaRegistryHelper.getAllProperties((EntityType)type);
        Map allTypes = MetaRegistry.get().getEntities();
        for (Map.Entry entry : properties.entrySet()) {
            Object obj;
            if (!allTypes.containsKey(((Property)entry.getValue()).getType()) && !((Property)entry.getValue()).getType().startsWith(NestedEntityReference.class.getName()) || (obj = entity.getValue((String)entry.getKey())) == null) continue;
            if (((Property)entry.getValue()).isReference() || ((Property)entry.getValue()).getType().startsWith(NestedEntityReference.class.getName())) {
                EntityContainer ctr;
                EntityReference ref = (EntityReference)obj;
                if (obj instanceof NestedEntityReference) {
                    ref = new EntityReference(ref.getUid(), ref.getType(), null);
                }
                if (processed.contains(ref) || currentDepth > 0 || (ctr = EntityStorage.get().resolve(ref)) == null) continue;
                if (!cache.containsKey(ref)) {
                    cache.put(ref, ctr);
                }
                ExportImportHelper.collectEntitiesInternal(ctr, toIgnore, processed, cache, currentDepth + 1);
                continue;
            }
            if (!(obj instanceof BaseEntity)) continue;
            ExportImportHelper.collectEntitiesInternal(obj, toIgnore, processed, cache, currentDepth);
        }
        RandomAccessMapWrapper collections = MetaRegistryHelper.getAllCollections((BaseClassType)type);
        for (Map.Entry entry : collections.entrySet()) {
            Object obj;
            if (!allTypes.containsKey(((EntityCollection)entry.getValue()).getElementType()) && !((EntityCollection)entry.getValue()).getElementType().startsWith(NestedEntityReference.class.getName()) || (obj = entity.getValue((String)entry.getKey())) == null || !(obj instanceof Collection)) continue;
            Collection coll = (Collection)obj;
            for (Object item : coll) {
                if (item == null) continue;
                if (((EntityCollection)entry.getValue()).isReference() || ((EntityCollection)entry.getValue()).getElementType().startsWith(NestedEntityReference.class.getName())) {
                    EntityContainer ctr;
                    EntityReference ref = (EntityReference)item;
                    if (item instanceof NestedEntityReference) {
                        ref = new EntityReference(ref.getUid(), ref.getType(), null);
                    }
                    if (processed.contains(ref) || currentDepth > 0 || (ctr = EntityStorage.get().resolve(ref)) == null) continue;
                    if (!cache.containsKey(ref)) {
                        cache.put(ref, ctr);
                    }
                    ExportImportHelper.collectEntitiesInternal(ctr, toIgnore, processed, cache, currentDepth + 1);
                    continue;
                }
                if (!(item instanceof BaseEntity)) continue;
                ExportImportHelper.collectEntitiesInternal(item, toIgnore, processed, cache, currentDepth);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static ItemExportSettings createSettings(Collection<EntityContainer<?>> containers, Set<DictionaryReference<?>> dictionaries) {
        ItemExportSettings relatedEntitiesSettings = new ItemExportSettings();
        relatedEntitiesSettings.setExportType(ExportType.ALL);
        relatedEntitiesSettings.setGroup(true);
        relatedEntitiesSettings.setObjectId("related-entities");
        LinkedHashMap entitiesMap = new LinkedHashMap();
        for (EntityContainer<?> entityContainer : containers) {
            void var6_10;
            Set set = (Set)entitiesMap.get(entityContainer.getEntityType());
            if (set == null) {
                HashSet hashSet = new HashSet();
                entitiesMap.put(entityContainer.getEntityType(), hashSet);
            }
            EntityReference ref = entityContainer.toReference();
            if (entityContainer.getVersionsCount() != entityContainer.getVersionInfo().getVersionNumber() + 1) {
                ref.setUid(String.format("%s|version=%s", ref.getUid(), entityContainer.getVersionInfo().getVersionNumber() - 1));
            }
            var6_10.add(ref);
        }
        for (Map.Entry entry : entitiesMap.entrySet()) {
            ItemExportSettings itemExportSettings = new ItemExportSettings();
            itemExportSettings.setExportType(ExportType.SELECTED);
            itemExportSettings.setItemType(ItemType.ENTITY);
            itemExportSettings.getSelectedItems().addAll((Collection)entry.getValue());
            itemExportSettings.setObjectId(((Class)entry.getKey()).getName());
            relatedEntitiesSettings.getChildren().add(itemExportSettings);
            itemExportSettings.setParent(relatedEntitiesSettings);
        }
        LinkedHashMap dictMap = new LinkedHashMap();
        for (DictionaryReference<?> dictionaryReference : dictionaries) {
            HashSet dicts = (HashSet)dictMap.get(dictionaryReference.getType());
            if (dicts == null) {
                dicts = new HashSet();
                dictMap.put(dictionaryReference.getType(), dicts);
            }
            dicts.add(dictionaryReference);
        }
        for (Map.Entry entry : dictMap.entrySet()) {
            ItemExportSettings settings = new ItemExportSettings();
            settings.setExportType(ExportType.SELECTED);
            settings.setItemType(ItemType.DICTIONARY);
            settings.getSelectedItems().addAll((Collection)entry.getValue());
            settings.setObjectId(((Class)entry.getKey()).getName());
            relatedEntitiesSettings.getChildren().add(settings);
            settings.setParent(relatedEntitiesSettings);
        }
        return relatedEntitiesSettings;
    }

    public static Map<ItemExportSettings, List<ExportedItem>> exportData(List<ItemExportSettings> settings, Set<EntityContainer<?>> entityContainers, Set<DictionaryReference<?>> dictionaries, Set<String> toIgnore, AsyncServerTask.Callback callback) throws Exception {
        HashMap map = new HashMap();
        callback.updateProgress((byte)0, "\u0441\u043e\u0431\u0438\u0440\u0430\u0435\u043c \u0441\u0441\u044b\u043b\u043a\u0438 \u043d\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u044b");
        entityContainers.forEach(ctr -> map.put((EntityReference<?>)ctr.toReference(), (EntityContainer<?>)ctr));
        ExportImportHelper.collectEntities(map, toIgnore);
        Collection<EntityContainer<?>> containers = map.values();
        HashSet resultDictionaries = new HashSet(dictionaries);
        ExportImportHelper.collectDictionaries(containers, resultDictionaries);
        ArrayList<ItemExportSettings> resultSettings = new ArrayList<ItemExportSettings>(settings);
        ItemExportSettings otherExportSettings = ExportImportHelper.createSettings(containers, dictionaries);
        resultSettings.add(otherExportSettings);
        callback.updateProgress((byte)50, "\u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u0435\u043c \u0434\u0430\u043d\u043d\u044b\u0435");
        return ExportImportHelper.exportData(resultSettings, callback);
    }

    public static Map<ItemExportSettings, List<ExportedItem>> exportData(List<ItemExportSettings> parameters, AsyncServerTask.Callback callback) throws Exception {
        LinkedHashMap<ItemExportSettings, List<ExportedItem>> result = new LinkedHashMap<ItemExportSettings, List<ExportedItem>>();
        LinkedHashMap<ItemExportSettings, ArrayList<ItemExportSettings>> settingsMap = new LinkedHashMap<ItemExportSettings, ArrayList<ItemExportSettings>>();
        for (ItemExportSettings itemExportSettings : parameters) {
            ArrayList<ItemExportSettings> settings = new ArrayList<ItemExportSettings>();
            ExportImportHelper.collectExportSettings(settings, itemExportSettings);
            settingsMap.put(itemExportSettings, settings);
        }
        for (Map.Entry entry : settingsMap.entrySet()) {
            result.put((ItemExportSettings)entry.getKey(), ExportImportHelper.exportItem((List)entry.getValue(), callback));
        }
        return result;
    }

    public static void importData(ImportData data, AsyncServerTask.Callback callback) throws Exception {
        log.debug("starting import");
        if (!"true".equals(System.getProperty("midoffice.import-cleanup-enabled"))) {
            throw new IllegalStateException("import is not allowed, set midoffice.import-cleanup-enabled=true in boot.properties");
        }
        EntityStorageThreadContext.execute(() -> {
            EntityStorageThreadContext.setIgnoreReadTryCount((boolean)true);
            HashMap<String, ImportType> importTypes = new HashMap<String, ImportType>();
            LinkedHashMap<String, ArrayList<ExportedItem>> items = new LinkedHashMap<String, ArrayList<ExportedItem>>();
            ExportImportHelper.sort(data.getItems());
            for (ExportedItem item : data.getItems()) {
                String objectId = item.getObjectId();
                importTypes.put(objectId, ExportImportHelper.getImportType(ExportImportHelper.findChild(data.getSettings(), objectId)));
                ArrayList<ExportedItem> list = (ArrayList<ExportedItem>)items.get(objectId);
                if (list == null) {
                    list = new ArrayList<ExportedItem>();
                    items.put(objectId, list);
                }
                list.add(item);
            }
            ValueHolder resetDictVersion = new ValueHolder();
            try {
                HashSet<String> cleanedUpIndexes = new HashSet<String>();
                for (Map.Entry entry : items.entrySet()) {
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    String objectId = (String)entry.getKey();
                    List value = (List)entry.getValue();
                    if (MetaRegistry.get().getDictionaries().containsKey(objectId)) {
                        ExportImportHelper.importDictionary(objectId, value, (ImportType)importTypes.get(objectId), (ValueHolder<Boolean>)resetDictVersion, callback);
                        continue;
                    }
                    if (MetaRegistry.get().getEntities().containsKey(objectId)) {
                        ExportImportHelper.importEntity(objectId, value, (ImportType)importTypes.get(objectId), cleanedUpIndexes, callback);
                        continue;
                    }
                    Class cls = XHelper.getClass((String)objectId);
                    if (BaseAsset.class.isAssignableFrom(cls)) {
                        ExportImportHelper.importAsset(objectId, value, (ImportType)importTypes.get(objectId), callback);
                        continue;
                    }
                    callback.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.ImportObjectsTask_unsupportedObjectType, (Object[])new Object[]{objectId}));
                }
            }
            finally {
                EntityCacheManager ecm;
                if (Boolean.TRUE.equals(resetDictVersion.getValue())) {
                    try {
                        LogicalStorage.get().getDbPropertiesStorage().putValue("dicts-version", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                    }
                    catch (Throwable e) {
                        callback.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.ImportObjectsTask_cantUpdateDictionaryVersion, (Throwable)e, (Object[])new Object[0]));
                    }
                }
                if ((ecm = EntityCacheManager.get()) instanceof AECManager) {
                    ((AECManager)ecm).reset();
                } else {
                    ecm.check();
                }
                DictionaryCache.get().forceSynchronization();
                ((AssetsCacheManager)Environment.getPublished(AssetsCacheManager.class)).reset();
            }
        });
    }

    private static void sort(List<ExportedItem> items) {
        items.sort(Comparator.comparingInt(ExportImportHelper::getEntityPriority));
    }

    private static int getEntityPriority(ExportedItem a) {
        if (Organization.class.getName().equals(a.getObjectId())) {
            return 0;
        }
        return 1;
    }

    private static List<ExportedItem> exportItem(List<ItemExportSettings> value, AsyncServerTask.Callback callback) throws Exception {
        ArrayList<ExportedItem> result = new ArrayList<ExportedItem>();
        block5: for (ItemExportSettings item : value) {
            switch (item.getItemType()) {
                case ENTITY: {
                    ExportedItem exportedEntity = ExportImportHelper.exportEntity(item, callback);
                    if (exportedEntity == null) continue block5;
                    result.add(exportedEntity);
                    continue block5;
                }
                case DICTIONARY: {
                    ExportedItem exportedDictionary = ExportImportHelper.exportDictionary(item, callback);
                    if (exportedDictionary == null) continue block5;
                    result.add(exportedDictionary);
                    continue block5;
                }
                case ASSET: {
                    ExportedItem exportedAsset = ExportImportHelper.exportAsset(item, callback);
                    if (exportedAsset == null) continue block5;
                    result.add(exportedAsset);
                    continue block5;
                }
            }
            throw new Exception("not supported item type " + item.getItemType().name());
        }
        return result;
    }

    private static ExportedItem exportAsset(ItemExportSettings item, AsyncServerTask.Callback callback) throws Exception {
        int bundleIndex = 0;
        ArrayList assets = new ArrayList(AssetsStorage.get().search(XHelper.getClass((String)item.getObjectId()), new SearchQuery()).getData());
        String name = item.getObjectId().substring(item.getObjectId().lastIndexOf(".") + 1);
        int size = assets.size();
        if (size == 0) {
            callback.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.ExportObjectsTask_noObjectTypeSatisfyingCriteria, (Object[])new Object[]{name}));
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream strm = new ZipOutputStream(baos);
        ExportImportHelper.exportObjects(assets, strm, item.getObjectId(), bundleIndex, size, callback);
        strm.close();
        callback.updateProgress((byte)100, Messages.ExportObjectsTask_exportFinish + name);
        ExportedItem result = new ExportedItem();
        result.setType(ItemType.ASSET);
        result.setObjectId(item.getObjectId());
        result.setContent(baos.toByteArray());
        result.setObjectsCount(size);
        return result;
    }

    private static ExportedItem exportDictionary(ItemExportSettings item, AsyncServerTask.Callback callback) throws Exception {
        DictionaryType dictionaryType = (DictionaryType)MetaRegistry.get().getDictionaries().get(item.getObjectId());
        String name = dictionaryType == null ? item.getObjectId() : dictionaryType.getDisplayName();
        callback.updateProgress((byte)0, Messages.ExportObjectsTask_export + name);
        ArrayList<Object> dicts = new ArrayList<Object>();
        switch (item.getExportType()) {
            case ALL: {
                dicts.addAll(DictionaryCache.get().getAll(XHelper.getClass((String)item.getObjectId())).values());
                break;
            }
            default: {
                for (Object obj : item.getSelectedItems()) {
                    BaseDictionary dict = DictionaryCache.get().resolveReference((DictionaryReference)obj);
                    if (dict == null) {
                        callback.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.ExportObjectsTask_cantExportRefError, (Object[])new Object[]{obj}));
                        continue;
                    }
                    dicts.add(dict);
                }
            }
        }
        dicts = new ArrayList(dicts);
        int size = dicts.size();
        if (size == 0) {
            callback.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.ExportObjectsTask_noObjectTypeSatisfyingCriteria, (Object[])new Object[]{name}));
            return null;
        }
        ArrayList bundle = new ArrayList();
        int bundleIndex = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream strm = new ZipOutputStream(baos);
        for (int n = 0; n < size; ++n) {
            bundle.add(dicts.get(n));
            if (n != 0 && n % 10 == 0) {
                ExportImportHelper.exportObjects(bundle, strm, item.getObjectId(), bundleIndex, size, callback);
                bundle.clear();
                ++bundleIndex;
            }
            if (n == 0 || n % 10 != 0) continue;
            callback.updateProgress((byte)Math.round(100.0 * (double)n / (double)size), Messages.ExportObjectsTask_export + name);
        }
        if (!bundle.isEmpty()) {
            ExportImportHelper.exportObjects(bundle, strm, item.getObjectId(), bundleIndex, size, callback);
            bundle.clear();
        }
        strm.close();
        callback.updateProgress((byte)100, Messages.ExportObjectsTask_exportFinish + name);
        ExportedItem result = new ExportedItem();
        result.setType(ItemType.DICTIONARY);
        result.setObjectId(item.getObjectId());
        result.setContent(baos.toByteArray());
        result.setObjectsCount(size);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportObjects(List<? extends XSerializable> bundle, ZipOutputStream strm, String objectId, int bundleIndex, int totalCount, AsyncServerTask.Callback callback) {
        try {
            Document result = DocumentBuilderHelper.newDocument();
            result.appendChild(result.createElement("objects"));
            Element rootElm = result.getDocumentElement();
            rootElm.setAttribute("totalCount", Integer.toString(totalCount));
            for (XSerializable xSerializable : bundle) {
                XHelper.writeObject((Element)rootElm, (String)"object", (Object)xSerializable);
            }
            String fileName = String.format("%s%08d.xml", objectId, bundleIndex);
            strm.putNextEntry(new ZipEntry(fileName));
            try {
                XUtil.newTransformer().transform(new DOMSource(result), new StreamResult(strm));
            }
            finally {
                strm.closeEntry();
            }
            strm.flush();
        }
        catch (Throwable e) {
            log.error("unable to export " + bundle, e);
            callback.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.ExportObjectsTask_cantExport, (Object[])new Object[]{bundle.toString()}));
        }
    }

    private static ExportedItem exportEntity(ItemExportSettings item, AsyncServerTask.Callback callback) throws Exception {
        ArrayList<String> uids;
        EntityType entityType = (EntityType)MetaRegistry.get().getEntities().get(item.getObjectId());
        String name = entityType == null ? item.getObjectId() : entityType.getDisplayName();
        callback.updateProgress((byte)0, Messages.ExportObjectsTask_export + name);
        Class cls = XHelper.getClass((String)item.getObjectId());
        try {
            switch (item.getExportType()) {
                case ALL: {
                    Collection indexHandlers = LogicalStorageRegistry.get().getIndexHandlers(cls);
                    if (indexHandlers.isEmpty()) {
                        throw Xeption.forDeveloper((String)"\u0434\u043b\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0} \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043d\u0438 \u043e\u0434\u043d\u043e\u0433\u043e indexhandler", (Object[])new Object[]{cls.getName()});
                    }
                    IndexHandler handler = null;
                    Iterator iterator = indexHandlers.iterator();
                    while (iterator.hasNext()) {
                        IndexHandler h = (IndexHandler)iterator.next();
                        IndexType indexType = MetaRegistryHelper.getIndexType((String)h.getIndexClass().getName());
                        if (!"true".equals(indexType.getParameters().get("use-in-export"))) continue;
                        handler = h;
                        break;
                    }
                    if (handler == null) {
                        handler = (IndexHandler)indexHandlers.iterator().next();
                    }
                    Class indexClass = handler.getIndexClass();
                    SearchQuery query = new SearchQuery();
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"entityType", (Object)cls.getName()));
                    query.getPreferredProperties().add("entityType");
                    uids = new ArrayList();
                    for (EntityIndex idx : EntityStorage.get().search(indexClass, query).getData()) {
                        if (uids.contains(idx.getSource().getUid())) continue;
                        uids.add(idx.getSource().getUid());
                    }
                    break;
                }
                case SELECTED: {
                    uids = new ArrayList<String>();
                    for (Object obj : item.getSelectedItems()) {
                        uids.add(((EntityReference)obj).getUid());
                    }
                    break;
                }
                default: {
                    SearchQuery query = item.getQueryData().getQuery();
                    query.getPreferredProperties().add("containerUid");
                    uids = new ArrayList();
                    for (EntityIndex index : EntityStorage.get().search(XHelper.getClass((String)item.getQueryData().getIndexClassName()), query).getData()) {
                        if (uids.contains(index.getSource().getUid())) continue;
                        uids.add(index.getSource().getUid());
                    }
                    uids = new ArrayList(uids);
                }
            }
        }
        catch (Throwable e) {
            callback.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.ExportObjectsTask_cantGetListObjectExport, (Throwable)e, (Object[])new Object[0]));
            return null;
        }
        int size = uids.size();
        if (size == 0) {
            callback.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.ExportObjectsTask_noObjectTypeSatisfyingCriteria, (Object[])new Object[]{name}));
            return null;
        }
        ArrayList<EntityContainer> bundle = new ArrayList<EntityContainer>();
        int bundleIndex = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream strm = new ZipOutputStream(baos);
        boolean hasExportedItems = false;
        for (int n = 0; n < size; ++n) {
            try {
                String etcUid = (String)uids.get(n);
                Integer versionNumber = null;
                String versionDelimiter = "|version=";
                if (etcUid.contains(versionDelimiter)) {
                    int idx = etcUid.indexOf(versionDelimiter);
                    versionNumber = Integer.valueOf(etcUid.substring(idx + versionDelimiter.length()));
                    etcUid = etcUid.substring(0, idx);
                }
                EntityContainer ctr = EntityStorage.get().load(cls, etcUid, versionNumber);
                bundle.add(ctr);
                hasExportedItems = true;
            }
            catch (Throwable e) {
                log.error("unable to load container", e);
                callback.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.ExportObjectsTask_unexpectedError, (Throwable)e, (Object[])new Object[0]));
                continue;
            }
            if (n != 0 && n % 10 == 0) {
                ExportImportHelper.exportObjects(bundle, strm, item.getObjectId(), bundleIndex, size, callback);
                bundle.clear();
                ++bundleIndex;
            }
            if (n == 0 || n % 10 != 0) continue;
            callback.updateProgress((byte)Math.round(100.0 * (double)n / (double)size), Messages.ExportObjectsTask_exportFinish + name);
        }
        if (!bundle.isEmpty()) {
            ExportImportHelper.exportObjects(bundle, strm, item.getObjectId(), bundleIndex, size, callback);
            bundle.clear();
        }
        if (!hasExportedItems) {
            return null;
        }
        strm.close();
        callback.updateProgress((byte)100, Messages.ExportObjectsTask_exportFinish + name);
        ExportedItem result = new ExportedItem();
        result.setType(ItemType.ENTITY);
        result.setObjectId(item.getObjectId());
        result.setContent(baos.toByteArray());
        result.setObjectsCount(size);
        return result;
    }

    public static void collectExportSettings(List<ItemExportSettings> allSettings, ItemExportSettings item) {
        if (item.isGroup()) {
            for (ItemExportSettings nestedItem : item.getChildren()) {
                ExportImportHelper.collectExportSettings(allSettings, nestedItem);
            }
            return;
        }
        if (ExportImportHelper.isSkippAll(item)) {
            return;
        }
        ItemExportSettings settings = new ItemExportSettings();
        settings.setItemType(item.getItemType());
        settings.setObjectId(item.getObjectId());
        settings.setExportType(item.getExportType());
        switch (item.getExportType()) {
            case QUERY: {
                settings.setQueryData(item.getQueryData());
                break;
            }
            case SELECTED: {
                settings.getSelectedItems().addAll(item.getSelectedItems());
                break;
            }
            default: {
                settings.setExportType(ExportType.ALL);
            }
        }
        allSettings.add(settings);
    }

    private static boolean isSkippAll(ItemExportSettings settings) {
        if (settings.getExportType() == ExportType.NONE) {
            return true;
        }
        if (settings.getExportType() == ExportType.INHERITED && settings.getParent() != null) {
            return ExportImportHelper.isSkippAll(settings.getParent());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void importAsset(String objectId, List<ExportedItem> list, ImportType importType, AsyncServerTask.Callback callback) {
        String objectName = objectId.substring(objectId.lastIndexOf(".") + 1);
        log.debug("importing asset " + objectId);
        callback.updateProgress((byte)0, L10nResourcesManager.getStr((String)Messages.ImportObjectsTask_importObjectStarted, (Object[])new Object[0]) + objectName);
        try {
            Class cls = XHelper.getClass((String)objectId);
            if (importType == ImportType.CLEANUP) {
                for (ExportedItem item : AssetsStorage.get().search(cls, new SearchQuery(), true).getData()) {
                    AssetsStorage.get().delete((BaseAsset)item);
                }
                log.debug("deleted all assets");
            }
            for (ExportedItem item : list) {
                int entriesCount = -1;
                int currentIndex = 0;
                int lastPercent = 0;
                try (ZipInputStream strm = new ZipInputStream(new ByteArrayInputStream(item.getContent()));){
                    ZipEntry entry;
                    block9: while ((entry = strm.getNextEntry()) != null) {
                        log.debug("reading entry " + entry);
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        IoUtil.copyStream((InputStream)strm, (OutputStream)baos, (int)256);
                        byte[] arr = baos.toByteArray();
                        if (arr.length == 0) continue;
                        Element rootElm = DocumentBuilderHelper.parse((InputStream)new ByteArrayInputStream(arr)).getDocumentElement();
                        for (Element elm : XmlUtil.getElements((Element)rootElm, (String)"object")) {
                            try {
                                byte percent;
                                ++currentIndex;
                                if (entriesCount == -1) {
                                    entriesCount = XHelper.readInt((Element)rootElm, (String)"@totalCount", (int)0);
                                    callback.updateProgress((byte)0, L10nResourcesManager.getStr((String)Messages.ImportObjectsTask_importObjectStarted, (Object[])new Object[0]) + objectName);
                                }
                                if (entriesCount > 0 && (percent = (byte)Math.round(100.0 * (double)currentIndex / (double)entriesCount)) > lastPercent + 5) {
                                    lastPercent = percent;
                                    callback.updateProgress(percent, L10nResourcesManager.getStr((String)Messages.ImportObjectsTask_importObject, (Object[])new Object[]{objectName}));
                                }
                                if (importType == ImportType.IGNORE) continue block9;
                                BaseAsset ctr = (BaseAsset)cls.newInstance();
                                ctr.fromXML(elm);
                                BaseAsset oldCtr = AssetsStorage.get().load(cls, ctr.getUid(), true);
                                if (oldCtr != null) {
                                    if (importType == ImportType.IGNORE) continue;
                                    if (importType == ImportType.APPEND) {
                                        ctr.setUid(UUIDGenerator.generate().toString());
                                    }
                                }
                                AssetsStorage.get().save(ctr, true);
                                log.debug(String.format("imported asset %s (%s from %s)", ctr.getUid(), currentIndex, entriesCount));
                            }
                            catch (Throwable e) {
                                log.error("unable to import asset " + objectName, e);
                                callback.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.ImportObjectsTask_cantImportObject, (Throwable)e, (Object[])new Object[]{objectName}));
                            }
                        }
                    }
                }
            }
        }
        catch (Throwable e) {
            log.error("unable to import assets " + objectId, e);
            callback.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.ImportObjectsTask_cantImportNoOneObject, (Throwable)e, (Object[])new Object[]{objectName}));
        }
        log.debug("import of asset " + objectId + " ended");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void importEntity(String objectId, List<ExportedItem> list, ImportType importType, Set<String> cleanedUpIndexes, AsyncServerTask.Callback callback) {
        log.debug("importing entity " + objectId);
        EntityType entityType = (EntityType)MetaRegistry.get().getEntities().get(objectId);
        String objectName = entityType == null ? objectId : entityType.getDisplayName();
        try {
            Class cls = XHelper.getClass((String)objectId);
            if (importType == ImportType.CLEANUP) {
                LogicalSession ls = LogicalStorage.get().beginUnitOfWork();
                try {
                    LogicalStorage.get().getEntityStorage().deleteAllEntities(cls);
                    log.debug("deleted all entities");
                    for (IndexType item : MetaRegistry.get().getIndexes().values()) {
                        Class ettClass = XHelper.getClass((String)item.getEntityId());
                        if (cleanedUpIndexes.contains(item.getId()) || !ettClass.isAssignableFrom(cls)) continue;
                        LogicalStorage.get().getEntityStorage().deleteAllIndexes(XHelper.getClass((String)item.getId()));
                        log.debug("deleted all indexes " + item.getId());
                        cleanedUpIndexes.add(item.getId());
                    }
                    LogicalStorage.get().endUnitOfWork(ls, true);
                }
                finally {
                    LogicalStorage.get().cancelUnitOfWork(ls);
                }
            }
            for (ExportedItem item : list) {
                int entriesCount = -1;
                int currentIndex = 0;
                int lastPercent = 0;
                try (ZipInputStream strm = new ZipInputStream(new ByteArrayInputStream(item.getContent()));){
                    ZipEntry entry;
                    block12: while ((entry = strm.getNextEntry()) != null) {
                        log.debug("reading entry " + entry);
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        IoUtil.copyStream((InputStream)strm, (OutputStream)baos, (int)256);
                        byte[] arr = baos.toByteArray();
                        if (arr.length == 0) continue;
                        Element rootElm = DocumentBuilderHelper.parse((InputStream)new ByteArrayInputStream(arr)).getDocumentElement();
                        for (Element elm : XmlUtil.getElements((Element)rootElm, (String)"object")) {
                            try {
                                byte percent;
                                ++currentIndex;
                                if (entriesCount == -1) {
                                    entriesCount = XHelper.readInt((Element)rootElm, (String)"@totalCount", (int)0);
                                    callback.updateProgress((byte)0, L10nResourcesManager.getStr((String)Messages.ImportObjectsTask_importObjectStarted, (Object[])new Object[]{objectName}));
                                }
                                if (entriesCount > 0 && (percent = (byte)Math.round(100.0 * (double)currentIndex / (double)entriesCount)) > lastPercent + 5) {
                                    lastPercent = percent;
                                    callback.updateProgress(percent, L10nResourcesManager.getStr((String)Messages.ImportObjectsTask_importObject, (Object[])new Object[]{objectName}));
                                }
                                if (importType == ImportType.IGNORE) continue block12;
                                EntityContainer ctr = new EntityContainer(cls);
                                ctr.fromXML(elm);
                                LogicalEntityStorage.clearRevision((EntityContainer)ctr);
                                EntityContainer oldCtr = EntityStorage.get().resolve(ctr.toReference());
                                if (oldCtr != null) {
                                    if (importType == ImportType.DONT_REPLACE) continue;
                                    if (importType == ImportType.APPEND) {
                                        ctr.setUid(UUIDGenerator.generate().toString());
                                    }
                                    if (importType == ImportType.REPLACE) {
                                        ctr.setVersionsCount(oldCtr.getVersionsCount());
                                        ctr.getVersionInfo().setVersionNumber(oldCtr.getVersionsCount() - 1);
                                    }
                                } else {
                                    ctr.setVersionsCount(0);
                                    ctr.getVersionInfo().setVersionNumber(0);
                                }
                                EntityStorage.get().save(ctr, true, (EntityStorageSaveParameters)new EntityStorageSaveParameters().ignoreInterceptors(true));
                                log.debug(String.format("imported entity %s (%s from %s)", ctr.getUid(), currentIndex, entriesCount));
                            }
                            catch (Throwable e) {
                                log.error("unable to import object " + objectName, e);
                                callback.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.ImportObjectsTask_cantImportObject, (Throwable)e, (Object[])new Object[]{objectName}));
                            }
                        }
                    }
                }
            }
        }
        catch (Throwable e) {
            log.error("unable to import objects of type " + objectId, e);
            callback.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.ImportObjectsTask_cantImportNoOneObject, (Throwable)e, (Object[])new Object[]{objectName}));
        }
        log.debug("import of entity " + objectId + " ended");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void importDictionary(String objectId, List<ExportedItem> list, ImportType importType, ValueHolder<Boolean> resetDictVersion, AsyncServerTask.Callback callback) {
        log.debug("importing dictionary " + objectId);
        DictionaryType dictionaryType = (DictionaryType)MetaRegistry.get().getDictionaries().get(objectId);
        String objectName = dictionaryType == null ? objectId : dictionaryType.getDisplayName();
        try {
            Class cls = XHelper.getClass((String)objectId);
            if (importType == ImportType.CLEANUP) {
                Map all = DictionaryCache.get().getAll(cls);
                if (all.size() > 100) {
                    LogicalSession ls = LogicalStorage.get().beginUnitOfWork();
                    try {
                        LogicalStorage.get().getStandardDictionaryStorage().deleteAll(cls);
                        LogicalStorage.get().endUnitOfWork(ls, true);
                        resetDictVersion.setValue((Object)Boolean.TRUE);
                    }
                    finally {
                        LogicalStorage.get().cancelUnitOfWork(ls);
                    }
                    log.debug("deleted all dictionaries");
                } else {
                    callback.updateProgress((byte)0, L10nResourcesManager.getStr((String)Messages.ImportObjectsTask_removeObjects, (Object[])new Object[]{objectName}));
                    for (BaseDictionary dict : new ArrayList(all.values())) {
                        LogicalStorage.get().getStandardDictionaryStorage().delete(dict);
                    }
                    log.debug("deleted every dictionary");
                }
            }
            for (ExportedItem item : list) {
                int entriesCount = -1;
                int currentIndex = 0;
                int lastPercent = 0;
                try (ZipInputStream strm = new ZipInputStream(new ByteArrayInputStream(item.getContent()));){
                    ZipEntry entry;
                    block10: while ((entry = strm.getNextEntry()) != null) {
                        log.debug("reading entry " + entry);
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        IoUtil.copyStream((InputStream)strm, (OutputStream)baos, (int)256);
                        byte[] arr = baos.toByteArray();
                        if (arr.length == 0) continue;
                        Element rootElm = DocumentBuilderHelper.parse((InputStream)new ByteArrayInputStream(arr)).getDocumentElement();
                        for (Element elm : XmlUtil.getElements((Element)rootElm, (String)"object")) {
                            byte percent;
                            ++currentIndex;
                            if (entriesCount == -1) {
                                entriesCount = XHelper.readInt((Element)rootElm, (String)"@totalCount", (int)0);
                                callback.updateProgress((byte)0, L10nResourcesManager.getStr((String)Messages.ImportObjectsTask_importObjectStarted, (Object[])new Object[]{objectName}));
                            }
                            if (entriesCount > 0 && currentIndex % 10 == 0 && (percent = (byte)Math.round(100.0 * (double)currentIndex / (double)entriesCount)) > lastPercent + 5) {
                                lastPercent = percent;
                                callback.updateProgress(percent, L10nResourcesManager.getStr((String)Messages.ImportObjectsTask_importObject, (Object[])new Object[]{objectName}));
                            }
                            if (importType == ImportType.IGNORE) continue block10;
                            BaseDictionary dict = (BaseDictionary)cls.newInstance();
                            dict.fromXML(elm);
                            BaseDictionary oldDict = LogicalStorage.get().getStandardDictionaryStorage().load(cls, dict.getUid());
                            if (oldDict != null && importType == ImportType.IGNORE) continue;
                            LogicalStorage.get().getStandardDictionaryStorage().save(dict, true);
                            log.debug(String.format("imported dict %s (%s from %s)", dict.getCode(), currentIndex, entriesCount));
                        }
                    }
                }
            }
        }
        catch (Throwable e) {
            log.error("unable to import dictionary " + objectName, e);
            callback.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.ImportObjectsTask_cantImportNoOneObject, (Throwable)e, (Object[])new Object[]{objectName}));
        }
        log.debug("import of dictionary " + objectId + " ended");
    }

    private static ImportType getImportType(ItemImportSettings settings) {
        if (settings == null) {
            return ImportType.CLEANUP;
        }
        if (settings.getImportType() == ImportType.INHERITED) {
            if (settings.getParent() == null) {
                return ImportType.CLEANUP;
            }
            return ExportImportHelper.getImportType(settings.getParent());
        }
        return settings.getImportType();
    }

    private static ItemImportSettings findChild(ItemImportSettings settings, String objectId) {
        if (null == settings) {
            return null;
        }
        if (settings.getObjectId() == null || settings.getObjectId().equals(objectId)) {
            return settings;
        }
        for (ItemImportSettings item : settings.getChildren()) {
            ItemImportSettings res = ExportImportHelper.findChild(item, objectId);
            if (res == null) continue;
            return res;
        }
        return null;
    }
}

