/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PersonPosition;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemsList;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.AuthorityLetter;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.ShipmentProperties;
import com.gridnine.xtrip.common.model.system.ConsecutiveNumberCategory;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.LazyValueHolder;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FinanceDocumentHelper {
    private static Logger log = LoggerFactory.getLogger(FinanceDocumentHelper.class);

    public static ConsecutiveNumberCategory getCategory(FinanceDocumentType type) {
        if (type == FinanceDocumentType.INTERNAL_BILL) {
            return ConsecutiveNumberCategory.FINANCE_DOCUMENT_INTERNAL_BILL;
        }
        if (type == FinanceDocumentType.STANDARD_BILL) {
            return ConsecutiveNumberCategory.FINANCE_DOCUMENT_STANDARD_BILL;
        }
        if (type == FinanceDocumentType.INVOICE) {
            return ConsecutiveNumberCategory.FINANCE_DOCUMENT_INVOICE;
        }
        if (type == FinanceDocumentType.INVOICE_CONSOLIDATED) {
            return ConsecutiveNumberCategory.FINANCE_DOCUMENT_INVOICE_CONSOLIDATED;
        }
        if (type == FinanceDocumentType.INVOICE_PREPAYMENT) {
            return ConsecutiveNumberCategory.FINANCE_DOCUMENT_INVOICE_PREPAYMENT;
        }
        if (type == FinanceDocumentType.CORRECTION_DOCUMENT) {
            return ConsecutiveNumberCategory.FINANCE_DOCUMENT_CORRECTION_DOCUMENT;
        }
        if (type == FinanceDocumentType.INVOICE_FACTURA) {
            return ConsecutiveNumberCategory.FINANCE_DOCUMENT_INVOICE_FACTURA;
        }
        if (type == FinanceDocumentType.ACCEPTANCE_CERTIFICATE) {
            return ConsecutiveNumberCategory.FINANCE_DOCUMENT_ACCEPTANCE_CERTIFICATE;
        }
        if (type == FinanceDocumentType.INVOICE_DETAILED) {
            return ConsecutiveNumberCategory.FINANCE_DOCUMENT_INVOICE_DETAILED;
        }
        if (type == FinanceDocumentType.INVOICE_FACTURA_FEES) {
            return ConsecutiveNumberCategory.FINANCE_DOCUMENT_INVOICE_FACTURA_FEES;
        }
        if (type == FinanceDocumentType.UNIVERSAL_DOCUMENT) {
            return ConsecutiveNumberCategory.FINANCE_DOCUMENT_UNIVERSAL_DOCUMENT;
        }
        return null;
    }

    public static ShipmentProperties getShipmentProperties(EntityReference<Organization> organization, boolean strict) {
        ShipmentProperties shipmentProperties = null;
        EntityContainer organizationContainer = EntityStorage.get().resolve(organization);
        if (organizationContainer != null) {
            shipmentProperties = ((Organization)organizationContainer.getEntity()).getShipmentProperties();
        }
        if (shipmentProperties == null && !strict) {
            EntityContainer defaultOrganizationContainer;
            EntityReference defaultOrganization = null;
            if (ProfileHelper.isOrganizationType(organization, (OrganizationType)OrganizationType.AGENCY)) {
                defaultOrganization = ProfileDao.findAllAgenciesProfile();
            } else if (ProfileHelper.isOrganizationType(organization, (OrganizationType)OrganizationType.CORPORATE_CLIENT)) {
                defaultOrganization = ProfileDao.findAllClientsProfile();
            }
            if (defaultOrganization != null && (defaultOrganizationContainer = EntityStorage.get().resolve(organization)) != null) {
                shipmentProperties = ((Organization)defaultOrganizationContainer.getEntity()).getShipmentProperties();
            }
        }
        return shipmentProperties;
    }

    public static FinanceDocumentsProperties getFinanceDocumentsProperties(EntityReference<Organization> organization, boolean strict) {
        FinanceDocumentsProperties financeDocumentsProperties = null;
        EntityContainer organizationContainer = EntityStorage.get().resolve(organization);
        if (organizationContainer != null) {
            financeDocumentsProperties = ((Organization)organizationContainer.getEntity()).getFinanceDocumentProperties();
        }
        if (financeDocumentsProperties == null && !strict) {
            EntityContainer defaultOrganizationContainer;
            EntityReference defaultOrganization = null;
            if (ProfileHelper.isOrganizationType(organization, (OrganizationType)OrganizationType.AGENCY)) {
                defaultOrganization = ProfileDao.findAllAgenciesProfile();
            } else if (ProfileHelper.isOrganizationType(organization, (OrganizationType)OrganizationType.CORPORATE_CLIENT)) {
                defaultOrganization = ProfileDao.findAllClientsProfile();
            }
            if (defaultOrganization != null && (defaultOrganizationContainer = EntityStorage.get().resolve(organization)) != null) {
                financeDocumentsProperties = ((Organization)defaultOrganizationContainer.getEntity()).getFinanceDocumentProperties();
            }
        }
        return financeDocumentsProperties;
    }

    public static Map<NestedEntityReference<BookingFile, BaseProduct>, Set<FinanceDocumentsHelper.FinanceDocumentProductData>> getShipmentFinanceDocumentProductDatas(Map<NestedEntityReference<BookingFile, BaseProduct>, BaseProduct> products, EntityReference<Organization> contextSubagency, Date date) {
        Map<NestedEntityReference<BookingFile, BaseProduct>, Set<FinanceDocumentsHelper.FinanceDocumentProductData>> financeDocumentProductDatas = FinanceDocumentHelper.getFinanceDocumentProductDatas(products, false);
        financeDocumentProductDatas.values().forEach(productDatas -> productDatas.removeIf(productData -> !GeneralProductHelper.filterValidationMessages((Collection)GeneralProductHelper.getValidationMessages((BaseProduct)productData.getProduct()), null, Collections.singleton(ValidationMessageSeverity.SHIPMENT_ERROR)).isEmpty()));
        financeDocumentProductDatas.values().removeIf(Set::isEmpty);
        LazyValueHolder shipmentProperties = new LazyValueHolder(() -> FinanceDocumentHelper.getShipmentProperties(contextSubagency, false));
        financeDocumentProductDatas.values().forEach(productDatas -> productDatas.removeIf(productData -> !(productData.getProduct().getShipmentsDate() == null && productData.getProduct().getShipmentsDateSubagent() == null || productData.getProduct().getShipmentsDate() != null && !MiscUtil.clearTime((Date)productData.getProduct().getShipmentsDate()).after(date) || productData.getProduct().getShipmentsDateSubagent() != null && !MiscUtil.clearTime((Date)productData.getProduct().getShipmentsDateSubagent()).after(date) || shipmentProperties.get() == null || !((ShipmentProperties)shipmentProperties.get()).isCreateAfterShipmentDateOnly())));
        financeDocumentProductDatas.values().removeIf(Set::isEmpty);
        return financeDocumentProductDatas;
    }

    public static Map<NestedEntityReference<BookingFile, BaseProduct>, Set<FinanceDocumentsHelper.FinanceDocumentProductData>> getFinancePrepaymentDocumentProductDatas(Map<NestedEntityReference<BookingFile, BaseProduct>, BaseProduct> products) {
        Map<NestedEntityReference<BookingFile, BaseProduct>, Set<FinanceDocumentsHelper.FinanceDocumentProductData>> financeDocumentProductDatas = FinanceDocumentHelper.getFinanceDocumentProductDatas(products, true);
        financeDocumentProductDatas.values().forEach(productDatas -> productDatas.removeIf(productData -> !productData.getProduct().getPrepaymentDocuments().isEmpty()));
        financeDocumentProductDatas.values().removeIf(Set::isEmpty);
        return financeDocumentProductDatas;
    }

    public static Map<EntityReference<Shipment>, Map<NestedEntityReference<BookingFile, BaseProduct>, FinanceDocumentsHelper.FinanceDocumentProductData>> getCorrectionShipmentFinanceDocumentProductDatas(Map<NestedEntityReference<BookingFile, BaseProduct>, BaseProduct> products) {
        HashMap<EntityReference<Shipment>, Map<NestedEntityReference<BookingFile, BaseProduct>, FinanceDocumentsHelper.FinanceDocumentProductData>> result = new HashMap<EntityReference<Shipment>, Map<NestedEntityReference<BookingFile, BaseProduct>, FinanceDocumentsHelper.FinanceDocumentProductData>>();
        products.forEach((reference, product) -> {
            ProductHandler productHandler = ProductHandler.of((BaseProduct)product);
            if (productHandler.getTicketType(product) != TicketType.CORRECTION) {
                return;
            }
            ProductStatus status = productHandler.getBaseStatus(product);
            if (!FinanceDocumentsHelper.allowedProductStatusesShipment.contains(status)) {
                return;
            }
            product.getFopDetalizations().values().stream().flatMap(fopDetalization -> fopDetalization.getComponents().stream()).filter(fopComponent -> fopComponent.getShipment() != null && fopComponent.getCorrectionShipment() == null).forEach(fopComponent -> {
                FinanceDocumentsHelper.FinanceDocumentProductData data = result.computeIfAbsent(fopComponent.getShipment(), s -> new HashMap()).computeIfAbsent(reference, r -> new FinanceDocumentsHelper.FinanceDocumentProductData());
                data.setProduct(product);
                data.setAgency(GeneralProductHelper.getAgency((BaseProduct)product));
                data.setSubagency(GeneralProductHelper.getSubagency((BaseProduct)product));
                BigDecimal componentAmount = status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE ? MiscUtil.negate((BigDecimal)fopComponent.getAmount()) : fopComponent.getAmount();
                data.setTotal(MiscUtil.sum((BigDecimal[])new BigDecimal[]{data.getTotal(), componentAmount}));
            });
        });
        return result;
    }

    private static Map<NestedEntityReference<BookingFile, BaseProduct>, Set<FinanceDocumentsHelper.FinanceDocumentProductData>> getFinanceDocumentProductDatas(Map<NestedEntityReference<BookingFile, BaseProduct>, BaseProduct> products, boolean prepayament) {
        Map<String, MiscUtil.Pair> fops = products.values().stream().flatMap(item -> ProductHandler.of((BaseProduct)item).getUnmodifiableContractRelations(item).stream()).map(item -> new MiscUtil.Pair(item, Optional.ofNullable(EntityStorage.get().resolve(item.getGeneralData().getContractData().getContract())).map(o -> ((Contract)o.getEntity()).getContractType()).orElse(null))).filter(item -> item.getSecond() != null).flatMap(item -> ((GeneralProductContractRelationData)item.getFirst()).getFops().stream().map(it -> new MiscUtil.Pair(it, item.getSecond()))).collect(Collectors.toMap(item -> ((GeneralProductFop)item.getFirst()).getUid(), item -> item));
        return new HashMap<NestedEntityReference<BookingFile, BaseProduct>, Set<FinanceDocumentsHelper.FinanceDocumentProductData>>(products.entrySet().stream().filter(item -> prepayament ? FinanceDocumentsHelper.allowedProductStatusesPrepayment.contains(ProductHandler.of((BaseProduct)((BaseProduct)item.getValue())).getBaseStatus((BaseProduct)item.getValue())) : FinanceDocumentsHelper.allowedProductStatusesShipment.contains(ProductHandler.of((BaseProduct)((BaseProduct)item.getValue())).getBaseStatus((BaseProduct)item.getValue()))).map(item -> new MiscUtil.Pair(item.getKey(), ((BaseProduct)item.getValue()).getFopDetalizations().entrySet().stream().filter(entry -> fops.containsKey(entry.getKey()) && ((GeneralProductFop)((MiscUtil.Pair)fops.get(entry.getKey())).getFirst()).getType() != PaymentType.TICKET).map(entry -> new MiscUtil.Pair(((MiscUtil.Pair)fops.get(entry.getKey())).getSecond(), (Object)((FopDetalization)entry.getValue()).getComponents())).map(entry -> ((List)entry.getSecond()).stream().reduce(new FinanceDocumentsHelper.FinanceDocumentProductData(), (data, component) -> {
            data.setProduct((BaseProduct)item.getValue());
            data.setAgency(GeneralProductHelper.getAgency((BaseProduct)((BaseProduct)item.getValue())));
            data.setSubagency(GeneralProductHelper.getSubagency((BaseProduct)((BaseProduct)item.getValue())));
            data.setContractType((ContractType)entry.getFirst());
            ProductStatus status = ProductHandler.of((BaseProduct)((BaseProduct)item.getValue())).getBaseStatus((BaseProduct)item.getValue());
            BigDecimal componentAmount = status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE ? MiscUtil.negate((BigDecimal)component.getAmount()) : component.getAmount();
            data.setTotal(MiscUtil.sum((BigDecimal[])new BigDecimal[]{data.getTotal(), componentAmount}));
            if (component.getShipment() == null) {
                data.setRemain(MiscUtil.sum((BigDecimal[])new BigDecimal[]{data.getRemain(), componentAmount}));
            }
            return data;
        }, (data1, data2) -> {
            data1.setTotal(MiscUtil.sum((BigDecimal[])new BigDecimal[]{data1.getTotal(), data2.getTotal()}));
            data1.setRemain(MiscUtil.sum((BigDecimal[])new BigDecimal[]{data1.getRemain(), data2.getRemain()}));
            return data1;
        })).filter(it -> it.getRemain() != null).collect(Collectors.toSet()))).filter(item -> ((Set)item.getSecond()).size() > 0).collect(Collectors.toMap(MiscUtil.Pair::getFirst, MiscUtil.Pair::getSecond)));
    }

    public static FinanceDocumentsHelper.FinanceConsolidatedDocumentsShipmentsData getFinanceConsolidatedDocumentsShipmentsData(List<MiscUtil.Pair<EntityReference<Shipment>, Boolean>> shipmentReferences) {
        FinanceDocumentsHelper.FinanceConsolidatedDocumentsShipmentsData shipmentsData = new FinanceDocumentsHelper.FinanceConsolidatedDocumentsShipmentsData();
        HashMap<MiscUtil.Pair<EntityReference<Shipment>, Boolean>, MiscUtil.Pair> shipmentAmountDatas = new HashMap<MiscUtil.Pair<EntityReference<Shipment>, Boolean>, MiscUtil.Pair>();
        BigDecimal totalAmount = BigDecimal.ZERO;
        EntityStorageContext esc = EntityStorageHelper.createContext();
        for (MiscUtil.Pair<EntityReference<Shipment>, Boolean> shipmentReference : shipmentReferences) {
            Shipment shipment;
            EntityContainer shipmentCtr = EntityStorageHelper.resolve((EntityReference)((EntityReference)shipmentReference.getFirst()), (EntityStorageContext)esc);
            if (shipmentCtr == null || shipmentCtr.getEntity() == null || (shipment = (Shipment)shipmentCtr.getEntity()).getFinanceDocuments().stream().map(ref -> EntityStorageHelper.resolve((EntityReference)ref, (EntityStorageContext)esc)).filter(Objects::nonNull).map(EntityContainer::getEntity).anyMatch(item -> FinanceDocumentsHelper.isConsolidated((FinanceDocumentType)item.getType()))) continue;
            BigDecimal shipmentTotalAmount = FinanceDocumentHelper.getBillingItems(shipment.getBillingItems(), esc).stream().filter(bi -> bi.getAmount() != null && bi.getAmount().getTotal() != null).map(bi -> bi.getAmount().getTotal()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            shipmentAmountDatas.put(shipmentReference, new MiscUtil.Pair((Object)shipment, (Object)shipmentTotalAmount));
            totalAmount = totalAmount.add(shipmentTotalAmount);
        }
        shipmentsData.setTotalAmount(totalAmount);
        shipmentsData.setShipmentAmountDatas(shipmentAmountDatas);
        return shipmentsData;
    }

    public static List<BillingItem> getBillingItems(List<NestedEntityReference<BillingItemsList, BillingItem>> billingItems, EntityStorageContext storageContext) {
        Map<NestedEntityReference<BillingItemsList, BillingItem>, BillingItem> billingItemMap = FinanceDocumentHelper.getBillingItemsMap(billingItems, storageContext);
        return billingItems.stream().map(billingItemMap::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static Map<EntityContainer<BillingItemsList>, Collection<BillingItem>> getBillingItemsLists(List<NestedEntityReference<BillingItemsList, BillingItem>> billingItems, EntityStorageContext storageContext) {
        HashMap billingItemMap = new HashMap();
        billingItems.stream().map(listBillingItemNestedRef -> new EntityReference(listBillingItemNestedRef.getUid(), listBillingItemNestedRef.getType(), null)).distinct().map(listBillingItemRef -> EntityStorageHelper.resolve((EntityReference)listBillingItemRef, (EntityStorageContext)storageContext)).filter(Objects::nonNull).forEach(billingItemsListCtr -> ((BillingItemsList)billingItemsListCtr.getEntity()).getData().forEach(billingItem -> billingItemMap.put(new NestedEntityReference(billingItemsListCtr, (BaseEntity)billingItem, billingItem.getUid()), new MiscUtil.Pair(billingItemsListCtr, billingItem))));
        return billingItems.stream().map(billingItemMap::get).filter(Objects::nonNull).collect(Collectors.groupingBy(MiscUtil.Pair::getFirst, MiscUtil.getListCollector(MiscUtil.Pair::getSecond)));
    }

    public static Map<NestedEntityReference<BillingItemsList, BillingItem>, BillingItem> getBillingItemsMap(List<NestedEntityReference<BillingItemsList, BillingItem>> billingItems, EntityStorageContext storageContext) {
        HashMap<NestedEntityReference<BillingItemsList, BillingItem>, BillingItem> billingItemsMap = new HashMap<NestedEntityReference<BillingItemsList, BillingItem>, BillingItem>();
        billingItems.stream().map(listBillingItemNestedRef -> new EntityReference(listBillingItemNestedRef.getUid(), listBillingItemNestedRef.getType(), null)).distinct().map(listBillingItemRef -> EntityStorageHelper.resolve((EntityReference)listBillingItemRef, (EntityStorageContext)storageContext)).filter(Objects::nonNull).forEach(billingItemsListCtr -> ((BillingItemsList)billingItemsListCtr.getEntity()).getData().forEach(billingItem -> billingItemsMap.put((NestedEntityReference<BillingItemsList, BillingItem>)new NestedEntityReference(billingItemsListCtr, (BaseEntity)billingItem, billingItem.getUid()), (BillingItem)billingItem)));
        return billingItemsMap;
    }

    public static AuthorityLetter getAuthorityLetter(Person person, DictionaryReference<PersonPosition> position, FinanceDocumentType type, Date date) {
        return person.getAuthorityLetters().stream().filter(item -> !(item.getPositions().size() != 0 && !item.getPositions().contains(position) || item.getFinanceDocumentTypes().size() != 0 && !item.getFinanceDocumentTypes().contains(type) || !MiscUtil.isBetween((Date)item.getStartDate(), (Date)item.getEndDate(), (Date)date))).findFirst().orElse(null);
    }
}

