/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Contractor;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.ContractorDescription;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PredefinedContractRelationType;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.profile.SalesChainDescription;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import com.gridnine.xtrip.server.model.test.TestContractRelationDescriptionBuilder;
import com.gridnine.xtrip.server.model.test.TestContractorDescriptionBuilder;
import com.gridnine.xtrip.server.model.test.TestSalesChainBuilder;
import com.gridnine.xtrip.server.model.test.TestSalesChainDescriptionBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class GeneralProductHelperTest
extends ModelTestBase {
    private final EntityReference<Organization> supplier = new EntityReference("supplier", Organization.class, "\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a");
    private final EntityReference<Organization> anotherSupplier = new EntityReference("another-supplier", Organization.class, "\u0414\u0440\u0443\u0433\u043e\u0439 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a");
    private final EntityReference<Organization> technicalProvider = new EntityReference("technical-provider", Organization.class, "\u0422\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440");
    private final EntityReference<Organization> anotherTechnicalProvider = new EntityReference("another-technical-provider", Organization.class, "\u0414\u0440\u0443\u0433\u043e\u0439 \u0442\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440");
    private final EntityReference<Organization> agency = new EntityReference("agency", Organization.class, "A\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e");
    private final EntityReference<Organization> anotherAgency = new EntityReference("another-agency", Organization.class, "\u0414\u0440\u0443\u0433\u043e\u0435 \u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e");
    private final EntityReference<Organization> subagency1 = new EntityReference("subagency-1", Organization.class, "\u0421\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e 1");
    private final EntityReference<Organization> anotherSubagency1 = new EntityReference("another-subagency-1", Organization.class, "\u0414\u0440\u0443\u0433\u043e\u0435 \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e 1");
    private final EntityReference<Organization> subagency2 = new EntityReference("subagency-2", Organization.class, "\u0421\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e 2");
    private final EntityReference<Organization> anotherSubagency2 = new EntityReference("another-subagency-2", Organization.class, "\u0414\u0440\u0443\u0433\u043e\u0435 \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e 2");
    private final EntityReference<Organization> subagency3 = new EntityReference("subagency-3", Organization.class, "\u0421\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e 3");
    private final EntityReference<Organization> anotherSubagency3 = new EntityReference("another-subagency-3", Organization.class, "\u0414\u0440\u0443\u0433\u043e\u0435 \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e 3");
    private final EntityReference<Organization> subagency4 = new EntityReference("subagency-4", Organization.class, "\u0421\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e 4");
    private final EntityReference<Organization> anotherSubagency4 = new EntityReference("another-subagency-4", Organization.class, "\u0414\u0440\u0443\u0433\u043e\u0435 \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e 4");
    private final EntityReference<ContractorDescription> supplierContractorDescription = new EntityReference("contractor-SUPPLIER", ContractorDescription.class, "\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a");
    private final EntityReference<ContractorDescription> technicalProviderContractorDescription = new EntityReference("contractor-TECHNICAL_PROVIDER", ContractorDescription.class, "\u0422\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440");
    private final EntityReference<ContractorDescription> agencyContractorDescription = new EntityReference("contractor-AGENCY", ContractorDescription.class, "A\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e");
    private final EntityReference<ContractorDescription> clientContractorDescription = new EntityReference("contractor-CLIENT", ContractorDescription.class, "\u041a\u043b\u0438\u0435\u043d\u0442");
    private final EntityReference<ContractRelationDescription> supplierToAgencyContractRelationDescription = new EntityReference("relation-SUPPLIER_TO_AGENCY", ContractRelationDescription.class, "\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 \u0441 \u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e\u043c");
    private final EntityReference<ContractRelationDescription> technicalProviderToAgencyContractRelationDescription = new EntityReference("relation-TECHNICAL_PROVIDER_TO_AGENCY", ContractRelationDescription.class, "\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u0442\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u0430 \u0441 \u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e\u043c");
    private EntityReference<ContractorDescription> subagency1ContractorDescription;
    private EntityReference<ContractorDescription> subagency2ContractorDescription;
    private EntityReference<ContractorDescription> subagency3ContractorDescription;
    private EntityReference<ContractorDescription> subagency4ContractorDescription;
    private EntityReference<SalesChainDescription> salesChainDescription;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void init() throws Exception {
        this.subagency1ContractorDescription = new TestContractorDescriptionBuilder().predefinedType(PredefinedContractorType.SUBAGENCY).name("\u0421\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e 1").create().toReference();
        this.subagency2ContractorDescription = new TestContractorDescriptionBuilder().predefinedType(PredefinedContractorType.SUBAGENCY).name("\u0421\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e 2").create().toReference();
        this.subagency3ContractorDescription = new TestContractorDescriptionBuilder().predefinedType(PredefinedContractorType.SUBAGENCY).name("\u0421\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e 3").create().toReference();
        this.subagency4ContractorDescription = new TestContractorDescriptionBuilder().predefinedType(PredefinedContractorType.SUBAGENCY).name("\u0421\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e 4").create().toReference();
        EntityReference agencyToSubagency1ContractRelationDescription = new TestContractRelationDescriptionBuilder().predefinedType(PredefinedContractRelationType.AGENCY_TO_SUBAGENCY).name("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0430 \u0441 \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e\u043c 1").supplier(this.agencyContractorDescription).customer(this.subagency1ContractorDescription).create().toReference();
        EntityReference subagency1ToSubagency2ContractRelationDescription = new TestContractRelationDescriptionBuilder().predefinedType(PredefinedContractRelationType.SUBAGENCY_TO_SUBAGENCY).name("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0430 1 \u0441 \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e\u043c 2").supplier(this.subagency1ContractorDescription).customer(this.subagency2ContractorDescription).create().toReference();
        EntityReference subagency2ToSubagency3ContractRelationDescription = new TestContractRelationDescriptionBuilder().predefinedType(PredefinedContractRelationType.SUBAGENCY_TO_SUBAGENCY).name("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0430 2 \u0441 \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e\u043c 3").supplier(this.subagency2ContractorDescription).customer(this.subagency3ContractorDescription).create().toReference();
        EntityReference subagency3ToSubagency4ContractRelationDescription = new TestContractRelationDescriptionBuilder().predefinedType(PredefinedContractRelationType.SUBAGENCY_TO_SUBAGENCY).name("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0430 3 \u0441 \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e\u043c 4").supplier(this.subagency3ContractorDescription).customer(this.subagency4ContractorDescription).create().toReference();
        EntityReference subagency4ToClientContractRelationDescription = new TestContractRelationDescriptionBuilder().predefinedType(PredefinedContractRelationType.SUBAGENCY_TO_CLIENT).name("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0430 4 \u0441 \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u043c").supplier(this.subagency4ContractorDescription).customer(this.clientContractorDescription).create().toReference();
        this.salesChainDescription = new TestSalesChainDescriptionBuilder().name("\u0421\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u043a\u0430\u044f \u043f\u0440\u043e\u0434\u0430\u0436\u0430 (4 \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0430)").contractRelation(this.supplierToAgencyContractRelationDescription).contractRelation(this.technicalProviderToAgencyContractRelationDescription).contractRelation(agencyToSubagency1ContractRelationDescription).contractRelation(subagency1ToSubagency2ContractRelationDescription).contractRelation(subagency2ToSubagency3ContractRelationDescription).contractRelation(subagency3ToSubagency4ContractRelationDescription).contractRelation(subagency4ToClientContractRelationDescription).create().toReference();
    }

    @Test
    public void setContractorTest01() throws Exception {
        SalesChain salesChain = new TestSalesChainBuilder().description(this.salesChainDescription).getEntity();
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUPPLIER, this.supplier, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.TECHNICAL_PROVIDER, this.technicalProvider, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.AGENCY, this.agency, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency1, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency2, (int)1);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency3, (int)2);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency4, (int)3);
        Assert.assertEquals((long)7L, (long)salesChain.getContractors().size());
        this.checkContractor((Contractor)salesChain.getContractors().get(0), this.supplierContractorDescription, this.supplier);
        this.checkContractor((Contractor)salesChain.getContractors().get(1), this.technicalProviderContractorDescription, this.technicalProvider);
        this.checkContractor((Contractor)salesChain.getContractors().get(2), this.agencyContractorDescription, this.agency);
        this.checkContractor((Contractor)salesChain.getContractors().get(3), this.subagency1ContractorDescription, this.subagency1);
        this.checkContractor((Contractor)salesChain.getContractors().get(4), this.subagency2ContractorDescription, this.subagency2);
        this.checkContractor((Contractor)salesChain.getContractors().get(5), this.subagency3ContractorDescription, this.subagency3);
        this.checkContractor((Contractor)salesChain.getContractors().get(6), this.subagency4ContractorDescription, this.subagency4);
    }

    @Test
    public void setContractorTest02() throws Exception {
        SalesChain salesChain = new TestSalesChainBuilder().description(this.salesChainDescription).getEntity();
        List<Runnable> runnables = Arrays.asList(() -> GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUPPLIER, this.supplier, (int)0), () -> GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.TECHNICAL_PROVIDER, this.technicalProvider, (int)0), () -> GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.AGENCY, this.agency, (int)0), () -> GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency1, (int)0), () -> GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency2, (int)1), () -> GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency3, (int)2), () -> GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency4, (int)3));
        Collections.shuffle(runnables);
        for (Runnable runnable : runnables) {
            runnable.run();
        }
        Assert.assertEquals((long)7L, (long)salesChain.getContractors().size());
        this.checkContractor((Contractor)salesChain.getContractors().get(0), this.supplierContractorDescription, this.supplier);
        this.checkContractor((Contractor)salesChain.getContractors().get(1), this.technicalProviderContractorDescription, this.technicalProvider);
        this.checkContractor((Contractor)salesChain.getContractors().get(2), this.agencyContractorDescription, this.agency);
        this.checkContractor((Contractor)salesChain.getContractors().get(3), this.subagency1ContractorDescription, this.subagency1);
        this.checkContractor((Contractor)salesChain.getContractors().get(4), this.subagency2ContractorDescription, this.subagency2);
        this.checkContractor((Contractor)salesChain.getContractors().get(5), this.subagency3ContractorDescription, this.subagency3);
        this.checkContractor((Contractor)salesChain.getContractors().get(6), this.subagency4ContractorDescription, this.subagency4);
    }

    @Test
    public void setContractorTest03() throws Exception {
        SalesChain salesChain = new TestSalesChainBuilder().description(this.salesChainDescription).getEntity();
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUPPLIER, this.supplier, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.TECHNICAL_PROVIDER, this.technicalProvider, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.AGENCY, this.agency, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency1, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency2, (int)1);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency3, (int)2);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency4, (int)3);
        Assert.assertEquals((long)7L, (long)salesChain.getContractors().size());
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUPPLIER, this.anotherSupplier, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.TECHNICAL_PROVIDER, this.anotherTechnicalProvider, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.AGENCY, this.anotherAgency, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.anotherSubagency1, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.anotherSubagency2, (int)1);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.anotherSubagency3, (int)2);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.anotherSubagency4, (int)3);
        Assert.assertEquals((long)7L, (long)salesChain.getContractors().size());
        this.checkContractor((Contractor)salesChain.getContractors().get(0), this.supplierContractorDescription, this.anotherSupplier);
        this.checkContractor((Contractor)salesChain.getContractors().get(1), this.technicalProviderContractorDescription, this.anotherTechnicalProvider);
        this.checkContractor((Contractor)salesChain.getContractors().get(2), this.agencyContractorDescription, this.anotherAgency);
        this.checkContractor((Contractor)salesChain.getContractors().get(3), this.subagency1ContractorDescription, this.anotherSubagency1);
        this.checkContractor((Contractor)salesChain.getContractors().get(4), this.subagency2ContractorDescription, this.anotherSubagency2);
        this.checkContractor((Contractor)salesChain.getContractors().get(5), this.subagency3ContractorDescription, this.anotherSubagency3);
        this.checkContractor((Contractor)salesChain.getContractors().get(6), this.subagency4ContractorDescription, this.anotherSubagency4);
    }

    @Test
    public void setContractorTest04() throws Exception {
        SalesChain salesChain = new TestSalesChainBuilder().description(this.salesChainDescription).getEntity();
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUPPLIER, this.supplier, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.TECHNICAL_PROVIDER, this.technicalProvider, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.AGENCY, this.agency, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency1, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency2, (int)1);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency3, (int)2);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency4, (int)3);
        Assert.assertEquals((long)7L, (long)salesChain.getContractors().size());
        List<Runnable> runnables = Arrays.asList(() -> GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUPPLIER, this.anotherSupplier, (int)0), () -> GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.TECHNICAL_PROVIDER, this.anotherTechnicalProvider, (int)0), () -> GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.AGENCY, this.anotherAgency, (int)0), () -> GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.anotherSubagency1, (int)0), () -> GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.anotherSubagency2, (int)1), () -> GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.anotherSubagency3, (int)2), () -> GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.anotherSubagency4, (int)3));
        Collections.shuffle(runnables);
        for (Runnable runnable : runnables) {
            runnable.run();
        }
        Assert.assertEquals((long)7L, (long)salesChain.getContractors().size());
        this.checkContractor((Contractor)salesChain.getContractors().get(0), this.supplierContractorDescription, this.anotherSupplier);
        this.checkContractor((Contractor)salesChain.getContractors().get(1), this.technicalProviderContractorDescription, this.anotherTechnicalProvider);
        this.checkContractor((Contractor)salesChain.getContractors().get(2), this.agencyContractorDescription, this.anotherAgency);
        this.checkContractor((Contractor)salesChain.getContractors().get(3), this.subagency1ContractorDescription, this.anotherSubagency1);
        this.checkContractor((Contractor)salesChain.getContractors().get(4), this.subagency2ContractorDescription, this.anotherSubagency2);
        this.checkContractor((Contractor)salesChain.getContractors().get(5), this.subagency3ContractorDescription, this.anotherSubagency3);
        this.checkContractor((Contractor)salesChain.getContractors().get(6), this.subagency4ContractorDescription, this.anotherSubagency4);
    }

    @Test
    public void setContractorTest05() throws Exception {
        SalesChain salesChain = new TestSalesChainBuilder().description(this.salesChainDescription).getEntity();
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUPPLIER, this.supplier, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.TECHNICAL_PROVIDER, this.technicalProvider, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.AGENCY, this.agency, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency1, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency2, (int)1);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency3, (int)2);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency4, (int)3);
        Assert.assertEquals((long)7L, (long)salesChain.getContractors().size());
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUPPLIER, null, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.TECHNICAL_PROVIDER, null, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.AGENCY, null, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, null, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, null, (int)1);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, null, (int)2);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, null, (int)3);
        Assert.assertEquals((long)0L, (long)salesChain.getContractors().size());
    }

    @Test
    public void setContractorTest06() throws Exception {
        SalesChain salesChain = new TestSalesChainBuilder().description(this.salesChainDescription).getEntity();
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUPPLIER, this.supplier, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.TECHNICAL_PROVIDER, this.technicalProvider, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.AGENCY, this.agency, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency1, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency2, (int)1);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency3, (int)2);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency4, (int)3);
        Assert.assertEquals((long)7L, (long)salesChain.getContractors().size());
        List<Runnable> runnables = Arrays.asList(() -> GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUPPLIER, null, (int)0), () -> GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.TECHNICAL_PROVIDER, null, (int)0), () -> GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.AGENCY, null, (int)0), () -> GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, null, (int)0), () -> GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, null, (int)1), () -> GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, null, (int)2), () -> GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, null, (int)3));
        Collections.shuffle(runnables);
        for (Runnable runnable : runnables) {
            runnable.run();
        }
        Assert.assertEquals((long)0L, (long)salesChain.getContractors().size());
    }

    @Test
    public void setContractorTest07() throws Exception {
        SalesChain salesChain = new TestSalesChainBuilder().description(this.salesChainDescription).getEntity();
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUPPLIER, this.supplier, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.TECHNICAL_PROVIDER, this.technicalProvider, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.AGENCY, this.agency, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency1, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency2, (int)1);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency3, (int)2);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency4, (int)3);
        Assert.assertEquals((long)7L, (long)salesChain.getContractors().size());
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUPPLIER, this.agency, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency4, (int)1);
        Assert.assertEquals((long)5L, (long)salesChain.getContractors().size());
        this.checkContractor((Contractor)salesChain.getContractors().get(0), this.supplierContractorDescription, this.agency);
        this.checkContractor((Contractor)salesChain.getContractors().get(1), this.technicalProviderContractorDescription, this.technicalProvider);
        this.checkContractor((Contractor)salesChain.getContractors().get(2), this.subagency1ContractorDescription, this.subagency1);
        this.checkContractor((Contractor)salesChain.getContractors().get(3), this.subagency2ContractorDescription, this.subagency4);
        this.checkContractor((Contractor)salesChain.getContractors().get(4), this.subagency3ContractorDescription, this.subagency3);
    }

    @Test
    public void setContractorTest08() throws Exception {
        SalesChain salesChain = new TestSalesChainBuilder().description(this.salesChainDescription).getEntity();
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUPPLIER, this.supplier, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.TECHNICAL_PROVIDER, this.technicalProvider, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.AGENCY, this.agency, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency1, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency2, (int)1);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency3, (int)2);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency4, (int)3);
        Assert.assertEquals((long)7L, (long)salesChain.getContractors().size());
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.AGENCY, this.supplier, (int)0);
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency1, (int)2);
        Assert.assertEquals((long)5L, (long)salesChain.getContractors().size());
        this.checkContractor((Contractor)salesChain.getContractors().get(0), this.supplierContractorDescription, this.supplier);
        this.checkContractor((Contractor)salesChain.getContractors().get(1), this.technicalProviderContractorDescription, this.technicalProvider);
        this.checkContractor((Contractor)salesChain.getContractors().get(2), this.subagency1ContractorDescription, this.subagency1);
        this.checkContractor((Contractor)salesChain.getContractors().get(3), this.subagency2ContractorDescription, this.subagency2);
        this.checkContractor((Contractor)salesChain.getContractors().get(4), this.subagency4ContractorDescription, this.subagency4);
    }

    @Test
    public void setContractorTest09() throws Exception {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("sales chain can't be null");
        GeneralProductHelper.setContractor(null, (PredefinedContractorType)PredefinedContractorType.SUPPLIER, this.supplier, (int)0);
    }

    @Test
    public void setContractorTest10() throws Exception {
        SalesChain salesChain = new TestSalesChainBuilder().description(this.salesChainDescription).getEntity();
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("type can't be null");
        GeneralProductHelper.setContractor((SalesChain)salesChain, null, this.supplier, (int)0);
    }

    @Test
    public void setContractorTest11() throws Exception {
        SalesChain salesChain = new TestSalesChainBuilder().description(this.salesChainDescription).getEntity();
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("level should be greater or equals 0");
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUPPLIER, this.supplier, (int)-1);
    }

    @Test
    public void setContractorTest12() throws Exception {
        EntityReference emptySalesChainDescription = new TestSalesChainDescriptionBuilder().name("\u041f\u0443\u0441\u0442\u0430\u044f \u043f\u0440\u043e\u0434\u0430\u0436\u0430").create().toReference();
        SalesChain salesChain = new TestSalesChainBuilder().description(emptySalesChainDescription).getEntity();
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("supplier is not supported");
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUPPLIER, this.supplier, (int)0);
    }

    @Test
    public void setContractorTest13() throws Exception {
        EntityReference emptySalesChainDescription = new TestSalesChainDescriptionBuilder().name("\u041f\u0443\u0441\u0442\u0430\u044f \u043f\u0440\u043e\u0434\u0430\u0436\u0430").create().toReference();
        SalesChain salesChain = new TestSalesChainBuilder().description(emptySalesChainDescription).getEntity();
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("technical provider is not supported");
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.TECHNICAL_PROVIDER, this.technicalProvider, (int)0);
    }

    @Test
    public void setContractorTest14() throws Exception {
        EntityReference emptySalesChainDescription = new TestSalesChainDescriptionBuilder().name("\u041f\u0443\u0441\u0442\u0430\u044f \u043f\u0440\u043e\u0434\u0430\u0436\u0430").create().toReference();
        SalesChain salesChain = new TestSalesChainBuilder().description(emptySalesChainDescription).getEntity();
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("agency is not supported");
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.AGENCY, this.agency, (int)0);
    }

    @Test
    public void setContractorTest15() throws Exception {
        EntityReference emptySalesChainDescription = new TestSalesChainDescriptionBuilder().name("\u041f\u0443\u0441\u0442\u0430\u044f \u043f\u0440\u043e\u0434\u0430\u0436\u0430").create().toReference();
        SalesChain salesChain = new TestSalesChainBuilder().description(emptySalesChainDescription).getEntity();
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("subagency is not supported");
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency1, (int)0);
    }

    @Test
    public void setContractorTest16() throws Exception {
        SalesChain salesChain = new TestSalesChainBuilder().description(this.salesChainDescription).getEntity();
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("level is greater than supported subagency count");
        GeneralProductHelper.setContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, this.subagency1, (int)4);
    }

    private void checkContractor(Contractor contractor, EntityReference<ContractorDescription> contractorDescription, EntityReference<Organization> organization) throws Exception {
        Assert.assertEquals(contractorDescription, (Object)contractor.getDescription());
        Assert.assertEquals(organization, (Object)contractor.getContractor());
    }
}

